*Identifying UK Standalone Firms*

qui use "${cbt_datadir}\Exemption_MNE", clear

tab year
keep if insample_uk==1

tab country
drop  country country_name    /*all uk firms*/

merge m:1 bvd_id using "${cbt_datadir}\etpf_owernship", keepusing(allsub_uk)

drop if _merge==2
tab _merge

*with UK UO*
gen uo_uk=uo_ctry=="GB"

*with UK UO and all other peers UK*

tab allsub_uk if uo_uk==1
 
gen uo_uk_domestic = uo_uk==1 & (allsub_uk==1 | allsub_uk==.)
gen uo_uk_mne= uo_uk==1 & (allsub_uk==0)

drop allsub_uk _merge

***Variables for Regression***

gen insample_mne= (uo_uk_mne==1 | (uo_uk_mne==0 & uo_ctry!="GB"))
gen insample_domestic= (uo_uk_mne==1  | uo_uk_domestic==1) 
gen insample_parent= ( mnc_parent==1 | domestic_parent==1)
gen insample_exemption=(uo_ctry!="IE" & uo_ctry != "IL" & uo_ctry !="KR" & uo_ctry != "MX" & uo_ctry != "PL" & uo_ctry !="US" & uo_ctry !="JP")

xtset id year

gen post=(year>=2009)

*interaction term*

gen post_ukmne=uo_uk_mne*post
gen post_ukparent=mnc_parent*post

tab year, gen (year_d)

*firm-level controls*
xtset id year
bysort id: gen lag_turn=turnover_real[_n-1]
bysort id: gen lag_pm=profit_margin[_n-1]

*country-level controls*
qui replace pop=pop/1000
gen lpop=ln(pop)
gen lunemp=ln(unemp)
gen lgdp_capita=ln(gdp_capita)

qui save "${cbt_datadir}\Exemption_MNE_UKsample", replace




