*******************************
***Generate Matched Sample*****
*******************************

qui use "${cbt_datadir}\Exemption_MNE", clear

keep if insample_foreign==1

gen uk_parent=uo_ctry=="GB"
gen low_tax= (corp_low2005==1 & corp_low2011==1)

*firm-level controls*
xtset id year
bysort id: gen lag_turn=turnover_real[_n-1]
bysort id: gen lag_pm=profit_margin[_n-1]

keep if low_tax==1 
keep if year<=2008

egen id_year=group (id year)

qui save "${cbt_datadir}\Exemption_MNE4match", replace

*pre-treatment characteristics

qui use "${cbt_datadir}\Exemption_MNE4match", replace

collapse (mean)turnover turn_g ebit wkrs uk_parent (first)country, by (bvd_id)

mahapick turnover turn_g ebit wkrs, idvar(bvd_id) ///
treated(uk_parent) genfile("${cbt_datadir}\Foreign_UKmatches") replace prime_id(TREATED) matchnum(NO_MATCHES) ///
nummatches(1) matchon(country) /*GEN_IND NON_UK*/

save "${cbt_datadir}\MNE_foreign2match", replace

use "${cbt_datadir}\Foreign_UKmatches", clear

drop if  NO_MATCHES!=1

save "${cbt_datadir}\Foreign_UKmatches2", replace

*Generate ID so can merge in with original dataset
*determine how many matches are duplicates and see if issue - here, only 38 duplicates
by bvd_id, sort:  gen nvals = _n == 1
count if nvals!=1
drop if nvals != 1

*Create dummy to identify control firm
gen CONTROL = 1
keep TREATED bvd_id CONTROL 
save "${cbt_datadir}\Foreign_UK_matches_control", replace


************************
***Trial Regression*****
************************

qui use "${cbt_datadir}\Exemption_MNE4match", clear

merge m:1 bvd_id using "${cbt_datadir}\Foreign_UK_matches_control"

bysort id: egen control1=max(CONTROL)
replace CONTROL=control1 

keep if (uk_parent==0 & CONTROL==1)
keep bvd_id CONTROL 
duplicates drop

merge 1:m bvd_id using "${cbt_datadir}\Exemption_MNE"
keep if insample_foreign==1

gen uk_parent=uo_ctry=="GB"
gen low_tax= (corp_low2005==1 & corp_low2011==1)

keep if low_tax==1
tab year if CONTROL==1

keep if uk_parent==1 | (uk_parent==0 & CONTROL==1)
tab uk_parent
tab year uk_parent

drop _merge

qui save "${cbt_datadir}\Exemption_MNEmatched", replace

