

********************************************************
*Title: AEJPol-2018-0592_DATA_figure.do
*Date: 28 June, 2018
*Author: Li Liu
********************************************************


********Figure 2. Common Trends in Aggregate Investment*****

use  "${cbt_datadir}\gfcf.dta", clear

*Panel A: Gross fixed capital formation: selected countries

#delimit ;
graph twoway (connect gfcf_gdp year if cname=="United Kingdom", sort msymbol(triangle) mcolor(blue) lcolor(blue) lwidth(medthick))
(line gfcf_gdp year if cname=="France", sort lcolor(dkgreen) lwidth(medthick))
(line gfcf_gdp year if cname=="Germany", sort lcolor(orange) lwidth(medthick) lpattern(dash))
, 
xtitle("Year") xlabel(2005(1)2012)
legend (order(1 "UK" 2 "France" 3 "Germany") rows(1) position(1) ring(0))
ylabel(10(5)30) ytitle("Gross Capital Formation/GDP, %") graphregion(fcolor(white))
;
#delimit cr

graph save "${cbt_graphdir}\I_aggregate1.gph", replace
graph export "${cbt_graphdir}\I_aggregate1.png", replace

*Panel B: Gross fixed capital formation: UK vs Non-UK EU27

gen uk=cname=="United Kingdom"
tab uk

collapse (sum) gfcf gdp, by (uk year)
gen gfcf_gdp=gfcf/gdp

#delimit ;
graph twoway (connect gfcf_gdp year if uk==1, sort msymbol(triangle) mcolor(blue) lcolor(blue) lwidth(medthick))
(line gfcf_gdp year if uk==0, sort lcolor(cranberry) lwidth(medthick) lpattern(dash))
, 
xtitle("Year") xlabel(2005(1)2012)
legend (order(1 "UK" 2 "Non-UK EU27, GDP weighted") rows(1) position(1) ring(0))
ylabel(10(5)30) ytitle("Gross Capital Formation/GDP, %") graphregion(fcolor(white))
;
#delimit cr

graph save "${cbt_graphdir}\I_aggregate2.gph", replace
graph export "${cbt_graphdir}\I_aggregate2.png", replace


***********************Figure 3. Timing*********************

qui use "${cbt_resultdir}\timing", clear
drop if year>2009

qui gen b_min95=bhat-1.96* bhat_std
qui gen b_max95=bhat+1.96* bhat_std

#delimit ;

serrbar bhat bhat_std year, scale (1.96) 
ylabel() ytitle("Investment per euro of lagged capital") 
xlabel(2007(1)2009)  graphregion(fcolor(white))
yline(0, lwidth(vvthin) lpattern(dash))
xtitle("Year") graphregion(margin(l+10 r+10))
;

#delimit cr

graph save "${cbt_graphdir}\lowtax_timing", replace
graph export "${cbt_graphdir}\lowtax_timing.png", replace


clear

**************Figure 4. Graphical Evidence***********************


qui use "${cbt_datadir}\Exemption_MNE4reg", clear

xtset id year

preserve

collapse (mean)Irate_w=Irate_w99, by (low_tax uk_parent year)

sort low_tax uk_parent year
bysort low_tax uk_parent: gen Irate_w_2006=Irate_w if year==2006
bysort low_tax uk_parent: replace Irate_w_2006=Irate_w_2006[_n-1] if Irate_w_2006==.
gen Irate_w_rel=Irate_w-Irate_w_2006

keep if year>=2006

*Relative level

#delimit ;
graph twoway (connect Irate_w_rel year if low_tax==1 & uk_parent==1, sort msymbol(triangle) mcolor(blue) lcolor(blue) lwidth(medthick))
(connect Irate_w_rel year if low_tax==1 & uk_parent==0, sort lcolor(dkgreen) mcolor(dkgreen) lwidth(medthick) lpattern(dash))
, 
xtitle("Year") xlabel(2006(1)2011)
xline(2008, lpattern(dash) lwidth(vthin))
xline(2009, lpattern(solid) lwidth(vthin))
legend (order(1 "UK Parent" 2 "Non-UK Parent") rows(2) position(1) ring(0))
ylabel() ytitle("Investment per euro of lagged capital") graphregion(fcolor(white))
;
#delimit cr

graph save "${cbt_graphdir}\Iratew_lowtax.gph", replace
graph export "${cbt_graphdir}\Iratew_lowtax.png", replace

restore

*High-tax countries: UK versus non-UK parents*

collapse (mean)Irate_w=Irate_w99, by (high_tax uk_parent year)

sort high_tax uk_parent year
bysort high_tax uk_parent: gen Irate_w_2006=Irate_w if year==2006
bysort high_tax uk_parent: replace Irate_w_2006=Irate_w_2006[_n-1] if Irate_w_2006==.
gen Irate_w_rel=Irate_w-Irate_w_2006

keep if year>=2006

#delimit ;
graph twoway (connect Irate_w_rel year if high_tax==1 & uk_parent==1, sort msymbol(triangle) mcolor(blue) lcolor(blue) lwidth(medthick))
(connect Irate_w_rel year if high_tax==1 & uk_parent==0, sort lcolor(dkgreen) mcolor(dkgreen) lwidth(medthick) lpattern(dash))
, 
xtitle("Year")
xline(2008, lpattern(dash) lwidth(vthin) )
xline(2009, lpattern(solid) lwidth(vthin))
legend (order(1 "UK Parent" 2 "Non-UK Parent") rows(2) position(1) ring(0))
ylabel(-0.2(0.05)0.15) ytitle("Investment per euro of lagged capital") graphregion(fcolor(white))
;
#delimit cr

graph save "${cbt_graphdir}\Irate_hightax.gph", replace
graph export "${cbt_graphdir}\Irate_hightax.png", replace

clear


**************Figure 5. Heterogenous Investment Responses in Low-Tax Countries***********************

***Regressions to generate the coefficients in each panel***

qui use "${cbt_datadir}\Exemption4reg_MNE", clear

keep if insample_foreign==1

global ctrl_firm lag_turn lag_cf lag_pm turn_g_lag 
global ctrl_host corp_rate lpop lunemp lgdp_capita host_governance host_stable_fi
global ctrl_home uo_gdpgrowth uo_gdppcap uo_governance uo_stable_fi

***I. Based on Pre-Treatment Affiliate Characteristics***

estimates clear 

*1. Heterogeneity by Size Quartile

forv j=10/10 {

global nq=`j'

*1.1 By Turnover Size Quartile-Pre Reform

*size decile*
bysort id: egen size_avg1=mean(turnover_real) if year<2008
bysort id: egen size_avg=min(size_avg1)

xtile pct_size = size_avg, nq($nq)

qui tab pct_size, gen (pct_size_d)

	forv i=1/$nq {
	qui gen post_ukparent_d`i'= post_ukparent*pct_size_d`i' 
	}

eststo: reghdfe Irate_w99 post_ukparent_d*  ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id  i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_lowtax_bysalessize${nq}.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) keep(post_ukparent*)  label replace 
estimates clear

qui drop pct_size size_avg size_avg1 pct_size_d* post_ukparent_d*

}

*1.2 Heterogeneity by Total Asset Size Quartile-Pre Reform

forv j=10/10 {

global nq=`j'

*size decile*
bysort id: egen size_avg1=mean(asset_total) if year<2008
bysort id: egen size_avg=min(size_avg1) 

xtile pct_size = size_avg, nq($nq)

qui tab pct_size, gen (pct_size_d)

	forv i=1/$nq {
	qui gen post_ukparent_d`i'= post_ukparent*pct_size_d`i' 
	}

eststo: reghdfe Irate_w99 post_ukparent_d*  ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id  i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_lowtax_byassetsize${nq}.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) keep(post_ukparent*)  label replace 
estimates clear

qui drop pct_size size_avg size_avg1 pct_size_d* post_ukparent_d*

}

*2. Heterogeneity by Cash Flow Quartile

forv j=10/10 {

global nq=`j'

*cash flow decile*
bysort id: egen cf_avg1=mean(cf_w) if year<2008
bysort id: egen cf_avg=min(cf_avg1) 

xtile pct_cf = cf_avg, nq(${nq})

qui tab pct_cf, gen (pct_cf_d)

	forv i=1/$nq {
	qui gen post_ukparent_d`i'= post_ukparent*pct_cf_d`i' 
	}

eststo: reghdfe Irate_w99 post_ukparent_d*  ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id  i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_lowtax_bycf${nq}.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) keep(post_ukparent*)  label replace 

test post_ukparent_d2+ post_ukparent_d3+post_ukparent_d4+post_ukparent_d5+post_ukparent_d6+post_ukparent_d7=0
test post_ukparent_d8+ post_ukparent_d9+post_ukparent_d10=0


qui drop pct_cf cf_avg1 cf_avg pct_cf_d* post_ukparent_d*
estimates clear

}


*3. Heterogeneity by Profitability Quartile

forv j=10/10 {

global nq=`j'

*profitability decile*
bysort id: egen pm_avg1=mean(pmargin_w) if year<2008
bysort id: egen pm_avg=min(pm_avg1) 

xtile pct_pm = pm_avg, nq(${nq})

qui tab pct_pm, gen (pct_pm_d)

	forv i=1/$nq {
	qui gen post_ukparent_d`i'= post_ukparent*pct_pm_d`i' 
	}

eststo: reghdfe Irate_w99 post_ukparent_d*  ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id  i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_lowtax_bypm${nq}.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) keep(post_ukparent*)  label replace 
estimates clear

test post_ukparent_d4+post_ukparent_d5+post_ukparent_d6+post_ukparent_d7+post_ukparent_d8=0
test post_ukparent_d1+ post_ukparent_d2+ post_ukparent_d3=0
test post_ukparent_d9+post_ukparent_d10=0

qui drop pct_pm pm_avg pm_avg1 pct_pm_d* post_ukparent_d*

}

***II. Heterogeneity by Parent Size Quartile***

*Number of related companies*

global nq=5

xtile pct_nocompany = no_companies if low_tax==1, nq($nq)

qui tab pct_nocompany, gen (pct_uocompany_d)

	forv i=1/$nq {
	qui gen post_ukparent_d`i'= post_ukparent*pct_uocompany_d`i' 
	}

eststo: reghdfe Irate_w99 post_ukparent_d*  ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id  i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_lowtax_bynocompany${nq}.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) keep(post_ukparent*)  label replace 
estimates clear

qui drop pct_nocompany  pct_uocompany_d* post_ukparent_d*


*Parent Asset*

global nq=5

bysort id: egen uoasset_avg1=mean(uo_asset) 
bysort id: egen uoasset_avg=min(uoasset_avg1) 

xtile pct_uoasset = uoasset_avg if low_tax==1, nq($nq)

qui tab pct_uoasset, gen (pct_uoasset_d)

	forv i=1/$nq {
	qui gen post_ukparent_d`i'= post_ukparent*pct_uoasset_d`i' 
	}

eststo: reghdfe Irate_w99 post_ukparent_d*  ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id  i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_lowtax_byuoasset${nq}.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) keep(post_ukparent*)  label replace 
estimates clear

qui drop pct_uoasset uoasset_avg uoasset_avg1 pct_uoasset_d* post_ukparent_d*

****Graphs to Plot the Above Coefficients and CIs***

qui use "${cbt_resultdir}\lowtax_response_decile", clear

*turnover
qui gen b_turnover_min95= bhat_turnover-1.64* bhat_turnover_std
qui gen b_turnover_max95=bhat_turnover+1.64* bhat_turnover_std

*asset
qui gen b_asset_min95= bhat_asset-1.64* bhat_asset_std
qui gen b_asset_max95=bhat_asset+1.64* bhat_asset_std

*cash flow
qui gen b_cf_min95= bhat_cf-1.64* bhat_cf_std
qui gen b_cf_max95=bhat_cf+1.64*bhat_cf_std

*profitability
qui gen b_pm_min95= bhat_pm-1.64* bhat_pm_std
qui gen b_pm_max95=bhat_pm+1.64* bhat_pm_std

*Graph by Decile*

*turnover

#delimit ;

serrbar bhat_turnover bhat_turnover_std decile, scale (1.64) 
ylabel(-1(0.25)1) ytitle("Investment per lagged capital") 
xlabel(1(1)10)  graphregion(fcolor(white))
yline(0, lwidth(vthin) lpattern(dash))
xtitle("Turnover Decile") graphregion(margin(l+10 r+10))
;

#delimit cr

graph save "${cbt_graphdir}\turnover_het", replace
graph export "${cbt_graphdir}\turnover_het.png", replace

*asset

#delimit ;

serrbar bhat_asset bhat_asset_std decile, scale (1.64) 
ylabel(-1(0.25)1) ytitle("Investment per lagged capital") 
xlabel(1(1)10)  graphregion(fcolor(white))
yline(0, lwidth(vthin) lpattern(dash))
xtitle("Asset Decile") graphregion(margin(l+10 r+10))
;

#delimit cr

graph save "${cbt_graphdir}\asset_het", replace
graph export "${cbt_graphdir}\asset_het.png", replace

*cash flow

#delimit ;

serrbar bhat_cf bhat_cf_std decile, scale (1.64) 
ylabel(-1(0.25)1) ytitle("Investment per lagged capital") 
xlabel(1(1)10)  graphregion(fcolor(white))
yline(0, lwidth(vthin) lpattern(dash))
xtitle("Cash Flow Decile") graphregion(margin(l+10 r+10))
;

#delimit cr

graph save "${cbt_graphdir}\cf_het", replace
graph export "${cbt_graphdir}\cf_het.png", replace

*profitability

#delimit ;

serrbar bhat_pm bhat_pm_std decile, scale (1.64) 
ylabel(-1(0.25)1) ytitle("Investment per lagged capital") 
xlabel(1(1)10)  graphregion(fcolor(white))
yline(0, lwidth(vthin) lpattern(dash))
xtitle("Profit Margin Decile") graphregion(margin(l+10 r+10))
;

#delimit cr

graph save "${cbt_graphdir}\pm_het", replace
graph export "${cbt_graphdir}\pm_het.png", replace

*number of related companies

preserve
drop if decile>5
#delimit ;

serrbar bhat_num bhat_num_std decile, scale (1.64) 
ylabel(-1(0.25)1) ytitle("Investment per lagged capital") 
xlabel(1(1)5)  graphregion(fcolor(white))
yline(0, lwidth(vthin) lpattern(dash))
xtitle("Company Group Size Quintile") graphregion(margin(l+10 r+10))
;

#delimit cr

graph save "${cbt_graphdir}\num_het", replace
graph export "${cbt_graphdir}\num_het.png", replace

restore

*group asset

drop if decile>5

#delimit ;

serrbar uo_asset uo_asset_std decile, scale (1.64) 
ylabel(-1(0.25)1) ytitle("Investment per lagged capital") 
xlabel(1(1)5)  graphregion(fcolor(white))
yline(0, lwidth(vthin) lpattern(dash))
xtitle("Company Group Asset Quintile") graphregion(margin(l+10 r+10))
;

#delimit cr

graph save "${cbt_graphdir}\uoasset_het", replace
graph export "${cbt_graphdir}\uoasset_het.png", replace


clear
exit
