*create ID
egen _ID = group (sector)

*Reshapre dataset as panel
reshape long lobby ngo news events, i(sector) j(year)


*Indentify dataset as panel
xtset _ID year

*Organize dataset
order _ID year

*Generare new variable: lobby in millions of US$
gen lobby_mil=lobby/1000000
drop lobby
rename lobby_mil lobby


*Rename variables
rename news neg_reports

*summarize main variables
summarize neg_reports events lobby

*regressions and tables

quietly xtreg neg_reports d.lobby L.d.lobby i.year, fe vce(cluster _ID)
estimates store m1, title (Model I)

quietly xtreg lobby neg_reports L.neg_reports i.year, fe vce(cluster _ID)
estimates store m2, title (Model II)

esttab m1, star(* 0.10 ** 0.05 *** 0.01) t varwidth(25)
esttab m2, star(* 0.10 ** 0.05 *** 0.01) t varwidth(25)

