
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" 
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"


**************************************************************
*Merge Transfer to CENCOL Data
***************************************************************		
use $temdir/aca_CENCOL_withwages_rr, clear
			keep ssn mlot1_term
			gen SID=reverse(substr(reverse(ssn),3,.))
			duplicates drop
			tempfile tempsp
			save `tempsp'
use /home/research/cavoced/cte/data/trans_ALL
		keep SID trans_*
		duplicates drop
		joinby SID using `tempsp', unmatched(both)
		keep if _merge==3
		gen transyear=floor(trans_term/10000)
		gen trans_flag=transyear>mlot1_term & transyear<(mlot1_term+6)
		keep if trans_flag
		keep ssn trans_flag trans_seg
		tempfile temptrn
		save `temptrn'
		clear
***************************************************

use $temdir/aca_CENCOL_withwages_rr, clear
		
	********************
	*Regressions
	**********************
	drop appflag
	egen appflag=tag(ssn lotnum)
	global racevar "age_at  race_H race_A race_OBX"
	global acadvar "gpa_prelot1   "
	global empvar "hemp_anypre emp_pre "	
	global finvar "sfa_bog sfa_pel  sfa_cal "	

	
*Create a consistent sample for the 1st stage regressions
	reg numlots  lot_adm $racevar $acadvar $empvar $finvar loof* if lotnum==1 & appflag==1
	gen ESAMPLEall=e(sample)
	reg logwage0 win14   zc0* if lotnum<5   & ysince_lot1==5.25 , cluster(ssn)  
	gen ESAMPLE57=e(sample)
	foreach g of varlist E*{
		bysort ssn: egen a=total(`g')
		replace `g'=a>0
		drop a
		}	


****************************************************************	
*First Stage
****************************************************************
		local covars0=" "
		local covars1="age_at race_H race_A race_OBX "	
		local covars2="age_at race_H race_A race_OBX gpa_prelot1   "	
		local covars3="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre "	
		local covars4="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre sfa_bog sfa_pel sfa_cal missfin "	

*Cycle through covarite lists for just main outcome
eststo clear
foreach endo in numlots enrn enr  awa2 awa_anytop2 awa_anyawa trans_flag{
foreach list in 0 1 2 3 4{
	ivreg2 emp (`endo'= lot_adm ) loof* `covars`list'' if lotnum==1 & appflag==1 & ESAMPLE57==1,  ffirst cluster(ssn)
		local f1=e(widstat)
	eststo f11`list': reg `endo' lot_adm loof*  `covars`list'' if lotnum==1 & appflag==1 & ESAMPLE57==1,  cluster(ssn)
		estadd scalar FF=`f1'
		}
		#delimit;
	esttab f1* using "$outdir/rr/reg_1stst_`endo'_sensi.tex", replace label	se  
		keep(lot_adm) stat(FF N , label("F" "Students" )) nostar nonotes  nogaps nomtitles nonumbers nolines prehead(" ") posthead(" ") postfoot(" ");
		#delimit cr
		eststo clear
		}

	foreach endo in numlots enrn enr  awa2 awa_anytop2 awa_anyawa trans_flag{
	ivreg2 emp (`endo'= lot_adm ) loof* if lotnum==1 & appflag==1 & ESAMPLE57==1,  ffirst cluster(ssn)
		local f1=e(widstat)
	ivreg2 emp (`endo'=  lot_adm) $racevar $acadvar $empvar $finvar loof* if lotnum==1 & appflag==1 & ESAMPLE57==1,  ffirst  cluster(ssn)
		local f2=e(widstat)
	eststo f11`endo'1: reg `endo' lot_adm loof* if lotnum==1 & appflag==1 & ESAMPLE57==1,  cluster(ssn)
		estadd scalar FF=`f1'
		qui sum `endo' if  lotnum==1 & appflag==1 & e(sample)& ESAMPLE57==1
		estadd scalar meanwag=r(mean)
	eststo f12`endo'2: reg `endo'  lot_adm $racevar $acadvar $empvar $finvar loof* if lotnum==1 & appflag==1 & ESAMPLE57==1,   cluster(ssn)
		estadd scalar FF=`f2'
		qui sum `endo' if  lotnum==1 & appflag==1 & e(sample)& ESAMPLE57==1
		estadd scalar meanwag=r(mean)
		

	
	}	
	#delimit;
	esttab f11* using "$outdir/rr/reg_1ststn_bmanregs_1.tex", replace label
			se  keep(lot_adm) stat(FF N meanwag, label("F" "Students" "Y-Mean")) nostar nonotes  nogaps nomtitles nonumbers nolines prehead(" ") posthead(" ") postfoot(" ");

	esttab f12* using "$outdir/rr/reg_1ststn_bmanregs_1c.tex", replace label
			se  keep(lot_adm) stat(FF N meanwag, label("F" "Students" "Y-Mean")) nostar nonotes  nogaps nomtitles nonumbers nolines prehead(" ") posthead(" ") postfoot(" ");
			
			#delimit cr
*/
***********************************************
*Outcomes
***********************************************

	keep if ESAMPLE57==1
	eststo clear
		local covars1="age_at race_H race_A race_OBX "	
		local covars2="age_at race_H race_A race_OBX gpa_prelot1   "	
		local covars3="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre "	
		local covars4="age_at race_H race_A race_OBX gpa_prelot1   hemp_anypre emp_pre sfa_bog sfa_pel sfa_cal missfin "	

	*Table 1: Red Form: 1st Lottery

		eststo r1157: reg logwage0 flot lot_adm    yfe* qfe* loofe* if lotnum==1 & rys==5, cluster(ssn)  
		*eststo r1257: reg logwage0 flot lot_adm      yfe* qfe* loofe* if lotnum==1 & rys==5, cluster(ssn)  
		eststo r1357: reg logwage0 flot lot_adm    `covars1'   yfe* qfe* loofe* if lotnum==1 & rys==5, cluster(ssn)  
		eststo r1457: reg logwage0 flot lot_adm    `covars2'   yfe* qfe* loofe* if lotnum==1 & rys==5, cluster(ssn)  
		eststo r1557: reg logwage0 flot lot_adm    `covars3'   yfe* qfe* loofe* if lotnum==1 & rys==5, cluster(ssn)  
 		eststo r1657: reg logwage0 flot lot_adm    `covars4'   yfe* qfe* loofe* if lotnum==1 & rys==5, cluster(ssn)  
            
		
		#delimit;
		esttab r1*using  "$outdir/rr/reg_redform_bmanregs_57_lot1.tex", keep(lot_adm*   ) se replace label  stat(N) nostar
			nonotes  nogaps nomtitles nonumbers noobs nolines prehead(" ") posthead(" ") postfoot(" ");
			#delimit cr
	
	*Table 2: Enroll 
		foreach endo in enr enrn {
		
		*First Lottery (main results)
		eststo ie1157: ivreg2 logwage0 (`endo'=lot_adm)  enrolled	yfe* qfe* flot loofe* gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & lot_adm==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie1157" , replace
		eststo ie1357: ivreg2 logwage0 (`endo'=lot_adm)  enrolled  	`covars1'    yfe* qfe* flot loofe*     gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & lot_adm==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie1357" , replace
		eststo ie1457: ivreg2 logwage0 (`endo'=lot_adm)  enrolled  	`covars2' yfe* qfe* flot loofe*     `covars' gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)  & lot_adm==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie1457" , replace
		eststo ie1557: ivreg2 logwage0 (`endo'=lot_adm)  enrolled  	`covars3' yfe* qfe* flot loofe*     `covars' gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)  & lot_adm==0
			estadd scalar meanwag=r(mean)				
			estimates save "$temdir/i`endo'ie1557" , replace
		eststo ie1657: ivreg2 logwage0 (`endo'=lot_adm)  enrolled  	`covars4' yfe* qfe* flot loofe*     `covars' gap if lotnum==1 & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)  & lot_adm==0
			estadd scalar meanwag=r(mean)				
			estimates save "$temdir/i`endo'ie1657" , replace			

		*Lotteries 1-4, unweighted (robustness)
		eststo ie2157: ivreg2 logwage0 (`endo'=win14)   enrolled   zc0* zcgap* if lotnum<5   & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample)  & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie2157" , replace
		eststo ie2357: ivreg2 logwage0 (`endo'=win14)   enrolled  zc0* zcgap*    zc1* if lotnum<5   & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie2357" , replace
		eststo ie2457: ivreg2 logwage0 (`endo'=win14)    enrolled  zc0* zcgap*    zc1*  zc2* if lotnum<5   & rys==5, cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie2457" , replace
		eststo ie2557: ivreg2 logwage0 (`endo'=win14)    enrolled  zc0* zcgap*    zc1* zc2* zc3* if lotnum<5   & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie2557" , replace
		eststo ie2657: ivreg2 logwage0 (`endo'=win14)    enrolled  zc0* zcgap*    zc1* zc2* zc3* zc4* if lotnum<5   & rys==5 , cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie2657" , replace			
			#delimit;
			esttab  ie2*  using  "$outdir/CENCOL/reg_iv`endo'_bmanregs_57_win14_now.tex", keep(`endo' ) se replace label stat(N, label("N"))
					nonotes  nogaps nomtitles noobs nonumbers nolines prehead(" ") posthead(" ") postfoot(" ");
				#delimit cr
				
		*Lotteries 1-4, weighted (robustness)		
		eststo ie2157: ivreg2 logwage0 (`endo'=win14)    enrolled  zc0* zcgap* if lotnum<5   & rys==5 [weight=weii], cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)
			estimates save "$temdir/i`endo'ie3157" , replace
		eststo ie2357: ivreg2 logwage0 (`endo'=win14)   enrolled  zc0* zcgap*    zc1* if lotnum<5   & rys==5 [weight=weii], cluster(ssn)  
			estadd scalar Ftous=e(widstat) 
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie3357" , replace
		eststo ie2457: ivreg2 logwage0 (`endo'=win14)    enrolled  zc0* zcgap*    zc1*  zc2* if lotnum<5   & rys==5 [weight=weii], cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie3457" , replace
		eststo ie2557: ivreg2 logwage0 (`endo'=win14)    enrolled  zc0* zcgap*    zc1* zc2* zc3* if lotnum<5   & rys==5  [weight=weii], cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie3557" , replace
		eststo ie2657: ivreg2 logwage0 (`endo'=win14)    enrolled  zc0* zcgap*    zc1* zc2* zc3* zc4* if lotnum<5   & rys==5  [weight=weii], cluster(ssn)  
			estadd scalar Ftous=e(widstat)
			sum wages0 if e(sample) & win14==0
			estadd scalar meanwag=r(mean)	
			estimates save "$temdir/i`endo'ie3657" , replace			

			}
			}
