

***-----------------------------------------------------------------------------------------------------------------------------***	
***   				Barrage, Chyn, Hastings (2019, AEJ:Policy)		     				        ***
***						TABLE 1										***	
***-----------------------------------------------------------------------------------------------------------------------------***	
	
/* This do-file replicates Columns 1 and 2 of BCH Table 1.
Inputs:   BCH_Replication_Table1.dta
Outputs:  Table1_BCH.xls
*/
	
clear all
set more off

*Set directory:
include 1_SET_DIRECTORY.do

*Install programs:
cap net install outreg2, from(http://fmwww.bc.edu/repec/bocode/o/)

*Open data:
use BCH_Replication_Table1.dta, clear


****************** 
** Table 1 Col 1**           
******************

	areg avprice during_spill post_spill bp_duringspill bp_postspill [aweight=p_obs_time], absorb(random_id) cluster(random_zip_id)
	egen id_tag=tag(random_id) if e(sample)==1
	count if id_tag==1
	local stations=`r(N)'
	drop id_tag
	
	outreg2 using Table1_BCH.xls, replace label excel adjr2 stats(coef se) dec(3) ///
	addstat(# of zips,`e(N_clust)', # of stations,`stations') ///
	nocons ///
	ctitle("Average Net Price") ///
	title("Table 1: Oil Spill Impacts, Difference-in-Difference Estimates")

******************* 
** Table 1 Col 2 **           
*******************
    
    areg ln_avq during_spill post_spill bp_duringspill bp_postspill [aweight=q_obs_time], absorb(random_id) cluster(random_zip_id)
	egen id_tag=tag(random_id) if e(sample)==1
	count if id_tag==1
	local stations=`r(N)'
	drop id_tag

	outreg2 using Table1_BCH.xls, append label excel adjr2 stats(coef se) dec(3) ///
	addstat(# of zips,`e(N_clust)', # of stations,`stations') ///
	ctitle("Ln(Avg. Fleet Sales)") nocons 
	
