clear all
close all

global al la la1 dd ga zmax L rr rr1 pi bt pp_Pz pp_Pz_1 pp_Pa pp_Pa_1 pp_Pa1 pp_Pa1_1 KK nu pp_PT pp_PT_1 pp_PS pp_PS_1 Tax w_hist r_hist la_hist T t w0 r0 Tax0 kk AA BB AA_W expand

% benchmark calibration
ga = .9^(1/4); % probability of remaining alive
al =  1/3; % capital elasticity 
dd = 1-(1-0.07)^(1/4); % depreciation rate
la0=1/(1-.69); % leverage factor, 1/(1-theta)
% la0=1/(1-.59); % alternative calibration of the colateral constraint
% la0=1/(1-.79); % alternative calibration of the colateral constraint

bt= 0.9865; % th=0.69 % discount factor in the benchmark calibratio
% alternative calibrations of the discount factor, consistent with the 
% alternative calibration of the colateral constraint
% bt= 0.9826; % B/(4*Y)=0.62, th=0.59 
% bt= 0.9898; % B/(4*Y)=0.62, th=0.79

L  = 1; % (fixed) labor supply
nu = 0.23; % share of income devoted to cash goods
% nu = 0; % share of income devoted to cash goods for the cashless limit
% it turns of that this alternative value do not requires a different
% value for the discount factor

pw=0.25; % fraction of workers in the population

N=40; % number of entrepreneurial types
zmax=10; % maximum value of entrepreneurial productivity 
sd=3.36; % standard deviation of the distribution of log productivity
mu=0;
z(:,1)=linspace(0,zmax,N)';
Pz=logncdf(z,mu,sd)/logncdf(zmax,mu,sd);
pp_Pz = pchip(z,Pz);
Mder = diag(3:-1:1,1);
pp_Pz_1 = pp_Pz;
pp_Pz_1.coefs = pp_Pz.coefs*Mder;


load lognormal_B0_201609.mat
%load lognormal_B0_nu0_201609 % initial conditions for the calibration with
% nu = 0, i.e., cashless limit.
% the next two initial conditions correspond to alternative calibrations of
% the collateral constraint parameters discussed in Section E.1 in the
% Online Appendix.
% load lognormal_B0_201609_th059
% load lognormal_B0_201609_th079

% Initialize the policy function for workers

T=150;

% we calculate the policy function for workers solve using the endogenous
% grid method (Carroll, 2005)

kk=[0 logspace(log(.001)/log(10),log(100)/log(10),40)]';

c0=(1+r0)*kk+w0-pw*Tax0;

for i=1:100
    
    B=(1+r0)*bt*c0.^(-1);
    cc=B.^(-1);
    mm=nu/(1-nu)*c0/(1+r0);
    kk2=(cc+kk+mm-w0+pw*Tax0)/(1+r0);
    kk2_low=(cc(1)+kk(1)+mm(1)-w0+pw*Tax0)/(1+r0);
    c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w0-pw*Tax0);cc(kk2>=kk2_low)],kk,'linear');
    
    if max(max(abs(c1-c0)))<.0001
        break
    end
    c0=c1;
    
end

alow=(1-bt*(1+r0))/bt/(1+r0)^2*(w0-pw*Tax0);

index0=find(kk<alow);
index1=find(kk>=alow);
a0(index1,1)=(1+r0)*kk(index1)+w0-pw*Tax0-c0(index1)-nu/(1-nu)*bt*(1+r0)*c0(index1)/(1+r0);
a0(index0,1)=0;



% transtion part starts

% initializing the history of wages and interest rate

% if we do not have a better guess saves use the following

w_hist=[w0*ones(T+1,1)];
r_hist=[r0*ones(T+1,1)];p2(1,1)=p0;
Tax=ones(T+1,1)*Tax0;

expand=zeros(length(Tax),1);
expand(4)=1;

% initializing history of the collateral constraint parameters
la_low=1/(1-.45); % drop of r to -.03 annualized
% la_low=1/(1-.54); % drop of r to -.025 annualized
% la_low=1/(1-.515); % drop of r to -.03 annualized
la_hist=[la0./linspace(1,la0/la_low,4)]';
la_hist(5:20)=la_low;
for t=length(la_hist)+1:T+1, la_hist(t,1)=.9*la_hist(t-1,1)+.1*la_hist(1,1);end
la_hist=la0*ones(T+1,1);

% initializing the government debt
B2(1,1)=B0;

% initializing the policy function of workers in the steady state (notice
% that the new steady state is endogenous, as it depends on the sequence of
% policies during the ZLB
for i=1:100
    
    B=(1+r0)*bt*c0.^(-1);
    cc=B.^(-1);
    mm=nu/(1-nu)*c0/(1+r0);
    kk2=(cc+kk+mm-w0+pw*Tax0)/(1+r0);
    kk2_low=(cc(1)+kk(1)+mm(1)-w0+pw*Tax0)/(1+r0);
    c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w0-pw*Tax0);cc(kk2>=kk2_low)],kk,'linear');
    
    if max(max(abs(c1-c0)))<.0001
        break
    end
    c0=c1;
    
end

g=.005;
% g=.0025;
% g=0;
g1=.0037;
g2=.005;
T1=31;    

r_data=[.005 0.0032 0.0015 0.0001 -0.0011 -0.0020 -0.0028 -0.0033 -0.0037 ...
   -0.0040 -0.0041 -0.0042 -0.0043 -0.0043 -0.0043 -0.0042 -0.0042 ...
   -0.0042 -0.0042 -0.0042 -0.0042 -0.0042 -0.0043 -0.0043 -0.0044 ...
   -0.0044 -0.0044 -0.0044 -0.0042 -0.0040 -0.0037 -0.0032];

% ZLB constraint attained on 2008:Q4
p2(1,1)=p0; for t=1:5, p2(t+1,1)=(1+.005)*p2(t); end
for t=6:T1, p2(t+1,1)=p2(t)/(1+r_data(t+1)); end
for t=T1+1:T, p2(t+1,1)=(1+.005)*p2(t); end

% target debt to GDP
% B_Y=B0/(4*Y0); for t=1:T1, B_Y(t+1)=(t/T1)*1+((T1-t)/T1)*(B0/(4*Y0)); end
B_Y=[B0/(4*Y0) 0.6253 0.6362 0.6562 0.6659 0.7247 0.8566 0.8846 0.9063 ...
0.9265 0.9453 0.9743 0.9911 1.0011 1.0210 1.0307 1.0167 1.0262 1.0439 ...
1.0532 1.0578 1.0612 1.0853 1.1097 1.1104 1.1042 1.1233 1.1521 1.1373 ...
1.1332 1.1455 1.1429 1.1269];
    
[a2_W M2_W c1_W c2_W]=feval('out_workers_simple3',[w_hist r_hist],p2,M0_W/(1+g),pw*(1-expand).*Tax,c0);

la_hist_new(1,1)=la0;

% loop over price, leverage factor, and tax sequences
for iT=1:20
    
    
    
    Pa2(:,1)=Pa0;
    pp_Pa = pchip(z,Pa2(:,1));
    pp_Pa_1 = pp_Pa;
    pp_Pa_1.coefs = pp_Pa.coefs*Mder;
    
    PT2=(1-pw)*Pz;
    pp_PT = pchip(z,PT2);
    pp_PT_1 = pp_PT;
    pp_PT_1.coefs = pp_PT.coefs*Mder;
    
    PS2=Pz;
    pp_PS = pchip(z,PS2);
    pp_PS_1 = pp_PS;
    pp_PS_1.coefs = pp_PS.coefs*Mder;
    
    K2(1,1)=K0;
    zlow2(1)=zlow0;
    Z2(1,1)=Z0;
    Y2(1,1)=Z2(1,1)*K2(1,1)^al*L^(1-al);
    w2(1,1)=(1-al)*Z2(1,1)*K2(1,1)^al*L^(-al);
    pi = al*((1-al)/w2(1,1))^((1-al)/al);
    r2(1,1) =pi*zlow2(1)-dd;
    rr=r2(1,1);
    M2(1,1)=M0/(1+g);
    
    zlb(1)=0; % indicator taking the value 1 if 1+r(t)=p(t-1)/p(t) in t (ZLB binding)
    
% loop over time periods
    for t=1:T
        
        if t==1
            C1(t,1)=C10;
        end
        
        la=la_hist(t);
        
        sum_Tax_temp_all_2=quad('eq_sum_Tax_2_c',z(1),z(end));
        sum_Tax_temp_all=quad('eq_sum_Tax_c',z(1),z(end));
        C2(t,1)=(1-nu)*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
        C1(t+1,1)=p2(t)/p2(t+1)*bt*nu*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
        A2(t+1,1)=bt*(quad('eqR',z(1),z(end))-expand(t)*Tax(t)-(1-expand(t))*(1-pw)*Tax(t))...
            +(1-bt)*sum_Tax_temp_all;
        M2_E(t+1,1)=p2(t)*nu*(1-bt)/(1-nu*(1-bt))*bt*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
        M2(t+1,1)=M2_E(t+1,1)+M2_W(t+1);
        
        
        
        Pa2(1,t+1)=0; Pa2(N,t+1)=A2(t+1,1);
        
        R0z2=quad('eqR',z(1),z(2));
        T_temp=quad('eq_Tax_c',z(1),z(2));
        T_sum_temp=quad('eq_sum_Tax_c',z(1),z(2));
        Pa2(2,t+1) = ga*(bt*(R0z2-T_temp)+(1-bt)*T_sum_temp)...
            +(1-ga)*ppval(pp_Pz,z(2))*A2(t+1,1)...
            +(1-ga)*nu*(1-bt)*(T_sum_temp...
            -ppval(pp_Pz,z(2))*sum_Tax_temp_all);
        % atemp=quad('eq_a',z(1),z(2));
        %             Pa2_neg(2,t+1)=min(0,atemp);
        %             Pa2(2,t+1) = ga*(max(0,atemp))...
        %                 +(1-ga)*ppval(pp_Pz,z(2))*K2(t+1,1);
        
        for i=3:N-1
            
            R0z2=R0z2+quad('eqR',z(i-1),z(i));
            T_temp=T_temp+quad('eq_Tax_c',z(i-1),z(i));
            T_sum_temp=T_sum_temp+quad('eq_sum_Tax_c',z(i-1),z(i));
            Pa2(i,t+1) = ga*(bt*(R0z2-T_temp)+(1-bt)*T_sum_temp)...
                +(1-ga)*ppval(pp_Pz,z(i))*A2(t+1,1)...
                +(1-ga)*nu*(1-bt)*(T_sum_temp...
                -ppval(pp_Pz,z(i))*sum_Tax_temp_all);
            % atemp=quad('eq_a',z(i-1),z(i));
            %             Pa2_neg(i,t+1)=min(0,atemp);
            %                 Pa2(i,t+1) = ga*(max(0,atemp))...
            %                 +(1-ga)*ppval(pp_Pz,z(i))*K2(t+1,1);
            
        end
        
        pp_Pa1 = pchip(z,Pa2(:,t+1));
        pp_Pa1_1 = pp_Pa1;
        pp_Pa1_1.coefs = pp_Pa1.coefs*Mder;
        
        AA=A2(t+1,1);
        AA_W=a2_W(t+1);
        
        if t<=T1
            
            la_low=1;
            la_high=la0;
            la1=.5*la_low+.5*la_high;
            
            for ila=1:15
                
                pi = al*((1-al)/w2(t,1))^((1-al)/al);
                
%                 if t<=4
%                 r2(t+1,1) = r_data(t+1);                    
%                 else
%                 r2(t+1,1) = p2(t)/p2(t+1)-1;
%                 end
                r2(t+1,1) = r_data(t+1);                    
                
                rr1=r2(t+1,1);
                
                zlow2(t+1)=fminbnd('eqzhat_ZLB_B',z(1),z(end));
                K2(t+1,1)=la1*(AA-ppval(pp_Pa1,zlow2(t+1)));
                Ztemp=quad('eqZ_ZLB_B',zlow2(t+1),zmax)/(AA-ppval(pp_Pa1,zlow2(t+1)));
                Z2(t+1,1) = Ztemp^al;
                Y2(t+1,1) = Z2(t+1,1)*K2(t+1,1)^al*L^(1-al);
                w2(t+1,1)=(1-al)*Z2(t+1,1)*K2(t+1,1)^al*L^(-al);
                
                B2(t+1,1)=A2(t+1,1)+a2_W(t+1)-K2(t+1,1);
                
                diff=B2(t+1)/(4*Y2(t+1))-B_Y(t);
                
                if abs(diff)<.0001
                    [t ila]
                    break
                end
                
                if diff>0
                    la_low=la1;
                    la1=.5*la_low+.5*la_high;
                else
                    la_high=la1;
                    la1=.5*la_low+.5*la_high;
                end
                
            end
            
            la_hist_new(t+1,1)=la1;
            
            Taxnew(t,1)=(M2(t,1)-M2(t+1,1))/p2(t,1)+(1+r2(t))*B2(t)-B2(t+1);
            
            pi = al*((1-al)/w2(t+1))^((1-al)/al);
            rr = r2(t+1,1);
            zlb(t+1)=1;
            
            pp_Pa = pchip(z,Pa2(:,t+1));
            pp_Pa_1 = pp_Pa;
            pp_Pa_1.coefs = pp_Pa.coefs*Mder;
            
            if Taxnew(t,1)<0
                expand(t)=1;
            else
                expand(t)=0;
            end
            
%             [t ila la1 B2(t+1)/(4*Y2(t+1)) Taxnew(t,1)]
            
        else
            
            la_hist_new(t+1,1)=.95*la_hist_new(t)+.05*la0;
%             la_hist_new(t+1,1)=la_hist_new(t); % alternative forecast for
%             the credit constraint after the calibration period. This is
%             used for the simulations in Figure A.3 of Online Appendix E.2.
            la1=la_hist(t+1);
            
            Taxnew(t,1)=r2(t)*B2(t,1)+(M2(t,1)-M2(t+1,1))/p2(t,1);
            B2(t+1,1)=B2(t,1);
            BB=B2(t+1,1);
            
            zlow2(t+1)=fminbnd('eqzhat_unc_B',z(1),z(end));
            K2(t+1,1)=la1*(AA-ppval(pp_Pa1,zlow2(t+1)));
            KK=K2(t+1,1);
            Pazlow2(t+1)=ppval(pp_Pa1,zlow2(t+1));
            Ztemp=quad('eqZ',zlow2(t+1),z(end));
            Z2(t+1,1)=Ztemp^al;
            Y2(t+1,1)=Z2(t+1,1)*K2(t+1,1)^al*L^(1-al);
            w2(t+1,1)=(1-al)*Z2(t+1,1)*K2(t+1,1)^al*L^(-al);
            pi = al*((1-al)/w2(t+1,1))^((1-al)/al);
            r2(t+1,1)=pi*zlow2(t+1)-dd;
            
            rr=r2(t+1,1);
            zlb(t+1)=0;
            
            pp_Pa = pchip(z,Pa2(:,t+1));
            pp_Pa_1 = pp_Pa;
            pp_Pa_1.coefs = pp_Pa.coefs*Mder;
            
            expand(t)=0;
            
        end
        
    end
    
    
    Taxnew(t+1,1)=Taxnew(t,1);
    
    [iT min(Tax-Taxnew) max(Tax-Taxnew) min(Tax) max(Tax) max(abs(la_hist-la_hist_new))]
    
    if max(abs(Tax-Taxnew))<0.001
        break
    end
    
    %         Tax_acum(:,iT)=Tax;
    %         K_acum(:,iT)=K2;
    %         B_acum(:,iT)=B2;
    
    figure(1)
    tt=1:40;
    subplot(2,2,1),plot(tt,Tax(tt),tt,Taxnew(tt))
    subplot(2,2,2),plot(tt,la_hist(tt),tt,la_hist_new(tt))
    subplot(2,2,3),plot(tt,w2(tt),tt,w_hist(tt))
    subplot(2,2,4),plot(tt,r2(tt),tt,r_hist(tt))
    
 
%     update_T=.9;
%     update_price=.9;
%     update_la=.9;
    update_T=.5;
    update_price=.5;
    update_la=.5;
    
    Tax= (1-update_T)*Tax+update_T*Taxnew;
    w_hist=(1-update_price)*w_hist+update_price*w2;
    r_hist=(1-update_price)*r_hist+update_price*r2;
    la_hist=(1-update_la)*la_hist+update_la*la_hist_new;
    %         w_hist(end-5,end)=w(end);
    %         r_hist(end-5,end)=r(end);
    
    w0=w2(end);
    r0=r2(end);
    Tax0 = Tax(end);
    
    if bt*(1+r0)<1
        
        for i=1:100
            
            B=(1+r0)*bt*c0.^(-1);
            cc=B.^(-1);
            mm=nu/(1-nu)*c0/(1+r0);
            kk2=(cc+kk+mm-w0+pw*Tax0)/(1+r0);
            kk2_low=(cc(1)+kk(1)+mm(1)-w0+pw*Tax0)/(1+r0);
            c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w0-pw*Tax0);cc(kk2>=kk2_low)],kk,'linear');
            
            if max(max(abs(c1-c0)))<.0001
                break
            end
            c0=c1;
            
        end
        
        [a2_W M2_W c1_W c2_W]=feval('out_workers_simple3',[w_hist r_hist ],p2,M0_W/(1+g),pw*(1-expand).*Tax,c0);
        
    end
    
    [Y2(1:5)-(K2(2:6)-(1-dd)*K2(1:5)) C1(1:5)+C2(1:5)+c1_W(1:5)+c2_W(1:5)]
    
    [min(la_hist) max(la_hist) min(Y2/Y2(1))]
   
    tt=1:40;
    figure(2)
subplot(3,2,1),plot(tt,1-1./la_hist(tt))
axis([0 max(tt) .3 .7])
title('debt to capital ratio, \theta_t')
subplot(3,2,2),plot(tt,Y2(tt)./Y2(1))
axis([0 max(tt) .9 1.01])
title('output')
subplot(3,2,3),plot(tt,Z2(tt)/Z2(1))
axis([0 max(tt) .9 1.01])
title('TFP')
subplot(3,2,4),plot(tt,K2(tt)/K2(1))
axis([0 max(tt) .9 1.01])
title('capital')
% subplot(3,2,4),plot(tt,smooth((K2(tt+1)-(1-dd)*K2(tt))./Y2(tt),7),1,dd*K0/Y0,'o')
% subplot(3,2,4),plot(tt,(K2(tt+1)-(1-dd)*K2(tt))./Y2(tt))
% axis([0 max(tt) .15 .2])
% title('investment rate')
subplot(3,2,5),plot(tt,B2(tt)./(4*Y2(tt)))
axis([0 max(tt) 0.5 1.2])
title('government debt')
subplot(3,2,6),plot(tt,(1+r2(tt+1)).^4-1,tt,((1+r2(tt+1)).*p2(tt+1)./p2(tt)).^4-1)
axis([0 max(tt) -.03 .06])
title('interest rates')

end

Tax2=Tax;

save la_hist la_hist_cal_201902.mat % this must only be 
save lognormal_B_bailout_cal_trans_smooth_201902.mat Y2 Z2 K2 B2 r2 Tax2 p2 M2 zlow2 la_hist 

% this lines should be uncommented when running alternative simulations. In
% these cases, the previous two lines should be commented.

% save lognormal_B_bailout_cal_trans_smooth_lafixed_201609.mat Y2 Z2 K2 B2 r2 Tax2 p2 M2 zlow2 la_hist 
% save lognormal_B_bailout_cal_trans_smooth_nu_0_201902.mat Y2 Z2 K2 B2 r2 Tax2 p2 M2 zlow2 la_hist 
% save lognormal_B_bailout_cal_trans_sensitivity_th_059.mat Y2 Z2 K2 B2 r2 Tax2 p2 M2 zlow2 la_hist 
% save lognormal_B_bailout_cal_trans_sensitivity_th_079.mat Y2 Z2 K2 B2 r2 Tax2 p2 M2 zlow2 la_hist 

