clear all
close all

global al la la1 dd ga zmax L rr rr1 pi bt pp_Pz pp_Pz_1 pp_Pa pp_Pa_1 pp_Pa1 pp_Pa1_1 KK nu pp_PT pp_PT_1 pp_PS pp_PS_1 Tax w_hist r_hist la_hist T t w0 r0 Tax0 kk AA BB AA_W expand

% benchmark calibration
ga = .9^(1/4);
al =  1/3;
dd = 1-(1-0.07)^(1/4);
la=1/(1-.69);

bt= 0.9865; % th=0.69
L  = 1;
nu = 0.23; % share of income devoted to cash goods
pw=0.25; % fraction of workers in the population
% 
N=40;
zmax=10;
sd=3.36;
mu=0;
% z(:,1)=[0;logspace(log(.01)/log(10),log(zmax)/log(10),N-1)'];
z(:,1)=linspace(0,zmax,N)';
Pz=logncdf(z,mu,sd)/logncdf(zmax,mu,sd);
pp_Pz = pchip(z,Pz);
Mder = diag(3:-1:1,1);
pp_Pz_1 = pp_Pz;
pp_Pz_1.coefs = pp_Pz.coefs*Mder;

load lognormal_B0_201609


% M0=0;
% M0_W=0;
% M0_E=0;

% Initialize the policy function for workers

T=150;

% we calculate the policy function for workers solve using the endogenous
% grid method (Carroll, 2005)

kk=[0 logspace(log(.001)/log(10),log(100)/log(10),40)]';

c0=(1+r0)*kk+w0-pw*Tax0;

for i=1:100
    
    B=(1+r0)*bt*c0.^(-1);
    cc=B.^(-1);
    mm=nu/(1-nu)*c0/(1+r0);
    kk2=(cc+kk+mm-w0+pw*Tax0)/(1+r0);
    kk2_low=(cc(1)+kk(1)+mm(1)-w0+pw*Tax0)/(1+r0);
    c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w0-pw*Tax0);cc(kk2>=kk2_low)],kk,'linear');
    
    if max(max(abs(c1-c0)))<.0001
        break
    end
    c0=c1;
    
end

alow=(1-bt*(1+r0))/bt/(1+r0)^2*(w0-pw*Tax0);

index0=find(kk<alow);
index1=find(kk>=alow);
a0(index1,1)=(1+r0)*kk(index1)+w0-pw*Tax0-c0(index1)-nu/(1-nu)*bt*(1+r0)*c0(index1)/(1+r0);
a0(index0,1)=0;



% transtion part starts

% initializing the history of wages and interest rate

% if we do not have a better guess saves use the following

w_hist=[w0*ones(T+1,1)];
r_hist=[r0*ones(T+1,1)];p2(1,1)=p0;
Tax=ones(T+1,1)*Tax0;

expand=zeros(length(Tax),1);
expand(4)=1;

% history of the collateral constraint parameters
load la_hist_cal_201902.mat

% initializing the government debt
B2(1,1)=B0;

% initializing the policy function of workers in the steady state (notice
% that the new steady state is endogenous, as it depends on the sequence of
% policies during the ZLB
for i=1:100
    
    B=(1+r0)*bt*c0.^(-1);
    cc=B.^(-1);
    mm=nu/(1-nu)*c0/(1+r0);
    kk2=(cc+kk+mm-w0+pw*Tax0)/(1+r0);
    kk2_low=(cc(1)+kk(1)+mm(1)-w0+pw*Tax0)/(1+r0);
    c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w0-pw*Tax0);cc(kk2>=kk2_low)],kk,'linear');
    
    if max(max(abs(c1-c0)))<.0001
        break
    end
    c0=c1;
    
end

% g=.0075;
% g=.005;
% g=.0025;
g=0;

% sequence of prices, exogenous given that the government follows an
% inflation target
p2(1,1)=p0;for t=1:T, p2(t+1,1)=(1+g)*p2(t,1); end


% % [M2_W a2_W]=feval('out_workers_Tax',[w1(1:100)' r1(1:100)'  zeros(100,1)
% % pw*Tax0*ones(100,1)],p2,M0_W/(1+g),T);
[a2_W M2_W c1_W c2_W]=feval('out_workers_simple3',[w_hist r_hist],p2,M0_W/(1+g),pw*(1-expand).*Tax,c0);


for iT=1:30
    
        
        
        Pa2(:,1)=Pa0;
        pp_Pa = pchip(z,Pa2(:,1));
        pp_Pa_1 = pp_Pa;
        pp_Pa_1.coefs = pp_Pa.coefs*Mder;
        
        PT2=(1-pw)*Pz;
        pp_PT = pchip(z,PT2);
        pp_PT_1 = pp_PT;
        pp_PT_1.coefs = pp_PT.coefs*Mder;

        PS2=Pz;
        pp_PS = pchip(z,PS2);
        pp_PS_1 = pp_PS;
        pp_PS_1.coefs = pp_PS.coefs*Mder;
        
        K2(1,1)=K0;
        zlow2(1)=zlow0;
        Z2(1,1)=Z0;
        Y2(1,1)=Z2(1,1)*K2(1,1)^al*L^(1-al);
        w2(1,1)=(1-al)*Z2(1,1)*K2(1,1)^al*L^(-al);
        pi = al*((1-al)/w2(1,1))^((1-al)/al);
        r2(1,1) =pi*zlow2(1)-dd;
        rr=r2(1,1);
        M2(1,1)=M0/(1+g);
        
        zlb(1)=0; % indicator taking the value 1 if 1+r(t)=p(t-1)/p(t) in t (ZLB binding)
        
        for t=1:T
            
            la=la_hist(t);
            la1=la_hist(t+1);
            
            if t==1
                
%                 C20=(1-nu)*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-quad('eq_sum_Tax_02',z(1),z(end)));
%                 C10=1/(1+g)*bt*nu/(1-nu)*C20;
%                 C1(t,1)=1/(1+g)*bt*nu*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-quad('eq_sum_Tax_02',z(1),z(end)));
                C1(t,1)=C10;
                
            end
            
            sum_Tax_temp_all_2=quad('eq_sum_Tax_2_c',z(1),z(end));
            sum_Tax_temp_all=quad('eq_sum_Tax_c',z(1),z(end));
            C2(t,1)=(1-nu)*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
            C1(t+1,1)=p2(t)/p2(t+1)*bt*nu*(1-bt)/(1-nu*(1-bt))*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
            A2(t+1,1)=bt*(quad('eqR',z(1),z(end))-expand(t)*Tax(t)-(1-expand(t))*(1-pw)*Tax(t))...
                +(1-bt)*sum_Tax_temp_all;
            M2_E(t+1,1)=p2(t)*nu*(1-bt)/(1-nu*(1-bt))*bt*(quad('eqR',z(1),z(end))-sum_Tax_temp_all_2);
            M2(t+1,1)=M2_E(t+1,1)+M2_W(t+1);
  
                
            Taxnew(t,1)=r2(t)*B2(t,1)+(M2(t,1)-M2(t+1,1))/p2(t,1);
                
            B2(t+1,1)=B2(t,1);
                
            
            Pa2(1,t+1)=0; Pa2(N,t+1)=A2(t+1,1);
            
            R0z2=quad('eqR',z(1),z(2));
            T_temp=quad('eq_Tax_c',z(1),z(2));
            T_sum_temp=quad('eq_sum_Tax_c',z(1),z(2));
            Pa2(2,t+1) = ga*(bt*(R0z2-T_temp)+(1-bt)*T_sum_temp)...
                +(1-ga)*ppval(pp_Pz,z(2))*A2(t+1,1)...
                +(1-ga)*nu*(1-bt)*(T_sum_temp...
                                   -ppval(pp_Pz,z(2))*sum_Tax_temp_all);
            % atemp=quad('eq_a',z(1),z(2));
            %             Pa2_neg(2,t+1)=min(0,atemp);
            %             Pa2(2,t+1) = ga*(max(0,atemp))...
            %                 +(1-ga)*ppval(pp_Pz,z(2))*K2(t+1,1);
            
            for i=3:N-1
                
                R0z2=R0z2+quad('eqR',z(i-1),z(i));
                T_temp=T_temp+quad('eq_Tax_c',z(i-1),z(i));
                T_sum_temp=T_sum_temp+quad('eq_sum_Tax_c',z(i-1),z(i));
                Pa2(i,t+1) = ga*(bt*(R0z2-T_temp)+(1-bt)*T_sum_temp)...
                    +(1-ga)*ppval(pp_Pz,z(i))*A2(t+1,1)...
                +(1-ga)*nu*(1-bt)*(T_sum_temp...
                                   -ppval(pp_Pz,z(i))*sum_Tax_temp_all);
                % atemp=quad('eq_a',z(i-1),z(i));
                %             Pa2_neg(i,t+1)=min(0,atemp);
                %                 Pa2(i,t+1) = ga*(max(0,atemp))...
                %                 +(1-ga)*ppval(pp_Pz,z(i))*K2(t+1,1);
                
            end
            
            pp_Pa1 = pchip(z,Pa2(:,t+1));
            pp_Pa1_1 = pp_Pa1;
            pp_Pa1_1.coefs = pp_Pa1.coefs*Mder;
            
            AA=A2(t+1,1);
            BB=B2(t+1,1);
            AA_W=a2_W(t+1);
            
            zlow2(t+1)=fminbnd('eqzhat_unc_B',z(1),z(end));
            K2(t+1,1)=la1*(AA-ppval(pp_Pa1,zlow2(t+1)));
            KK=K2(t+1,1);
            Pazlow2(t+1)=ppval(pp_Pa1,zlow2(t+1));
            Ztemp=quad('eqZ',zlow2(t+1),z(end));
            Z2(t+1,1)=Ztemp^al;
            Y2(t+1,1)=Z2(t+1,1)*K2(t+1,1)^al*L^(1-al);
            w2(t+1,1)=(1-al)*Z2(t+1,1)*K2(t+1,1)^al*L^(-al);
            pi = al*((1-al)/w2(t+1,1))^((1-al)/al);
            r2(t+1,1)=pi*zlow2(t+1)-dd;
            
            if r2(t+1,1)>=p2(t)/p2(t+1)-1 % check that ZLB is binding at t+1
                
                rr=r2(t+1,1);
                zlb(t+1)=0;
                
                pp_Pa = pchip(z,Pa2(:,t+1));
                pp_Pa_1 = pp_Pa; 
                pp_Pa_1.coefs = pp_Pa.coefs*Mder;
                
                expand(t)=0;

            else % ZLB is binding at t+1 (but not at t)
                
                pi = al*((1-al)/w2(t,1))^((1-al)/al);
                
                r2(t+1,1) = p2(t)/p2(t+1)-1;
                
                
                rr1=r2(t+1,1);
                
                zlow2(t+1)=fminbnd('eqzhat_ZLB_B',z(1),z(end));
                K2(t+1,1)=la1*(AA-ppval(pp_Pa1,zlow2(t+1)));
                Ztemp=quad('eqZ_ZLB_B',zlow2(t+1),zmax)/(AA-ppval(pp_Pa1,zlow2(t+1)));
                Z2(t+1,1) = Ztemp^al;
                Y2(t+1,1) = Z2(t+1,1)*K2(t+1,1)^al*L^(1-al);
                w2(t+1,1)=(1-al)*Z2(t+1,1)*K2(t+1,1)^al*L^(-al);
                
                B2(t+1)=A2(t+1,1)+a2_W(t+1)-K2(t+1,1);
                
                Taxnew(t,1)=(M2(t,1)-M2(t+1,1))/p2(t,1)+(1+r2(t))*B2(t)-B2(t+1);
                
                pi = al*((1-al)/w2(t+1))^((1-al)/al);
                rr = r2(t+1,1);
                zlb(t+1)=1;
                pp_Pa = pchip(z,Pa2(:,t+1));
                pp_Pa_1 = pp_Pa; 
                pp_Pa_1.coefs = pp_Pa.coefs*Mder;
                
                expand(t)=1;

            end
            
            
        end
        
        Taxnew(t+1,1)=Taxnew(t,1);
        
        [iT min(Tax-Taxnew) max(Tax-Taxnew) min(Tax) max(Tax) max(r2) min(K2) max(K2) K2(end) min(find(zlb==1)) max(find(zlb==1))]
        
        if max(abs(Tax-Taxnew))<0.001
            break
        end
        
%         Tax_acum(:,iT)=Tax;
%         K_acum(:,iT)=K2;
%         B_acum(:,iT)=B2;
        
        update_T=1;
        update_price=1;
        
        Tax= (1-update_T)*Tax+update_T*Taxnew;
        w_hist=(1-update_price)*w_hist+update_price*w2;
        r_hist=(1-update_price)*r_hist+update_price*r2;
        
%         w_hist(end-5,end)=w(end);
%         r_hist(end-5,end)=r(end);
        
w0=w2(end);
r0=r2(end);
Tax0 = Tax(end);

if bt*(1+r0)<1

for i=1:100
    
    B=(1+r0)*bt*c0.^(-1);
    cc=B.^(-1);
    mm=nu/(1-nu)*c0/(1+r0);
    kk2=(cc+kk+mm-w0+pw*Tax0)/(1+r0);
    kk2_low=(cc(1)+kk(1)+mm(1)-w0+pw*Tax0)/(1+r0);
    c1=interp1([0;kk2(kk2>=kk2_low)],[(1-nu)/(1-nu*(1-bt))*(w0-pw*Tax0);cc(kk2>=kk2_low)],kk,'linear');
    
    if max(max(abs(c1-c0)))<.0001
        break
    end
    c0=c1;
    
end

    % [M2_W a2_W]=feval('out_workers_Tax',[w2(1:100) r2(1:100)  zlb(1:100)' pw*Tax],p2,M0_W/(1+g),T);
        [a2_W M2_W c1_W c2_W]=feval('out_workers_simple3',[w_hist r_hist ],p2,M0_W/(1+g),pw*(1-expand).*Tax,c0);

end        
     
[Y2(1:5)-(K2(2:6)-(1-dd)*K2(1:5)) C1(1:5)+C2(1:5)+c1_W(1:5)+c2_W(1:5)]

end


Tax2=Tax;

figure(1)
tt=1:40;
subplot(2,2,1),plot(tt,Y2(tt)./Y2(1))
axis([0 40 .9 1.01])
title('debt to capital ratio, \theta_t')
subplot(2,2,2),plot(tt,Z2(tt)/Z2(1))
axis([0 40 .9 1.01])
title('TFP')
subplot(2,2,3),plot(tt,K2(tt)/K2(1))
axis([0 40 .9 1.01])
title('capital')
subplot(2,2,4),plot(tt,B2(tt)./(4*Y2(tt)))
axis([0 40 0 2.5])
title('government debt')

save lognormal_B_bailout_00_smooth_201902.mat Y2 Z2 K2 B2 r2 w2 zlow2 Tax2
% save lognormal_B_bailout_0075_smooth_201902.mat Y2 Z2 K2 B2 r2 w2 zlow2 Tax2 M2 p2
