%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SVAR: This file replicates Figure B6 in the paper 
disp(' --------------------------------------------------------------------')
disp('  ')
disp(' Structural VAR - Instrumental Variable ')
disp('  ')
disp('           Figure B6   ')
disp('  ')
disp(' --------------------------------------------------------------------')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')

plot_for_paper =1;
diff_counter = 1;
init_group = 2;%groups to plot
end_group  = 7;
init_entry = 3;%3->start from the initial age group
num_age_groups = 7;% max column in th VAR

for entry_variable=init_entry:num_age_groups
% Load Data
CONTROLS            = xlsread('data/FF_DATA.xlsx','CONTROLS');
NARR                = xlsread('data/FF_DATA.xlsx','FF PROXIES'); 
PROX                = NARR(:,2);
PROX(isnan(PROX))   = 0;
PRATE_AGE           = xlsread('data/FF_DATA.xlsx','PRATE');
ATR_AGE             = xlsread('data/FF_DATA.xlsx','ATR'); 
AMTR_AGE            = xlsread('data/FF_DATA.xlsx','AMTR'); 

for diff_idx=1:4-(entry_variable - init_entry) % because of this URATE changes to pick up the differences while the participation rate is unchanged

URATE_AGE = xlsread('data/FF_DATA.xlsx','DIFF URATE'); 
diff_counter = diff_counter+1; 
                
DATASET.TSERIES = [AMTR_AGE(:,1) AMTR_AGE(:,2) URATE_AGE(:,entry_variable) PRATE_AGE(:,entry_variable) CONTROLS(:,2)  CONTROLS(:,6:10)   PROX ATR_AGE(:,2) ];
DATASET.LABEL   = {'DATES','AMTR_AGE','UR_AGE','PR_AGE','RGDP','GOV_TOT','STPRICE','DDEBT','AVTAX','DFFR','PROX', 'ATR_AGE'};
DATASET.UNIT    = [     0     1           1       1       2        1         1        1      1       2        2       1 ];
DATASET.FIGLABELS= [{'year' ,'Average Marginal Tax Rate','Unemployment Rate Age','Participation Rate Age','Real GDP', ...
                    'Government Spending','Real Stock Prices', 'DlogDebt','Avg Tax','DFFR','AMTR proxy','Avg Tax Age'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
SPEC.sb              = 1961;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [  ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 5; % Length of IR horizon 

SPEC.select_variables = {'AMTR_AGE','ATR_AGE','RGDP','GOV_TOT','DDEBT','STPRICE','DFFR','UR_AGE','PR_AGE'};
plotdisplay = {'UR_AGE','PR_AGE'};
    
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

% Estimate SVARIV model
SVARIV               = SPEC;
SVARIV               = doProxySVAR(SVARIV); 

% Inference:
clevel              = [95 68];    % CI Percentiles
SVARIVci            = doProxySVARci(SVARIV,clevel,3);

% Make Plot 
name = '_SVARIV';

display1= cell2mat(values(SVARIV.MAP,plotdisplay));
% Save Output from every iteration
FF_SVARIV(:,:,diff_counter) = SVARIV.irs(:,display1);% time,UR or PR,age group
FF_SVARIVciL(:,:,:,diff_counter) = squeeze(SVARIVci.irsL(:,display1,:));% time,UR or PR,age group
FF_SVARIVciH(:,:,:,diff_counter) = squeeze(SVARIVci.irsH(:,display1,:));% time,UR or PR,age group
end
end

avg_lf_share = [ (0.067613748+0.114089218)	0.237455049	0.228682514	0.195562158	0.120387512	0.036209801];
idx_ur = 1;
FIGLABELS_UR = {'SHOULD NOT HAPPEN!','A. UNR_{1624}-UNR_{2534}','B. UNR_{1624}-UNR_{3544}','C. UNR_{1624}-UNR_{4554}','D. UNR_{1624}-UNR_{5564}',...
                                         'E. UNR_{2534}-UNR_{3544}','F. UNR_{2534}-UNR_{4554}','G. UNR_{2534}-UNR_{5564}',...
                                         'H. UNR_{3544}-UNR_{4554}','I. UNR_{3544}-UNR_{5564}',...
                                         'J. UNR_{4554}-UNR_{5564}'};
plot_style_estimated = 'o-';

numrows =2;
numcols =5;
%% IRFS Unemployment Rate by Age
figure('units','normalized','outerposition',[0 0 1 1])
for nvar = init_group:diff_counter
                  
        box on
        hold on
           subplot(numrows,numcols,nvar-init_group+1);
            plot(0:SVARIV.irhor-1,FF_SVARIV(:,idx_ur,nvar),plot_style_estimated,'MarkerSize',4,'LineWidth',2,'Color', [0 0 0.5]);hold on
            if isempty(SVARIVci)==0
                if isempty(FF_SVARIVciH)==0
                p1=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_ur,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_ur,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                end
                if size(FF_SVARIVciH,2)>1
                p2=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_ur,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_ur,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');              
                end               
            end
            hline(0,'k-')
            ti=title( FIGLABELS_UR{nvar});
            xl=xlabel('horizon (years)','Fontsize',8);
            yl=ylabel('percentage points','Fontsize',8);
            set(gca,'XTick',0:1:10)
            set([xl,yl], 'FontName', 'AvantGarde','FontSize',12);
            set([ti], 'FontName', 'AvantGarde','FontSize',16);
            grid on
            axis manual
            axis([0 SVARIV.irhor-1 -1.5 1.5])
end
str=strcat('FF_figures/',name,'_','diff_urate_age_FigureB6');
saveas(gcf,str,'epsc');

