clear all; 
close all;
clc;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIGURE 7                                                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Age-specific AMTRs
disp('Age-specific AMTRs:');  

% h=0: impact elas.
IMPACT_ELAS_AGE=[2.14 2.63 1.49 1.79 1.47 1.24]/100;
disp('Age-specific impact elasticities (h=0):')
disp('    16-24     25-34     35-44     45-54     55-64     65+')
disp(IMPACT_ELAS_AGE)

% h=1: lagged elas.
LAGGED_ELAS_AGE=[2.59 3.42 3.00 3.68 3.13 1.92]/100;
disp('Age-specific lagged elasticities (h=1):')
disp('    16-24     25-34     35-44     45-54     55-64     65+')
disp(LAGGED_ELAS_AGE)

IRF_UNR_16PL_by_age   = IMPACT_ELAS_AGE; % impact elasticities 
IRF_UNR_16PL_by_age_2 = LAGGED_ELAS_AGE; % lagged elasticities 

% Age-specific labor force shares
% Age:            16-24         25-34        35-44      45-54     55-64        65+
lfs_age_1950=[0.185223288	0.235004541	0.224302971	0.183953406	0.12269365  0.048822144];
lfs_age_1955=[0.15006882	0.231552655	0.236837788	0.199805973	0.130910852	0.050823912];
lfs_age_1960=[0.165800145	0.206563785	0.23366175	0.213298481	0.134798043	0.045877796];
lfs_age_1965=[0.190300416	0.191148802	0.226182228	0.211628711	0.139006627	0.041733215];
lfs_age_1970=[0.215612245	0.205814068	0.198589272	0.204759949	0.136313662	0.038910804];
lfs_age_1975=[0.241218708	0.243821593	0.180261977	0.182177039	0.120993699	0.031526984];
lfs_age_1980=[0.236586489	0.273301867	0.191354633	0.158120967	0.112069335	0.028566709];
lfs_age_1985=[0.204564302	0.29057079	0.225813134	0.150022915	0.103856633	0.025172226];
lfs_age_1990=[0.178738993	0.285515526	0.255438954	0.160904827	0.09198128	0.02742042 ];
lfs_age_1995=[0.162149854	0.258477093	0.270219524	0.190640193	0.089644452	0.028868883];
lfs_age_2000=[0.15795026	0.22972984	0.263474671	0.217919705	0.100687439	0.030238085];
lfs_age_2005=[0.149280045	0.216584898	0.241291249	0.230394113	0.127103486	0.03534621 ];

% Age-specific unemployment rates
% Age:           16-24          25-34       35-44       45-54      55-64        65+
unr_age_1950=[0.093206243	0.048051437	0.037958053	0.041754657	0.048169094	0.045243779];
unr_age_1955=[0.086636094	0.038266337	0.033808609	0.033583693	0.041713167	0.03633567 ];
unr_age_1960=[0.112192305	0.052315037	0.041269272	0.041337478	0.04219237	0.038062193];
unr_age_1965=[0.100996318	0.037152192	0.032446743	0.027702267	0.031071604	0.032960549];
unr_age_1970=[0.11048955	0.042098775	0.031356465	0.028075938	0.02738694	0.032162078];
unr_age_1975=[0.160568963	0.077679775	0.056239432	0.052282417	0.045816104	0.05256927 ];
unr_age_1980=[0.138495287	0.069240025	0.04594785	0.039948155	0.033285587	0.030961019];
unr_age_1985=[0.135726156	0.069789566	0.051404408	0.046949418	0.043162818	0.032084182];
unr_age_1990=[0.111614983	0.055516513	0.041308366	0.035698558	0.03337677	0.030284734];
unr_age_1995=[0.120750935	0.053846004	0.043343271	0.033475181	0.035882663	0.040144871];
unr_age_2000=[0.093376158	0.036838691	0.030168455	0.024516036	0.024704687	0.030693701];
unr_age_2005=[0.113097085	0.051346734	0.038859091	0.034747875	0.033203074	0.034814873]; 

% Counterfactuals: percentage changes implied by changing labor force shares
% using age-specific elasticities (impact response)
dUNR_16PL_ctrfl_1950=((IRF_UNR_16PL_by_age.*unr_age_1950)*lfs_age_1950')*100;
dUNR_16PL_ctrfl_1955=((IRF_UNR_16PL_by_age.*unr_age_1955)*lfs_age_1955')*100;
dUNR_16PL_ctrfl_1960=((IRF_UNR_16PL_by_age.*unr_age_1960)*lfs_age_1960')*100;
dUNR_16PL_ctrfl_1965=((IRF_UNR_16PL_by_age.*unr_age_1965)*lfs_age_1965')*100;
dUNR_16PL_ctrfl_1970=((IRF_UNR_16PL_by_age.*unr_age_1970)*lfs_age_1970')*100;
dUNR_16PL_ctrfl_1975=((IRF_UNR_16PL_by_age.*unr_age_1975)*lfs_age_1975')*100;
dUNR_16PL_ctrfl_1980=((IRF_UNR_16PL_by_age.*unr_age_1980)*lfs_age_1980')*100;
dUNR_16PL_ctrfl_1985=((IRF_UNR_16PL_by_age.*unr_age_1985)*lfs_age_1985')*100;
dUNR_16PL_ctrfl_1990=((IRF_UNR_16PL_by_age.*unr_age_1990)*lfs_age_1990')*100;
dUNR_16PL_ctrfl_1995=((IRF_UNR_16PL_by_age.*unr_age_1995)*lfs_age_1995')*100;
dUNR_16PL_ctrfl_2000=((IRF_UNR_16PL_by_age.*unr_age_2000)*lfs_age_2000')*100;
dUNR_16PL_ctrfl_2005=((IRF_UNR_16PL_by_age.*unr_age_2005)*lfs_age_2005')*100;

dUNR_16PL_ctrfl=[dUNR_16PL_ctrfl_1950 dUNR_16PL_ctrfl_1955 dUNR_16PL_ctrfl_1960...
    dUNR_16PL_ctrfl_1965 dUNR_16PL_ctrfl_1970 dUNR_16PL_ctrfl_1975 dUNR_16PL_ctrfl_1980...
    dUNR_16PL_ctrfl_1985 dUNR_16PL_ctrfl_1990 dUNR_16PL_ctrfl_1995 dUNR_16PL_ctrfl_2000...
    dUNR_16PL_ctrfl_2005];

% Counterfactuals: percentage changes implied by changing labor force shares
% using age-specific elasticities (1-year ahead)
dUNR_16PL_ctrfl_2_1950=((IRF_UNR_16PL_by_age_2.*unr_age_1950)*lfs_age_1950')*100;
dUNR_16PL_ctrfl_2_1955=((IRF_UNR_16PL_by_age_2.*unr_age_1955)*lfs_age_1955')*100;
dUNR_16PL_ctrfl_2_1960=((IRF_UNR_16PL_by_age_2.*unr_age_1960)*lfs_age_1960')*100;
dUNR_16PL_ctrfl_2_1965=((IRF_UNR_16PL_by_age_2.*unr_age_1965)*lfs_age_1965')*100;
dUNR_16PL_ctrfl_2_1970=((IRF_UNR_16PL_by_age_2.*unr_age_1970)*lfs_age_1970')*100;
dUNR_16PL_ctrfl_2_1975=((IRF_UNR_16PL_by_age_2.*unr_age_1975)*lfs_age_1975')*100;
dUNR_16PL_ctrfl_2_1980=((IRF_UNR_16PL_by_age_2.*unr_age_1980)*lfs_age_1980')*100;
dUNR_16PL_ctrfl_2_1985=((IRF_UNR_16PL_by_age_2.*unr_age_1985)*lfs_age_1985')*100;
dUNR_16PL_ctrfl_2_1990=((IRF_UNR_16PL_by_age_2.*unr_age_1990)*lfs_age_1990')*100;
dUNR_16PL_ctrfl_2_1995=((IRF_UNR_16PL_by_age_2.*unr_age_1995)*lfs_age_1995')*100;
dUNR_16PL_ctrfl_2_2000=((IRF_UNR_16PL_by_age_2.*unr_age_2000)*lfs_age_2000')*100;
dUNR_16PL_ctrfl_2_2005=((IRF_UNR_16PL_by_age_2.*unr_age_2005)*lfs_age_2005')*100;

dUNR_16PL_ctrfl_2=[dUNR_16PL_ctrfl_2_1950 dUNR_16PL_ctrfl_2_1955 dUNR_16PL_ctrfl_2_1960...
    dUNR_16PL_ctrfl_2_1965 dUNR_16PL_ctrfl_2_1970 dUNR_16PL_ctrfl_2_1975 dUNR_16PL_ctrfl_2_1980...
    dUNR_16PL_ctrfl_2_1985 dUNR_16PL_ctrfl_2_1990 dUNR_16PL_ctrfl_2_1995 dUNR_16PL_ctrfl_2_2000...
    dUNR_16PL_ctrfl_2_2005];

% Converting the counterfactual responses from a 1 percent to a 1 percentage
% point cut in the tax rate: 0.01/0.2972=0.0336
dUNR_16PL_ctrfl_to_1pp_cut_in_tax   = dUNR_16PL_ctrfl*3.36;
dUNR_16PL_ctrfl_2_to_1pp_cut_in_tax = dUNR_16PL_ctrfl_2*3.36;

% Counterfactual aggregate unemployment response
% h=1
disp('Counterfactual aggregate unemployment response (h=0):')
disp('')
disp(dUNR_16PL_ctrfl_to_1pp_cut_in_tax)

% h=2
disp('Counterfactual aggregate unemployment response (h=1):')
disp('')
disp(dUNR_16PL_ctrfl_2_to_1pp_cut_in_tax)
    
% Figure 7
f=figure; 
[AX,H1,H2]=plotyy(1:12,-1*dUNR_16PL_ctrfl_to_1pp_cut_in_tax,1:12,-1*dUNR_16PL_ctrfl_2_to_1pp_cut_in_tax);
set(AX,'XTick',[1 2 3 4 5 6 7 8 9 10 11 12]);
set(AX,'XTickLabel',['1950';'1955';'1960';'1965';'1970';'1975';'1980';'1985';'1990';'1995';'2000';'2005'])
set(AX,'XLim',[0.5 12.5])
set(AX(1),'ycolor',[0.0 0 0.5])
set(AX(2),'ycolor',[0.9 0 0.0])
set(AX(1),'YLim',[-0.85 -0.25])
set(AX(1),'YTick',[-0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.5 -0.45 -0.4 -0.35 -0.3 -0.25 -0.2 -0.15]);
set(AX(2),'YLim',[-1.0 -0.0])
set(AX(2),'YTick',[-1.0 -0.8 -0.6 -0.4 -0.2 -0.0]);
set(get(AX(1),'Ylabel'),'String','percentage points','FontName', 'AvantGarde','FontSize',12);
set(get(AX(2),'Ylabel'),'String','percentage points','FontName', 'AvantGarde','FontSize',12);
set(H1,'LineStyle','-','Marker','o','MarkerSize',4,'LineWidth',2,'Color',[0.0 0 0.5])
set(H2,'LineStyle','--','Marker','d','MarkerSize',4,'LineWidth',2,'Color',[0.9 0 0.0])
xl=xlabel('year');
ti=title('AC-adj URATE Response');
set(xl, 'FontName', 'AvantGarde','FontSize',12);
set(ti, 'FontName', 'AvantGarde','FontSize',12);
grid on
legend([H1;H2],'Impact response','Lagged response','Location','SouthEast')
legend boxoff
str=strcat('FF_figures/','AGING_Figure7');
saveas(gcf,str,'epsc');
