%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SVAR: This file replicates Figure 3 in the paper 
disp(' --------------------------------------------------------------------')
disp('  ')
disp(' Structural VAR - Instrumental Variable ')
disp('  ')
disp('              Figure 3 ')
disp('  ')
disp(' --------------------------------------------------------------------')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')


% Load Data
CONTROLS            = xlsread('data/FF_DATA.xlsx','CONTROLS');
NARR                = xlsread('data/FF_DATA.xlsx','FF PROXIES'); 
PROX                = NARR(:,2);

PROX(isnan(PROX))   = 0;

AMTR_AGE            = xlsread('data/FF_DATA.xlsx','AMTR'); 
URATE_AGE           = xlsread('data/FF_DATA.xlsx','URATE'); 
PRATE_AGE           = xlsread('data/FF_DATA.xlsx','PRATE'); 
ATR_AGE             = xlsread('data/FF_DATA.xlsx','ATR'); 

DATASET.TSERIES = [AMTR_AGE(:,1) AMTR_AGE(:,2) URATE_AGE(:,2) PRATE_AGE(:,2) CONTROLS(:,2)  CONTROLS(:,6:10)   PROX ATR_AGE(:,2) ];
DATASET.LABEL   = {'DATES','AMTR_AGE','UR_AGE','PR_AGE','RGDP','GOV_TOT','STPRICE','DDEBT','AVTAX','DFFR','PROX', 'ATR_AGE'};
DATASET.UNIT    = [     0     1           1       1       2        1         1        1      1       2        2       1 ];
DATASET.FIGLABELS= [{'year' ,'Average Marginal Tax Rate','Unemployment Rate Age','Participation Rate Age','Real GDP', ...
                    'Government Spending','Real Stock Prices', 'DlogDebt','Avg Tax','DFFR','AMTR proxy','Avg Tax Age'}];  
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
SPEC.sb              = 1961;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [   ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 5; % Length of IR horizon 
SPEC.select_variables = {'AMTR_AGE','ATR_AGE','RGDP','GOV_TOT','DDEBT','STPRICE','DFFR','UR_AGE','PR_AGE'};
plotdisplay = {'UR_AGE','PR_AGE','AMTR_AGE'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   

% Estimate SVARIV model
SVARIV               = SPEC;
SVARIV               = doProxySVAR(SVARIV); 

% Inference:
clevel              = [95 68];    % CI Percentiles
SVARIVci            = doProxySVARci(SVARIV,clevel,3);

% Make Plot 
name = '_SVARIV';

display1= cell2mat(values(SVARIV.MAP,plotdisplay));
% Save Output from every iteration
FF_SVARIV(:,:,2) = SVARIV.irs(:,display1);% time,UR or PR,age group
FF_SVARIVciL(:,:,:,2) = squeeze(SVARIVci.irsL(:,display1,:));% time,UR or PR,age group
FF_SVARIVciH(:,:,:,2) = squeeze(SVARIVci.irsH(:,display1,:));% time,UR or PR,age group

avg_lf_share = [ (0.067613748+0.114089218)	0.237455049	0.228682514	0.195562158	0.120387512	0.036209801];

idx_ur = 1;
idx_pr = 2;
idx_tax = 3;

plot_style_estimated = 'o-';
plot_for_paper =1;
fontsizetitle = 16;


numrows = 1;
numcols = 3;
FIGLABELS_UR = {'SHOULD NOT HAPPEN!','B. URATE 16+','B. URATE 16-24','C. URATE 25-34','D. URATE 35-44','E. URATE 45-54','F. URATE 55-64','G. URATE 65+'};
FIGLABELS_PR = {'SHOULD NOT HAPPEN!','C. PRATE 16+','B. PRATE 16-24','C. PRATE 25-34','D. PRATE 35-44','E. PRATE 45-54','F. PRATE 55-64','G. PRATE 65+'};
FIGLABELS_TR = {'SHOULD NOT HAPPEN!','A. AMTR 16+' ,'B. AMTR 16-24' ,'C. AMTR 25-34' ,'D. AMTR 35-44' ,'E. AMTR 45-54' ,'F. AMTR 55-64' ,'G. AMTR 65+'};

approx_digit = '%.3f';

%% IRFS: AMTR, URATE, and PRATE
figure('units','normalized','outerposition',[0 0 1 1])
nvar = 2;
        box on
            %% Amtr
            subplot(numrows,numcols,1);
            plot(0:SVARIV.irhor-1,FF_SVARIV(:,idx_tax,nvar),plot_style_estimated,'MarkerSize',4,'LineWidth',2,'Color', [0 0 0.5]);hold on

            if isempty(SVARIVci)==0
                if isempty(FF_SVARIVciH)==0
                p1=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_tax,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_tax,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                end
                if size(FF_SVARIVciH,2)>1
                p2=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_tax,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_tax,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');              
                end               
            end
            hline(0,'k-')
            ti=title( FIGLABELS_TR{nvar});
            xl=xlabel('horizon (years)','Fontsize',8);
            yl=ylabel('percentage points','Fontsize',8);
            set(gca,'XTick',0:1:10)
            set([xl,yl], 'FontName', 'AvantGarde','FontSize',12);
            set([ti], 'FontName', 'AvantGarde','FontSize',fontsizetitle);
            grid on
            axis manual
            axis([0 SVARIV.irhor-1 -1.5 1])
            %% Urate
            subplot(numrows,numcols,2);
            plot(0:SVARIV.irhor-1,FF_SVARIV(:,idx_ur,nvar),plot_style_estimated,'MarkerSize',4,'LineWidth',2,'Color', [0 0 0.5]);hold on
            if isempty(SVARIVci)==0
                if isempty(FF_SVARIVciH)==0
                p1=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_ur,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_ur,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                end
                if size(FF_SVARIVciH,2)>1
                p2=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_ur,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_ur,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');              
                end               
            end
            hline(0,'k-')
            ti=title( FIGLABELS_UR{nvar});
            xl=xlabel('horizon (years)','Fontsize',8);
            yl=ylabel('percentage points','Fontsize',8);
            set(gca,'XTick',0:1:10)
            set([xl,yl], 'FontName', 'AvantGarde','FontSize',12);
            set([ti], 'FontName', 'AvantGarde','FontSize',fontsizetitle);
            grid on
            axis manual
            axis([0 SVARIV.irhor-1 -1.5 1.])

            %% Prate
            subplot(numrows,numcols,3);
            plot(0:SVARIV.irhor-1,FF_SVARIV(:,idx_pr,nvar),plot_style_estimated,'MarkerSize',4,'LineWidth',2,'Color', [0 0 0.5]);hold on

            if isempty(SVARIVci)==0
                if isempty(FF_SVARIVciH)==0
                p1=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_pr,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_pr,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                end
                if size(FF_SVARIVciH,2)>1
                p2=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_pr,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_pr,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');              
                end               
            end
            hline(0,'k-')
            ti=title( FIGLABELS_PR{nvar});
            xl=xlabel('horizon (years)','Fontsize',8);
            yl=ylabel('percentage points','Fontsize',8);
            set(gca,'XTick',0:1:10)
            set([xl,yl], 'FontName', 'AvantGarde','FontSize',12);
            set([ti], 'FontName', 'AvantGarde','FontSize',fontsizetitle);
            grid on
            axis manual
            axis([0 SVARIV.irhor-1 -1.5 1])
            
str=strcat('FF_figures/',name,'_','Figure_3');
saveas(gcf,str,'epsc');

