clear;close all;clc;
% SVAR: This file replicates Figure 2, A1 and A2 in the paper 
disp(' --------------------------------------------------------------------')
disp('  ')
disp('              Figure 2, A1 and A2 ')
disp('  ')
disp(' --------------------------------------------------------------------')

init_plot = 2 ;end_plot = 7;%

AMTR_AGE_0     = xlsread('data/FF_DATA.xlsx','AMTR'); 
AMIITR_AGE_0   = xlsread('data/FF_DATA.xlsx','AMIITR'); 
AMPTR_AGE_0    = xlsread('data/FF_DATA.xlsx','AMPTR'); 

amtr_legend_string ={'Aggregate','16-24','25-34','35-44','45-54','55-64','65+'};
plot_linestyle = {'','b-','bo-','b*-','bx:','bv:','bs:','bd:','b^:'};

% Time Series Indicators and Plot Options
length_data = length(AMTR_AGE_0(:,1));
date_init = 16 ;date_end = length_data-3;
linethickness = 1.75;fontsizetitle = 25;fontsizelegend = 14;
fontsizeylabel = 10;fontsizexlabel = 10;linewidth_thickness =1;
color_string = [0 0 0.5];
xticks_value = [  1 5 10 15 20 25 30 35 40 45 50  ];
xtick_labels = {'1961','1965','1970','1975','1980','1985','1990','1995','2000','2005','2010'};
linewidth_thickness = [ 0 3.5 1.5*ones(1,7) ];

yaxis_string = 'percent'; xaxis_string = 'year'; 
scaling_amtr = 100;scaling_amiitr = 100;scaling_amptr = 100;
scaling_gr_inc = 100;
subplot_ix = 0; % 1-> separate figures for different age groups

%% AMTR
f180=figure(180);
for ii=init_plot:end_plot
    plot(scaling_amtr*AMTR_AGE_0(date_init:date_end,ii),plot_linestyle{ii},'Linewidth',linewidth_thickness(ii),'Color', color_string);hold on 
    grid on;  axis tight
end
h_legend = legend(amtr_legend_string);
title(' Average Marginal Tax Rates','FontName', 'AvantGarde','Fontsize',fontsizetitle);

ylabel(yaxis_string,'Fontsize',fontsizeylabel)
xlabel(xaxis_string,'Fontsize',fontsizexlabel)
set(h_legend,'FontSize',fontsizelegend,'Box', 'off','Location','Northeast');
try
    xticks(xticks_value)
catch
    xtick = [ 1 5:5:50 ];
end
xticklabels(xtick_labels)
axis manual
axis([1 52 15 45])
% set(gcf,'Position',[50 50 800 600])
str=strcat('FF_figures/','AMTR_Figure2');
saveas(gcf,str,'epsc');


%% AMIITR
f181=figure(181);
for ii=init_plot:end_plot
    plot(scaling_amtr*AMIITR_AGE_0(date_init:date_end,ii),plot_linestyle{ii},'Linewidth',linewidth_thickness(ii),'Color', color_string);hold on 
    grid on;  axis tight
end
h_legend = legend(amtr_legend_string);
title(' Average Marginal Individual Income Tax Rates','FontName', 'AvantGarde','Fontsize',fontsizetitle);
ylabel(yaxis_string,'Fontsize',fontsizeylabel)
xlabel(xaxis_string,'Fontsize',fontsizexlabel)
set(h_legend,'FontSize',fontsizelegend,'Box', 'off','Location','Northeast');
try
    xticks(xticks_value)
catch
    xtick = [ 1 5:5:50 ];
end
xticklabels(xtick_labels)
axis manual
axis([1 52 10 40])
% set(gcf,'Position',[50 50 800 600])
str=strcat('FF_figures/','AMIITR_FigureA1');
saveas(gcf,str,'epsc');


%% AMPTR
f182=figure(182);
for ii=init_plot:end_plot
    plot(scaling_amtr*AMPTR_AGE_0(date_init:date_end,ii),plot_linestyle{ii},'Linewidth',linewidth_thickness(ii),'Color', color_string);hold on 
    grid on;  axis tight
end
h_legend = legend(amtr_legend_string);
title(' Average Marginal Payroll Tax Rates','FontName', 'AvantGarde','Fontsize',fontsizetitle);
ylabel(yaxis_string,'Fontsize',fontsizeylabel)
xlabel(xaxis_string,'Fontsize',fontsizexlabel)
set(h_legend,'FontSize',fontsizelegend,'Box', 'off','Location','Southeast');
try
    xticks(xticks_value)
catch
    xtick = [ 1 5:5:50 ];
end
xticklabels(xtick_labels)
axis manual
axis([1 52 0 15])
% set(gcf,'Position',[50 50 800 600])

str=strcat('FF_figures/','AMPTR_FigureA2');
saveas(gcf,str,'epsc');

disp([' Avg AMTR      : ' num2str(100*nanmean(AMTR_AGE_0(date_init:date_end,init_plot:end_plot))) ])
disp([' Std AMTR      : ' num2str(100*nanstd(AMTR_AGE_0(date_init:date_end,init_plot:end_plot))) ])
disp([' Std AMIITR    : ' num2str(100*nanstd(AMIITR_AGE_0(date_init:date_end,init_plot:end_plot))) ])
disp([' Std AMPTR     : ' num2str(100*nanstd(AMPTR_AGE_0(date_init:date_end,init_plot:end_plot))) ])
for iv=init_plot:end_plot
for ii=init_plot:end_plot
    corr_with_aggregate(iv,ii) = corr(AMTR_AGE_0(date_init:date_end,ii),AMTR_AGE_0(date_init:date_end,iv));
end
disp([' Corr AMTR ' num2str(iv) ' : ' num2str(corr_with_aggregate(iv,:)) ])
end

