* use the fertility outcomes for moms created in 1b_cr_fertilityasoutcomes

do "D:\Data\workdata\704665\daycare\dofiles\first.do"

use "$work\analysis_daycare_onlymoms_everopen.dta", clear

* merge on controls
merge m:1 muni year using "$work/munic_controls_recode_ipolated.dta", keep(match master)
drop _merge

*rescale so that they are within 0-100 range
foreach var of varlist $contrvars{
replace `var'=0 if `var'<0
replace `var'=100 if `var'>100
}


******************* Effect of daycare on fertility


eststo clear
foreach var in $fertility {
eststo: areg `var' operating  $style2, abs(muni) cl(muni)
qui sum `var'_raw [aw `e(wexp)'] if e(sample)==1 & operating==0
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\fertility_moms_everD_yrapproval.tex", keep(operating) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) collabels(,none)
replace booktabs fragment  cells(b(star fmt(%9.3f)) se(par([ ])))  stats(dv N, fmt(%9.3f %9.0f) label("Control mean, dep. var." "Observations (cells)"))
mtitles ("No Kids" "Num. Kids" "Age at Fst. Birth" "Dad Ever Miss." ) ;
#delimit cr
