* analysis of take-up rate for DK towns (no kids and no of slots)
* analysis of missing obs per town

do "D:\Data\workdata\704665\daycare\dofiles\first.do"

******************* takup rate ***************************************************
* I use the 1 yr survivors as the relevant cohort size and NOT live births

use "$work\townsdata.dta",clear

preserve
bys Kommune_ID: keep if _n==1
keep Kommune_ID
rename Kommune_ID muni
save "$work\townid.dta",replace
dis _N
restore


merge 1:1 Kommune_ID year using "$work\daycareslots_bymuniyear_yrapproval.dta"
* we can merge all towns in the towns aggregate data

keep if _merge==3
drop _merge

* need for each year the nbr of children 3-7 years in the muni
* we have data for 1933-1950
* ie can look at nbr of kids/nbr of slots for years 1940-1950, right?
sort Kommune_ID year

foreach num of numlist 1940(1)1950{
foreach nums of numlist 3 4 5 6 7 {
gen age1`num'`nums'=.
}
}

gen survivors=livebirth-death01-death14

foreach num of numlist 1940(1)1950{
foreach nums of numlist 3 4 5 6 7 {
by Kommune_ID: replace age1`num'`nums'=survivors if year==`num'-`nums'
by Kommune_ID: egen age`num'`nums'=max(age1`num'`nums')
}
}

gen relevant_cohorts=.
foreach num of numlist 1940(1)1950{
egen relevantcohorts`num'=rowtotal(age`num'*) if year==`num'
replace relevant_cohorts=relevantcohorts`num'  if year==`num'
}


label var relevant_cohorts "Preschool aged 3-7"
drop age*  relevantcohorts*

preserve 
keep if year>=1940

gen share_covered=numslots_muni/relevant_cohorts

****************** FIRST STAGE, Appendix Table A11
sort id_by year
bys id_by: egen ever1=mean(operating_muni)
gen already=1 if numslots_muni>0 & operating_muni==0
replace already = 0 if already==.
bys id_by: egen already1=max(already)

label var operating_muni "Any Approved Preschool"

* estimate a first stage
estimates clear
* for all
eststo:  areg share_covered operating_muni i.year  if ever1>0,absorb(id_by) cl(id_by)
qui sum share_covered if e(sample)==1
estadd scalar dv=`r(mean)'

* without the always some preschool but may always be approved
eststo:  areg share_covered operating_muni i.year if already1!=1  &  ever1>0 ,absorb(id_by) cl(id_by)
qui sum share_covered  if e(sample)==1
estadd scalar dv=`r(mean)'

* without the never and always approved preschool
eststo:  areg share_covered operating_muni i.year if ever1!=0 & ever1!=1 ,absorb(id_by) cl(id_by)
qui sum share_covered if e(sample)==1
estadd scalar dv=`r(mean)'

#delimit ;
esttab using  "$results\firststage.tex", keep(operating_muni) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) mgroups("Share Enrolled, Ages 3-7", pattern(1 0  0) prefix(\multicolumn{@span}{c}{) suffix(}) span
erepeat(\cmidrule(lr){@span}))
replace booktabs fragment stats(dv N, label("Mean, dept. var." "Observations (cells)"))
mtitles ("1940-50, Ever Preschool"  "No Non-App. Preschool" "1940-1950, Switchers, Urb." ) ;
#delimit cr

restore




sort id_by year
bys id_by: egen ever1=mean(operating_muni)
gen already=1 if numslots_muni>0 & operating_muni==0
replace already = 0 if already==.
bys id_by: egen already1=max(already)

label var operating_muni "Any Approved Preschool"



***********************************************************************************
* Appendix Table A1
* number of births in following year
***********************************************************************************
sort Kommune_ID year
gen allbirths=livebirth+stillbirth
by Kommune_ID: gen births1=allbirth[_n+1]
by Kommune_ID: gen births2=allbirth[_n+2]
by Kommune_ID: gen births3=allbirth[_n+3]
egen births123=rowtotal(births1-births3)
gen lnbirths123=ln(births123)

estimates clear
* for all
eststo:  areg births123 operating_muni i.year  if ever1>0 & year<=1947,absorb(id_by) cl(id_by)
qui sum births123 if e(sample)==1
estadd scalar dv=`r(mean)'

* without the always some preschool but may always be approved
eststo:  areg births123 operating_muni i.year if already1!=1  &  ever1>0 & year<=1947,absorb(id_by) cl(id_by)
qui sum births123  if e(sample)==1
estadd scalar dv=`r(mean)'

* without the never and always approved preschool
eststo:  areg births123 operating_muni i.year if ever1!=0 & ever1!=1 & year<=1947,absorb(id_by) cl(id_by)
qui sum births123 if e(sample)==1
estadd scalar dv=`r(mean)'

#delimit ;
esttab using  "$results\births123.tex", keep(operating_muni) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) mgroups("No of Births (3 Yrs)", pattern(1 0  0) prefix(\multicolumn{@span}{c}{) suffix(}) span
erepeat(\cmidrule(lr){@span}))
replace booktabs fragment stats(dv N, label("Mean, dept. var." "Observations (cells)"))
mtitles ("Ever Preschool"  "No Non-App. Preschool" "1933-1947, Switchers, Urb." ) ;
#delimit cr

/* similar for ln births*/


***********************************************************************************
*********************missing obs for towns appendix table C1***********************
***********************************************************************************

use "$work\townsdata.dta",clear
gen fodyear=year
merge 1:m Kommune_ID fodyear using "$work\pop_daycare_popmunic_yrapproval.dta"

keep if _merge==3
drop _merge

gen N=1

* collapse
#delimit ;
collapse 
		(mean) livebirth death01 death14 pop male   numinst numslots numinstperpop numslotsperpop  popmunic  
		(max) operating
		(count) N
		(firstnm) Amtsnavn
		, by(Kommune_ID fodyear) fast;
#delimit cr

* missing obs
gen survivors=(livebirth-death01)
gen missing=N/survivors

encode Amtsnavn, gen(county)

***** Merge to Munic x Year Characteristics that are Interpolated
ren Kommune_ID muni
ren fodyear year
merge 1:1 muni year using "$work/munic_controls_recode_ipolated.dta", keep(match master)
drop _merge
*rescale so that they are within 0-100 range
foreach var of varlist $contrvars{
replace `var'=0 if `var'<0
replace `var'=100 if `var'>100
}

**** first year of approval
cap drop startingyear
sort muni year operating
by muni: gen afstyear = year if operating[_n]==1 & operating[_n-1]==0

bys muni: egen fstyear = mean(afstyear)
*note: this is missing for munis that already had childcare by 1933


**** Regression correlating missing obs with childcare for the 86 towns

label var operating "Any Approved Preschool"

global out missing


foreach vars of varlist $out{

	 areg `vars' operating  i.year   [aweight=N] , abs(muni) cl(muni)
	
	estimates store `vars'1
	qui sum `vars' [aw `e(wexp)'] if e(sample)==1
	estadd scalar dv=`r(mean)'
	 

	 areg `vars' operating  $style1 , abs(muni) cl(muni)

	
	estimates store `vars'2
	qui sum `vars' [aw `e(wexp)'] if e(sample)==1
	estadd scalar dv=`r(mean)'
	
	areg `vars' operating  i.year  $style2 , abs(muni) cl(muni)
			
	
	estimates store `vars'3
	qui sum `vars' [aw `e(wexp)'] if e(sample)==1
	estadd scalar dv=`r(mean)'
	
	

}

/*Creates the table  */
file open myfile using "$results\sharemissing_correlation_URB.tex", write replace
file write myfile "\begin{tabular}{p{2.5in} ccc}" _n "\toprule" _n ///
" Outcome   &         (1)   &         (2)  	& (3) 			 		\\" _n 
file close myfile
foreach vars of global out  {
	estout `vars'* using "$results\sharemissing_correlation_URB.tex", type ///
		append  cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
		stats(dv N, fmt(%9.3f %9.0f) labels("Mean of dep. var." "No. of obs.")) style(tex)  ///
		mlabels(,none) collabels(,none) ///
		keep(operating ) varlabels(operating "Any Approved Preschool at Age 3") ///
		prefoot("[.5em]") posthead("\midrule")
}
file open myfile using "$results\sharemissing_correlation_URB.tex", write append
file write myfile "\midrule" _n ///
"Cohort FE 									&    Yes   &         Yes  & 		Yes  	 \\" _n ///
"Municipality FE 										&    Yes   &         Yes  &        Yes 	 \\" _n ///
"Muni Controls (ipolated) 		&     No   &        Yes   &        Yes 		\\" _n ///
"County Trends		&     No   &         No   &        Yes 	\\" _n ///
"\bottomrule" _n "\end{tabular}"
file close myfile









