/* Phase in analysis

Mitchells Plain
FOR TUFTS SERVER - current cleaning from workingdata_v12



set more off

clear all
cap cd /cluster/tufts/jack_collab01/
* Set macros

use "workingdata/workingdata.dta", clear

*/

drop if switchmonthD == 1
keep if shortrun == 1
global IN  "SA Utilities/Phase in/Mitchell's Plain/Data and analysis"

global resdir "SA Utilities/Paper/Tables-Figures"

local r = 100

cap log close
*log using logfiles/het.txt, text replace name(het)
*global resdir "tablesfigures/"

cap file close NPV_het
file open NPV_het using "$IN/Data/admin_data/NPV_het.txt", write text replace // replace

file write NPV_het "Result" _tab "Shortrun" _tab "Characteristic" _tab "High" _tab "observed" _tab "bootstrap" ///
	_tab "se" _tab "ci normal lb" _tab "ci normal ub" _tab "ci bias lb" _tab "ci bias ub" _n

tempfile orig
save `orig', replace

xtset, clear

capture program drop boot
program define boot, rclass
preserve

	bsample, cluster(id) idcluster(newid)
	xtset newid monthyear
 
	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	
** Calculate mean NPV 
	
	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 // start with meter cost deficit
	gen NPV_1 = 0
	gen NPV_diff = .
	
	gen i = 1+.00643 // monthly rate
	
		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
		
		replace NPV_diff = NPV_1 / abs(NPV_0)
	
	
	sum NPV_diff
    return scalar NPV = r(mean)

	restore
   
end

// post observed mean, bootstrapped mean, bootstrapped se, normal CI, bias corrected CI


drop if switchmonth == monthyear
*keep if switcher == 1

	xtset, clear
	
	tempfile all
	save `all', replace
	
foreach var of varlist mlifeline_switch below_medkwh pval300 outstanding1 usuallylate ever_disconnected_cr { //  { //
	
	keep if shortrun == 1

		forval h = 0/1 {
		
				di "var is `var'"
				di "q is `q'"
	
				keep if `var' == `h'
				
				* get observed stats
							xtset id monthyear
							
							xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
							margins, at(pp = (0 1)) post
							gen rev_0 = _b[1._at]
							gen rev_1 = _b[2._at]
							
							xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
							margins, at(pp = (0 1)) post
							gen cost_0 = _b[1._at]
							gen cost_1 = _b[2._at]
							
							xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
							margins, at(pp = (0 1)) post
							gen timing_0 = _b[1._at]
							gen timing_1 = _b[2._at]
						
							sum rev_* cost_* timing_*
							
						
							gen NPV_0 = 0 // ignore meter cost 
							gen NPV_1 = 0
							gen NPV_diff = .
							
							gen i = 1+.00643 // monthly rate
							
								forval m = 0/1 {
							
								replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
								
								}
								replace NPV_diff = NPV_1 / abs(NPV_0)
							
							
							sum NPV_diff
							
							local observed = r(mean)
							local n = r(N)
						
							drop NPV_* i rev_* cost_* timing_*
							
				xtset, clear
				simulate mean=r(NPV), seed(5925169) reps(`r') : boot
	
				bstat, stat(`observed') n(`n')
				
				local b 	: display %-4.3f _b[mean]
				local se 	: display %-4.3f _se[mean]
				matrix bs = e(b_bs)
				local bs 	= bs[1,1]
				matrix ci_n = e(ci_normal)
				local ci_n_lb = ci_n[1,1]
				local ci_n_ub = ci_n[2,1]
				matrix ci_b = e(ci_bc)
				local ci_b_lb = ci_b[1,1]
				local ci_b_ub = ci_b[2,1]
				
				file write NPV_het "NPV_diff" _tab "`shortrun'" _tab "`var'" _tab "`h'" _tab "`b'" _tab "`bs'" _tab ///
					"`se'" _tab "`ci_n_lb'" _tab "`ci_n_ub'" _tab "`ci_b_lb'" _tab "`ci_b_ub'" _n
		
						
				use `all', clear
			
				} // end q loop
				
	} // end var loop

file close NPV_het 
