/* Phase in analysis

Mitchells Plain
FOR TUFTS SERVER - current cleaning from workingdata_v9



set more off
clear all

cap cd /cluster/tufts/jack_collab01/
* Set macros

cap log close
log using logfiles/NPV_alt.txt, text replace name(NPV_alt)
global resdir "tablesfigures/"

use "workingdata/workingdata.dta", clear
*/	
*********************************
  ** CE and NPV CALCULATIONS **
*********************************

** Calculate NPV at different annual rates

cap file close NPV_int
file open NPV_int using "$IN/Data/admin_data/NPV_int.txt", write text replace

file write NPV_int "rate" _tab "NPV_0" _tab "NPV_1"  _n

// interests rates from 0 to 25% annual, in intervals of 3%


foreach int of numlist 0 0.00247 0.00487 0.00721 0.00949 0.01171 0.01389 0.01601 0.01877 {

preserve

	drop if switchmonth == monthyear
	keep if shortrun == 1
	
	xi:xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xi:xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xi:xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	

** Calculate NPV 
	
	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 // ignore diff in meter cost
	gen NPV_1 = 0
	
	gen i = 1+`int' // monthly rate of 8%
	
	

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
	
	sum i
	local i = r(mean)
	sum NPV_0
	local post = r(mean)
	sum NPV_1 
	local pre = r(mean)
	
	file write NPV_int "`i'" _tab "`post'" _tab "`pre'"  _n
restore
}

cap file close NPV_int



* By average marginal cost



cap file close NPV_cost
file open NPV_cost using "$IN/Data/admin_data/NPV_cost.txt", write text replace

file write NPV_cost "mcX" _tab "NPV_0" _tab "NPV_1"  _n

foreach cost of numlist 0 0.5 1 1.5 2 2.5 3 {

preserve

	drop if switchmonth == monthyear
	keep if shortrun == 1
	replace cost = 1.1125 * mcons_30 * mc * `cost'
	label var cost "Average supply cost including recovery"

	replace cost = cost + 90 if disconnection_cr == 1 
	replace cost = cost + 1.74*(1-pp) // billing costs for postpaid
	replace cost = cost + (mcons_30 * vendor * pp)
	
	xi:xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xi:xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xi:xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	

** Calculate NPV 
	
	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 // ignore diff in meter cost
	gen NPV_1 = 0
	
	gen i = 1+0.00643 // monthly rate of 8%
	

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
	

	sum NPV_0
	local post = r(mean)
	sum NPV_1 
	local pre = r(mean)
	
	file write NPV_cost "`cost'" _tab "`post'" _tab "`pre'"  _n
restore
}

cap file close NPV_cost



* By impact on losses



cap file close NPV_loss
file open NPV_loss using "$IN/Data/admin_data/NPV_loss.txt", write text replace

file write NPV_loss "lossX" _tab "NPV_0" _tab "NPV_1"  _n

foreach loss of numlist 0 1 2 3 4 {

preserve

	drop if switchmonth == monthyear
	keep if shortrun == 1
	replace cost = (1 + .1125) * mcons_30 * mc
	replace cost = (1 + (.1125 * `loss')) * mcons_30 * mc if pp == 1
	label var cost "Average supply cost including recovery"

	replace cost = cost + 90 if disconnection_cr == 1 
	replace cost = cost + 1.74*(1-pp) // billing costs for postpaid
	replace cost = cost + (mcons_30 * vendor * pp)
	
	xi:xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xi:xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xi:xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	

** Calculate NPV 
	
	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 // ignore diff in meter cost
	gen NPV_1 = 0
	
	gen i = 1+0.00643 // monthly rate of 8%
	

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
	

	sum NPV_0
	local post = r(mean)
	sum NPV_1 
	local pre = r(mean)
	
	file write NPV_loss "`loss'" _tab "`post'" _tab "`pre'"  _n
restore
}

cap file close NPV_loss

 

cap log close
