%% f_gmm_inert
%
% compute GMM obj for the bunching problem.
% 

function r_obj = calcErrDirect(params, data)
    
    % pull out parameters
    e = params(1);
    
    % find highest person to bunch, pre-period
    maxInc = max(data.income);
    upperZ = min(data.zStar.*( (1-data.t0)./(1-data.t1) ).^e , maxInc);
    
    % find simulated bunching
    bSim = calcBFromZ(data.zStar, upperZ,data);
    
    % calculate objective as weighted inner product
    r_obj = bSim - data.bunch;
    
    
end