
local bwlist = "$bwList"
local sampleList = "$sampleList"

/********************************************************************************************/
/* Calculate bunching and bootstrap bunching, by age 1990-1999, for 68-73 year olds         */
/********************************************************************************************/


    local time1 "$S_TIME"
    local nBoot = 200
    noisily di "`sampleList'"
    noisily di "`bwlist'"

    qui foreach sample of local sampleList{

			local y1 1990
			if `y1'==1990{
				local y2 1999
				local yy "9099"
				local max = 30000
				local min = -10000
			}

			foreach bw of local bwlist{
				noisily di "`sample', `bw'"
				use "$datadir/cfopSSA_`sample'_`bw'" if ///
					age>=68 & age<=73 &  year>=`y1' & year<=`y2', clear

				/* collapse dataset to counts */
				collapse (sum) count (mean) real_threshold, by(realDistanceRound age)
				gen rd1k = realDistanceRound/1000
				egen total = total(count), by(age)
				gen prob = count/total
				gen order = _n
				sort order

				local row   0
				gen b           = .
				gen bSE         = .
				gen bSEDM       = .
				gen ageGraph    = .

				** Before age loop, generate bootstrap placeholders
				if (`y1' == 1990){
					forvalues bs = 1/`nBoot'{
						gen bsEstimate`bs' = .
					}
				}

				local exclude = round(3000/`bw',1)
				foreach age of numlist 67/73{

					/* set sample */
					gen sample =  age == `age' & inrange(realDistanceRound,`min', `max')
					sum real_threshold if sample
					local zstar = r(mean)

					/* set upper and lower limits, trying to avoid holes in the data; not perfect */
					# delimit ;
					capture bunchPoly realDistanceRound prob if sample,
							kink(0) exclude(`exclude') bw(`bw') degree(7) 
							keep(1) print(0) nboot(100)
					;
					# delimit cr
					local rc = _rc

					/* fill in for graphing */
					local ++row
					replace ageGraph    = `age' in `row'
					if `rc' == 0 {
						sort order
						replace b          = r(scaledMass) in `row'
						replace bSE        = r(scaledMassBS) in `row'
						replace bSEDM      = r(scaledMassSE) in `row'

						** Bootstrap distribution for some samples
						count if sample
						local nBins = r(N)
						gen residuals = prob-fit if sample
						forvalues bs = 1/`nBoot'{

							** draw from residuals
							sort sample realDistanceRound
							gen use = 1+round((`nBins'-1)*uniform(),1)
							by sample: gen bsProb = prob + residuals[use] if sample

							** compute bunching for BS sample, save numbers
							# delimit ;
							capture bunchPoly realDistanceRound bsProb if sample,
									kink(0) exclude(`exclude') bw(`bw') 
									degree(7) keep(0) print(0) nboot(0)
							;
							# delimit cr
							sort order
							replace bsEstimate`bs' = r(scaledMass) in `row'
							drop use bsProb
						}
						** end bootstrap loop
						drop residuals smoothDensity
                    
					} /* end if no error */
					if `rc' != 0{
						local rc = _rc
						noisily di "    age = `age', y1 = `y1', bw = `bw', sample = `sample': error code: `rc'"

						/* make a filler graph */
						if `age'>=59 & `age'<=73{
							gen zero_temp = 0 in 1
							# delimit ;
							twoway scatter zero_temp rd1k if _n==1,
									name(cfop`age', replace) legend(off) xtitle("") ytitle("") title("")
									xlabel(,nolabel) ylabel(,nolabel)
									graphregion(color(white))
							;
							# delimit cr
							replace b           = . in `row'
							replace bSE         = . in `row'
							drop zero_temp
						}
					} /* end if error */

					drop sample
				} /* end age loop */

				/* outsheet results to a table */
				sort order
				outsheet ageGraph b bSE`a1' if !missing(age) ///
					using "$tabdir/ageStatsDensPoly_`yy'_6871_`bw'_`sample'.txt", replace

				** outsheet bootsrap distribution 
        outsheet ageGraph bsEstimate* if !missing(bsEstimate1) using ///
					"$tabdir/ageBS_9099_6871_`bw'_`sample'.txt", replace
			} /* end bw loop */
    } /* end sample loop */

    local time2 "$S_TIME"
    noisily display "Analysis 1 started `time1', ended `time2'"


/********************************************************************************************/
/* Calculate bunching and bootstrap bunching, by year 1982-2003, for 66-69 year olds        */
/********************************************************************************************/

    local time1 "$S_TIME"
    local nBoot = 200
    qui foreach sample of local sampleList{

			if "`sample'" == "s1Main"               local sampleTitle "1% Sample, claim by 65, no SE Income"
			if "`sample'" == "s1Full"               local sampleTitle "1% Sample, no SE Income"
			if "`sample'" == "s1Both"               local sampleTitle "1% Sample, claim by 65"
			if "`sample'" == "s1SE"                 local sampleTitle "1% Sample, claim by 65, SE income"
			if "`sample'" == "s1Claim"              local sampleTitle "1% Sample, claimed, no SE income"
			if "`sample'" == "s1Placebo"            local sampleTitle "1% Sample, not yet claimed"

			local aaList "66 67 68 69 6668 6768 6669"
			foreach aa of local aaList{

				if `aa' == 66 {
					local a1 66
					local a2 66
				}
				if `aa' == 67 {
					local a1 67
					local a2 67
				}
				if `aa' == 68 {
					local a1 68
					local a2 68
				}
				if `aa' == 69 {
					local a1 69
					local a2 69
				}
			
				if `aa' == 6668 {
					local a1 66
					local a2 68
				}
				if `aa' == 6768 {
					local a1 67
					local a2 68
				}

				if `aa' == 6669 {
					local a1 66
					local a2 68
				}


				foreach bw of local bwlist{
				
					noisily di "  bw = `bw'"

					use "$datadir/cfopSSA_`sample'_`bw'" if age>=`a1' & age<=`a2'  ///
							& year>=1978 & year<=2002, clear


					/* collapse dataset to counts */
					collapse (sum) count (mean) real_threshold, by(realDistanceRound year)
					gen rd1k = realDistanceRound / 1e3
					egen total = total(count), by(year)
					gen prob = count/total

					/* fill in missings with true zeros*/
					keep if realDistanceRound>=-1e4 & realDistanceRound<=3e4
					gen panelVar = realDistanceRound/`bw'
					tsset year panelVar
					gen original = 1
					tsfill
					gen filledIn = missing(original)
					assert missing(realDistanceRound) & missing(count) & missing(prob) if filledIn
					replace realDistanceRound = `bw'*panelVar if filledIn
					replace prob = 0 if filledIn
					replace rd1k = realDistanceRound/1e3

					gen order = _n
					sort order

					local row   0
					gen b       = .
					gen bSE     = .
					gen bSEDM = .
					gen yearPost = .

					** bootstrap placeholders
					forvalues bs = 1/`nBoot'{
						gen bsEstimate`bs' = .
					}

					/* define kink as +/- 3k */
					local exclude = int(3000/`bw')
					qui levelsof year, local(years)
					foreach year of local years{

						if inrange(`year', 1978, 2003) { 
							local max = 30000
							local min = -10000

							sum realDistanceRound if year == `year'
							local max = min(`r(max)', `max')

							/* set sample */
							gen sample =  year == `year' & inrange(realDistanceRound, `min', `max') 
							sum real_threshold if sample
							local zstar = r(mean)

							# delimit ;
							capture bunchPoly realDistanceRound prob if sample,
									kink(0) exclude(`exclude') bw(`bw') 
									degree(7) keep(1) print(0) nboot(100)
							;
							# delimit cr
							local rc = _rc

							/* fill in results */
							local ++row
							sort order
							replace yearPost    = `year' in `row'
							if `rc' == 0{
								replace b           = r(scaledMass) in `row'
								replace bSE         = r(scaledMassBS) in `row'
								replace bSEDM       = r(scaledMassSE) in `row'

								** calculate bootstrap standard errors for appropriate years
								count if sample
								local nBins = r(N)
								gen residuals = prob-fit if sample
								forvalues bs = 1/`nBoot'{

									** draw from residuals
									sort sample realDistanceRound
									gen use = 1+round((`nBins'-1)*uniform(),1)
									by sample: gen bsProb = prob + residuals[use] if sample

									** compute bunching for BS sample, save numbers
									# delimit ;
									capture bunchPoly realDistanceRound bsProb if sample,
										kink(0) exclude(`exclude') bw(`bw') 
										degree(7) keep(0) print(0) nboot(0)
									;
									# delimit cr
									sort order
									replace bsEstimate`bs' = r(scaledMass) in `row'
									drop use bsProb
								}
								** end bootstrap loop
								drop residuals smoothDensity
							}
							if `rc' != 0{
								noisily di "year = `year', a1 = `a1', bw = `bw', sample = `sample': error code: `rc'"
							}
							drop sample
						} /* end year if */
					} /* end year loop */

					/* outsheet to a table */
					sort order
					outsheet yearPost b bSE ///
						if !missing(yearPost) ///
						using "$tabdir/yearStatsDensPoly_7803_`aa'_`bw'_`sample'.txt", ///
						replace

					** outsheet bootstrap distribution
					outsheet yearPost bsEstimate*  ///
						if !missing(bsEstimate1) ///
						using "$tabdir/yearBS_7803_`aa'_`bw'_`sample'.txt", replace

					** Outsheet distribution
					outsheet year realDistanceRound prob ///
						if abs(rd1k)<=30 & (year==1989 | year==1990) ///
						using "$tabdir/yearDist_8990_`aa'_`bw'_`sample'.txt", replace
					
					noisily di "done with bw:`bw', sample=`sample', a1 `a1'"
				} /* end bw loop */
			} /* end aStart loop */
    } /* end ds loop */

    local time2 "$S_TIME"
    noisily display "Bunch structural started `time1', ended `time2'"
