
********************************************************************************
********************************************************************************
** Figures 4 a and B
********************************************************************************
********************************************************************************

local bw 800
local exclude = round(3000/`bw',1)

use "$datadir/dens800_8399", clear 

sort age rdR
by age: gen realDistanceRound = -9600 if _n == 1
by age: replace realDistanceRound = realDistanceRound[_n-1] + 800 if _n > 1
by age: egen tCount = total(count)
gen prob = count / tCount
gen order = _n
sort order
local row   0
gen b           = .
gen bSE         = .
gen bSEDM       = .
gen ageGraph    = .

qui forvalues age = 69/72 {
	
	local nox "nolabel"
	if `age' >= 69 local nox ""
	local noy "nolabel"
	if `age' == 59 | `age' == 64 | `age' == 69 local noy ""
	// Calculate bunching
	gen eSample =  age == `age'

	// estimate bunching, fill in table 
	bunchPoly realDistanceRound prob if eSample, kink(0) exclude(`exclude') ///
		bw(`bw') degree(7) keep(1) print(0) nboot(100)
	local ++row
	replace ageGraph    = `age' in `row'
	sort order
	replace b          = r(scaledMass)*`bw' in `row'
	replace bSE        = r(scaledMassBS)*`bw' in `row'
	replace bSEDM      = r(scaledMassSE)*`bw' in `row'

	
	
	// plot earnings distributions
	# delimit ;
	twoway 
		(connected prob rdR if age == `age', sort msize(small) mcolor("$blue"))
		(line smoothDensity rdR if age == `age', sort lcolor("$red"))
		,
		title("`age'", ring(0))
		xlabel(, `nox' labsize(small))
		xtitle("")
		xline(0, lcolor(gs12))
		ylabel(, labsize(small) `nox')
		legend(off)
		graphregion(color(white))
		name(g`age', replace)
		nodraw
	;
	# delimit cr
			
	drop smoothDensity fit eSample
	
}

list ageGraph b bSE  if ~missing(ageGraph) , noobs clean


# delimit ;
graph combine 
	g69 g70 g71 g72 , ycommon
	cols(2) imargin(small)
	xsize(6) ysize(6)
	l1title("Probability in bin") 
	b1title("Real distance to kink (thousands of dollars)")
	title("A. Earnings distribution by age", span pos(11))
	graphregion(color(white))
	name(bins, replace)
;
# delimit cr


gen upper = b + 1.96*bSE
gen lower = b - 1.96*bSE
# delimit ;
twoway
	(connected b ageGraph, mcolor("$blue"))
	(line upper ageGraph, lpattern(dash) lcolor("$red"))
	(line lower ageGraph, lpattern(dash) lcolor("$red")),
	title("B. Bunching amount by age", span pos(11))
	xtitle("") ytitle("")
	yline(0, lcolor(gs12))
	graphregion(color(white))
	xlabel(69(1)72)
	ylabel(0(1000)4000 ,format(%6.0f))
	legend(off)		
	name(ts, replace)
	
;
# delimit cr

format b upper lower %5.3f
list ageGraph b upper lower  if ~missing(ageGraph) , noobs clean

graph combine bins ts, cols(1) graphregion(color(white)) xsize(4) ysize(7)

graph export "$figdir/figure4.png", replace width(2000) height(3500)

