log using "/home/projects/sehs/replication/logs/tables1and2and3.log", replace

clear
set more off

*created by: LS
*created on: 02 feb 2015
*REVISED: Aug 22, 2017 
*REVISED: Jan 29, 2018 -- Convert table 3 to reflect marginal effects with the means at the discontinuity.

tempfile temp1 temp2 temp3 temp4 

use "/home/projects/sehs/replication/data/fullestsample_max.dta"
keep if inlist(sdcent,.25,.5)

gen centerrank=.
forvalues i=1/6 {
  replace centerrank=`i' if schoice==schoice`i'
}
tab centerrank
tab centerrank admit, row col
tab centerrank admit, row col, if tier==1
tab centerrank admit, row col, if tier==4
table centerrank admit, c(mean pointstotal mean centered)
table centerrank admit, c(mean pointstotal mean centered), if tier==1
table centerrank admit, c(mean pointstotal mean centered), if tier==4

keep sid
duplicates drop
sort sid
save `temp1'
clear

use "/home/projects/sehs/replication/data/analytic_replication"
drop if sid==.
* Keep only students enrolled in 9th grade
keep if sidtype=="both" | sidtype=="only9"
#delimit;
global grade8 "black8 hisp8 white8 asian8 male8 frpl8 assignedsch8 MATH_NPR gpacore7 pointstotal 
	eligible selectruleany selective ";
global chars "ACT APpct cohgrad collenrollpct oss_kidspct raceherf2 pctmale pctiep pctfrl 
	stds_prs2 stds_humr stds_sats";
#delimit cr

* Merge on identifiers for the sample within one-half SD of the cut-off
sort sid
merge m:1 sid using `temp1'
gen halfsdsample=_merge==3

gen selectruleany=offerrule~=""

*Standardize the latent 8
gen stdlatent8=.
sum latent8 if sidtype=="both" & cohort9==2010
replace stdlatent8=(latent8-r(mean))/r(sd) if cohort9==2010
sum latent8 if sidtype=="both" & cohort9==2011
replace stdlatent8=(latent8-r(mean))/r(sd) if cohort9==2011
sum latent8 if sidtype=="both" & cohort9==2012
replace stdlatent8=(latent8-r(mean))/r(sd) if cohort9==2012
sum latent8 if sidtype=="both" & cohort9==2013
replace stdlatent8=(latent8-r(mean))/r(sd) if cohort9==2013
sum stdlatent8 if sidtype=="both"
table cohort9 if sidtype=="both", c(mean stdlatent8)



* Table 1
file close _all
file open myfile using "/home/projects/sehs/replication/tables/table1.txt", write replace
file write myfile "Variable" _tab "Variable Label" _tab "Selective = yes" _tab "Selective = no" _n

foreach v of varlist $chars {
        sum `v' if selective==0
        local mean0 = round(r(mean),.1)
        local sd0 = round(r(sd),.1)
        sum `v' if selective==1
        local mean1 = round(r(mean),.1)
        local sd1 = round(r(sd),.1)
        local z: variable label `v'
        file write myfile "`v'" _tab "`z'" _tab %8.3f "`mean1'" _tab %8.3f "`mean0'" _n
        file write myfile _tab _tab "(" %8.3f "`sd1'" ")" _tab "(" %8.3f "`sd0'" ")" _n
}
file close _all

* Table 2
sum $grade8 if dsped8==0 & (sidtype=="both"|sidtype=="only9")
sum $grade8 if completeapp==1 & dsped8==0 & (sidtype=="both"|sidtype=="only9")
sum $grade8 if halfsdsample==1
sum $grade8 if halfsdsample==1 & tier==1
sum $grade8 if halfsdsample==1 & tier==2
sum $grade8 if halfsdsample==1 & tier==3
sum $grade8 if halfsdsample==1 & tier==4

* Table 3
use "/home/projects/sehs/replication/data/fullestsample_max.dta", clear
keep if inlist(sdcent,.25,.5)
#delimit ;
global grade8i "black8_1 black8_2 black8_3 black8_4 hisp8_1 hisp8_2 hisp8_3 hisp8_4 male8_1 male8_2 male8_3 male8_4
        frpl8_1 frpl8_2 frpl8_3 frpl8_4 assignedsch8_1 assignedsch8_2 assignedsch8_3 assignedsch8_4";
#delimit cr

quietly tab tierschcoh, gen(tsc)

foreach v of global chars {
reg `v' i.tier1 i.tier2 i.tier3 i.tier4 centeredXtier1-centeredXtier4 i.admitXtier1 i.admitXtier2 i.admitXtier3 i.admitXtier4 centeredXadmitXtier1-centeredXadmitXtier4 tsc1-tsc143, cluster(schoice_n)
test i1.admitXtier1=i1.admitXtier4
outreg2 i1.admitXtier1 i1.admitXtier2 i1.admitXtier3 i1.admitXtier4 using "/home/projects/sehs/replication/tables/table3.xml", nocons keep(i.admitXtier1 i.admitXtier2 i.admitXtier3 i.admitXtier4) excel se dec(3) addstat(p-value, `r(p)') append
margins admitXtier1, at(centeredXtier1=0 centeredXadmitXtier1=0) subpop(tier1)
margins admitXtier4, at(centeredXtier4=0 centeredXadmitXtier4=0) subpop(tier4)


}

file close _all
