###################################################################
# Name              : AssembleBootstrapFM_invar.R
# Description       : This program puts together all the results on the 
#                     bootstrapped samples and ouputs estimates of the 
#                     measurement system in the case where we allow 
#                     factor loadings and intercepts to vary between 
#                     treatment and control groups. 
###################################################################




setwd(dir_anal)                             
source(inputFM) 

##################################################################
# Put together the output from the boostrap if it has been 
# estimated on several R windows ("nodes")
##################################################################

# Put all the results from the different nodes together in a list called "allbootFM" 
cores              <- length(pos)               # Total number of nodes 
allbootFM          <- list()


setwd(dir_outputFM)                              # Save this list in the directory with the output for the measurement system 
for (b in 1:cores){  
  nameBootFM         <- paste("BootFM", pos[b], ".R", sep="")
  load(nameBootFM)
  allbootFM[[b]] <- bootFM
}

save(allbootFM, file="allbootFM.R")

# Save the different components of this list into separate obejctves
allbsample      <- bsample * cores 
probBoot        <- array(0, dim=c(nM, allbsample,nG))
meanBoot        <- array(0, dim=c(nM, nFI, allbsample,nG))
covBoot         <- array(0, dim=c(nFI*2, nFI, allbsample, nG))
lambdaBoot      <- array(0, dim=c(nZ, nF, allbsample, nG))
interBoot      <- array(0, dim = c(nZ, allbsample, nG))
epsBoot         <- array(0, dim=c(nZ,  allbsample))



for (c in 1:cores){
  for (r in 1:(allbsample/cores)){
   
    for (g in 1:nG){
      if (length(allbootFM[[c]][[r]]) == 1){
        probBoot[,(c-1)*(allbsample/cores) + r,g] <- rep(NA, nM)
        meanBoot[,,(c-1)*(allbsample/cores) + r,g] <- matrix(NA, nM, nFI)
        covBoot[,,(c-1)*(allbsample/cores) + r,g]   <- matrix(NA,nFI*2, nFI  )
        lambdaBoot[,,(c-1)*(allbsample/cores) + r, g] <- matrix(NA, nZ, nF)
        interBoot[,(c-1)*(allbsample/cores) + r,g]    <- matrix(NA, nZ, 1)
    } else if (length(allbootFM[[c]][[r]]) != 1){ 
      probBoot[,(c-1)*(allbsample/cores) + r,g]    <- allbootFM[[c]][[r]]$prob[[g]]     
      meanBoot[,,(c-1)*(allbsample/cores) + r,g]   <- allbootFM[[c]][[r]]$mean[[g]]
      covBoot[,,(c-1)*(allbsample/cores) + r,g]    <- rbind(allbootFM[[c]][[r]]$cov[[g]][[1]],allbootFM[[c]][[r]]$cov[[g]][[2]])
      lambdaBoot[,,(c-1)*(allbsample/cores) + r, g]     <- allbootFM[[c]][[r]]$lambda[[g]]
   interBoot[,(c-1)*(allbsample/cores)+r,g] <- allbootFM[[c]][[r]]$int[[g]]
       }  
    
    if (length(allbootFM[[c]][[r]]) == 1){
      epsBoot[,(c-1)*(allbsample/cores) + r]    <- rep(NA, nZ)        
    } else if (length(allbootFM[[c]][[r]]) != 1){
    epsBoot[,(c-1)*(allbsample/cores) + r]         <- allbootFM[[c]][[r]]$eps   
    } 
    
  }  
}
} 


bootFMlong <- list()
for (c in 1:cores){
  for (r in 1:bsample){
    bootFMlong[[(c-1)*(allbsample/cores) + r]]<- allbootFM[[c]][[r]]
  }
}

# Flag those bootstrap samples that didn't work
flag <- 0
for (b in 1:allbsample){
  if (length(bootFMlong[[b]])==1) {
    flag <- c(flag, b)
  } else if (length(bootFMlong[[b]])!=1){
    flag <- flag
  }
}

if (length(flag)==1){
  noflag = seq(1, allbsample)
} else if (length(flag)>=1){
  flag = flag[-1]
  noflag       <- seq(1, allbsample)
  noflag       <- noflag[-flag]
}
nof          <- length(noflag)


##################################################################
# Save estimates of the different parameters of the 
# measurement system (point estimates and bootstrapped 
# standard errors)
##################################################################

# Load the estimates obtained on the true data 
setwd(dir_outputFM)
load("trueFM.R")

# Mixture weights  
probSE <- matrix(0, 4, 2)
for (g in 1:2){
  probSE[1,g] <- prob.mix[[g]][1]
  probSE[2,g] <- apply(probBoot[,,g], 1, sd, na.rm=TRUE)[1]
  probSE[3,g] <- prob.mix[[g]][2]
  probSE[4,g] <- apply(probBoot[,,g], 1, sd,na.rm=TRUE)[2]
} 
write.csv(probSE, file="probSE.csv")


# Means 
mean_sd <- array(0, dim=c(nM, nFI, nG))
for (g in 1:nG){
  for (m in 1:nM){
    for (f in 1:nFI){
      mean_sd[m,f,g]      <- sd(meanBoot[m,f,,g], na.rm=TRUE)
    }
  }
} 

meanSE <- array(0, dim=c(nM*2, nFI, nG))

for (i in 1:nM){
  for (g in 1:nG){
    meanSE[(i*2-1),,g] <- mean.mix[[g]][i,]
    meanSE[(i*2),,g]   <- mean_sd[i,,g]
  }
} 
write.csv(meanSE, file="meanSE.csv")

# Covariances 
cov_sd <- array(0,dim=c(nFI*2, nFI, nG))
for (g in 1:nG){  
  for (i in 1:(nFI*2)){
    for (j in 1:nFI){
      cov_sd[i,j,g]      <- sd(covBoot[i,j,,g], na.rm=TRUE)
    }
  }
} 

covSE <- array(0, dim=c(nFI*4, nFI, nG))
for (g in 1:nG){
  for (i in 1:(nFI*2)){
    covSE[(i*2-1),,g] <- cov.mix[[g]][i,]
    covSE[(i*2),,g]   <- cov_sd[i,,g]
  } 
}

write.csv(covSE, file="covSE.csv")


# Factor Loadings with SE 
lambda_sd1 <- matrix(0, nZ, nF)
for (i in 1:nZ){
  for (j in 1:nF){
    lambda_sd1[i,j]      <- sd(lambdaBoot[i,j,,1], na.rm=TRUE)
  }
}

lambdaSE1 <- matrix(0, (nZ*2), nF)
for (i in 1:nZ){
  lambdaSE1[(i*2-1),] <- lambda[[1]][i,]
  lambdaSE1[(i*2),] <- lambda_sd1[i,]
}

write.csv(lambdaSE1, file="lambdaSE1.csv")


# Factor Loadings with SE 
lambda_sd2 <- matrix(0, nZ, nF)
for (i in 1:nZ){
  for (j in 1:nF){
    lambda_sd2[i,j]      <- sd(lambdaBoot[i,j,,2], na.rm=TRUE)
  }
}

lambdaSE2 <- matrix(0, (nZ*2), nF)
for (i in 1:nZ){
  lambdaSE2[(i*2-1),] <- lambda[[2]][i,]
  lambdaSE2[(i*2),] <- lambda_sd2[i,]
}

write.csv(lambdaSE2, file="lambdaSE2.csv")

# Factor Loadings without SE 
write.csv(lambda, file="lambda.csv")

# Total implied means for each group 
totmean <- array(0, dim=c(3, nFI, nG)) 
intertotmean <- rep(0, 400)
for (g in 1:nG){
  totmean[1,,g] <- prob.mix[[g]]%*%mean.mix[[g]]
  for (f in 1:nFI){
  intertotmean  <- probBoot[1,,g]*meanBoot[1,f,,g] 
  for (m in 2:nM) intertotmean <- intertotmean + probBoot[m,,g]*meanBoot[m,f,,g] 
  totmean[2,f,g] <- sd(intertotmean, na.rm=TRUE)
  totmean[3,f,g] <- paste("[", round(quantile(intertotmean, .05, na.rm=TRUE),3), ",", round(quantile(intertotmean, .95, na.rm=TRUE),3), "]", sep="")    
  }
}

write.csv(totmean, file="totmeanSE.csv")


##################################################################
# Test equality of factor loadings between treated and control
##################################################################
# Factor loadings 
totest         <- which(invarload[,,2]==2)
beta           <- lambda[[1]][totest] - lambda[[2]][totest]
nP             <- length(beta)

bootbeta      <- matrix(NA, nP, nof)
for (b in 1:nof){
  bootbeta[,b] <- lambdaBoot[,,noflag[b],1][totest] - lambdaBoot[,,noflag[b],2][totest]
}

mbootbeta     <- rowMeans(bootbeta)
vcov        <- array(0, dim=c(nP, nP, nof))
for (i in 1:nof){
    vcov[,,i]    <- (bootbeta[,i] - mbootbeta) %*% t(bootbeta[,i] - mbootbeta)
}

vcovf       <- matrix(0, nP, nP)
for (j in 1:nP){
    for (k in 1:nP){
      vcovf[j,k]        <- 1/nof * sum(vcov[j,k,])
  }
}

test <- beta %*% solve(make.positive.definite(vcovf)) %*% beta

boottest <- rep(0,nof)
for (b in 1:nof){
  boottest[b] <- (bootbeta[,b] - beta )%*% solve(make.positive.definite(vcovf)) %*% matrix((bootbeta[,b] - beta ), nP, 1)
}

indicator        <- function(condition) ifelse(condition,1,0)
pvalue_invar_loadings         <- 1/nof * sum(indicator(boottest>rep(test, nof)))

setwd(dir_outputFM)
write.csv(pvalue_invar_loadings  , file="Ftest_invar_loadings.csv")

# Intercepts 
totest         <- which(invarint[,2]==2)
beta           <- intercept[[1]][totest] - intercept[[2]][totest]
nP             <- length(beta)

bootbeta      <- matrix(NA, nP, nof)
for (b in 1:nof){
  bootbeta[,b] <- interBoot[totest,noflag[b],1] - interBoot[totest,noflag[b],2]
}

mbootbeta     <- rowMeans(bootbeta)
vcov        <- array(0, dim=c(nP, nP, nof))
for (i in 1:nof){
  vcov[,,i]    <- (bootbeta[,i] - mbootbeta) %*% t(bootbeta[,i] - mbootbeta)
}

vcovf       <- matrix(0, nP, nP)
for (j in 1:nP){
  for (k in 1:nP){
    vcovf[j,k]        <- 1/nof * sum(vcov[j,k,])
  }
}

test <- beta %*% solve(make.positive.definite(vcovf)) %*% beta


boottest <- rep(0,nof)
for (b in 1:nof){
  boottest[b] <- (bootbeta[,b] - beta )%*% solve(make.positive.definite(vcovf)) %*% matrix((bootbeta[,b] - beta ), nP, 1)
}

indicator        <- function(condition) ifelse(condition,1,0)
pvalue_invar_intercept       <- 1/nof * sum(indicator(boottest>rep(test, nof)))

setwd(dir_outputFM)
write.csv(pvalue_invar_intercept  , file="Ftest_invar_intercept.csv")
