clear
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% QUANTITATIVE ANALYSIS
% 1. Appendix F Additional Tables (Gravity Equation Estimates)
% 2. Appendix D.5.2. Aggregate Moments
% 3. Appendix D.5 Quantitative results: moments, parameters and fit
% 4. Appendix D.5.3 The margins of trade
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 1. Appendix F Additional Tables (Gravity Equation Estimates)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The file tradeshare.m is not included in the folder. See Readme file for
% instructions on how to build the trade share matrix.
load tradeshare
numeraire=119;
% USA=119
load('cepii.mat')

% Gravity 
% Cepii costs estimates: Table 4 Gravity equation: Estimates
% Si estimates: Table 7 Gravity equation: Estimates
[s_tilde_us, predic_trade, tau, taudis, ssd, arr, cefsd]=grav_new(tradeshare,cepii);

thetalogtau=4*log(tau(119,:));

load output
y=output(:,1)/output(119,1);
l=output(:,2)/output(119,2);
pcy=output(:,3)/output(119,3);

load pwt
nom_gdp=pwt(:,4)/pwt(119,4);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 2. Appendix D.5.2. Aggregate Moments
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pcincome=fsolve(@(x) percapitay(x,l,tradeshare, numeraire),pcy);

labelss=importdata('ctry_label.csv');
yy=nom_gdp./l;
[R,P]=corrcoef(log(yy),log(pcincome))

figure(1)
lscatter(log(yy),log(pcincome), labelss, 'Fontsize', 10)
xlabel('Per capita GDP, current USD (2004), expenditure side (log), US=0','FontSize',15);
ylabel('Model: Income per person (log), US=0','FontSize',15)
hold on
plot([-10 2 ],[-10 2 ],'Color','k','LineWidth',2);
annotation('textbox',[.15 .9 0 0],'string','$corr(log\hat{E},logE)=0.87^{***}$','FontSize',12,'Interpreter','Latex')
axis([-10 2 -10 2])
set(gcf, 'PaperUnits', 'inches');
afFigurePosition = [.25 2.5 7 5];
set(gcf, 'PaperPosition', afFigurePosition);
set(gca,'FontSize',15);
print('figure_2', '-dpng')
hold off 

hh = (tradeshare(:)~=0);
[R,P]=corrcoef(tradeshare(hh),predic_trade(hh))
figure(2)
scatter(tradeshare(hh),predic_trade(hh), 'MarkerEdgeColor', 'black')
xlabel('Bilateral trade shares','FontSize',15);
ylabel('Predicted bilateral trade shares','FontSize',15)
hold on
plot([0 1],[0 1],'Color','k','LineWidth',2);
annotation('textbox',[.2 .8 0 0],'string','$corr(\hat{\lambda},\lambda)=0.913^{***}$','FontSize',12,'Interpreter','Latex')
set(gcf, 'PaperUnits', 'inches');
afFigurePosition = [.25 2.5 7 5];
set(gcf, 'PaperPosition', afFigurePosition);
set(gca,'FontSize',15);
print('figure_3', '-dpng')
hold off 



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 3. Appendix D.5 Quantitative results: moments, parameters and fit
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
pcy=pcincome;

S=500000;
R = unifrnd(0,1,1,S);
R=sort(R);
um=max(R);

% targeting the productivity and sales advantage from bejk and the price elasticity from mango :0.14
[over, fval,exitflag] = fminsearch (@(x) overid(x,R,um,tradeshare,l,pcy,thetalogtau, S, ssd),[2.7 1.9]);
kappa=over(1);
gamma=over(2);
%save over over
% load over
moments=feval(@(x) momens_four(x,R,um,tradeshare,l,pcy,thetalogtau, S, ssd),[kappa gamma]);

Em=1/((1+gamma)*(kappa-1));

logtau=4*log(tau);
tauss=exp(logtau/kappa);
thetalogtau=4*log(tau(119,:));
taus_us=exp(thetalogtau/kappa);
taus_us=taus_us/taus_us(1,119);
% Normalizing by ii trade costs for each country
for i=1:123
    tauss(i,:)=tauss(i,:)/tauss(i,i);
end
SS=exp(ssd);
SS=SS./SS(119);

wage=(l.*pcy./SS).^(1/(kappa+1));
wage=wage./wage(119);

chat_usj=pcy'./taus_us;
chat_cii=pcy'./taus_us/pcy(119);
chat_cii(119)=0;
ctilde_cii=max(chat_cii);

% Conditional on exporting firms
cii=(R/um).^(1/kappa)*ctilde_cii;
tij=(cii'*((chat_usj).^(-1)))';
delta=zeros(123,S);
for j=1:123
    for k=1:S
        if tij(j,k)<=1
            delta(j,k)=1;
        end
    end
end

for j=1:123
    mu_j(j,1)=(tauss(:,j)').^(-kappa)*(wage.^(-1-kappa).*l.*pcy);
end

for j=1:123
    first(j)=(l(j)*((taus_us(1,j)*wage(119))^(gamma+1))*(pcy(j)^(-gamma))*(mu_j(j)^(-1)));
end

for i=1:S
    for j=1:123
        sale(j,i)=first(j)*((cii(i)*gamma+chat_usj(j))*(chat_usj(j)-cii(i))^gamma);
    end
end

sale=sale.*delta;

tot_revenues=sum(sale);

sale_us=sale;
sale_us(119,:)=0;

tot_exports=sum(sale_us);

export_intensity=tot_exports./tot_revenues;

export_intensity=sort(export_intensity);

threshold=.1;
kk=1;
for i=1:S
    if export_intensity(i)>=threshold
        table(kk,1)=100*threshold;
        table(kk,2)=i;
        threshold=threshold+.1;
        kk=kk+1;
    end
end

tab(1)=100*table(1,2)/S;
for i=2:6
    tab(i)=(table(i,2)-table(i-1,2))*100/S;
end
tab(7)=(S-table(6,2))*100/S;

% TABLES 1 and 2
fid=fopen('table_1.tex','wt');
fprintf(fid,'\n \\begin{tabular}{lccc}');
fprintf(fid,'\n Moment & Model & Data & Source \\\\ \\hline');
fprintf(fid, '\n US Exporter Productivity Advantage & $%5.2f$ & 0.33 & BEJK \\\\', moments(1));
fprintf(fid, '\n US Exporter Sales Advantage & $%5.2f$ & 4.8 & BEJK \\\\', moments(2));
fprintf(fid, '\n US Av. Price Elasticity of Income & $%5.2f$ & 0.14 & Simonovska \\\\', moments(3));
fprintf(fid, '\n Population, relative to US & (N-1)x1 vector & WDI \\\\');
fprintf(fid, '\n Bilateral trade shares & Gravity & Comtrade \\\\ \\hline \\hline');
fprintf(fid,'\n Parameter & Value & &  \\\\ \\hline');
fprintf(fid,'\n $\\gamma$ & $%5.3f$ &  & \\\\' , gamma);
fprintf(fid,'\n $\\kappa$ & $%5.3f$  & & \\\\', kappa );
fprintf(fid,'\n L & (N-1)x1 vector &  & \\\\');
fprintf(fid,'\n $\\tau$ & Gravity & & \\\\');
fprintf(fid,'\n \\hline \\end{tabular}');
fclose(fid);


fid=fopen('table_2.tex','wt');
fprintf(fid,'\n \\begin{tabular}{lccc}');
fprintf(fid,'\n \\hline');
fprintf(fid,'\n Moments & Model & Data & Source \\\\ \\hline');
fprintf(fid,'\n US Exporters, \\%% All firms & $%5.2f$ &  18 - 21 & Bernard et al., BEJK \\\\', moments(4)*100);
fprintf(fid,'\n \\hline');
fprintf(fid,'\n Export Intensity (\\%%) & & & BEJK \\\\ \\hline');
fprintf(fid,'\n 0-10 &  $%5.1f$ &  66 & \\\\', tab(1));
fprintf(fid,'\n 10-20 &  $%5.1f$ &  16 & \\\\', tab(2));
fprintf(fid,'\n 20-30  &  $%5.1f$ &  7.7 & \\\\', tab(3));
fprintf(fid,'\n 30-40  &  $%5.1f$ &  4.4 & \\\\', tab(4));
fprintf(fid,'\n 40-50  &  $%5.1f$ &  2.4 & \\\\', tab(5));
fprintf(fid,'\n 50-60 &  $%5.1f$ &  1.5  & \\\\', tab(6));
fprintf(fid,'\n 60-100  &  $%5.1f$  &  2.8 & \\\\', tab(7));
fprintf(fid,'\n \\hline');
fprintf(fid, '\n Mark-up, mean, \\%% & $%5.2f$  & 5 - 40 &  Jaimovich=Floetotto \\\\', Em*100);
fprintf(fid, '\n Cost pass-through, mean, \\%% & $%5.2f$  & 0.36 - 0.57 &  De Loecker et al. \\\\', 1-moments(3));
fprintf(fid,'\n Log E, rel. US, mean & -3.03 & -2.70 & WDI \\\\');
fprintf(fid,'\n (standard deviation) & (2.67) & (1.66) &  \\\\ \\hline \\hline');
fprintf(fid,'\n Moments & Corr & (model,data) &    \\\\ \\hline');
fprintf(fid,'\n Log E, 123 countries & 0.87 & & \\\\ \\hline');
fprintf(fid,'\n lambda , 123 countries & 0.91 & &  \\\\ \\hline');
fprintf(fid,'\n \\hline \\end{tabular}');
fclose(fid);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 4. Appendix D.5.3 The margins of trade
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear
clc
% The file tradeshare.m is not included in the folder. See Readme file for
% instructions on how to build the trade share matrix.
load tradeshare
numeraire=119;
load('cepii.mat')
[s_tilde_us, predic_trade, tau, taudis, ssd, arr, cefsd]=grav_new(tradeshare,cepii);
thetalogtau=4*log(tau(119,:));
load output
y=output(:,1)/output(119,1);
l=output(:,2)/output(119,2);
pcy=output(:,3)/output(119,3);
pcincome=fsolve(@(x) percapitay(x,l,tradeshare, numeraire),pcy);
pcy=pcincome;
S=500000;
R = unifrnd(0,1,1,S);
R=sort(R);
um=max(R);
load over
kappa=over(1);
gamma=over(2);
taus_us=exp(thetalogtau/kappa);
taus_us=taus_us/taus_us(1,119);
% Getting the whole matrix of trade costs
logtau=4*log(tau);
tauss=exp(logtau/kappa);
chat_usj=pcy'./taus_us;
chat_cii=pcy'./taus_us/pcy(119);
chat_cii(119)=0;
ctilde_cii=max(chat_cii);
cii=(R/um).^(1/kappa)*chat_usj(119);
tij=(cii'*((chat_usj).^(-1)))';
delta=zeros(123,S);
for j=1:123
    for k=1:S
        if tij(j,k)<=1
            delta(j,k)=1;
        end
    end
end
mostfav=78;
% MEX=78
DELTA=max(delta,[],2);
ext_jUS=(DELTA.*(pcy.^kappa).*(tauss(119,:).^(-kappa))').*(pcy(mostfav)^(-kappa))*tauss(119,mostfav)^(kappa);
ccode=1:123;
ccode=ccode';
csvwrite('extensivemodel.csv',[ccode ext_jUS] )