clear all
set more off
cd "\\tsclient\C\Users\Luca\Dropbox\Addilog\replication\data_code_international_trade_with_indirect_additivity"
import delimited  "extensivemodel.csv", clear
rename v1 ccode
rename v2 rel_extensive

merge 1:1 ccode using "extensive_list.dta"
keep if _merge==3
drop _merge
gen hh=1
drop if rel_extensive==0
save "tot_varieties_model.dta", replace
keep if fic=="MEX"
rename pcy_model pcy_mex
rename l l_mex
rename dist dist_mex
keep hh *_mex
merge 1:m hh using "C:\Users\lmacedon\Desktop\tot_varieties_model.dta"
drop _merge
gen logy=ln(pcy_model/pcy_mex)
gen logL=ln(l/l_mex)
gen logExtensive_margin=ln(rel_extensive)
gen logdist=dist-dist_mex


label variable logy "Log(pcincome)"
label variable logL "Log(L)"

eststo: reg logExtensive_margin logy logL logdist

esttab using table_3.tex, label cells(b(star fmt(3)) se(par)) stats(r2 N , fmt(2 0) labels(`"$ R^2$"' `"\# Observations"')) starlevels(* 0.10 ** 0.05 *** 0.01) noconstant nodep nonumbers collabels(none)  mtitles("(1)" "(2)" "(3)") replace
