clear
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 3.2 Welfare gains from trade
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The file tradeshare.m is not included in the folder. See Readme file for
% instructions on how to build the trade share matrix.
load tradeshare

kappa=5;
gamma=fsolve(@equation_50, 1);

load output
Y=output(:,1)/output(119,1);
pcy=output(:,3)/output(119,3);
population=output(:,2)/output(119,2);

pcy_model=fsolve(@(x) percapitay(x,population,tradeshare, 119),pcy);

for i=1:123
    What_acr(i,1)=100*(1-(tradeshare(i,i))^(1/kappa));
end

for i=1:123
    lambda_hat(i)=1/tradeshare(i,i);
    Wj(i,1)=fsolve(@(x) equation_48(x,lambda_hat(i), gamma, kappa, pcy_model(i) ), pcy_model(i));
    What(i,1)=100*(1-Wj(i,1)/pcy_model(i));
end

labelss=importdata('ctry_label.csv');

figure(1)
lscatter(log(population), What_acr, labelss, 'Fontsize', 10)
xlabel('Population size L (log), US=0','FontSize',15);
ylabel('Welfare Cost of Autarky (%) - CES Model','FontSize',15)
hold on
plot([-8,2],[ mean(What_acr) mean(What_acr)], 'k-')
hold on
plot([-8,2],[ mean(What_acr)+var(What_acr)^0.5 mean(What_acr)+var(What_acr)^0.5], 'k--')
hold on
plot([-8,2],[ mean(What_acr)-var(What_acr)^0.5 mean(What_acr)-var(What_acr)^0.5], 'k--')
hold on
annotation('textbox',[.72 .37 0 0],'string','mean=13.97','FontSize',10)
hold on
annotation('textbox',[.72 .50 0 0],'string','std. dev.=9.21','FontSize',10)
set(gcf, 'PaperUnits', 'inches');
afFigurePosition = [.25 2.5 7 5];
set(gcf, 'PaperPosition', afFigurePosition);
set(gca,'FontSize',15);
ylim([0 56])
xlim([-8 2])
print('figure1a', '-dpng')
hold off 



figure(2)
lscatter(log(population), What, labelss, 'Fontsize', 10)
xlabel('Population size L (log), US=0','FontSize',15);
ylabel('Welfare Cost of Autarky (%) - IA Model','FontSize',15)
hold on
plot([-8,2],[ mean(What) mean(What)], 'k-')
hold on
plot([-8,2],[ mean(What)+var(What)^0.5 mean(What)+var(What)^0.5], 'k--')
hold on
plot([-8,2],[ mean(What)-var(What)^0.5 mean(What)-var(What)^0.5], 'k--')
hold on
annotation('textbox',[.74 .32 0 0],'string','mean=10.35','FontSize',10)
hold on
annotation('textbox',[.74 .42 0 0],'string','std. dev.=6.89','FontSize',10)
set(gcf, 'PaperUnits', 'inches');
afFigurePosition = [.25 2.5 7 5];
set(gcf, 'PaperPosition', afFigurePosition);
set(gca,'FontSize',15);
ylim([0 56])
xlim([-8 2])
print('figure1b', '-dpng')
hold off 


wgains_us_acr=(0.93)^(-gamma/((gamma+1)*(kappa+1)))-1
