function [s_tilde_us,tssdmat, rtausd, taudis, ssd, arr, cefsd]=grav_new(trdshrs,cepii)

N = length(trdshrs);
[mm,nn]=size(cepii);
xrow = -ones(1,N-1);
eee=eye(N-2,N-2);

dummy = [-ones(N-2,1) eee];
xrow(1,1)=-2;
dummy = [xrow;dummy];

size(dummy);
for i = 1:N-2
    xrow = -ones(1,N-1);
    dum = [eee(:,1:i), -ones(N-2,1), eee(:,i+1:end)];
    xrow(1,i+1) = -2 ;
    dum = [xrow;dum];
    size(dum);
    dummy = [dummy;dum];
end

dummy = [ones(N-1,N-1) + eye(N-1,N-1);dummy];

asym = eye(N-1,N-1);
for i = 1:N-1
    ass = eye(N-1,N-1);
    ass(i,:) = [];
    ass = [-ones(1,N-1);ass];
    asym = [asym;ass];
end



trdata = trdshrs;
trdata = trdata./(repmat(diag(trdata),1,N))';
hh = (trdata(:)~=0);
qq = (trdata(:)~=0);
ff = (trdata(:)~=1);
% gg = (trdata(:)~=0);
trdata = trdata(hh);

% Here we create the rows for the ii observations for dummy and asym
dummy1=zeros(mm,N-1);
dummy1(ff,:)=dummy;
dummy=dummy1(hh,:);

dummy1=zeros(mm,N-1);
dummy1(ff,:)=asym;
asym=dummy1(hh,:);

cepii_nz=cepii;
cepii=cepii(hh,:);

% gravity
[bsd,bintsd,rsd,rintsd,statssd] = regress(log(trdata),[dummy asym cepii]);


[var_white se_white] = EikerWhite(rsd,[dummy asym cepii]);

se_white_usd = [ones(1,N-1)*var_white(1:N-1,1:N-1)*ones(1,N-1)'].^.5; 

se_white_usa = [ones(1,N-1)*var_white(N:end-nn,N:end-nn)*ones(1,N-1)'].^.5;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ssd = [-sum(bsd(1:N-1));bsd(1:N-1)];
ds = .01.*round(100*ssd);
ses = [se_white_usd ; se_white(1:N-1)];

s_tilde=exp(ds);

s_tilde_us=s_tilde/s_tilde(119);


disp('Si Estimates')
disp([ds,.01.*round(100*ses)])

disp('Cepii Cost Estimates')
disp([bsd(end-nn+1:end) .01.*round(100*se_white(end-nn+1:end))])

bsasym = bsd(N:end-nn);
best = [-sum(bsasym); bsd(N:end-nn)];
seimp = [se_white_usa ; .01.*round(100*se_white(N:end-nn))];

disp('Exporter Fixed Effect')
disp([best, .01.*round(100*seimp)])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Reconstruct Fitted Values
ysd =exp([dummy asym cepii]*bsd);

msdmat = zeros(N^2,1);
msdmat(hh) = ysd;
msdmat(~ff) = 1;
msdmat = reshape(msdmat,N,N);
sdc = sum(msdmat);
sdc = repmat(sdc,N,1);
tssdmat = msdmat./sdc;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Construct Trade Costs

% theta =  0.1818;
theta=.25;

bsasym = bsd(N:end-nn);
bsasym = [-sum(bsasym);bsd(N:end-nn)];
beasym = exp(-theta.*bsasym)-1;
arr = 100.*beasym;

cefsd = exp(-theta.*bsd(end-nn+1:end,:))-1;
constant=bsd(end-nn+1,:);
dist_elas=bsd(end-nn+2,:);
tdiff_elas=bsd(end-nn+3,:);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

disp('Theta')
disp(theta)

disp('Cepii Effects')
disp([exp(-theta.*bsd(end-nn+1:end))-1])

disp('Destination Effect')
disp(100.*beasym)

sse = sum((log(ysd)-log(trdata)).^2);
sst = sum((log(trdata)-mean(log(trdata))).^2);

disp('Sum of Square Errors')
disp(sse);

disp('Total Sum of Squares')
disp(sst)

disp('Rsquared')
disp(1-sse/sst)

disp('Error Variance')
disp(statssd(end))


rmsesd = (mean((log(trdshrs(qq))-log(tssdmat(qq))).^2)).^.5;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


beasym=(beasym(:,:)*ones(1,N));
% beasym = beasym(ff);

taudis = zeros(N^2,1);
rtausd = zeros(N^2,1);
% rtausd(~hh) = 100;
% taudis(~hh) = 100;
% rtausd(~ff) = 1;
% taudis(~ff) = 1;


ll=length(cefsd);
% Trade costs from dummies
dd=1+cepii_nz(:,3).*cefsd(3);
for ii=4:ll
    dd=dd.*(1+cepii_nz(:,ii).*cefsd(ii));
end

% Including constant+distance+time_difference
dd=dd.*exp(-theta.*(cepii_nz(:,1).*constant + cepii_nz(:,2).*dist_elas));

[oo,kkk]=size(cepii_nz);
beasym=reshape(beasym,[oo,1]);
rtausd = dd.*(1+beasym);
taudis = dd;
taudis = reshape(taudis,N,N);
rtausd = reshape(rtausd,N,N);
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ssd = [-sum(bsd(1:N-1));bsd(1:N-1)];

