clear
clc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% D.6 Counterfactual: trade cost reduction between USA and EU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

numeraire=119;
% US=119
ll=[1:numeraire-1,numeraire+1:123];
load over
kappa=over(1);
gamma=over(2);

% The file tradeshare.m is not included in the folder. See Readme file for
% instructions on how to build the trade share matrix.
load tradeshare
load cepii
[s_tilde_us, predic_trade, tau, taudis, ssd, arr, cefsd]=grav_new(tradeshare,cepii);
logtau=4*log(tau);
tauss=exp(logtau/kappa);
for i=1:123
    tauss(i,:)=tauss(i,:)/tauss(i,i);
end
tau_new=tau;
TTIP_EU=[5, 9, 17, 33, 34, 48, 35, 103, 40, 43, 44, 118, 50, 32, 53, 58, 60, 71, 68, 92, 93, 94, 101, 100, 107];
TTIP_ctry=[5, 9, 17, 33, 34, 48, 35, 103, 40, 43, 44, 118, 50, 32, 53, 58, 60, 71, 68, 92, 93, 94, 101, 100, 107, 119];

for i=1:123
    for j=1:123
        if any(i==TTIP_EU)==1 && j==119
            tau_new(i,j)=tau_new(i,j)*(1+1*cefsd(7));
        end
    end
end

for i=1:123
    for j=1:123
        if i==119 && any(j==TTIP_EU)==1
            tau_new(i,j)=tau_new(i,j)*(1+1*cefsd(7));
        end
    end
end
logtau_new=4*log(tau_new);
tauss_new=exp(logtau_new/kappa);
for i=1:123
    tauss_new(i,:)=tauss_new(i,:)/tauss_new(i,i);
end
tau_hat=tauss_new./tauss;

SS=exp(ssd);
SS=SS./SS(numeraire);
      
load output
Y=output(:,1)/output(numeraire,1);
pcy=output(:,3)/output(numeraire,3);
population=output(:,2)/output(numeraire,2);

options=optimset('TolX',1e-7, 'TolFun', 1e-7 );
pcy_model=fsolve(@(x) percapitay(x,population,tradeshare, numeraire),pcy);

% Wage hat
ww=ones(123,1);
Y=pcy_model.*population;

ww=ones(123,1);
options=optimset('TolX',1e-7, 'TolFun', 1e-7);

wage_hat=fsolve(@(x) wage_equation_new(x, Y, kappa, tau_hat, tradeshare, numeraire),ww(ll),options);
wage_hat(ll,1)=wage_hat;
wage_hat(numeraire)=1;

for j=1:123
    wtemp=wage_hat(j);
    lambda_hat_jj(j,1)=(tradeshare(:,j)'*((tau_hat(:,j).*(wage_hat./wtemp)).^(-kappa)))^(-1);
end


for i=1:123
    Wj(i,1)=fsolve(@(x) equation_48(x,lambda_hat_jj(i,1), gamma, kappa, pcy_model(i) ), pcy_model(i)+0.001);
    What_ttip(i,1)=100*(Wj(i)/pcy_model(i)-1);
end

for i=1:123
    What_ttip_old(i,1)=(lambda_hat_jj(i,1))^(-gamma/((gamma+1)*(kappa+1)))-1;
end

What_ttip_old=What_ttip_old*100;


US_rtas=[21,25,59,62,78];
EU_rtas=[38, 54,59,62,69,72,78,80, 86, 102, 108, 109, 114];
jj=1;
for kk=1:123
    if any(kk==TTIP_ctry)==0 && any(kk==US_rtas)==0 && any(kk==EU_rtas)==0
        no_ttip(jj)=kk;
        jj=jj+1;
    end
end

'Average Change in welfare (All Countries)'
mean(What_ttip)
'Standard Deviation'
var(What_ttip)^0.5

'Average Change in welfare (Countries out of TTIP)'
mean(What_ttip(no_ttip))
'Standard Deviation'
var(What_ttip(no_ttip))^0.5

'Average Change in welfare (Countries in TTIP)'
mean(What_ttip(TTIP_ctry))
'Standard Deviation'
var(What_ttip(TTIP_ctry))^0.5



labelss=importdata('ctry_label.csv');

% Plots
figure(1)
lscatter(log(population(no_ttip)), What_ttip(no_ttip), labelss(no_ttip), 'Fontsize', 10)
xlabel('Population size L (log), US=0','FontSize',15);
ylabel('Welfare gains from trade cost reduction (%)','FontSize',15)
hold on
lscatter(log(population(TTIP_ctry)), What_ttip(TTIP_ctry), labelss(TTIP_ctry), 'Fontsize', 10, 'LabelColor', 'b')
hold on
lscatter(log(population(EU_rtas)), What_ttip(EU_rtas), labelss(EU_rtas), 'Fontsize', 10, 'LabelColor', 'g')
hold on
lscatter(log(population(US_rtas)), What_ttip(US_rtas), labelss(US_rtas), 'Fontsize', 10, 'LabelColor', 'r')
ylim([-0.2 2.25])
set(gcf, 'PaperUnits', 'inches');
afFigurePosition = [.25 2.5 7 5];
set(gcf, 'PaperPosition', afFigurePosition);
set(gca,'FontSize',15);
print('figure4a', '-dpng')
hold off 

figure(2)
lscatter(log(population(no_ttip)), What_ttip(no_ttip), labelss(no_ttip), 'Fontsize', 10)
xlabel('Population size L (log), US=0','FontSize',15);
ylabel('Welfare gains from trade cost reduction (%)','FontSize',15)
hold on
lscatter(log(population(TTIP_ctry)), What_ttip(TTIP_ctry), labelss(TTIP_ctry), 'Fontsize', 10, 'LabelColor', 'b')
hold on
lscatter(log(population(EU_rtas)), What_ttip(EU_rtas), labelss(EU_rtas), 'Fontsize', 10, 'LabelColor', 'g')
hold on
lscatter(log(population(US_rtas)), What_ttip(US_rtas), labelss(US_rtas), 'Fontsize', 10, 'LabelColor', 'r')
ylim([-0.16 0.4])
set(gcf, 'PaperUnits', 'inches');
afFigurePosition = [.25 2.5 7 5];
set(gcf, 'PaperPosition', afFigurePosition);
set(gca,'FontSize',15);
print('figure4b', '-dpng')
hold off 

