log using "/home/projects/sehs/replication/logs/figure2.log", replace

clear
set more off

*created by: LS
*created on: 28 jan 2015 

tempfile temp1
use "/home/projects/sehs/replication/data/fullestsample_max.dta", clear
gen bin=.
replace bin=brooks_bin if schoice=="Brooks"
replace bin=jones_bin if schoice=="Jones"
replace bin=king_bin if schoice=="King"
replace bin=lane_bin if schoice=="Lane"
replace bin=lindblom_bin if schoice=="Lindblom"
replace bin=northside_bin if schoice=="Northside"
replace bin=payton_bin if schoice=="Payton"
replace bin=southshore_bin if schoice=="South Shore"
replace bin=westing_bin if schoice=="Westinghouse"
replace bin=young_bin if schoice=="Young"

count

preserve
keep if tier==1
collapse (mean) selective, by(bin)
scatter selective bin, xline(0) scheme(sj) ytitle("Probability of enrolling, Tier 1")
graph save "/home/projects/sehs/replication/figures/figure2_tier1.gph", replace
restore

preserve
keep if tier==4
collapse (mean) selective, by(bin)
scatter selective bin, xline(0) scheme(sj) ytitle("Probability of enrolling, Tier 4")
graph save "/home/projects/sehs/replication/figures/figure2_tier4.gph", replace
restore


