//FIGURE 1A
clear all
//use "wrk_eos.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
gcollapse (mean) app, by(P_pmra)
gen lg_app = log(app)
tw scatter app P_pmra, msize(medlarge) mcolor(navy) ///
	graphregion(color(white) lcolor(white)) bgcolor(white) ///
	xlabel(1 "1" 6.25 "25" 12.5 "50" 18.75 "75" 25 "100") ylabel(,angle(horiz)) yscale(range(0(0.001)0.004)) ///
	xtitle("Percentiles of RFA-Scientist Similarity") ///
	ytitle("Prob. Scientist Enters RFA") ///
	scale(1.4)
tw scatter lg_app P_pmra , msize(medlarge) mcolor(navy) ///
	graphregion(color(white) lcolor(white)) bgcolor(white) ///
	xlabel(1 "1" 6.25 "25" 12.5 "50" 18.75 "75" 25 "100") ///
	xtitle("Percentiles of RFA-Scientist Similarity") ///
	ytitle("Prob. Scientist Enters RFA") ///
	ylabel(-9.903 "1/20,000" -7.601 "1/2,000" -5.298 "1/200",angle(horiz) gmin gmax ) ///
	scale(1.4)
gr export "~/Dropbox/_Papers/2017_EoS/___replicate/fig_1a.pdf", replace



//FIGURE 1B
clear all
//use "wrk_eos.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
gcollapse (mean) app dol , by(P_dol)
replace dol = dol / 1000000
gen lg_app = log(app)
tw scatter lg_app dol, msize(medlarge) mcolor(navy) m(Oh) mlw(medthick) ///
	graphregion(color(white) lcolor(white)) bgcolor(white) ///
	xtitle("Funds Available in RFA, {c $|}M") ///
	ytitle("Prob. Scientist Enters RFA") ///
	ylabel(-9.903 "1/20,000" -7.601 "1/2,000" -5.298 "1/200", angle(horiz) gmin gmax) ///
	scale(1.4)
gr export "~/Dropbox/_Papers/2017_EoS/___replicate/fig_1b.pdf", replace



//FIGURE 2A
clear all
use mesheffect_pubs.dta, replace
xtset xtree year
xtpoisson pubcnt FFFF.treat FFF.treat FF.treat F.treat treat L.treat LL.treat i.year , fe i(xtree) vce(robust)
coefplot, vertical keep(*treat*) yline(0) graphregion(color(white) lcolor(white)) bgcolor(white) ///
	ytitle("% Change in PubMed Publications") xtitle("Year") ///
	xlabel(1 "y-4" 2 "y-3" 3 "y-2" 4 "y-1" 5 "RFA Year" 6 "y+1" 7 "y+2")
	
	
	
//FIGURE 2B,2C
clear all
//use mesheffect_apps.dta, replace AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
xtset xtree xcouncil
xtpoisson SAscore_direct_app F12.treat F11.treat F10.treat F9.treat F8.treat F7.treat F6.treat F5.treat FFFF.treat FFF.treat FF.treat F.treat treat L.treat L2.treat L3.treat L4.treat L5.treat L6.treat i.xcouncil , fe i(xtree) vce(robust)
coefplot, vertical keep(*treat*) yline(0) graphregion(color(white) lcolor(white)) bgcolor(white) ///
	ytitle("% Change in NIH Applications") xtitle("Year") ///
	xlabel(1 "y-4" 2 " " 3 " " 4 "y-3" 5 " " 6 " " 7 "y-2" 8 " " 9 " " 10 "y-1" 11 " " 12 " " 13 "RFA" 14 " " 15 " " 16 "y+1" 17 " " 18 " " 19 "y+2")
xtpoisson SWscore_direct_app F12.treat F11.treat F10.treat F9.treat F8.treat F7.treat F6.treat F5.treat FFFF.treat FFF.treat FF.treat F.treat treat L.treat L2.treat L3.treat L4.treat L5.treat L6.treat i.xcouncil , fe i(xtree) vce(robust)
coefplot, vertical keep(*treat*) yline(0) graphregion(color(white) lcolor(white)) bgcolor(white) ///
	ytitle("% Change in NIH Awards") xtitle("Year") ///
	xlabel(1 "y-4" 2 " " 3 " " 4 "y-3" 5 " " 6 " " 7 "y-2" 8 " " 9 " " 10 "y-1" 11 " " 12 " " 13 "RFA" 14 " " 15 " " 16 "y+1" 17 " " 18 " " 19 "y+2")


	
//FIGURE 3
clear all
//use "wrk_eos.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
keep pmra win app
su pmra,d
local pmra_p50 = r(p50)
local pmra_p75 = r(p75)
keep if pmra >= `pmra_p50' & app
tw 	(kdensity pmra if !win, lcolor(navy) lw(thick) ) ///
	(kdensity pmra if win, lcolor(maroon) lw(thick) lpat(longdash)) ///
	, graphregion(color(white) lcolor(white)) bgcolor(white) ///
	legend(order(1 "RFA Losers" 2 "RFA Winners")  region(lcolor(white))) ///
	xtitle("Similarity Score") ytitle("Density of Applications") ///
	scale(1.4)

	
	
//TABLE 1
clear all
//use "entry2.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
eststo clear
eststo: reg app z_dol I__IP* , vce(cluster xrfa) 
	su app if e(sample)
	estadd scalar meany = r(mean)
	estadd local flg_simbins "Y"
eststo: reg app z_dol I__IP* i.rfaFE*, vce(cluster xrfa) 
	su app if e(sample)
	estadd scalar meany = r(mean)
	estadd local flg_simbins "Y"
	estadd local flg_rfaX "Y"
eststo: areg app z_dol I__IP* i.rfaFE* , a(xpi) vce(cluster xrfa) 
	su app if e(sample)
	estadd scalar meany = r(mean)
	estadd local flg_simbins "Y"
	estadd local flg_rfaX "Y"
	estadd local flg_sciFE "Y"	
eststo: areg app z_dol z_pmra i.rfaFE* , a(xpi) vce(cluster xrfa) 
	su app if e(sample)
	estadd scalar meany = r(mean)
	estadd local flg_rfaX "Y"
	estadd local flg_sciFE "Y"	
	predict pr_app , xbd
	egen sum_pr_app = sum(pr_app), by(xrfa)
	gen sum_pr_app_jk = sum_pr_app - pr_app
	egen z_sum_pr_app_jk = std(sum_pr_app_jk)
eststo: areg app z_dol z_pmra z_sum_pr_app_jk i.rfaFE* , a(xpi) vce(cluster xrfa) 
	su app if e(sample)
	estadd scalar meany = r(mean)
	estadd local flg_rfaX "Y"
	estadd local flg_sciFE "Y"			
	estadd local flg_comp "Y"		
esttab , se keep(z*) stats(N meany flg_simbins flg_rfaX flg_sciFE flg_comp) ///
	starlevels( * 0.1 ** 0.05 *** 0.01 ) label
eststo clear




//FIGURES 4 and 5
*SEE eos_replicate_grid.do FILE

//FIGURE 6
clear all
//use "nih_app01to15_clean.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
collapse (mean) rfa* open*, by(fy)
keep if fy >= 2002 & fy <= 2010
tsset fy
foreach var in pmra_max win awd1_direct {
	tsline open_`var' rfa_`var', saving(g`var') graphregion(color(white) lcolor(white)) bgcolor(white)
	corr open_`var' rfa_`var'
}
grc1leg gpmra_max.gph gwin.gph gawd1_direct.gph, graphregion(color(white) lcolor(white)) row(1)
erase gpmra_max.gph
erase gwin.gph
erase gawd1_direct.gph



//TABLE 2
clear all
//use "pmra_apps_clean.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
eststo clear
eststo: regress lg_pmraL1_max rfa if ptile != ., vce(cluster xP)
	su pmra_max if e(sample) & a_open
	estadd scalar myvar = round(`r(mean)', 0.1)
	egen XP = group(xP) if e(sample)
	su XP
	estadd scalar Npi = `r(max)'
	drop XP
eststo: regress lg_pmraL1_max rfa ptile lg_awdreq_tot, vce(cluster xP)
	su pmra_max if e(sample) & a_open
	estadd scalar myvar = round(`r(mean)', 0.1)
	egen XP = group(xP) if e(sample)
	su XP
	estadd scalar Npi = `r(max)'
	drop XP
eststo: reghdfe lg_pmraL1_max rfa ptile lg_awdreq_tot, a(xP) cluster(xP)
	su pmra_max if e(sample) & a_open
	estadd scalar myvar = round(`r(mean)', 0.1)	
	egen XP = group(xP) if e(sample)
	su XP
	estadd scalar Npi = `r(max)'
	drop XP
eststo: reghdfe lg_pmraL1_max rfa ptile lg_awdreq_tot, a(xDST) cluster(xP)
	su pmra_max if e(sample) & a_open
	estadd scalar myvar = round(`r(mean)', 0.1)	
	egen XP = group(xP) if e(sample)
	su XP
	estadd scalar Npi = `r(max)'
	drop XP
eststo: reghdfe lg_pmraL1_max rfa ptile lg_awdreq_tot, a(xP xDST) cluster(xP)
	su pmra_max if e(sample) & a_open
	estadd scalar myvar = round(`r(mean)', 0.1)	
	egen XP = group(xP) if e(sample)
	su XP
	estadd scalar Npi = `r(max)'
	drop XP
esttab , se drop(*cons* ptile lg_awdreq_tot ) stats(N myvar Npi) starlevels( * 0.1 ** 0.05 *** 0.01 ) label
eststo clear
foreach yvar in win lg_awd1_dir {
	local Y `yvar'
	if (`yvar' == lg_awd1_dir) {
		local Y awd1_dir
	}
	eststo clear
	eststo: regress `yvar' rfa if ptile != ., vce(cluster xP)
		su `Y' if e(sample) & a_open
		estadd scalar myvar = round(`r(mean)', 0.01)
		egen XP = group(xP) if e(sample)
		su XP
		estadd scalar Npi = `r(max)'
		drop XP
	eststo: regress `yvar' rfa ptile lg_awdreq_tot, vce(cluster xP)
		su `Y' if e(sample) & a_open
		estadd scalar myvar = round(`r(mean)', 0.01)
		egen XP = group(xP) if e(sample)
		su XP
		estadd scalar Npi = `r(max)'
		drop XP
	eststo: reghdfe `yvar' rfa ptile lg_awdreq_tot, a(xP) cluster(xP)
		su `Y' if e(sample) & a_open
		estadd scalar myvar = round(`r(mean)', 0.01)	
		egen XP = group(xP) if e(sample)
		su XP
		estadd scalar Npi = `r(max)'
		drop XP
	eststo: reghdfe `yvar' rfa ptile lg_awdreq_tot, a(xDST) cluster(xP)
		su `Y' if e(sample) & a_open
		estadd scalar myvar = round(`r(mean)', 0.01)	
		egen XP = group(xP) if e(sample)
		su XP
		estadd scalar Npi = `r(max)'
		drop XP
	eststo: reghdfe `yvar' rfa ptile lg_awdreq_tot, a(xP xDST) cluster(xP)
		su `Y' if e(sample) & a_open
		estadd scalar myvar = round(`r(mean)', 0.01)	
		egen XP = group(xP) if e(sample)
		su XP
		estadd scalar Npi = `r(max)'
		drop XP
	esttab , se drop(*cons* ptile lg_awdreq_tot ) stats(N myvar Npi) starlevels( * 0.1 ** 0.05 *** 0.01 ) label
	eststo clear
}
****PREMIUMS
di "Col 1 " ((((.22+.111) * ((1+.240)*270646)) / (.22 * 270646)) - 1 )
di "Col 2 " ((((.22+.075) * ((1+.199)*270670)) / (.22 * 270670)) - 1 )
di "Col 3 " ((((.21+.071) * ((1+.197)*288053)) / (.21 * 288053)) - 1 )
di "Col 4 " ((((.22+.121) * ((1+.059)*271693)) / (.22 * 271693)) - 1 )
di "Col 5 " ((((.21+.083) * ((1+.167)*284237)) / (.21 * 284237)) - 1 )
****IMPLIED ELASTICITIES
di "Col 1 " .236 / ((((.22+.111) * ((1+.240)*270646)) / (.22 * 270646)) - 1 )
di "Col 2 " .242 / ((((.22+.075) * ((1+.199)*270670)) / (.22 * 270670)) - 1 )
di "Col 3 " .153 / ((((.21+.071) * ((1+.197)*288053)) / (.21 * 288053)) - 1 )
di "Col 4 " .110 / ((((.22+.121) * ((1+.059)*271693)) / (.22 * 271693)) - 1 )
di "Col 5 " .101 / ((((.21+.083) * ((1+.167)*284237)) / (.21 * 284237)) - 1 )
*$ per 1sd
di ((14.7/30.2) / (.101 / ((((.21+.083) * ((1+.167)*284237)) / (.21 * 284237)) - 1 ))) * 284237





//FIGURE 7
clear all
//use "rdworking.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
gen r_win = .
gen r_z = .
foreach cset in open rfa {
	
	rlasso win_`cset' score_* rnk_* Iq_* i_icfy* if `cset', robust cluster(xgrp) prestd center
		predict tmp, resid lasso
		replace r_win = tmp if `cset'
		drop tmp
		
	rlasso zgrp_ratio_dolfromtop100_`cset' score_* rnk_* Iq_* i_icfy* if `cset', robust cluster(xgrp) prestd center
		predict tmp, resid lasso
		replace r_z = tmp if `cset'
		drop tmp		
}
binscatter r_win r_z , by(rfa) nq(25) line(none) graphregion(color(white) lcolor(white)) bgcolor(white) scale(1.2) ///
	ytitle("Pr(Win) Residuals") xtitle("Std. Fund Request Distance Residuals") legend(order(1 "Open" 2 "RFA") region(lcolor(white))) msymbols(cirlce  square_hollow)



//TABLE 3
clear all
//use "rdworking.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
su icfy
local Nicfy = r(max)
foreach yvar in IHS_pstF1_5_pub_authfl {

	eststo: pdslasso `yvar' win_open win_rfa (i_icfy*), robust cluster(xgrp) lopt(prestd center) post(lasso)
		mat A = e(V)
		estadd scalar e_open = round( (exp(_b[win_open] - 0.5*A[1,1]) - 1),0.001)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[2,2]) - 1),0.001)
		local slctlist = e(xselected_chs_l)
		local cnt = 0
		foreach var of varlist `slctlist' {
			if !regexm("`var'" , "i_icfy") {
				local cnt = `cnt' + 1
			}
		}
		local totposs = e(xhighdim_ct) - `Nicfy'
		estadd local NX_in_sel = string(`cnt') + "/" + string(`totposs') 
		testparm  win_open  win_rfa, equal
		if `r(p)' < 0.01 {
			estadd local diff_pval = "<0.01"	
		}
		else {
			estadd local diff_pval = round(r(p),0.01)
		}	
		su `yvar' if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local ICFY "Y"
		
	eststo: ivlasso `yvar' (score_* rnk_* Iq_* i_icfy*) ///
			(win_open win_rfa = grp_ratio_dolfromtop100_open grp_ratio_dolfromtop100_rfa) , ///
			robust cluster(xgrp) lopt(prestd center) post(lasso) idstats	
		mat A = e(V)
		estadd scalar e_open = round( (exp(_b[win_open] - 0.5*A[1,1]) - 1),0.001)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[2,2]) - 1),0.001)
		estadd scalar fstat = round(e(weakidr),0.1)
		local slctlist = e(xselected_chs_l)
		local cnt = 0
		foreach var of varlist `slctlist' {
			if !regexm("`var'" , "i_icfy") {
				local cnt = `cnt' + 1
			}
		}
		local totposs = e(xhighdim_ct) - `Nicfy'
		estadd local NX_in_sel = string(`cnt') + "/" + string(`totposs') 
		testparm  win_open  win_rfa, equal
		if `r(p)' < 0.01 {
			estadd local diff_pval = "<0.01"	
		}
		else {
			estadd local diff_pval = round(r(p),0.01)
		}	
		su `yvar' if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local IV = "Y"
		estadd local ICFY "Y"
		
	eststo: ivlasso `yvar' (score_* rnk_* Iq_* i_icfy* projvar_* e*projvar_* projvecI* ) ///
			(win_open win_rfa = grp_ratio_dolfromtop100_open grp_ratio_dolfromtop100_rfa) , ///
			robust cluster(xgrp) lopt(prestd center) post(lasso) idstats	
		mat A = e(V)
		estadd scalar e_open = round( (exp(_b[win_open] - 0.5*A[1,1]) - 1),0.001)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[2,2]) - 1),0.001)
		estadd scalar fstat = round(e(weakidr),0.1)
		local slctlist = e(xselected_chs_l)
		local cnt = 0
		foreach var of varlist `slctlist' {
			if !regexm("`var'" , "i_icfy") {
				local cnt = `cnt' + 1
			}
		}
		local totposs = e(xhighdim_ct) - `Nicfy'
		estadd local NX_in_sel = string(`cnt') + "/" + string(`totposs') 
		testparm  win_open  win_rfa, equal
		if `r(p)' < 0.01 {
			estadd local diff_pval = "<0.01"	
		}
		else {
			estadd local diff_pval = round(r(p),0.01)
		}	
		su `yvar' if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local IV = "Y"	
		estadd local ICFY "Y"
		estadd local projcntrls = "Y"	
		
	eststo: ivlasso `yvar' (score_* rnk_* Iq_* i_icfy* persvar_* e*persvar_* persvecI*) ///
			(win_open win_rfa = grp_ratio_dolfromtop100_open grp_ratio_dolfromtop100_rfa) , ///
			robust cluster(xgrp) lopt(prestd center) post(lasso) idstats	
		mat A = e(V)
		estadd scalar e_open = round( (exp(_b[win_open] - 0.5*A[1,1]) - 1),0.001)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[2,2]) - 1),0.001)
		estadd scalar fstat = round(e(weakidr),0.1)
		local slctlist = e(xselected_chs_l)
		local cnt = 0
		foreach var of varlist `slctlist' {
			if !regexm("`var'" , "i_icfy") {
				local cnt = `cnt' + 1
			}
		}
		local totposs = e(xhighdim_ct) - `Nicfy'
		estadd local NX_in_sel = string(`cnt') + "/" + string(`totposs') 
		testparm  win_open  win_rfa, equal
		if `r(p)' < 0.01 {
			estadd local diff_pval = "<0.01"	
		}
		else {
			estadd local diff_pval = round(r(p),0.01)
		}	
		su `yvar' if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local IV = "Y"	
		estadd local ICFY "Y"	
		estadd local perscntrls = "Y"	
		
	eststo: ivlasso `yvar' (score_* rnk_* Iq_* ) ///
			(win_open win_rfa = grp_ratio_dolfromtop100_open grp_ratio_dolfromtop100_rfa) , ///
			fe robust cluster(xgrp) lopt(prestd center) post(lasso) idstats	
		mat A = e(V)
		estadd scalar e_open = round( (exp(_b[win_open] - 0.5*A[1,1]) - 1),0.001)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[2,2]) - 1),0.001)
		estadd scalar fstat = round(e(weakidr),0.1)
		estadd local NX_in_sel = string(e(xselected_chs_l_ct)) + "/" + string(e(xhighdim_ct)) 
		testparm  win_open  win_rfa, equal
		if `r(p)' < 0.01 {
			estadd local diff_pval = "<0.01"	
		}
		else {
			estadd local diff_pval = round(r(p),0.01)
		}	
		su `yvar' if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local IV = "Y"	
		estadd local group_fe = "Y"
		
	eststo: ivlasso `yvar' (score_* rnk_* Iq_* persvar_* e*persvar_* persvecI* projvar_* e*projvar_* projvecI*) ///
			(win_open win_rfa = grp_ratio_dolfromtop100_open grp_ratio_dolfromtop100_rfa) , ///
			fe robust cluster(xgrp) lopt(prestd center) post(lasso) idstats	
		mat A = e(V)
		estadd scalar e_open = round( (exp(_b[win_open] - 0.5*A[1,1]) - 1),0.001)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[2,2]) - 1),0.001)
		estadd scalar fstat = round(e(weakidr),0.1)
		estadd local NX_in_sel = string(e(xselected_chs_l_ct)) + "/" + string(e(xhighdim_ct)) 
		testparm  win_open  win_rfa, equal
		if `r(p)' < 0.01 {
			estadd local diff_pval = "<0.01"	
		}
		else {
			estadd local diff_pval = round(r(p),0.01)
		}	
		su `yvar' if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local IV = "Y"	
		estadd local projcntrls = "Y"		
		estadd local perscntrls = "Y"
		estadd local group_fe = "Y"
	
	esttab , keep(win*) se stats(e_open e_rfa diff_pval IV fstat ICFY projcntrls perscntrls group_fe NX_in_sel meany N) ///
		starlevels( * 0.1 ** 0.05 *** 0.01 ) 
	eststo clear
}



//TABLE 4
clear all
//use "rdworking.dta", clear AVAILABLE WITH PERMISSION OF NIH OFFICE OF EXTRAMURAL RESEARCH
eststo clear
su icfy
local Nicfy = r(max)
foreach yvar in IHS_pstF1_5_pmra_authfl {

	eststo: pdslasso `yvar' win_rfa (pre_pmra* e*pre_pmra*), fe robust cluster(xgrp) lopt(prestd center) post(lasso)	
		mat A = e(V)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[1,1]) - 1),0.001)
		su pstF1_5_pmra_authfl if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local IV = ""	
		estadd local pmra = "Y"	
		estadd local group_fe = "Y"	
		
	eststo: ivlasso `yvar' (pre_pmra* e*pre_pmra* score_* rnk_* Iq_* ) ///
			(win_rfa = grp_ratio_dolfromtop100_rfa) , ///
			fe robust cluster(xgrp) lopt(prestd center) post(lasso) idstats	
		mat A = e(V)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[1,1]) - 1),0.001)
		estadd scalar fstat = round(e(weakidr),0.1)
		estadd local NX_in_sel = string(e(xselected_chs_l_ct)) + "/" + string(e(xhighdim_ct)) 	
		su pstF1_5_pmra_authfl if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local IV = "Y"	
		estadd local pmra = "Y"	
		estadd local group_fe = "Y"
		
	eststo: ivlasso `yvar' (pre_pmra* e*pre_pmra* score_* rnk_* Iq_* persvar_* e*persvar_* persvecI* projvar_* e*projvar_* projvecI*) ///
			(win_rfa = grp_ratio_dolfromtop100_rfa) , ///
			fe robust cluster(xgrp) lopt(prestd center) post(lasso) idstats	
		mat A = e(V)
		estadd scalar e_rfa = round( (exp(_b[win_rfa] - 0.5*A[1,1]) - 1),0.001)
		estadd scalar fstat = round(e(weakidr),0.1)
		estadd local NX_in_sel = string(e(xselected_chs_l_ct)) + "/" + string(e(xhighdim_ct)) 
		su pstF1_5_pmra_authfl if e(sample)
		estadd scalar meany = round(r(mean),0.01)
		estadd local IV = "Y"	
		estadd local projcntrls = "Y"		
		estadd local perscntrls = "Y"
		estadd local pmra = "Y"	
		estadd local group_fe = "Y"
	
	esttab , keep(win*) se stats(e_open e_rfa diff_pval IV fstat ICFY projcntrls perscntrls group_fe pmra NX_in_sel meany N) ///
		starlevels( * 0.1 ** 0.05 *** 0.01 ) 
	eststo clear
}




