do "D:\Data\workdata\704665\daycare\dofiles\first.do"

*************************************************************
* data from the Danish National Archives from censuses and elections
* this dofile cleans the munic level control vars-data and interpolates
* so we can use time-varying controls
*************************************************************

use "$external/munic_controls/munic_controls.dta", clear // external raw data

/* Level variables from JE Archives */
*Each party as a percentage of valid votes cast, GE:
gen socialdemo20 = V11m/V20m*100
gen radicallib20 = V12m/V20m*100
gen conservatives20 = V13m/V20m*100
gen agrarianlib20 = V14m/V20m*100

gen socialdemo24 = V22m/V31m*100
gen radicallib24 = V23m/V31m*100
gen conservatives24 = V24m/V31m*100
gen agrarianlib24 = V25m/V31m*100

gen socialdemo26 = V34m/V42m*100
gen radicallib26 = V35m/V42m*100
gen conservatives26 = V36m/V42m*100
gen agrarianlib26 = V37m/V42m*100

gen socialdemo29 = V45m/V52m*100
gen radicallib29 = V46m/V52m*100
gen conservatives29 = V47m/V52m*100
gen agrarianlib29 = V48m/V52m*100

gen socialdemo32 = V55m/V64m*100
gen radicallib32 = V56m/V64m*100
gen conservatives32 = V57m/V64m*100
gen agrarianlib32 = V58m/V64m*100

gen socialdemo35 = V67m/V77m*100
gen radicallib35 = V68m/V77m*100
gen conservatives35 = V69m/V77m*100
gen agrarianlib35 = V70m/V77m*100

gen socialdemo39 = V80m/V91m*100
gen radicallib39 = V81m/V91m*100
gen conservatives39 = V82m/V91m*100
gen agrarianlib39 = V83m/V91m*100

gen socialdemo43 = V94m/V103m*100
gen radicallib43 = V95m/V103m*100
gen conservatives43 = V96m/V103m*100
gen agrarianlib43 = V97m/V103m*100

gen socialdemo45 = V106m/V114m*100
gen radicallib45 = V107m/V114m*100
gen conservatives45 = V108m/V114m*100
gen agrarianlib45 = V109m/V114m*100


label var socialdemo20 "Socialdemokrats, pct"
label var radicallib20 "Social-liberals, pct"
label var conservatives20 "Conservatives, pct"
label var agrarianlib20 "Liberals, pct"

label var socialdemo24 "Socialdemokrats, pct"
label var radicallib24 "Social-liberals, pct"
label var conservatives24 "Conservatives, pct"
label var agrarianlib24 "Liberals, pct"

label var socialdemo26 "Socialdemokrats, pct"
label var radicallib26 "Social-liberals, pct"
label var conservatives26 "Conservatives, pct"
label var agrarianlib26 "Liberals, pct"

label var socialdemo29 "Socialdemokrats, pct"
label var radicallib29 "Social-liberals, pct"
label var conservatives29 "Conservatives, pct"
label var agrarianlib29 "Liberals, pct"

label var socialdemo32 "Socialdemokrats, pct"
label var radicallib32 "Social-liberals, pct"
label var conservatives32 "Conservatives, pct"
label var agrarianlib32 "Liberals, pct"

label var socialdemo35 "Socialdemokrats, pct"
label var radicallib35 "Social-liberals, pct"
label var conservatives35 "Conservatives, pct"
label var agrarianlib35 "Liberals, pct"

label var socialdemo39 "Socialdemokrats, pct"
label var radicallib39 "Social-liberals, pct"
label var conservatives39 "Conservatives, pct"
label var agrarianlib39 "Liberals, pct"

label var socialdemo43 "Socialdemokrats, pct"
label var radicallib43 "Social-liberals, pct"
label var conservatives43 "Conservatives, pct"
label var agrarianlib43 "Liberals, pct"

label var socialdemo45 "Socialdemokrats, pct"
label var radicallib45 "Social-liberals, pct"
label var conservatives45 "Conservatives, pct"
label var agrarianlib45 "Liberals, pct"


*Each party as a percentage of total votes cast, muni:

gen KBsocialdemo21 = V12valg1921/(V6valg1921)*100
gen KBradicallib21 = V13valg1921/(V6valg1921)*100
gen KBconservatives21 = V14valg1921/(V6valg1921)*100
gen KBagrarianlib21 = V15valg1921/(V6valg1921)*100

label var KBsocialdemo21 "Socialdemokrats muni, pct"
label var KBradicallib21 "Social-liberals muni, pct"
label var KBconservatives21 "Conservatives muni, pct"
label var KBagrarianlib21 "Liberals, muni, pct"



gen KBsocialdemo25 = V12valg1925/(V6valg1925)*100
gen KBradicallib25 = V13valg1925/(V6valg1925)*100
gen KBconservatives25 = V14valg1925/(V6valg1925)*100
gen KBagrarianlib25 = V15valg1925/(V6valg1925)*100

label var KBsocialdemo25 "Socialdemokrats muni, pct"
label var KBradicallib25 "Social-liberals muni, pct"
label var KBconservatives25 "Conservatives muni, pct"
label var KBagrarianlib25 "Liberals, muni, pct"


gen KBsocialdemo33 = V12valg1933/(V6valg1933)*100
gen KBradicallib33 = V13valg1933/(V6valg1933)*100
gen KBconservatives33 = V14valg1933/(V6valg1933)*100
gen KBagrarianlib33 = V15valg1933/(V6valg1933)*100

label var KBsocialdemo33 "Socialdemokrats muni, pct"
label var KBradicallib33 "Social-liberals muni, pct"
label var KBconservatives33 "Conservatives muni, pct"
label var KBagrarianlib33 "Liberals, muni, pct"

gen KBsocialdemo46 = V12valg1946/(V6valg1946)*100
gen KBradicallib46 = V13valg1946/(V6valg1946)*100
gen KBconservatives46 = V14valg1946/(V6valg1946)*100
gen KBagrarianlib46 = V15valg1946/(V6valg1946)*100

label var KBsocialdemo46 "Socialdemokrats muni, pct"
label var KBradicallib46 "Social-liberals muni, pct"
label var KBconservatives46 "Conservatives muni, pct"
label var KBagrarianlib46 "Liberals, muni, pct"

gen KBsocialdemo54 = V12valg1954/(V6valg1954)*100
gen KBradicallib54 = V13valg1954/(V6valg1954)*100
gen KBconservatives54 = V14valg1954/(V6valg1954)*100
gen KBagrarianlib54 = V15valg1954/(V6valg1954)*100

label var KBsocialdemo54 "Socialdemokrats muni, pct"
label var KBradicallib54 "Social-liberals muni, pct"
label var KBconservatives54 "Conservatives muni, pct"
label var KBagrarianlib54 "Liberals, muni, pct"


*******************************************************************************
*Population variables from the archive
*******************************************************************************

gen pop21 = log(V119m)
gen numpop21= V119m
gen urban21 = V122m/V119m*100

gen pop25 = log(V123m)
gen urban25 = V126m/V123m*100


foreach num of numlist 21 25 {
label var pop`num' "Log population"
label var urban`num' "Urbanization, pct"
}

label var numpop21 "Population 1921"


gen pop30 = log(V127m)
gen munipop30=V127m
gen numpop30=V127m
gen femalepop30 = V129m/V127m*100
gen urban30 = V138m/V127m*100

gen pop40 = log(V141m)
gen numpop40=V141m
gen urban40 = V154m/V141m*100
gen femalepop40 = V143m/V141m*100

* we do not have share females in 1935 - impute here from pop1930 and 1940
gen pop35 = log(V139m)
gen urban35 = V140m/V139m*100
gen femalepop35 = (femalepop30+femalepop40)/2

gen pop45 = log(V155m)
gen urban45 = V158m/V155m*100
gen femalepop45 = V157m/V155m*100


foreach num of numlist 30 35 40 45 {
label var femalepop`num' "Female, pct"
label var pop`num' "Log population"
label var urban`num' "Urbanization, pct"
}



*Industries
gen agripop30 = V130m/V127m*100
gen industrypop30 = V131m/V127m*100
label var agripop30 "Agriculture, pct"
label var industrypop30 "Industry, pct"

gen agripop40 = V144m/V141m*100
gen industrypop40 = V145m/V141m*100
label var agripop40 "Agriculture, pct"
label var industrypop40 "Industry, pct"

order Kommune_ID DigDag_Navn socialdemo20-industrypop40 


foreach var of varlist V166m-V243m {
egen help`var'=sum(`var')
}
* to find the ones that are empty

drop V167m V168m V173m V176m V179m V182m V183m V186m-V191m V193m V194m V199m V202m V205m V208m V209m 
drop V212m-V217m V219m V220m V225m V228m V231m V234m V235m V238m-V243m
drop help*

rename V166m incometaxp21
rename V169m incometaxp24
rename V170m incometaxp25
rename V171m incometaxp26
rename V172m incometaxp27
rename V174m incometaxp29
rename V175m incometaxp30
rename V177m incometaxp32
rename V178m incometaxp33
rename V180m incometaxp35
rename V181m incometaxp36
rename V184m incometaxp39
rename V185m incometaxp40

rename V192m taxableincometot21
rename V195m taxableincometot24
rename V196m taxableincometot25
rename V197m taxableincometot26
rename V198m taxableincometot27
rename V200m taxableincometot29
rename V201m taxableincometot30
rename V203m taxableincometot32
rename V204m taxableincometot33
rename V206m taxableincometot35
rename V207m taxableincometot36
rename V210m taxableincometot39
rename V211m taxableincometot40

rename V218m propertytaxp21
rename V221m propertytaxp24
rename V222m propertytaxp25
rename V223m propertytaxp26
rename V224m propertytaxp27
rename V226m propertytaxp29
rename V227m propertytaxp30
rename V229m propertytaxp32
rename V230m propertytaxp33
rename V232m propertytaxp35
rename V233m propertytaxp36
rename V236m propertytaxp39
rename V237m propertytaxp40



gen incometaxpercent21= incometaxp21/numpop21*100
gen propertytaxpercent21= propertytaxp21/numpop21*100
gen logtaxableincome21=ln(taxableincometot21)

label var incometaxpercent21 "Income tax payers, pct of pop"
label var propertytaxpercent21 "Property tax payers, pct of pop"
label var logtaxableincome21 "Taxable income, log"
compress


gen incometaxpercent30= incometaxp30/numpop30*100
gen propertytaxpercent30= propertytaxp30/numpop30*100
gen logtaxableincome30=ln(taxableincometot30)

label var incometaxpercent30 "Income tax payers, pct of pop"
label var propertytaxpercent30 "Property tax payers, pct of pop"
label var logtaxableincome30 "Taxable income, log"



gen incometaxpercent40= incometaxp40/numpop40*100
gen propertytaxpercent40= propertytaxp40/numpop40*100
gen logtaxableincome40=ln(taxableincometot40)

label var incometaxpercent40 "Income tax payers, pct of pop"
label var propertytaxpercent40 "Property tax payers, pct of pop"
label var logtaxableincome40 "Taxable income, log"

compress
save "$work/munic_controls_recode.dta", replace

* reshape
use "$work/munic_controls_recode.dta", clear

drop pop19*

foreach num of numlist 30(1)60{
gen help`num'=.
}


#delimit ;
reshape long help
	 socialdemo radicallib agrarianlib conservatives 
	 KBsocialdemo KBradicallib KBconservatives KBagrarianlib
	 pop numpop munipop urban femalepop 
	 industrypop agripop incometaxpercent logtaxableincome propertytaxpercent, i(Kommune_ID) j(year);
#delimit cr


drop V* 
drop incometaxp21- propertytaxp40  help


preserve
* keep the 1929 election and all 1930 census etc data
keep if year==20 | year==21| year==29 | year==30
replace year=1920 if year==20
replace year=1921 if year==21
replace year=1929 if year==29
replace year=1930 if year==30


keep if year==1929 | year==1930
sort Kommune_ID
foreach var of varlist socialdemo-conservatives{
by Kommune_ID: egen `var'1=max(`var')
drop `var'
rename `var'1 `var'1929
}


sort Kommune_ID
foreach var of varlist pop- propertytaxpercent{
by Kommune_ID: egen `var'1=max(`var')
drop `var'
rename `var'1 `var'1930
}


sort Kommune_ID
by Kommune_ID: keep if _n==1

drop year KB* NAVN1 DigDag_AmtNavn


label var sociald "Pct socialdemocratic votes 1929"
label var radical "Pct radical-liberal votes 1929"
label var conserv "Pct conservative votes 1929"
label var agrar "Pct agrarian-liberal votes 1929"
label var pop1930 "Ln population 1930"
label var munipop1930 "Population 1930"
label var urban "Pct urbanization 1930"
label var female "Pct female population 1930"
label var industry "Pct population in industry 1930"
label var agripop "Pct population in agriculture 1930"
label var incometax "Pct incometax payers 1930"
label var propertytax "Pct propertytax payers 1930"
label var logtaxa "Ln taxable income 1930"



compress
save "$work/munic_controls_recode2930.dta", replace

restore 


preserve

* keep the 1920 election and all 1921 census etc data
keep if year==20 | year==21| year==29 | year==30
replace year=1920 if year==20
replace year=1921 if year==21
replace year=1929 if year==29
replace year=1930 if year==30


keep if year==1920 | year==1921
sort Kommune_ID
foreach var of varlist socialdemo-conservatives{
by Kommune_ID: egen `var'1=max(`var')
drop `var'
rename `var'1 `var'1920
}


sort Kommune_ID
foreach var of varlist pop- propertytaxpercent{
by Kommune_ID: egen `var'1=max(`var')
drop `var'
rename `var'1 `var'1921
}

drop munipop female* industry* agri*

sort Kommune_ID
by Kommune_ID: keep if _n==1

drop year KB* NAVN1 DigDag_AmtNavn


label var sociald "Pct socialdemocratic votes 1920"
label var radical "Pct radical-liberal votes 1920"
label var conserv "Pct conservative votes 1920"
label var agrar "Pct agrarian-liberal votes 1920"
label var pop1921 "Ln population 1921"
label var urban "Pct urbanization 1921"
label var incometax "Pct incometax payers 1921"
label var propertytax "Pct propertytax payers 1921"
label var logtaxa "Ln taxable income 1921"



compress
save "$work/munic_controls_recode2021.dta", replace
 

restore

save "$work/munic_controls_recode_ontheway.dta", replace


***********************************************************
* interpolate as controls
***********************************************************
use "$work/munic_controls_recode_ontheway.dta", clear

sort Kommune_ID year
#delimit ;
global vars socialdemo radicallib agrarianlib conservatives KBsocialdemo KBradicallib KBconservatives KBagrarianlib
	 pop numpop munipop urban femalepop 
	 industrypop agripop incometaxpercent logtaxableincome propertytaxpercent;
#delimit cr

keep if year>=30

gsort Kommune_ID -year


foreach var of varlist socialdemo radicallib agrarianlib conservatives{
replace `var'=KB`var' if `var'==. & KB`var'!=.
replace `var'=. if `var'==0
}

foreach vars of varlist socialdemo radicallib agrarianlib conservatives pop urban femalepop{
by Kommune_ID: replace `vars'=`vars'[_n-1] if Kommune_ID[_n-1]==Kommune_ID & `vars'[_n-1]!=. & `vars'==.
}


* replace the still missings 
foreach var of varlist $vars{
by Kommune_ID: ipolate `var' year, gen(ipol_`var') epolate
}


sort Kommune_ID year

drop munipop* ipol_munipop* ipol_KB*

replace year=year+1900

keep Kommune_ID year ipol*
rename Kommune_ID muni
compress
save "$work/munic_controls_recode_ipolated.dta", replace




