* DESCRIPTIVE ANALYSES
* CORRELATION OF NURSE AND DAYCARE
* BASED ON EVER IMPLEMENTERS

do "D:\Data\workdata\704665\daycare\dofiles\first.do"

* analysis data
use  "$work\analysis_daycare_muni_ever_yrapproval.dta",clear

***************************************************
* testing observable characteristics in rural/urban areas
* table 3
***************************************************
replace early = 1 if fstyear==.

preserve
bys muni: keep if _n==1

merge 1:1 muni using $work\geographicvariables2.dta
keep if _merge==3
drop _merge
dis _N


   #delimit ;
global help  ever_nurse urban1921 pop1921  socialdemo1920 radicallib1920 agrarianlib1920 conservatives1920   logtaxableincome1921 incometaxpercent1921 propertytaxpercent1921;
	#delimit cr

mdesc $help

tab county rural

*very few missings- use other available year
replace incometaxpercent1921=incometaxpercent1930 if incometaxpercent1921==.
replace propertytaxpercent1921=propertytaxpercent1930 if propertytaxpercent1921==.
replace urban1921=urban1930 if urban1921==.
replace pop1921=pop1930 if pop1921==.
	
	mdesc $help

	
estimates clear	
reg  always $help   if rural==0   
	estimates store a0
	qui sum `e(depvar)'  if e(sample)==1
	estadd scalar dv=`r(mean)'
	testparm  $help 
	estadd scalar test=r(p)
	estadd scalar test1=r(F)

	
reg  early $help   if rural==0  
	estimates store a1
	qui sum `e(depvar)'  if e(sample)==1
	estadd scalar dv=`r(mean)'
	testparm  $help 
	estadd scalar test=r(p)
	estadd scalar test1=r(F)
	
reg fstyear $help     if rural==0 
	estimates store a2
	qui sum `e(depvar)'  if e(sample)==1
	estadd scalar dv=`r(mean)'
	testparm  $help 
	estadd scalar test=r(p)
	estadd scalar test1=r(F)
	
	reg  always $help  if rural==1  
	estimates store a3
	qui sum `e(depvar)'  if e(sample)==1
	estadd scalar dv=`r(mean)'
	testparm  $help 
	estadd scalar test=r(p)
	estadd scalar test1=r(F)
	
reg  early $help  if rural==1 
	estimates store a4
	qui sum `e(depvar)'  if e(sample)==1
	estadd scalar dv=`r(mean)'
	testparm  $help 
	estadd scalar test=r(p)
	estadd scalar test1=r(F)
	
reg fstyear $help    if rural==1 
	estimates store a5
	qui sum `e(depvar)'  if e(sample)==1
	estadd scalar dv=`r(mean)'
	testparm  $help 
	estadd scalar test=r(p)
	estadd scalar test1=r(F)
	
#delimit ;
esttab a* using  "$results\munichar_predict_operate_urbanrural.tex",  star(* .1 ** .05 *** .01) cells(b(star fmt(%9.3f))  se(par([ ])))
wrap label varwidth(18) keep($help )
replace booktabs fragment stats(dv  test1 test N,  fmt(%9.3f %9.3f %9.3f  %9.0f) label("Mean, dept. var." "F-test" "P-value joint F-test" "Observations (munics)"))
mtitles ( "Always impl." "Early impl." "Impl. year" "Always impl." "Early impl." "Impl. year") 
;
#delimit cr
restore



************************************************************************************************
**** check whether predicted outcomes are correlated with treatment (first generation)
* Appendix Table A9
************************************************************************************************

foreach out in $mainout {

reg `out' $contrvars [aweight=N]
predict pr`out'
}

global predout prindex_hc pryear50 prmorethanbasic50 prln_age3060_mean_wage_inc prsurv65


eststo clear
foreach var in  $predout  {
eststo: areg `var' operating  i.year i.county#c.year [aw=N], abs(muni) cl(muni)
qui sum `e(depvar)' [aw `e(wexp)'] if e(sample)==1
estadd scalar dv=`r(mean)'
}
#delimit ;
esttab using  "$results\predout_robustness.tex", keep(operating) star(* .1 ** .05 *** .01) se brackets
wrap label varwidth(18) 
replace booktabs fragment stats(N, label("Observations (cells)"))
mtitles ("Pr. HC Index" "Pr. Yrs. School" "Pr. More than Comp." "Pr. Log Wage Inc" "Pr. Survival beyond age 65" ) ;
#delimit cr


************************************************************************************************
****************** GRAPHS *******************
************************************************************************************************
***** Plot share of munis with approved childcare by year
* Figure 1B
************************************************************************************************

preserve
collapse (mean) operating, by(year)
line operating year, lcolor(black) lw(medthick) xlabel(1933(3)1960) xtitle("Year") ytitle("Approved Preschool in Municipality")
graph export "$graphs\operating_munic_yrapproval.png", replace
restore

************************************************************************************************
***** Plot variation in nurse and preschool
* Appendix Figure A1
************************************************************************************************

label var daycare_nurse "Preschool x NHV"
label var nurse_treat "NHV at Birth"

gen yob = year-3
gen nurse_noday = (nurse_treat>0 & operating==0)
gen day_nonurse = (nurse_treat==0 & operating==1)
gen noday_nonurse = (nurse_treat==0 & operating==0)
gen day_nurse = (nurse_treat>0 & operating==1)

preserve
collapse (mean) nurse_noday day_nonurse noday_nonurse day_nurse, by(yob)
twoway (line noday_nonurse yob, lcolor(gs0) lw(medthick)) (line nurse_noday yob, lcolor(gs0) lpattern(dash) lw(medthick)) (line day_nonurse yob, lcolor(gs0) lpattern(longdash) lw(medthick)) (line day_nurse yob, lcolor(gs0) lpattern(shortdash) lw(thick)),  xtitle(Year of Birth) xlabel(1930(3)1957) ytitle(Percent Municipalities) legend(label(1 "None") label(2 "NHV Only") label(3 "Preschool Only") label(4 "NHV & Preschool"))
graph export "$graphs\nurse_daycare_variation_yrapproval.png", replace
restore


************************************************************************************************
* nurse preschool distance in date
* Appendix Figure A2
************************************************************************************************

preserve

bysort muni year: gen nursedate=year-3 if nurse_treat==1 & nurse_treat[_n-1]!=1
by muni: egen nurseyear=min(nursedate)
drop nursedate
bys muni: keep if _n==1

gen distance=nurseyear-fstyear if fstyear!=. & nurseyear!=.
replace distance=-20 if fstyear==.
replace distance=-22 if nurseyear==.

label define cat -20 "Always Preschool" -22 "Never NHV" 
label values distance cat


hist distance, frequency discrete addlabels xlabel(-22(2)16, valuelabel angle(45)) ylabel(0(5)30) xtitle(Distance Preschool Approval and NHV Introduction (Years) ) ytitle(Number of Municipalities)
graph export "$graphs\histogram_distance.png", replace

restore

************************************************************************************************
************** Correlate nurse program with daycare
* Table 2
************************************************************************************************

eststo clear

eststo: areg nurse_treat operating  $style2, abs(muni) cl(muni)
qui sum `e(depvar)' [aw `e(wexp)'] if e(sample)==1
estadd scalar dv=`r(mean)'


eststo: areg  operating nurse_treat $style2, abs(muni) cl(muni)
qui sum `e(depvar)' [aw `e(wexp)'] if e(sample)==1
estadd scalar dv=`r(mean)'


#delimit ;
esttab using  "$results\day_nurse_correlation.tex", keep(operating nurse_treat) star(* .1 ** .05 *** .01) cells(b(star fmt(%9.3f))  se(par([ ])))
wrap label varwidth(18)  collabels(,none)
replace booktabs fragment stats(dv N, fmt(%9.3f %9.0f) label("Mean, dept. var." "Observations (cells)"))
mtitles ("NHV at Birth" "Any Approved Preschool at Age 3" ) ;
#delimit cr

