do "D:\Data\workdata\704665\daycare\dofiles\first.do"

*************************************************************
* Health outcomes from the Inpatient registry for the 2nd gen
* may 2019; added for referee
* only hosp admissions
* register starts in 1980 - condition on kids being at least 25
*************************************************************

u  "$work\pop3560_kidssample.dta", clear 
keep pnr fodyear_kid
sa "$work\pop_daycare_pnrlistkids.dta", replace

set more off
*entire data period used

foreach num of numlist 1980/1993{
use pnr recnum inddto behdage uddto pattype using "$raw\LPR_INDLAEGGELSER_`num'.dta" , clear
sort pnr
gen int outyear = `num'

merge m:1 pnr using "$work\pop_daycare_pnrlistkids.dta"
keep if _merge==3
drop _merge

save "$work\lpr`num'kids.dta",replace
}



foreach num of numlist 1994/2012{
use pnr recnum inddto sengdage uddto pattype using "$raw\LPR_INDLAEGGELSER_`num'.dta" , clear
sort pnr
rename sengdage behdage
gen int outyear = `num'

merge m:1 pnr using "$work\pop_daycare_pnrlistkids.dta"
keep if _merge==3
drop _merge

save "$work\lpr`num'kids.dta",replace
}


******************************************************************
* number of nights/year
******************************************************************

foreach num of numlist 1980/2012{

use "$work\lpr`num'kids.dta", clear

gen age=outyear-fodyear_kid

keep if age>=25 & age!=.

drop if pattype!="0"

gsort pnr inddto -behdage
by pnr inddto: keep if _n==1

* check for nested spells - there are very few of those...
gsort pnr inddto -uddto
by pnr: drop if inddto==inddto[_n-1] & uddto<=uddto[_n-1]
by pnr: drop if inddto>=inddto[_n-1] & uddto==uddto[_n-1]
by pnr: drop if inddto>=inddto[_n-1] & uddto<=uddto[_n-1]

collapse (sum) nights=behdage (mean) outyear, by(pnr age)
replace nights=365 if nights>365
compress
save "$work\lpr_nights`num'kids.dta", replace

}

use "$work\lpr_nights1980kids.dta", clear
foreach num of numlist 1981/2012{
append using "$work\lpr_nights`num'kids.dta" 
}

label var nights "Number of hospital nights in given year"
label var outyear "Outcome year"

drop outyear
reshape wide nights ever, i(pnr) j(age)
drop nights35-nights61

foreach num of numlist 25(1)34{
replace nights`num'=0 if nights`num'==.
}

save "$work\lpr_nights_kids.dta",replace

