clear all

do "D:\Data\workdata\704665\daycare\dofiles\first.do"

*************************************************************
* Health outcomes from the Inpatient registry
*************************************************************

u pnr using "$work\pop_daycare_popmunic_yrapproval.dta", clear 
sort pnr
sa "$work\pop_daycare_pnrlist.dta", replace

* merge pop to inpatient data

set more off
*entire data period used; 1994 databreak in inpatient data - thus 2 loops

foreach num of numlist 1980/1993{
use pnr recnum inddto behdage uddto pattype using "$raw\LPR_INDLAEGGELSER_`num'.dta" , clear
sort pnr
gen int outyear = `num'

merge 1:m recnum using "$raw\LPR_diagnoser`num'.dta"
keep if _merge==3
drop _merge

merge m:1 pnr using "$work\pop_daycare_pnrlist.dta"
keep if _merge==3
drop _merge

save "$work\lpr`num'.dta",replace
}



foreach num of numlist 1994/2012{
use pnr recnum inddto sengdage uddto pattype using "$raw\LPR_INDLAEGGELSER_`num'.dta" , clear
sort pnr
rename sengdage behdage
gen int outyear = `num'

merge 1:m recnum using "$raw\LPR_diagnoser`num'.dta"
keep if _merge==3
drop _merge

merge m:1 pnr using "$work\pop_daycare_pnrlist.dta"
keep if _merge==3
drop _merge

save "$work\lpr`num'.dta",replace
}


******************************************************************
* number of nights/year
******************************************************************

foreach num of numlist 1980/2012{

use "$work\lpr`num'.dta", clear
drop if pattype!="0" // only inpatient - due to databreak in 1994 cannot use outpatient as well

gsort pnr inddto -behdage
by pnr inddto: keep if _n==1

* check for nested spells - there are very few of those...
gsort pnr inddto -uddto
by pnr: drop if inddto==inddto[_n-1] & uddto<=uddto[_n-1]
by pnr: drop if inddto>=inddto[_n-1] & uddto==uddto[_n-1]
by pnr: drop if inddto>=inddto[_n-1] & uddto<=uddto[_n-1]

collapse (sum) nights=behdage (mean) outyear, by(pnr)
replace nights=365 if nights>365
compress
save "$work\lpr_nights`num'.dta", replace

}

use "$work\lpr_nights1980.dta", clear
foreach num of numlist 1981/2012{
append using "$work\lpr_nights`num'.dta" 
}

label var nights "Number of hospital nights in given year"
label var outyear "Outcome year"
save "$work\lpr_nights.dta",replace


use "$work\lpr_nights.dta", clear
merge m:1 pnr using "$work\pop_daycare_popmunic_yrapproval.dta"

keep pnr nights outyear fodyear

gen age=outyear-fodyear

sort pnr outyear
foreach num of numlist 45(10)75{
gen anights`num'=nights if age>=`num' & age<`num'+10
by pnr: egen nights`num'=sum(anights`num')
drop anights*
}

label var nights45 "No of hospital nights age 45-54"
label var nights55 "No of hospital nights age 55-64"
label var nights65 "No of hospital nights age 65-74"
label var nights75 "No of hospital nights age 75-84"

sort pnr 
by pnr: keep if _n==1

keep pnr nights45 nights55 nights65 

compress
save "$work\lpr_nights_ranges.dta", replace


******************************************************************
* diagnoses we are interested in
******************************************************************


foreach num of numlist 1980/2012{

use "$work\lpr`num'.dta", clear

drop inddto behdage uddto recnum pattype diagtype

* dupletter - same diag, same spell
gsort pnr diag 
by pnr diag : gen help=_n
keep if help==1
drop help 

* diabetes
* cardio vascular disease
* heart disease

* for merge with icd groups (23) for disease and causes of death
gen icd8=(outyear<=1993)

gen sks=substr(diag,1,4) if icd8==1
replace sks=substr(diag,2,5) if icd8==0

* ICD 8
gen diagd=substr(diag, 1,3)

gen diab1=1 if diagd=="249"
replace diab1=1 if diagd=="250"
by pnr: egen diab=min(diab1)
drop diab1 

gen cardio1=1 if (diagd>="390" & diagd<="458")
sort pnr
by pnr: egen cardio=min(cardio1)
drop cardio1

gen heart1=1 if (diagd>="410" & diagd<="414")
sort pnr
by pnr: egen heart=min(heart1)
drop heart1

drop diagd

* ICD 10
* codes are based on Statens Inistitut for Folkesundhed definitions
* all diag types (not only aktionsdiagnose)

gen diagd=substr(diag, 1,4)
gen diagd1=substr(diag, 1,2)

replace diab=1 if diagd=="DE10"
replace diab=1 if diagd=="DE11"
replace diab=1 if diagd=="DE12"
replace diab=1 if diagd=="DE13"
replace diab=1 if diagd=="DE14"

replace cardio=1 if (diagd>="DI00" & diagd<="DI99")

replace heart=1 if (diagd>="DI20" & diagd<="DI25")

drop diagd  diag sks
replace diab=0 if diab==.
replace cardio=0 if cardio==.
replace heart=0 if heart==.


* cancer - as a "placebo"
gen cancer1=1 if (diagd=="DB21")
replace cancer1=1 if diagd1=="DC"
replace cancer1=1 if diagd=="DD05"
replace cancer1=1 if diagd=="DD06"
replace cancer1=1 if diag=="DD07.6"
replace cancer1=1 if diag=="DD09.0"
replace cancer1=1 if diag=="DD09.1"
replace cancer1=1 if diag>="DD301" & diag<="DD309"
replace cancer1=1 if diagd=="DD30"
replace cancer1=1 if diagd=="DD32"
replace cancer1=1 if diagd=="DD33"
replace cancer1=1 if diag=="DD35.2"
replace cancer1=1 if diag=="DD35.3"
replace cancer1=1 if diag=="DD35.4"
replace cancer1=1 if diagd>="DD37" & diagd<="DD48"
replace cancer1=1 if diagd=="DN87"
replace cancer1=1 if diagd=="DO01"
by pnr: egen cancer=min(cancer1)
drop cancer1



* one record per person
sort pnr
by pnr: gen help=_n
keep if help==1
drop help

drop if diab==0 & heart ==0 & cardio==0 & cancer==0


label var diab "Diagnosed with diabetes"
label var cardio "Diagnosed with cardiovascular diseases"
label var heart "Diagnosed with heart disease"
label var cancer "Diagnosed with cancer"

compress
save "$work\lpr_diag`num'.dta", replace

}


use "$work\lpr_diag1980.dta", clear
foreach num of numlist 1981/2012{
append using "$work\lpr_diag`num'.dta" 
}

* diags are an absrobing state
sort pnr outyear
foreach var of varlist diab cardio heart cancer{
replace `var'=outyear if `var'==1
replace `var'=. if `var'==0
by pnr: egen outyear`var'=min(`var')
}

sort pnr outyear
by pnr: keep if _n==1

keep pnr outyeardiab outyearcardio outyearheart outyearcancer

label var outyeardiab "Year of diabetes diagnose"
label var outyearcardio "Year of cario. diagnose"
label var outyearheart "Year of heart disease diagnose"
label var outyearcancer "Year of cancer diagnose"


compress
save "$work\lpr_diag.dta", replace


* we still have to merge the deaths on - some people first get the diag when they die
* especially relevant for heart and cardio

use "$work\death19812013.dta",clear
gen year=year(doddato)

sort pnr
merge 1:1 pnr using "$work\lpr_diag.dta"

replace outyeardiab=deathyear if gruppe23==5 & outyeardiab==.
replace outyearheart=deathyear if gruppe23==8 & outyearheart==.
replace outyearcardio=deathyear if gruppe23==8 & outyearcardio==.
replace outyearcardio=deathyear if gruppe23==9 & outyearcardio==.
replace outyearcancer=deathyear if gruppe23==3 & outyearcancer==.
replace outyearcancer=deathyear if gruppe23==4 & outyearcancer==.

drop if outyearcardio==. & outyearheart==. & outyeardiab==. & outyearcancer==.
drop _merge doddato- death65 year

compress
********************************************
save "$work\lpr_diags_withdeath.dta", replace
********************************************


use "$work\lpr_diags_withdeath.dta", clear

merge m:1 pnr using "$work\pop_daycare_popmunic_yrapproval.dta"

keep pnr-outyearcancer pnr fodyear

foreach var in diab cardio heart cancer{
gen age_`var'=outyear`var'-fodyear
}


foreach var in diab cardio heart cancer{
sort pnr outyear`var'
foreach num of numlist 40(10)70{
gen a`var'`num'=1 if age_`var'<=`num' 
by pnr: egen `var'`num'=max(a`var'`num')
drop a`var'*
replace `var'`num'=0 if `var'`num'==.
}
}

foreach num of numlist 40(10)70{
label var cardio`num' "Diagnosed w. cardiovasc. disease by age `num'"
label var diab`num' "Diagnosed w. diabetes by age `num'"
label var heart`num' "Diagnosed w. heart disease by age `num'"
label var cancer`num' "Diagnosed w. cancer by age `num'"
}

keep pnr cardio* diab* heart* cancer*

compress
********************************************
save "$work\lpr_diags_withdeath_byage.dta", replace
********************************************



