* This file creates the Figure 3 from Ryan Bubb and Patrick Warren, An Equilibrium Theory of Retirement Plan Design (2019)

use bubbwarren19.dta, clear

set scheme s1mono

hist initialdefault, fraction start(0.5) width(1) xlabel(0(1)10) ylabel(0(.1).6) xscale(range(0 10)) name(defaulthist)

graph export defaulthist.pdf, name(defaulthist) as(pdf) replace
 
* create variable with the highest matching cap, to capture (rare) cases with
* multi-tiered matching.
gen highestmatchingcap = matchingcap1
replace highestmatchingcap = matchingcap2 if matchingcap2 != .
replace highestmatchingcap = matchingcap3 if matchingcap3 != .

hist highestmatchingcap, fraction  name(caphist) xlabel(0(10)100) 

graph export caphist.pdf, name(caphist) as(pdf)  replace

gen highestmatchingcap_trunc = highestmatchingcap
replace highestmatchingcap_trunc = 10 if highestmatchingcap_trunc > 10 & highestmatchingcap_trunc != .

hist highestmatchingcap_trunc, fraction  start(0.5) width(1) xlabel(0(1)10) ylabel(0(.1).6) xtitle("Matching Cap %") name(caphist2)

* have to manually edit the caphist2 graph to creat "10+" label on x axis and export to pdf.

*graph export caphist2.pdf, name(caphist2) as(pdf) replace

* create indicator for whether initial default < matching cap
gen defaultlessthancap = .
replace defaultlessthancap = 1 if initialdefault < highestmatchingcap & highestmatchingcap != . & initialdefault != .
replace defaultlessthancap = 0 if initialdefault >= highestmatchingcap & initialdefault != . & highestmatchingcap != .

tab defaultlessthancap

* how many have defaults strictly above the cap?
gen defaultstrictlygreaterthancap = .
replace defaultstrictlygreaterthancap = 1 if initialdefault > highestmatchingcap & highestmatchingcap != . & initialdefault != .
replace defaultstrictlygreaterthancap = 0 if initialdefault <= highestmatchingcap & initialdefault != . & highestmatchingcap != .

tab defaultstrictlygreaterthancap

gen ratio = initialdefault / highestmatchingcap

hist ratio, fraction start(-.05) width(0.1) xlabel(0(.5)4) name(ratiohist) xtitle("Default Contribution Rate / Matching Cap")

graph export ratiohist.pdf, name(ratiohist) as(pdf) replace

gen ratioequal1 = 0
replace ratioequal1 = 1 if initialdefault == highestmatchingcap

tab ratioequal1 
 
 
 * automatic escalation
 tab defaultautomaticannualincrease, m
 tab maximumdefault, m
 
 tab defaultautomaticannualincrease maximumdefault, m
 
 gen minsafeharborescalation = 0
 replace minsafeharborescalation = 1 if initialdefault==3 & defaultautomaticannualincrease == 1 & maximumdefault == 6
 
 tab minsafeharborescalation 
 
 gen safeharborescalation = 0
 replace safeharborescalation = 1 if initialdefault>=3 & defaultautomaticannualincrease == 1 & maximumdefault <= 6
 
 tab safeharborescalation 
 
 
 * plot ratio based on maximum default
 gen maxdef = initialdefault
 replace maxdef = maximumdefault if maximumdefault != .
 
 gen ratio_maxdef = maxdef / highestmatchingcap
 
 hist ratio_maxdef , fraction start(-.05) width(0.1) xlabel(0(.5)4) name(ratiohist_maxdef) xtitle("Maximum Default Contribution Rate / Matching Cap")

graph export ratiohist_maxdef.pdf, name(ratiohist_maxdef) as(pdf) replace

 
