% Fig: fixed cost bound (y) and quality (x)
% Regression: fixed cost bound on quality
function [q_lower, q_upper, b_lower, b_upper, fc_lb_est, fc_ub_est, bounds_distance]...
    = regression_and_plot_fc_bound_quality(filename_results_part3_51_mkts, jobid_results_part3_51_mkts, ifplot)

load(filename_results_part3_51_mkts);


q_upper = cell(n_mkt, n_oem);
q_lower = cell(n_mkt, n_oem);

fc_upper = cell(n_mkt, n_oem);

if add_potential_prod
    fc_lowerbound = fc_lowerbound_add_dropped; 
    fc_lower = fc_lowerbound_add_dropped;
else
    fc_lower = fc_lowerbound;
end

if include_flagship
    prod_ind = true(n_obs, 1);
else
    prod_ind = ~isflagship;
end

quality_index_includingbrand_model = quality_index_includingbrand;

uniquemodelid = unique(model_id);
for i = 1:length(uniquemodelid)
   ind = model_id == uniquemodelid(i);
   quality_index_includingbrand_model(ind) = mean(quality_index_includingbrand(ind));
end

for t = mkt_for_cf
    for no = 1 : n_oem
        q_upper_t_no_prod = quality_index_includingbrand_model(time==t&oem_ind(:, no)&prod_ind);
        fc_upper_t_no = fc_upperbound{t, no};
        
        inMkt_ind = model_id(time==t&oem_ind(:, no)&prod_ind);
        ind_ind = model_id_drop{t, no};
        
        q_upper_t_no = nan(length(ind_ind), 1);
        
        if length(unique(inMkt_ind))~=length(fc_upperbound{t, no})...
                || length(unique(inMkt_ind))~=length(ind_ind);
            error('product type mismatch');
        else                        
            for j = 1 : length(ind_ind)
                q_upper_t_no(j) = unique(q_upper_t_no_prod(ind_ind(j)==inMkt_ind));
            end
            
            for j = 1 : length(ind_ind)
                n_model_t_no = nnz(inMkt_ind==ind_ind(j));
                if n_model_t_no==0; error('model id mismatch'); end
                if n_model_t_no>1
                    fc_upper_t_no(j) = fc_upper_t_no(j)/n_model_t_no;
                end
            end
        end
        
        q_upper{t, no} = q_upper_t_no;
        fc_upper{t, no} = fc_upper_t_no;
        
        if add_potential_prod
            new_prod_t_no = new_dropped_prod_list{t, no};
        else
            new_prod_t_no = new_prod_list{t, no};
        end
        
        n_new_prod_t_no = length(new_prod_t_no);        
        
        if any(time==t & oem_ind(:, no))
            q_lower_t_no = nan(n_new_prod_t_no, 1);
            for j = 1 : n_new_prod_t_no
                q_lower_t_no(j) = new_prod_t_no{j}.q0 + new_prod_t_no{j}.brandeffect;
                fc_lowerbound{t, no}(j) = fc_lowerbound{t,no}(j)/length(new_prod_t_no{j}.carrier_id); 
            end       
            q_lower{t, no} = q_lower_t_no;
        end
        
        
    end
end


tmp_y = cell2mat(fc_lower(:));
fc_lb_est(1) = mean(tmp_y);
fc_lb_est(2) = length(tmp_y);
fc_lb_est(3) = mean(cell2mat(fc_lowerbound(:)));

n_model_cell_up = cell(n_mkt, n_oem);
for t = 1 : n_mkt
    model_id_t = model_id(time==t);
    for no = 1 : n_oem
        if ~isempty(fc_upperbound{t,no})
            n_t_no = length(fc_upperbound{t,no});
            nmto_vec = nan(n_t_no, 1);
            for ntn = 1 : n_t_no
                n_model_ntn = nnz(model_id_drop{t, no}(ntn)==model_id_t);
                if n_model_ntn==0; error('model index error'); end
                nmto_vec(ntn) = n_model_ntn;
            end
            n_model_cell_up{t, no} = nmto_vec;
        end
    end
end

tmp_x = cell2mat(q_lower(:));
tmp_x = [ones(length(tmp_x),1), tmp_x];

b_lower = regress(tmp_y, tmp_x);

tmp_y = cell2mat(fc_upper(:));
fc_ub_est(1) = mean(tmp_y);
fc_ub_est(2) = length(tmp_y);
fc_ub_est(3) = mean(cell2mat(fc_upperbound(:))); 

bounds_distance = fc_ub_est(1) - fc_lb_est(1);


tmp_x1 = cell2mat(q_upper(:));
tmp_x2 = cell2mat(n_model_cell_up(:));
tmp_x = [ones(length(tmp_x1),1), tmp_x1, tmp_x2];

b_upper = regress(tmp_y, tmp_x);

if ifplot
    figure; axes('FontSize',16);
    plot(cell2mat(q_lower(:)), cell2mat(fc_lower(:))*mktsize*1000*100/1e6, 'MarkerSize',15,'Marker','.','LineStyle','none');
    xlabel('quality','FontSize',16); 
    axis([2 8 0 35])
    ylabel('million $','FontSize',16)
    print(['fc_lb_' jobid_results_part3_51_mkts],'-dpdf')

    figure; axes('FontSize',16);
    plot(cell2mat(q_upper(:)), cell2mat(fc_upper(:))*mktsize*1000*100/1e6, 'MarkerSize',15,'Marker','.','LineStyle','none');
    xlabel('quality','FontSize',16); 
    axis([2 8 0 35])
    ylabel('million $','FontSize',16)
    print(['fc_ub_' jobid_results_part3_51_mkts],'-dpdf')
end
