function [markup_t, negativemarkup_carrier_t] = invertcost_t(t, ind_mkt_start, ind_mkt_end, share, prob_i, ...
    sim_pcoeff, n_smln, carrier_ind, oem_ind, setup)

tt = setup.uniquenumproduct2mkt(t);
n_carrier = size(carrier_ind, 2);
n_oem = size(oem_ind, 2);

ind_t = ind_mkt_start(t):ind_mkt_end(t);
n_prod_t = length(ind_t);

share_t = share(ind_t, :);
simShare_t = prob_i(ind_t, :);

sim_pcoeff_t = sim_pcoeff;
simSharep_t = simShare_t.*sim_pcoeff_t;

simSharep_t_weighted = simSharep_t / n_smln;

carrier_t = carrier_ind(ind_t, :);
oem_t = oem_ind(ind_t, :);

unique_ind_ijk1 = setup.unique_ind_ijk{tt,1};
unique_ind_ijk2 = setup.unique_ind_ijk{tt,2};
recover_ind_ijk1 = setup.recover_ind_ijk{tt,1};
recover_ind_ijk2 = setup.recover_ind_ijk{tt,2};

%% dsdp
dsdp = diag(sum(simSharep_t_weighted,2)) - (simSharep_t_weighted)*simShare_t'; 

%% markup
if isequal(setup.pricing_model, 'oem_carrier_collusion')
    collusionweightmatrix = zeros(n_prod_t, n_prod_t);
    for no = 1 : n_oem
        Jot = oem_t(:, no);
        for nc = 1 : n_carrier
            Jct = carrier_t(:, nc);
            collusionweightmatrix(Jot&Jct, Jot&Jct) = 1;
            collusionweightmatrix(Jot&Jct, Jot&~Jct) = setup.collusion_para_oem * setup.collusion_para_oem_share_of_profit; 
            collusionweightmatrix(Jot&Jct, ~Jot&Jct) = setup.collusion_para_carrier * (1-setup.collusion_para_oem_share_of_profit);
        end
    end
end
    
negativemarkup_carrier_t = nan(n_prod_t,1);

if isequal(setup.pricing_model, 'direct_oem')
    for no = 1 : n_oem
        Jot = oem_t(:, no);
        negativemarkup_carrier_t(Jot) = dsdp(Jot, Jot)'\share_t(Jot, :);
    end
    markup_t = -negativemarkup_carrier_t;
    negativemarkup_carrier_t = zeros(n_prod_t,1);
elseif isequal(setup.pricing_model, 'direct_carrier')
    for nc = 1 : n_carrier
        Jct = carrier_t(:, nc);
        negativemarkup_carrier_t(Jct) = dsdp(Jct, Jct)'\share_t(Jct, :);
    end
    markup_t = zeros(n_prod_t, 1);
elseif isequal(setup.pricing_model, 'oem_carrier_collusion')
    negativemarkup_carrier_t = setup.collusion_para_oem_share_of_profit*((collusionweightmatrix .* dsdp')\share_t);
    markup_t = -(1-setup.collusion_para_oem_share_of_profit) * negativemarkup_carrier_t;

elseif isequal(setup.pricing_model, 'sequential') || isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract')
    if (isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && t <= 25) % before the exclusive contract b/w Apple and AT&T ended in Jan 2011
        apple_t = setup.apple(ind_t);
        att = find(any(carrier_t(apple_t,:), 1));
        if length(att)~=1; error('iphones should be sold on one and only one carrier before Jan 2011'); end;

        for nc = 1:n_carrier
            Jct = carrier_t(:, nc);
            if nc == att
                tmpind = Jct & apple_t;
                negativemarkup_carrier_t(tmpind) = dsdp(tmpind, tmpind)'\share_t(tmpind, :);
                tmpind = Jct & ~apple_t;
                negativemarkup_carrier_t(tmpind) = dsdp(tmpind, tmpind)'\share_t(tmpind, :);
            else
                negativemarkup_carrier_t(Jct) = dsdp(Jct, Jct)'\share_t(Jct, :);
            end
        end
    else
        for nc = 1 : n_carrier
            Jct = carrier_t(:, nc);
            negativemarkup_carrier_t(Jct) = dsdp(Jct, Jct)'\share_t(Jct, :);
        end
    end

    %% ds2dp2: ds2dp2(j,i,k) is ds_j^2/dp_i*dp_k. 
    Esjsisk = simSharep_t_weighted(unique_ind_ijk1(:, 1), :).*simSharep_t(unique_ind_ijk1(:, 2), :);
    Esjsisk = sum(Esjsisk(recover_ind_ijk1, :).*simShare_t(unique_ind_ijk2, :), 2);

    ds2dp2 = nan(n_prod_t, n_prod_t, n_prod_t);
    for k = 1 : n_prod_t
        ds2dp2k = zeros(n_prod_t, n_prod_t);
        ds2dp2k(k,k) = -sum(sim_pcoeff.*simSharep_t_weighted(k,:),2); % -(i==j)*(j==k)*simShare_t(j, :)
        ds2dp2k(:,k) = ds2dp2k(:,k) + (simSharep_t_weighted * simSharep_t(k,:)'); % +(i==k)*simShare_t(i, :).*simShare_t(j, :)
        ds2dp2k(k,:) = ds2dp2k(k,:) + (simSharep_t(k,:) * simSharep_t_weighted'); % +(j==k)*simShare_t(i, :).*simShare_t(j, :)
        ds2dp2k = ds2dp2k + diag((simSharep_t(k, :)*simSharep_t_weighted')); % + (i==j)*simShare_t(k, :).*simShare_t(j, :)
        ds2dp2(:,:,k) = ds2dp2k;
    end

    ds2dp2 = -ds2dp2+2*reshape(Esjsisk(recover_ind_ijk2), [n_prod_t n_prod_t n_prod_t]);

    %% compute dpdw
    D0 = nan(n_prod_t, n_prod_t);
    if (isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && t <= 25) % before the exclusive contract b/w Apple and AT&T ended in Jan 2011
        for i = 1 : n_prod_t
            Jct = find(carrier_t(i,:)); % find the models of the same carrier as i
            if Jct == att && apple_t(i)
                Jct = carrier_t(:,Jct) & apple_t;
            elseif Jct == att && ~apple_t(i)
                Jct = carrier_t(:,Jct) & ~apple_t;
            else
                Jct = carrier_t(:,Jct);
            end
            tmp = squeeze(ds2dp2(Jct, i, :));
            D0(i,:) = -negativemarkup_carrier_t(Jct)'*tmp;
            D0(i,Jct) = D0(i,Jct) + dsdp(Jct, i)';
        end
    else
        for i = 1 : n_prod_t
            Jct = carrier_t(i,:); % find the models of the same carrier as i
            Jct = carrier_t(:,Jct);
            tmp = squeeze(ds2dp2(Jct, i, :));
            D0(i,:) = -negativemarkup_carrier_t(Jct)'*tmp;
            D0(i,Jct) = D0(i,Jct) + dsdp(Jct, i)';
        end
    end
    D0 = D0 + dsdp;

    same_carrier = false(n_prod_t, n_prod_t);

    if (isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && t <= 25) % before the exclusive contract b/w Apple and AT&T ended in Jan 2011
        for nc = 1 : n_carrier
            if nc == att
                Jct1 = carrier_t(:, nc) & apple_t;
                same_carrier(Jct1, Jct1) = true;
                Jct2 = carrier_t(:, nc) & ~apple_t;
                same_carrier(Jct2, Jct2) = true;
            else
                Jct = carrier_t(:, nc);
                same_carrier(Jct, Jct) = true;
            end
        end

    else
        for nc = 1 : n_carrier
            Jct = carrier_t(:, nc);
            same_carrier(Jct, Jct) = true;
        end            
    end

    dpdw = D0\(dsdp'.*same_carrier); % (k,h)-element = dp_kdw_h
    dsdw = dsdp*dpdw; % (j,i)-element = ds_jdw_i

    % recover the marginal cost of the phone maker
    if isequal(setup.pricing_model, 'sequential') || (isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && t > 25)
        markup_t = nan(n_prod_t, 1);
        for no = 1 : n_oem
            Jmt = oem_t(:, no);
            if any(Jmt)
                markup_t(Jmt, :) = - inv(dsdw(Jmt, Jmt)')*share_t(Jmt);
            end
        end

    elseif (isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && t <= 25)
        markup_t = nan(n_prod_t, 1);
        for no = 1 : n_oem
            Jmt = oem_t(:, no);
            if Jmt == apple_t
                markup_t(Jmt, :) = 0;
            else
                if any(Jmt & apple_t); error('either no is Apple or not'); end;
                if any(Jmt)
                    markup_t(Jmt, :) = - inv(dsdw(Jmt, Jmt)')*share_t(Jmt, :);
                end
            end
        end

    else
        error('undefined pricing model')
    end

else
    error('unknown pricing model');
end
    