function [p, w, share_t, mc_handset, carrier_profit, oem_variableprofit, ...
    simShare_t, simSharep_t, simSharep_t_weighted, ...
    dsdp, ds2dp2, dpdw, D0] =...
    equi_pw0(p0, w0, exp_u_wo_price, mc_handset,...
    ind_endogenous, carrier_t, oem_t, sim_pcoeff, setup)
% purpose: compute the oem pricing eqm
    
n_prod_t = size(p0, 1);
n_carrier = size(carrier_t, 2);
n_oem = size(oem_t, 2);
p = p0;
w = w0;
prev_w = w;
count = 0;

ind = (1:n_prod_t)';
ind_ijk = [repmat(ind, [n_prod_t, 1]), kron(ind, ones(n_prod_t,1))];
ind_ijk = [repmat(ind_ijk, [n_prod_t, 1]), kron(ind, ones(n_prod_t.^2,1))];

ind_ijk = sort(ind_ijk, 2);
[unique_ind_ijk, ~, recover_ind_ijk] = unique(ind_ijk, 'rows');  
unique_ind_ijk_12 = sort(unique_ind_ijk(:,1:2), 2);
[unique_ind_ijk_12, ~, recover_ind_ijk_12] = unique(unique_ind_ijk_12, 'rows');
unique_ind_ijk_3 = unique_ind_ijk(:,3); 
clear unique_ind_ijk;

new_prod_ind_p = true(n_prod_t, 1);% indice of products for which we compute the retail price. we do so for all product

diff_max = 1;
while diff_max > 1e-6
    if setup.use_w0 && count >= 1 % use w from the data
        break;
    end
    
    prev_w = w;  % save last round's w
    
    % eqm retail price and dsdp
    if (isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && setup.t <= 25) % before the exclusive contract b/w Apple and AT&T ended in Jan 2011
        apple_t = setup.apple;
        att = find(any(carrier_t(apple_t,:), 1));
        if length(att)~=1; error('iphones should be sold on one and only one carrier before Jan 2011'); end;

        carrier_t_altered = carrier_t;
        carrier_t_altered(:, att) = carrier_t(:, att) & apple_t;
        carrier_t_altered = [carrier_t_altered, carrier_t(:, att) & ~apple_t];

        [p, share_t, simShare_t, simSharep_t, simSharep_t_weighted, ...
            dsdp] = equi_p0(p, w, exp_u_wo_price,... % use last p as starting point for price in computing eqm price
            new_prod_ind_p, carrier_t_altered, sim_pcoeff, setup);
    else
        [p, share_t, simShare_t, simSharep_t, simSharep_t_weighted, ...
            dsdp] = equi_p0(p, w, exp_u_wo_price,... % use last p as starting point for price in computing eqm price
            new_prod_ind_p, carrier_t, sim_pcoeff, setup);
    end
    
    Esjsisk = simSharep_t_weighted(unique_ind_ijk_12(:, 1), :).*simSharep_t(unique_ind_ijk_12(:, 2), :);
    Esjsisk = Esjsisk(recover_ind_ijk_12,:) .* simShare_t(unique_ind_ijk_3, :);
    Esjsisk = sum(Esjsisk, 2);

    ds2dp2 = nan(n_prod_t, n_prod_t, n_prod_t);
    for k = 1 : n_prod_t
        ds2dp2k = zeros(n_prod_t, n_prod_t);
        ds2dp2k(k,k) = -sum(sim_pcoeff.*simSharep_t_weighted(k,:),2); % -(i==j)*(j==k)*simShare_t(j, :)
        ds2dp2k(:,k) = ds2dp2k(:,k) + (simSharep_t_weighted * simSharep_t(k,:)'); % +(i==k)*simShare_t(i, :).*simShare_t(j, :)
        ds2dp2k(k,:) = ds2dp2k(k,:) + (simSharep_t(k,:) * simSharep_t_weighted'); % +(j==k)*simShare_t(i, :).*simShare_t(j, :)
        ds2dp2k = ds2dp2k + diag((simSharep_t(k, :)*simSharep_t_weighted')); % + (i==j)*simShare_t(k, :).*simShare_t(j, :)
        ds2dp2(:,:,k) = ds2dp2k;
    end    

    ds2dp2 = -ds2dp2+2*reshape(Esjsisk(recover_ind_ijk), [n_prod_t n_prod_t n_prod_t]);    
            
    D0 = nan(n_prod_t, n_prod_t); 
    for i = 1 : n_prod_t
        if (isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && setup.t <= 25)
            Jct = find(carrier_t(i,:)); % find the models of the same carrier as i
            if Jct == att
                Jct = carrier_t(:,Jct) & ~apple_t;
            else
                Jct = carrier_t(:,Jct);
            end
            tmp = squeeze(ds2dp2(Jct, i, :));
            D0(i,:) = (p(Jct)-w(Jct))'*tmp;
            D0(i,Jct) = D0(i,Jct) + dsdp(Jct, i)';
        else
            Jct = carrier_t(i,:); % find the models of the same carrier as i
            Jct = carrier_t(:,Jct);
            tmp = squeeze(ds2dp2(Jct, i, :));
            D0(i,:) = (p(Jct)-w(Jct))'*tmp;
            D0(i,Jct) = D0(i,Jct) + dsdp(Jct, i)';
        end
    end
    D0 = D0 + dsdp;

    same_carrier = false(n_prod_t, n_prod_t);
    for nc = 1 : n_carrier
        Jct = carrier_t(:, nc);
        same_carrier(Jct, Jct) = true;
    end
    
    
    % dsdw
    if (isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && setup.t <= 25) % before the exclusive contract b/w Apple and AT&T ended in Jan 2011
        dsdw = nan(n_prod_t, n_prod_t);
        dpdw = D0(~apple_t, ~apple_t) \ (dsdp(~apple_t,~apple_t)' .* same_carrier(~apple_t, ~apple_t));
        dsdw(~apple_t,~apple_t) = dsdp(~apple_t, ~apple_t) * dpdw;
    else
        dpdw = D0\(dsdp'.*same_carrier); % (k,h)-element = dp_kdw_h
        dsdw = dsdp*dpdw; % (i,j)-element = ds_jdw_i
    end
    
    
    % update w according to the FOC
    for no = 1 : n_oem
        Jmt = oem_t(:, no);
        
        if isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && setup.t <= 25 && Jmt == apple_t
            continue % no need to update w for apple
        elseif isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract') && setup.t <= 25 && any(Jmt & apple_t);
            error('either no is Apple or not'); 
        else
            Jmt_endo = oem_t(:, no) & ind_endogenous;
            Jmt_exog = oem_t(:, no) & ~ind_endogenous;

            
            if any(Jmt_endo) && ~any(Jmt_exog)
                w(Jmt_endo) = mc_handset(Jmt_endo)-(dsdw(Jmt_endo, Jmt_endo)')\share_t(Jmt_endo);
            elseif any(Jmt_endo) && any(Jmt_exog)
                w(Jmt_endo) = mc_handset(Jmt_endo)-(dsdw(Jmt_endo, Jmt_endo)')\(share_t(Jmt_endo) + dsdw(Jmt_exog, Jmt_endo)'*(w(Jmt_exog) - mc_handset(Jmt_exog)));
            end
            
        end
    end
    count = count+1;
    diff_max = max(abs(w-prev_w));
    
    w = 0.7*w + 0.3*prev_w;
end

w = prev_w;

if nargout > 3
    carrier_profit = zeros(n_carrier, 1);
    oem_variableprofit = zeros(n_oem, 1);

    tmp = share_t.*(p-w);
    for nc = 1 : n_carrier
        if any(carrier_t(:,nc))
            carrier_profit(nc) = sum(tmp(carrier_t(:, nc)));
        end
    end

    tmp = share_t.*(w-mc_handset);
    for no = 1 : n_oem    
        if any(oem_t(:,no))
            oem_variableprofit(no) = sum(tmp(oem_t(:, no)));
        end
    end
end
