function [oem_profit, carrier_ind_l, oem_ind_l, q0, p, w, share,...
    cons_surplus, cons_surplus_no_error, expmu, carrier_profit, p_sim, ...
    w_sim, share_sim, prod_profit_binary, prod_profit_full] = ... 
    equi_ind(config_binary, binary_prod, config_full, full_prod, fixed_prod, ...
    setup, n_top_gap, n_carrier, n_draws, x_rand, ...
    sim_pcoeff, sim_qcoeff, sim_rand, ...
    mc_param_q)
% PURPOSE: compute pricing equilibrium and profit

n_oem = length(binary_prod);
n_prod_binary = 0;

for no = 1 : n_oem
    n_binary = length(config_binary{no});
    for nb = 1 : n_binary
        n_prod_binary = n_prod_binary + ...
            config_binary{no}(nb)*length(binary_prod{no}{nb}.q0);
    end
    
    n_prod_binary = n_prod_binary + sum(config_full{no}>0);

end

q0 = nan(n_prod_binary, 1);
w0 = nan(n_prod_binary, 1);
p0 = nan(n_prod_binary, 1);

meanutility_l = nan(n_prod_binary, n_draws);
mc_mean_l = nan(n_prod_binary, n_draws);

oem_ind_l = nan(n_prod_binary, n_oem);
carrier_ind_l = nan(n_prod_binary, n_carrier);

model_id_l = nan(n_prod_binary, 1);
carrier_id_l = nan(n_prod_binary, 1);
oem_id_l = nan(n_prod_binary, 1);

if ~isempty(x_rand)
    x_rand_l = nan(n_prod_binary, size(x_rand, 2));
else
    x_rand_l = [];
end

brandeffect_l = nan(n_prod_binary, 1);

prod_profit_ind_binary = cell(n_oem, 1);
prod_profit_ind_full = cell(n_oem, 1);


k = 0;
for no = 1 : n_oem
    n_binary = length(config_binary{no});
    ppib_no = cell(n_binary, 1);
    for nb = 1 : n_binary
        if config_binary{no}(nb)==1
            new_prod = binary_prod{no}{nb};
            ind = k+1:k+length(new_prod.q0);
            
            ppib_no{nb} = ind;
            q0(ind) = new_prod.q0;
            w0(ind) = new_prod.w0; 
            p0(ind) = new_prod.p0;
            
            oem_ind_l(ind, :) = new_prod.oem;
            carrier_ind_l(ind, :) = new_prod.carrier;
                        
            
            meanutility_l(ind, :) = new_prod.mean_u;
            mc_mean_l(ind, :) = new_prod.mean_mc;
            model_id_l(ind,:) = new_prod.model_id;
            carrier_id_l(ind,:) = new_prod.carrier_id;
            oem_id_l(ind,:) = new_prod.oem_id;
            
            if ~isempty(x_rand)
                x_rand_l(ind,:) = new_prod.x_rand;
            end
            
            brandeffect_l(ind) = new_prod.brandeffect;
            
            k = ind(end);
        end
    end
    
    prod_profit_ind_binary{no} = ppib_no; 
    
    ppif_no = cell(n_top_gap, 1);
    if ~isempty(config_full{no})
        for ntg = 1 : n_top_gap
            if config_full{no}(ntg)>0
                new_prod = full_prod{no}{config_full{no}(ntg), ntg};
                ind = k+1:k+length(new_prod.q0);
                
                ppif_no{ntg} = ind;
                q0(ind) = new_prod.q0;
                w0(ind) = new_prod.w0;
                p0(ind) = new_prod.p0;
                
                oem_ind_l(ind, :) = new_prod.oem;
                carrier_ind_l(ind, :) = new_prod.carrier;
                
                
                meanutility_l(ind, :) = new_prod.mean_u;
                mc_mean_l(ind, :) = new_prod.mean_mc;
                model_id_l(ind,:) = new_prod.model_id;
                carrier_id_l(ind,:) = new_prod.carrier_id;
                oem_id_l(ind,:) = new_prod.oem_id;
                
                if ~isempty(x_rand)
                    x_rand_l(ind,:) = new_prod.x_rand;
                end
                
                brandeffect_l(ind) = new_prod.brandeffect;
                
                k = ind(end);
            end
        end
        prod_profit_ind_full{no} = ppif_no;
    end        
end


% the set of products that are fixed. data are already organized at the product level
if ~isempty(fixed_prod) && ~isempty(fixed_prod.q)
    w0 = [w0; fixed_prod.w];
    p0 = [p0; fixed_prod.p];
    q0 = [q0; fixed_prod.q];
    carrier_ind_l = [carrier_ind_l; fixed_prod.carrier];
    oem_ind_l = [oem_ind_l; fixed_prod.oem];
    meanutility_l = [meanutility_l; fixed_prod.mean_demand];
    mc_mean_l = [mc_mean_l; fixed_prod.mean_mc];
    model_id_l = [model_id_l; fixed_prod.model_id];
    carrier_id_l = [carrier_id_l; fixed_prod.carrier_id];
    oem_id_l = [oem_id_l; fixed_prod.oem_id];
    
    x_rand_l = [x_rand_l; fixed_prod.x_rand];
    brandeffect_l = [brandeffect_l; fixed_prod.brandeffect];
end

n_prod_l = size(q0, 1);
setup.brandeffect = brandeffect_l;

% compute profits
if n_prod_l>0
    
    ind_endo_l = true(n_prod_l, 1);
    
    setup.new_nonflagship = true(n_prod_l, 1); % irrelevant
    
    n_draws = size(mc_mean_l, 2);
    p_sim = nan(n_prod_l, n_draws);
    w_sim = nan(n_prod_l, n_draws);
    share_sim = nan(n_prod_l, n_draws);
    carrier_profit_sim = nan(n_carrier, n_draws);
    oem_profit_sim = nan(n_oem, n_draws);
    cons_surplus_sim = nan(n_draws, 1);
    cons_surplus_no_error_sim = nan(n_draws, 1);
    expmu_sim = cell(n_draws, 1);
    
    oem_ind_l0 = oem_ind_l;
    if setup.merge
        ind_merged_prod = any(oem_ind_l(:, setup.merge_id(2:end)), 2);
        oem_ind_l(ind_merged_prod, setup.merge_id(1)) = true;
        oem_ind_l(ind_merged_prod, setup.merge_id(2:end)) = false;
    end
    
    prod_profit_vec_ns = nan(size(p0, 1), n_draws);
    parfor ns = 1 : n_draws
        [p_sim(:, ns), w_sim(:, ns), ~, share_sim(:, ns), ...
            carrier_profit_sim(:, ns), oem_profit_sim(:, ns), ...
            cons_surplus_sim(ns), cons_surplus_no_error_sim(ns), ...
            expmu_sim{ns}, prod_profit_vec_ns(:, ns)] = equi_pwq(p0, w0, q0, ...
            meanutility_l(:, ns), ind_endo_l, carrier_ind_l==1, oem_ind_l==1, ...
            x_rand_l, sim_pcoeff, sim_qcoeff, sim_rand,...
            mc_param_q, mc_mean_l(:, ns), setup);
    end

    
    oem_ind_l = oem_ind_l0;
    p = mean(p_sim, 2);
    w = mean(w_sim, 2);
    share = mean(share_sim, 2);
    carrier_profit = mean(carrier_profit_sim, 2);
    oem_profit = mean(oem_profit_sim, 2);
    cons_surplus = mean(cons_surplus_sim);
    cons_surplus_no_error = mean(cons_surplus_no_error_sim);
    expmu = expmu_sim;
    prod_profit_vec = mean(prod_profit_vec_ns, 2);
    
    % transform prod_profit_vec into configuration format
    prod_profit_binary = cell(n_oem, 1);
    prod_profit_full = cell(n_oem, 1);
    
    for no = 1 : n_oem
        n_binary = length(config_binary{no});
        ppb_no = nan(n_binary, 1);
        for nb = 1 : n_binary
            if config_binary{no}(nb)==1
                ppb_no(nb) = sum(prod_profit_vec(prod_profit_ind_binary{no}{nb}));
            end
        end
        prod_profit_binary{no} = ppb_no;
        
        
        ppf_no = nan(n_top_gap, 1);
        
        if ~isempty(config_full{no})
            for ntg = 1 : n_top_gap
                if config_full{no}(ntg)>0
                    ppf_no(ntg) = sum(prod_profit_vec(prod_profit_ind_full{no}{ntg}));
                end
            end
            prod_profit_full{no} = ppf_no;
        end
    end
else
    oem_profit = zeros(n_oem, 1);
end

if any(isnan(carrier_profit)) || any(isnan(oem_profit)) || any(isnan(cons_surplus))
    save('ws_nan.mat');
    error('nan in profit or consumer surplus');
end