clear; clear global; rng(12, 'twister')
%% purpose: MC estimation

load('part1_demand_est')

% compute markup and mc
setup.no_transformation_of_para = false;
setup.invertcost = true;

[~, ~, ~, ~, ~, mc_oem, mkup_oem,...
    sim_pcoeff, sim_qcoeff, mkup_carrier, demand_resid, ~, sim_rand]...
    = gmmobj_BLP_smartphone(para_nonlinear_est, ...
    share, x_rand, x_det, ind_mkt_start,ind_mkt_end, ...
    randomdraw, IV_demand, W, setup,  n_oem, n_carrier, n_mkt, ...
    carrier_ind, oem_ind, meanutility00, para_linear_est);

w = setup.price - mkup_carrier;

% mc stimation
[para_sigma, para_quality_coeff] = ...
    paravec2para_smartphone(para_nonlinear_est, setup, x_rand);

quality_index = x_det(:, dim_quality_in_x_det)*[1; para_quality_coeff];
dim_brand_in_linear_para = 1+(1:size(brandtime_dummies,2));    
brandeffect = brandtime_dummies*para_linear_est(dim_brand_in_linear_para)/para_linear_est(1);
quality_index_includingbrand = quality_index + brandeffect;

mcX = eval(['[' setup.Var_inMC ']']); 

tmp = exp(quality_index/setup.q_scale_in_cost);
tmpind = age_in_quarter == 0 & ~(lyear<=2007 | (lyear==2008 & lmonth <= 8)); 
tmp(tmpind) = 0;
mcIV = [ones(n_obs,1) tmp mcX];

mcX = [ones(n_obs, 1) exp(quality_index/setup.q_scale_in_cost) mcX];
dep_mc = mc_oem;

inv_mcIV = inv(mcIV'*mcIV);
pz = mcIV * inv_mcIV * mcIV';

mc_param = (mcX' * pz * mcX) \ (mcX' * pz * dep_mc);
mc_resid_shock = dep_mc - mcX*mc_param;

tmp = repmat(mc_resid_shock, [1, size(mcIV,2)]) .* mcIV;
tmp = (tmp' * tmp / length(dep_mc));
tmp2 = inv(mcX' * pz * mcX);
tmp = tmp2 * (mcX' * mcIV * inv_mcIV * tmp * inv_mcIV * mcIV' * mcX) * tmp2;
mc_param_hce_se = sqrt(diag(tmp));
mc_resid = mc_resid_shock;

% estimate the distribution of the shock
std_mc_shock = sqrt(mean(mc_resid_shock.^2)); % estimate of the std of the mc shock
std_mc_shock_se = sqrt(sqrt(mean((mc_resid_shock.^2-std_mc_shock^2).^2)))/sqrt(2); % its s.e.

save('part2_demand_mc_est');

