% PURPOSE: obtain bounds on the fixed cost for all products
clear; if ispc; dbstop if error; end;

load('part2_demand_mc_est')

Mkt_CF = 'n_mkt';
only_addproduct = false; % = true: run the code only to get the lower bound of the added products (for counterfatual simulations)

include_flagship = false; % whether getting the bounds for flagship products

add_potential_prod = true;
n_top_gap = 2;
gap_option = 'nonflagship'; % 'all', 'nonflagship'
gap_option2 = 'variable'; 

add_flag = 0; 
% 1: add the hypothetical products (not the dropped ones) as flagship products; 
% 0: add the hypothetical products as non-flagships

setup.counterfactual = '';

%% (1) preparation
setup.solve_q = 'fsolve';
setup.n_start_quality = 1;
setup.testcode = false;
if isequal(setup.pricing_model, 'sequential') || isequal(setup.pricing_model, 'apple_att_collusion_during_exclusivecontract')
    setup.mode = 1;
elseif isequal(setup.pricing_model, 'direct_oem') || isequal(setup.pricing_model, 'direct_carrier') || isequal(setup.pricing_model, 'oem_carrier_collusion')        
    setup.mode = 2;
end
setup.use_w0 = false;
setup.use_p0 = false;
setup.use_q0 = true;

% define meanutility (part of the meanutlity that is indp of quality or price)
ind_nonquality = setdiff((1:size(x_det,2)), setup.dim_quality_in_x_det);
ind_price = size(x_det,2) - 1;
ind_not_q_or_p = ind_nonquality;
ind_not_q_or_p(ind_nonquality == ind_price) = [];

para_linear_est_not_q_or_p = para_linear_est;
para_linear_est_not_q_or_p(1) = []; % delete quality coeff
para_linear_est_not_q_or_p(end-1) = []; %delete price coeff

meanutility = x_det(:, ind_not_q_or_p) * para_linear_est_not_q_or_p;

mc_param_q = mc_param(2); 
mean_mc = mc_param(1) + mcX(:,3:end)*mc_param(3:end);

dim_demand_brandtime = 2:4;  % brand dummies
dim_demand_flagship = 5;   % flagship dummy
dim_demand_carriertime = 6:24; % carrier year
dim_demand_time = 25:27;   % quarter
dim_demand_const = 29;

key_oem_list = {'Apple', 'Samsung', 'BlackBerry'};
key_oem_ind = nan(1, 3);
all_oem_list = cell(1, size(oem_ind, 2));
for no = 1 : size(oem_ind, 2)
    all_oem_list(no) = unique(oem(oem_ind(:, no)));
end

for no = 1 : 3
    key_oem_ind(no) = find(ismember(all_oem_list, key_oem_list(no)));
end
        
dim_mc_carriertime = 3:21;
dim_mc_brand = 22:24;        

dim_mc_const = 1;
    

new_prod_list = cell(n_mkt, size(oem_ind, 2));
old_prod_list = cell(n_mkt, size(oem_ind, 2));
new_dropped_prod_list = cell(n_mkt, size(oem_ind, 2));
new_potential_prod_list = cell(n_mkt, size(oem_ind, 2));

mkt_for_cf = eval(Mkt_CF);

new_model_id = 1000 + max(model_id) + reshape((1 : n_top_gap*size(oem_ind, 2)), [size(oem_ind, 2), n_top_gap]);
new_product_id = 1000 + max(product_id) + reshape((1 :...
    n_top_gap*size(oem_ind, 2)*n_carrier), [size(oem_ind, 2), n_top_gap, n_carrier]);

for t = mkt_for_cf
    ind_t = ind_mkt_start(t):ind_mkt_end(t);
    isflagship_t = isflagship(ind_t);
    
    if isequal(gap_option, 'all')
        ind_gap = true(size(isflagship_t));
    elseif isequal(gap_option, 'nonflagship')
        ind_gap = ~isflagship_t;
    end
        
    nonflag_q = sort(quality_index_includingbrand(ind_t(ind_gap)));
    nonflag_w = sort(w(ind_t(ind_gap)));
    nonflag_p = sort(price(ind_t(ind_gap)));
    nonflag_q_diff = diff(nonflag_q);
    disp([nonflag_q, [nonflag_q_diff; nan]]); disp(sort(nonflag_q_diff));
    [~, diff_ind] = sort(nonflag_q_diff, 'descend');
    tmp = unique(nonflag_q);

    if t==51 && isequal(gap_option, 'nonflagship')
        if isequal(gap_option2, 'fixed')
            diff_ind(nonflag_q(diff_ind)< tmp(3)) = [];   % exclude the gaps in the low-quality range
            diff_ind(nonflag_q(diff_ind)> tmp(end-5)) = [];   % exclude the gaps in the high-quality range
        elseif isequal(gap_option2, 'variable')
            diff_ind(nonflag_q(diff_ind)<4.5) = [];       
        end
    elseif t==51 && isequal(gap_option, 'all')
        diff_ind(nonflag_q(diff_ind)< tmp(3)) = [];   % exclude the gaps in the low-quality range
        diff_ind(nonflag_q(diff_ind)> tmp(end-15)) = [];   % exclude the gaps in the high-quality range
    end

    new_prod_quality_t = nan(n_top_gap, 1);
    w_quantile_t = nan(n_top_gap, 1);
    p_quantile_t = nan(n_top_gap, 1);
    for ng = 1 : n_top_gap
        new_prod_quality_t(ng) = median(nonflag_q(diff_ind(ng):diff_ind(ng)+1));
        w_quantile_t(ng) = median(nonflag_w(diff_ind(ng):diff_ind(ng)+1));
        p_quantile_t(ng) = median(nonflag_p(diff_ind(ng):diff_ind(ng)+1));
    end

    disp(new_prod_quality_t);

    
    if t>1; ind_tminus1 = ind_mkt_start(t-1):ind_mkt_end(t-1); end;
    for no = 1 : size(oem_ind, 2)
        if t == 1
            ind_dropped = [];
        else
            if include_flagship
                ind_dropped = ~ismember(product_id(ind_tminus1), product_id(ind_t));
                ind_dropped = ind_dropped & oem_ind(ind_tminus1,no);
                ind_dropped = ind_tminus1(ind_dropped);
                
            else
                ind_dropped = ~ismember(product_id(ind_tminus1), product_id(ind_t));
                ind_dropped = ind_dropped & ~isflagship(ind_tminus1) & oem_ind(ind_tminus1,no);
                ind_dropped = ind_tminus1(ind_dropped);
            end
        end
        
        if add_potential_prod
            new_prod = cell(length(ind_dropped)+...
                n_top_gap*size(carrier_ind, 2), 1);
            new_dropped_prod = cell(length(ind_dropped), 1);
            new_potential_prod = cell(size(carrier_ind, 2), n_top_gap);
        else
            new_prod = cell(length(ind_dropped), 1);
            new_dropped_prod = [];
            new_potential_prod = [];
        end
        
        for jj = 1:length(ind_dropped)
            j = ind_dropped(jj);
            new_prod_j.apple = apple(j);
            new_prod_j.brandeffect = brandeffect(j);
            new_prod_j.p0 = price(j);
            new_prod_j.w0 = w(j);
            new_prod_j.q0 = quality_index(j);
            new_prod_j.oem = oem_ind(j,:);
            new_prod_j.carrier = carrier_ind(j,:);
            new_prod_j.carrier_id = carrier_id(j);
            new_prod_j.oem_id = oem_id(j);
            new_prod_j.model_id = model_id(j);
            new_prod_j.prod_id = product_id(j);
            
            new_prod_j.x_rand = [];
            
            [new_demand, new_mc] = gen_mean(t, no, find(carrier_ind(j,:)), ...
                0, para_linear_est, mc_param, dim_demand_brandtime, ...
                dim_demand_flagship, dim_demand_carriertime, dim_demand_const, ...
                dim_demand_time, dim_mc_carriertime, dim_mc_brand, dim_mc_const, ...
                key_oem_ind);
            

            new_prod_j.mean_u = new_demand;
            new_prod_j.mean_mc = new_mc;
            
            new_prod{jj} = new_prod_j;
            if add_potential_prod
                new_dropped_prod{jj} = new_prod_j;
            end
        end
        
        if add_potential_prod
            for j1 = 1 : n_top_gap
                for j2 = 1 : size(carrier_ind, 2)
                    if no~=2
                        new_prod_j.apple = false;
                    else
                        new_prod_j.apple = true;
                    end
                    if ismember(no, key_oem_ind)
                        new_prod_j.brandeffect = para_linear_est(dim_demand_brandtime(ismember(key_oem_ind, no)))/para_linear_est(1);                        
                    else
                        new_prod_j.brandeffect = 0;
                    end


                    new_prod_j.p0 = p_quantile_t(j1);
                    new_prod_j.w0 = w_quantile_t(j1);

                    oem0_m = false(1, size(oem_ind, 2));
                    oem0_m(no) = true;
                    carrier0_m = false(1, size(carrier_ind, 2));
                    carrier0_m(j2) = true;
                    new_prod_j.oem = oem0_m;
                    new_prod_j.carrier = carrier0_m;
                    new_prod_j.carrier_id = unique(carrier_id(carrier_ind(:, carrier0_m)));
                    new_prod_j.oem_id = unique(oem_id(oem_ind(:, oem0_m)));
                    new_prod_j.model_id = new_model_id(no, j1);
                    new_prod_j.prod_id = new_product_id(no, j1, j2);

                    if isequal(gap_option2, 'variable')
                        oem_t = oem_ind(ind_t,no);
                        qt = quality_index_includingbrand(ind_t);
                        max_oem_q = max(qt(oem_t));
                        if isempty(max_oem_q) || max_oem_q<new_prod_quality_t(j1)
                            new_prod_j.q0 = nan;
                        else
                            new_prod_j.q0 = new_prod_quality_t(j1)-new_prod_j.brandeffect;
                        end

                    else
                        new_prod_j.q0 = new_prod_quality_t(j1)-new_prod_j.brandeffect;
                    end

                    new_prod_j.x_rand = [];
                    
                    [new_demand, new_mc] = gen_mean(t, no, j2, ...
                        add_flag, para_linear_est, mc_param, dim_demand_brandtime, ...
                        dim_demand_flagship, dim_demand_carriertime, dim_demand_const, ...
                        dim_demand_time, dim_mc_carriertime, dim_mc_brand, dim_mc_const, ...
                        key_oem_ind);

                   
                    new_prod_j.mean_u = new_demand;
                    new_prod_j.mean_mc = new_mc;

                    new_prod{length(ind_dropped)+...
                        (j1-1)*size(carrier_ind, 2)+j2} = new_prod_j;

                    if add_potential_prod
                        new_potential_prod{j2, j1} = new_prod_j;
                    end

                end
            end
        end
            
        new_prod_list{t, no} = new_prod;
        new_dropped_prod_list{t, no} = new_dropped_prod;
        new_potential_prod_list{t, no} = new_potential_prod;
    end
    
end

%% (2) draw shocksmln_demand, shocksmln_mc and shocksmln_fc
n_prod_per_mkt = ind_mkt_end-ind_mkt_start+1;
tmp = max(n_prod_per_mkt) + 1; % NOTE: + 1 b/c in a counterfactual alternative, we will add a product

shocksmln_demand = rand(tmp, n_draws);% uniform draws
tmptmp = sort(demand_resid); % compute empirical cdf
emp_cdf = (1:length(tmptmp))'./length(tmptmp);
shocksmln_demand = interp1(emp_cdf,tmptmp,shocksmln_demand,'linear','extrap'); % inverse of empirical cdf

shocksmln_mc = rand(tmp, n_draws);
tmptmp = sort(mc_resid_shock);
emp_cdf = (1:length(tmptmp))'./length(tmptmp);
shocksmln_mc = interp1(emp_cdf,tmptmp,shocksmln_mc,'linear','extrap'); % inverse of empirical cdf

%% (3) compute changes in oem profit due to dropping or keeping a product
oem_varprofit = nan(n_mkt, n_oem); % oem profit in the data
fc_upperbound = cell(n_mkt, n_oem);
fc_lowerbound = cell(n_mkt, n_oem);
fc_lowerbound_add_dropped = cell(n_mkt, n_oem);
fc_lowerbound_add_potential = cell(n_mkt, n_oem);
prod_id_drop = cell(n_mkt, n_oem);
model_id_drop = cell(n_mkt, n_oem);
prod_id_add = cell(n_mkt, n_oem);
prod_id_add_dropped = cell(n_mkt, n_oem);
prod_id_add_potential = cell(n_mkt, n_oem);

fc_lb_m_c = cell(n_mkt, size(oem_ind, 2), n_top_gap, n_carrier);
prod_id_lb_m_c = cell(n_mkt, size(oem_ind, 2), n_top_gap, n_carrier);
model_id_lb_m_c = cell(n_mkt, size(oem_ind, 2), n_top_gap, n_carrier);

fcl_mkt1 = cell(max(mkt_for_cf), n_oem);
fcl_mkt2 = cell(max(mkt_for_cf), n_oem);
fcu_mkt = cell(max(mkt_for_cf), n_oem);
fc_dq_mkt = cell(max(mkt_for_cf), n_oem);
n_prod_mkt = nan(max(mkt_for_cf), n_oem);

for t = mkt_for_cf
    fprintf(pfid, 't = %1.0f\n', t);
    
    ind_t = ind_mkt_start(t):ind_mkt_end(t);
    isflagship_t = isflagship(ind_t);
    if t>1; ind_tminus1 = ind_mkt_start(t-1):ind_mkt_end(t-1); end;
    
    setup_t = setup;
    setup_t.t = t;
    setup_t.q_frontier_includingbrand = max(quality_index_includingbrand(ind_t(isflagship(ind_t))));
    
    setup_t.brandeffect = brandeffect(ind_t);
    setup_t.apple = apple(ind_t);
    

    meanutility_t = repmat(meanutility(ind_t), [1,n_draws]) + shocksmln_demand(1:length(ind_t),:);
    mean_mc_t = repmat(mean_mc(ind_t),[1,n_draws]) + shocksmln_mc(1:length(ind_t),:);
  
    x_rand_t = [];
    
    %1) oem_varprofit in data
    p0_t = price(ind_t);
    w0_t = w(ind_t);
    q0_t = quality_index(ind_t);
    ind_endogenous_t = true(length(ind_t),1);
    carrier_t = carrier_ind(ind_t,:);
    oem_t = oem_ind(ind_t,:);
    prod_id_t = product_id(ind_t);
    model_id_t = model_id(ind_t);
    carrier_id_t = carrier_id(ind_t);
    oem_id_t = oem_id(ind_t);
    
    oem_varprofit_t = nan(n_oem, size(meanutility_t,2));
    carrier_profit_t = nan(n_carrier, size(meanutility_t,2));
    
    meanutility_t0 = meanutility_t;
    
    parfor ns = 1:size(meanutility_t,2)
        [p_test,w_test,q_test, ~, carrier_profit_t(:,ns), oem_varprofit_t(:,ns)] = ...
            equi_pwq(p0_t, w0_t, q0_t, meanutility_t0(:,ns), ind_endogenous_t, carrier_t, oem_t, ...
            x_rand_t, sim_pcoeff, sim_qcoeff, sim_rand, ...
            mc_param_q, mean_mc_t(:,ns), setup_t);
    end
    
    oem_varprofit_t = mean(oem_varprofit_t,2);
    oem_varprofit(t,:) = oem_varprofit_t';
    
    carrier_profit_t = mean(carrier_profit_t, 2);
    
    %2) deviating profit from dropping or adding a product/model
    for no = 1:n_oem
        
        fprintf(1, 'smartphone firm: %1d\n', no);
        if any(oem_t(:,no)) % active
            if ~only_addproduct
                % drop a product/model
                if include_flagship
                    ind_now = find(oem_t(:,no));
                else
                    ind_now = find(oem_t(:,no) & ~isflagship_t);
                end
                prod_id_drop{t, no} = prod_id_t(ind_now);

                fc_upperbound_t_no = nan(length(unique(model_id_t(ind_now))), 1);
                
                model_id_drop{t, no} = unique(model_id_t(ind_now));

                product_set = model_id_drop{t, no};
                product_ind_no_t = model_id_t(ind_now);

                old_prod_list_no_t = cell(length(product_set),1);
                for jj = 1:length(product_set)
                    j = ind_now(product_set(jj)==product_ind_no_t);

                    setup_t_1less = setup_t;
                    prod_j.brandeffect = setup_t.brandeffect(j); setup_t_1less.brandeffect(j) = [];
                    prod_j.apple = setup_t.apple(j); setup_t_1less.apple(j) = [];
                    prod_j.p0 = p0_t(j); p0_t_1less = p0_t; p0_t_1less(j) = [];
                    prod_j.w0 = w0_t(j); w0_t_1less = w0_t; w0_t_1less(j) = [];
                    prod_j.q0 = q0_t(j); q0_t_1less = q0_t; q0_t_1less(j) = [];
                    prod_j.endo = ind_endogenous_t(j); ind_endogenous_t_1less = ind_endogenous_t; ind_endogenous_t_1less(j) = [];
                    prod_j.carrier = carrier_t(j, :); carrier_t_1less = carrier_t; carrier_t_1less(j,:) = [];
                    prod_j.oem = oem_t(j,:); oem_t_1less = oem_t; oem_t_1less(j,:) = [];
                    carrier_id_t_1less = carrier_id_t; carrier_id_t_1less(j,:) = [];
                    oem_id_t_1less = oem_id_t; oem_id_t_1less(j,:) = [];
                    meanutility_t_1less = meanutility_t; meanutility_t_1less(j,:) = [];
                    model_id_t_1less = model_id_t; model_id_t_1less(j, :) = [];

                    old_prod_list_no_t(jj) = {prod_j};

                    n_prod_t_1less = length(ind_t) - length(j);

                    mc_mean_t_1less = mean_mc_t; mc_mean_t_1less(j,:) = [];

                    x_rand_t_1less = [];
                    
                    if isequal(setup.pricing_model, 'direct_carrier')
                        carriers_involved = any(carrier_t(j,:), 1);
                        deviating_profit = nan(nnz(carriers_involved), size(meanutility_t,2));
                        parfor ns = 1:size(meanutility_t,2)
                            [p_t_1less, w_t_1less, q_t_1less, share_t_1less, tmpprofit] = ...
                                equi_pwq(p0_t_1less, w0_t_1less, q0_t_1less, meanutility_t_1less(:,ns), ind_endogenous_t_1less, carrier_t_1less, oem_t_1less, ...
                                x_rand_t_1less, sim_pcoeff, sim_qcoeff, sim_rand, ...
                                mc_param_q, mc_mean_t_1less(:,ns), setup_t_1less);

                            deviating_profit(:,ns) = tmpprofit(carriers_involved, 1);
                        end
                        fc_upperbound_t_no(jj) = sum(carrier_profit_t(carriers_involved)) - sum(mean(deviating_profit,2));
                    else
                        deviating_profit = nan(size(meanutility_t,2),1);
                        parfor ns = 1:size(meanutility_t,2)
                            [p_t_1less, w_t_1less, q_t_1less, share_t_1less, ~, tmpprofit] = ...
                                equi_pwq(p0_t_1less, w0_t_1less, q0_t_1less, meanutility_t_1less(:,ns), ind_endogenous_t_1less, carrier_t_1less, oem_t_1less, ...
                                x_rand_t_1less, sim_pcoeff, sim_qcoeff, sim_rand, ...
                                mc_param_q, mc_mean_t_1less(:,ns), setup_t_1less);

                            deviating_profit(ns) = tmpprofit(no);
                        end
                        fc_upperbound_t_no(jj) = oem_varprofit_t(no) - mean(deviating_profit);
                    end
                end

                old_prod_list{t, no} = old_prod_list_no_t;

                if any(nnz(fc_upperbound_t_no<=0));
                    fprintf(pfid, '(t=%1.0f,m=%1.0f) with %1.0f non-positive upper bounds of fc\n', t,no, nnz(fc_upperbound_t_no<=0));
                end
                fc_upperbound{t, no} = fc_upperbound_t_no;
            end

            if t == 1 && ~add_potential_prod; continue; end; % we canot identify which products are dropped and can be kept

            % add products: add one product back
            fc_lowerbound_t_no = nan(length(new_prod_list{t, no}),1);
            prod_id_add_t_no = nan(length(new_prod_list{t, no}),1);

            if add_potential_prod
                n_dropped = length(new_dropped_prod_list{t, no});
                n_potential = length(new_potential_prod_list{t, no}(:));
            end

            for jj = 1:length(new_prod_list{t, no});
                if ~isnan(new_prod_list{t, no}{jj}.q0)
                    setup_t_1more = setup_t;
                    setup_t_1more.brandeffect = [setup_t_1more.brandeffect; new_prod_list{t, no}{jj}.brandeffect];
                    setup_t_1more.apple = [setup_t_1more.apple; new_prod_list{t, no}{jj}.apple];
                    p0_t_1more = [p0_t; new_prod_list{t, no}{jj}.p0];
                    w0_t_1more = [w0_t; new_prod_list{t, no}{jj}.w0];
                    q0_t_1more = [q0_t; new_prod_list{t, no}{jj}.q0];
                    ind_endogenous_t_1more = [ind_endogenous_t; true];
                    oem_t_1more = [oem_t; new_prod_list{t, no}{jj}.oem];
                    carrier_t_1more = [carrier_t; new_prod_list{t, no}{jj}.carrier];
                    model_id_t_1more = [model_id_t; new_prod_list{t, no}{jj}.model_id];
                    carrier_id_t_1more = [carrier_id_t; new_prod_list{t, no}{jj}.carrier_id];
                    oem_id_t_1more = [oem_id_t; new_prod_list{t, no}{jj}.oem_id];

                    x_rand_t_1more = [x_rand_t; new_prod_list{t, no}{jj}.x_rand];

                    meanutility_t_1more = [meanutility_t; new_prod_list{t, no}{jj}.mean_u + shocksmln_demand(length(ind_t)+1,:)];
                    mc_mean_t_1more = [mean_mc_t; new_prod_list{t, no}{jj}.mean_mc + shocksmln_mc(length(ind_t)+1,:)];

                    n_prod_t_1more = length(p0_t_1more);



                    deviating_profit = nan(n_draws, 1);

                    if isequal(setup.pricing_model, 'direct_carrier')
                        parfor ns = 1:n_draws
                            [~, ~, ~, ~, tmpprofit] = ...
                                equi_pwq(p0_t_1more, w0_t_1more, q0_t_1more, meanutility_t_1more(:,ns), ind_endogenous_t_1more, carrier_t_1more, oem_t_1more, ...
                                x_rand_t_1more, sim_pcoeff, sim_qcoeff, sim_rand, mc_param_q, mc_mean_t_1more(:,ns), setup_t_1more);

                            deviating_profit(ns) = tmpprofit(new_prod_list{t, no}{jj}.carrier);
                        end
                    else
                        parfor ns = 1:n_draws
                            [~, ~, ~, ~, ~, tmpprofit] = ...
                                equi_pwq(p0_t_1more, w0_t_1more, q0_t_1more, meanutility_t_1more(:,ns), ind_endogenous_t_1more, carrier_t_1more, oem_t_1more, ...
                                x_rand_t_1more, sim_pcoeff, sim_qcoeff, sim_rand, mc_param_q, mc_mean_t_1more(:,ns), setup_t_1more);

                            deviating_profit(ns) = tmpprofit(no);
                        end
                    end
                    deviating_profit = mean(deviating_profit);


                    if isequal(setup.pricing_model, 'direct_carrier')
                        fc_lowerbound_t_no(jj) = deviating_profit - carrier_profit_t(new_prod_list{t, no}{jj}.carrier);
                    else
                        fc_lowerbound_t_no(jj) = deviating_profit - oem_varprofit_t(no);
                    end
                    prod_id_add_t_no(jj) = new_prod_list{t, no}{jj}.prod_id;
                end
            end

            if add_potential_prod
                n_dropped = length(new_dropped_prod_list{t, no});
                n_potential = length(new_potential_prod_list{t, no}(:));

                fc_lowerbound_add_dropped{t, no} = fc_lowerbound_t_no(1:n_dropped);
                fc_lowerbound_add_potential{t, no} = reshape(fc_lowerbound_t_no(n_dropped+1:...
                    n_dropped+n_potential), [size(carrier_ind, 2), n_top_gap]);

                prod_id_add_dropped{t, no} = prod_id_add_t_no(1:n_dropped);
                prod_id_add_potential{t, no} = reshape(prod_id_add_t_no(n_dropped+1:...
                    n_dropped+n_potential), [size(carrier_ind, 2), n_top_gap]);
            end

            if any(nnz(fc_lowerbound_t_no<=0));
                fprintf(pfid, '(t=%1.0f,m=%1.0f) with %1.0f non-positive lower bounds of fc\n', t,no, nnz(fc_lowerbound_t_no<=0));
            end
            fc_lowerbound{t, no} = fc_lowerbound_t_no;
            prod_id_add{t, no} = prod_id_add_t_no;
            
        end        
        
    end
end

save('part3_demand_mc_fc_est');
    


