clear; clear global; if ispc; dbstop if error; end; rng(15, 'twister');
tic;

load('part3_demand_mc_fc_est')

%% setup
testcode = false;

counterfactual0 = {'merge_2_firms_seq1'}; % define the counterfactual simulation

use_potential_prod = true; % whether we allow new potential products
adjust_type = 'nonflagship'; % nonflagship, dynamic_def, all
fixed_oem = [2];    % fix the products of oem oem_ind(:, fixed_oem); no dropping or adding

top_n_merge = 2;

brand_option.utility = 'average'; % 'pre-merger' or 'average'
brand_option.mc = 'pre-merger'; % 'pre-merger' or 'average'

starting_point_option = 'observed'; % 'full', 'null', 'observed'

mkt_for_cf = eval(Mkt_CF);       % which markets

fc_bounds_option = 'proportional deviation';    % 'proportional deviation', 'mean1', 'mean2', 'linear_in_quality'. See below for the meaning of each option

fc_upper_dev = 0.5; % must be between 0 and 1: (1-fc_upper_dev)*fc_upperbound to fc_upperbound
fc_lower_dev = 4; % must be positive: fc_lowerbound to (1+fc_lower_dev)*fc_lowerbound

filename_results_part3_51_mkts = 'part3_demand_mc_fc_est.mat';

pfid = 1;

%% get inputs for equi_pwq
isflagship00 = isflagship;

n_carrier = size(carrier_ind,2);
n_oem = size(oem_ind,2);
max_k = 1; % see prod_equi_swap.m

max_iter_count = 100;
setup.BR_method = 'one_product';
setup.testcode = testcode;


p0 = price;
q0 = quality_index;
w0 = price - mkup_carrier; 
b = 0;

%% preparation

setup.use_p0 = false;
setup.use_w0 = false;
setup.use_q0 = false;

% compute components of mc that are indp of price and quality and the shocks
mc_param_q = mc_param(2); 
mc_mean = mc_param(1) + mcX(:,3:end)*mc_param(3:end);

% draw shocksmln_demand, shocksmln_mc and shocksmln_fc
uniqueproductid = unique(product_id);
n_prod = length(uniqueproductid);

n_draws = size(shocksmln_demand, 2);
setup.n_draws = n_draws;


quality_index_includingbrand_model = quality_index_includingbrand;

uniquemodelid = unique(model_id);
for i = 1:length(uniquemodelid)
    ind = model_id == uniquemodelid(i);
    quality_index_includingbrand_model(ind) = mean(quality_index_includingbrand(ind));
end

% use the demand and cost shocks in part 3 estimation
shocks_demand_prod_equi = nan(n_prod+1, n_mkt, n_draws);
shocks_mc_prod_equi = nan(n_prod+1, n_mkt, n_draws);

for t = 1 : n_mkt
    ind_t = ind_mkt_start(t):ind_mkt_end(t);
    n_prod_t = length(ind_t);
    for nn = 1 : n_prod_t
        shocks_demand_prod_equi(product_id(ind_t(nn))==uniqueproductid, t, :) = shocksmln_demand(nn, :);
        shocks_mc_prod_equi(product_id(ind_t(nn))==uniqueproductid, t, :) = shocksmln_mc(nn, :);
    end
    
    % add a product
    shocks_demand_prod_equi(n_prod+1, t, :) = shocksmln_demand(length(ind_t)+1, :);
    shocks_mc_prod_equi(n_prod+1, t, :) = shocksmln_mc(length(ind_t)+1, :);
    
end

if any(ismember(counterfactual0,{'merge_2_firms_seq1','merge_2_firms_seq2',...
        'merge_2_firms_simultaneous', 'no_cannibalization', ...
        'no_cannibalization_simultaneous'})) && (isequal(fc_bounds_option, 'linear_in_quality') || isequal(fc_bounds_option, 'mean2'))
    [~, ~, b_lower, b_upper, fc_lb_est, fc_ub_est, bounds_distance]...
        = regression_and_plot_fc_bound_quality(filename_results_part3_51_mkts, jobid_results_part3_51_mkts, false);

end


ind_id = model_id;
ind_id_drop = model_id_drop;

if any(ismember(counterfactual0,{'merge_2_firms_seq1','merge_2_firms_seq2',...
        'merge_2_firms_simultaneous', 'no_cannibalization', ...
        'no_cannibalization_simultaneous'}))
    q_upper = cell(n_mkt, n_oem);
    q_lower = cell(n_mkt, n_oem);
    for t = mkt_for_cf
        q_model_t = quality_index_includingbrand_model(time==t);
        ind_id_t = ind_id(time==t);
        for no = 1 : size(oem_ind, 2)
            q_upper_t_no = nan(length(ind_id_drop{t, no}), 1);
            for j = 1 : length(ind_id_drop{t, no})
                q_upper_t_no(j) = unique(q_model_t(ind_id_t==ind_id_drop{t, no}(j)));
            end
            q_upper{t, no} = q_upper_t_no;
            
            q_lower_t_no = nan(length(new_prod_list{t, no}), 1);
            
            for j = 1 : length(q_lower_t_no)
                q_lower_t_no(j) = new_prod_list{t,no}{j}.q0 + ...
                    new_prod_list{t,no}{j}.brandeffect;
            end
            
            q_lower{t, no} = q_lower_t_no;
        end
    end
end

        
fc_draws = rand(n_prod, n_draws_fc, n_mkt, n_oem, 2);
fc_sim_inMkt = cell(n_mkt, n_oem); 
fc_sim_potential = cell(n_mkt, n_oem); 

id_fixed = cell(n_mkt, 1);
prod_ind_fixed = cell(n_mkt, 1);

for t = mkt_for_cf
    ind_t = ind_mkt_start(t):ind_mkt_end(t);
    ind_id_t = ind_id(ind_t);
    oem_ind_t = oem_ind(ind_t, :);
    
    n_prod_t = length(ind_t);
    if isequal(adjust_type, 'dynamic_def')
        if t == n_mkt
            ind_fixed_t = false(length(ind_t),1);
            ind = ismember(oem(ind_t), {'Apple'}) & ismember(model(ind_t), {'iPhone 5'}); % iPhone 4, iPhone 4s, iPhone 4 CDMA are not
            ind = ind | (ismember(oem(ind_t), {'BlackBerry'}) & ismember(model(ind_t), {'Z10'})); % Bold 9900 is not
            ind = ind | (ismember(oem(ind_t), {'HTC'}) &  ismember(model_clean(ind_t), {'OnexEvo4G'})); % both One X AT&T and EVO 4G LTE are
            ind = ind | (ismember(oem(ind_t), {'LG'}) & ismember(model_clean(ind_t), {'OptimusG'})); % both Optimus G AT&T and Optimus G Sprint are
            ind = ind | (ismember(oem(ind_t), {'Motorola'}) & ismember(model(ind_t), {'DROID RAZR M'})); % DROID RAZR is not
            ind = ind | (ismember(oem(ind_t), {'Nokia'}) & ismember(model(ind_t), {'Lumia 920'})); % Lumia 920 is
            ind = ind | (ismember(oem(ind_t), {'Samsung'}) & ismember(model(ind_t), {'GALAXY Note II'}));
            ind = ind | (ismember(oem(ind_t), {'Samsung'}) & ismember(model(ind_t), {'Galaxy S III'})); % Galaxy S II T-Mobile is not
            
            % fixed oem
            for no = 1 : length(fixed_oem)
                ind = ind | oem_ind_t(:, fixed_oem(no));
            end
            
            ind_fixed_t(ind) = true;
            id_fixed{t} = unique(ind_id_t(ind_fixed_t));
            prod_ind_fixed{t} = ind_fixed_t;
        else
            error('to be written for other markets');
        end
    elseif isequal(adjust_type, 'nonflagship')
        prod_ind_fixed{t} = isflagship(ind_t);
        id_fixed{t} = unique(ind_id_t(isflagship(ind_t)));
    elseif isequal(adjust_type, 'all')
        id_fixed{t} = [];
        prod_ind_fixed{t} = false(length(ind_t),1);
    end
    
    isflagship_t = isflagship(ind_t);
    oem_t = oem_ind(ind_t,:);
    model_id_t = model_id(ind_t, :);
    product_id_t = product_id(ind_t, :);
    
    n_model_cell_up_t = cell(n_oem, 1);
    for no = 1 : n_oem
        if ~isempty(fc_upperbound{t,no})
            n_t_no = length(fc_upperbound{t,no});
            nmto_vec = nan(n_t_no, 1);
            for ntn = 1 : n_t_no
                n_model_ntn = nnz(model_id_drop{t, no}(ntn)==model_id_t);
                if n_model_ntn==0; error('model index error'); end
                nmto_vec(ntn) = n_model_ntn;
            end
            n_model_cell_up_t{no} = nmto_vec;
        end
    end
    
    if any(ismember(counterfactual0,{'merge_2_firms_seq1',...
            'merge_2_firms_seq2','merge_2_firms_simultaneous',...
            'no_cannibalization', 'no_cannibalization_simultaneous'}))
       
            
        for no = 1 : n_oem
            if any(oem_t(:, no))
                if isequal(fc_bounds_option, 'proportional deviation')
                    if any(fc_upperbound{t, no}<0) || any(fc_lowerbound{t, no}<0)
                        error('use other fc_brands_option when some bounds are negative');
                    end

                    if ~isempty(fc_upperbound{t,no})
                        tmp_lb_up = (1-fc_upper_dev)*fc_upperbound{t, no};
                        tmp_distance_up = fc_upper_dev*fc_upperbound{t, no};
                    end

                    if ~isempty(fc_lowerbound{t,no})
                        tmp_lb_lb = fc_lowerbound{t, no};
                        tmp_distance_lb = fc_lower_dev*fc_lowerbound{t,no}; 

                    end

                elseif isequal(fc_bounds_option, 'mean1')
                    if any(fc_upperbound{t, no}<0) || any(fc_lowerbound{t, no}<0)
                        error('use other fc_brands_option when some bounds are negative');
                    end
                    % existing products: draw from upper bound
                    if ~isempty(fc_upperbound{t,no})
                        tmp_lb_up = nan(size(fc_upperbound{t,no}));

                        for nnn = 1 : size(tmp_lb_up, 1)
                            tmp_lb_up(nnn) = min(0.5*fc_upperbound{t,no}(nnn),...
                                fc_lb_est(1)*n_model_cell_up_t{no}(nnn));
                        end
                        tmp_distance_up = fc_upperbound{t,no} - tmp_lb_up;
                        fprintf(1, 'mkt %1.0f, oem %1.0f, # prods s.t. 0.5*fc_upperbound{t,no} > fc_lb_est(1) = %1.0f\n', t, no, nnz(0.5*fc_upperbound{t,no}>fc_lb_est(1)));
                    end

                    % potential products: draw from lower bound
                    if ~isempty(fc_lowerbound{t,no})
                        tmp_lb_lb = fc_lowerbound{t, no};
                        tmp_distance_lb = max(5*fc_lowerbound{t,no}, fc_ub_est(1)); 

                        fprintf(1, 'mkt %1.0f, oem %1.0f, # prods s.t. 5*fc_lowerbound{t,no}<fc_ub_est(1) = %1.0f\n', t, no, nnz(5*fc_lowerbound{t,no}<fc_ub_est(1)));
                    end
                elseif isequal(fc_bounds_option, 'mean2')
                    % existing products: draw from upper bound
                    if ~isempty(fc_upperbound{t,no})
                        n_t_no = length(fc_upperbound{t,no});
                        tmp_distance_up = nan(n_t_no, 1);
                        for ntn = 1 : n_t_no
                            n_model_ntn = nnz(model_id_drop{t, no}(ntn)==model_id_t);
                            if n_model_ntn==0; error('model index error'); end
                            tmp_distance_up(ntn) = bounds_distance*n_model_ntn;
                        end
                        tmp_lb_up = fc_upperbound{t,no} - tmp_distance_up;
                    end
                    % potential products: draw from lower bound
                    if ~isempty(fc_lowerbound{t,no})
                        tmp_lb_lb = fc_lowerbound{t, no};
                        tmp_distance_lb = bounds_distance * ones(size(fc_lowerbound{t,no}));
                    end
                elseif isequal(fc_bounds_option, 'linear_in_quality')

                    % existing products: draw from upper bound
                    if ~isempty(fc_upperbound{t,no})
                        n_t_no = length(fc_upperbound{t,no});
                        tmp_distance_up = nan(n_t_no, 1);
                        for ntn = 1 : n_t_no
                            n_model_ntn = nnz(model_id_drop{t, no}(ntn)==model_id_t);
                            if n_model_ntn==0; error('model index error'); end
                            tmp_distance_up(ntn) = ...
                                b_upper(1) - b_lower(1) + ...
                                q_upper{t,no}(ntn)*(b_upper(2) - b_lower(2)) + ...
                                n_model_ntn*(b_upper(3) - 0);   % b_lower(3) normalized to 0
                        end
                        tmp_lb_up = fc_upperbound{t,no} - tmp_distance_up;
                        fprintf(1, 'mkt %1.0f, oem %1.0f, min fc_lower/fc_upper = %1.2e\n', t, no, min(tmp_lb_up./(tmp_lb_up+tmp_distance_up)));
                    end

                    % potential products: draw from lower bound
                    if ~isempty(fc_lowerbound{t,no})
                        tmp_lb_lb = fc_lowerbound{t, no};

                        tmp_distance_lb = b_upper(1) - b_lower(1) +...
                            q_lower{t,no} * (b_upper(2) - b_lower(2));

                        fprintf(1, 'mkt %1.0f, oem %1.0f, max fc_upper/fc_lower = %1.2e\n', t, no, max((tmp_lb_lb+tmp_distance_lb)./tmp_lb_lb));

                    end
                end

                % existing products: draw from upper bound
                if ~isempty(fc_upperbound{t,no})
                    if any(tmp_distance_up<=0); error('tmp_distance_up <= 0'); end;
                    if isequal(adjust_type, 'nonflagship')
                        fc_sim_inMkt{t, no} = ...
                            bsxfun(@plus, ...
                            tmp_lb_up, ...
                            bsxfun(@times,...
                            fc_draws(1:length(tmp_lb_up), :, t, no, 1),...
                            tmp_distance_up));
                    elseif isequal(adjust_type, 'dynamic_def') || isequal(adjust_type, 'all')
                        tmp1 = fc_draws(1:length(tmp_lb_up), :, t, no, 1);

                        % the following lines make sure that the first several rows are for non-flagship products so
                        % that fixed cost draws for the non-flagship products are the same in  'nonflagship' smln
                        % and 'dynamic_def' smln
                        isflagship_t_o = ismember(model_id_drop{t, no}, model_id_t(oem_t(:,no) & isflagship_t));
                        
                        tmp2 = nan(size(tmp1));
                        tmp2(~isflagship_t_o,:) = tmp1(1:nnz(~isflagship_t_o), :);
                        tmp2(isflagship_t_o,:) = tmp1(nnz(~isflagship_t_o)+1:length(tmp_lb_up), :);

                        fc_sim_inMkt{t, no} = ...
                            bsxfun(@plus, ...
                            tmp_lb_up, ...
                            bsxfun(@times,...
                            tmp2,...
                            tmp_distance_up));                        
                    else
                        error('to be written');
                    end
                end

                % potential products: draw from lower bound
                if ~isempty(fc_lowerbound{t,no})
                    if any(tmp_distance_lb<=0); error('tmp_distance_lb <= 0'); end;
                    fc_sim_potential{t, no} = bsxfun(@plus, ...
                        tmp_lb_lb, ...
                        bsxfun(@times, ...
                        fc_draws(1:length(tmp_lb_lb), :, t, no, 2),...
                        tmp_distance_lb));
                end
            end
        end
        
    end
end
clear isflagship_t

%% counterfactual simulations
oem_varprofit_part3_est = oem_varprofit;

for counterfactual = counterfactual0
    
    fprintf(pfid, '^^^^^^ starting %s ^^^^^\n', counterfactual{:});
    setup.counterfactual = counterfactual;
    if ismember(counterfactual, {'merge_2_firms_seq1','merge_2_firms_seq2','merge_2_firms_simultaneous'})
        n_potential = top_n_merge*(top_n_merge-1)/2;
    elseif ismember(counterfactual, {'no_cannibalization', 'no_cannibalization_simultaneous'})
        n_potential = 1;
    else
        if length(mkt_for_cf)==1
            if ismember(counterfactual, {'drop_any_nonflagship'})
                n_potential = sum(~isflagship(ind_mkt_start(mkt_for_cf):ind_mkt_end(mkt_for_cf)));
            elseif ismember(counterfactual, {'drop_any_2_nonflagship'})
                n_active_oem = sum(repmat(~isflagship(ind_mkt_start(mkt_for_cf):ind_mkt_end(mkt_for_cf)), [1 n_oem])...
                    &oem_ind(ind_mkt_start(mkt_for_cf):ind_mkt_end(mkt_for_cf), :));
                active_oem_ind = find(n_active_oem>1);
                n_potential = 0;
                for nao = 1 : length(active_oem_ind)
                    n_prod_nao = n_active_oem(active_oem_ind(nao));
                    n_potential = n_potential + 1/2*n_prod_nao*(n_prod_nao-1);
                end
            elseif ismember(counterfactual, {'add_1_product_in_gap'})
                n_active_oem = sum(repmat(~isflagship(ind_mkt_start(mkt_for_cf):ind_mkt_end(mkt_for_cf)), [1 n_oem])...
                    &oem_ind(ind_mkt_start(mkt_for_cf):ind_mkt_end(mkt_for_cf), :));
                active_oem_ind = find(n_active_oem>1);
                n_potential = length(active_oem_ind)*n_top_gap;
            else
                n_potential = 1;
            end
        elseif ~ismember(counterfactual, {'drop_any_nonflagship', ...
                'drop_any_2_nonflagship'})
            n_potential = 1;
        else
            error('to be written')
        end
    end
    
    prod_id_inMkt_cf = cell(n_mkt, 1);
    config_inMkt_cf = cell(n_mkt, 1);
    q_level_inMkt_cf = cell(n_mkt, 1);
    p_inMkt_cf = cell(n_mkt, 1);
    w_inMkt_cf = cell(n_mkt, 1);
    share_inMkt_cf = cell(n_mkt, 1);
    cons_surplus_inMkt_cf = cell(n_mkt, 1);
    cons_surplus_no_error_inMkt_cf = cell(n_mkt, 1);
    expmu_inMkt_cf = cell(n_mkt, 1);
    carrier_profit_inMkt_cf = cell(n_mkt, 1);
    profit_inMkt_cf = cell(n_mkt, 1);
    carrier_ind_inMkt_cf = cell(n_mkt, 1);
    oem_ind_inMkt_cf = cell(n_mkt, 1);
    q_inMkt_cf = cell(n_mkt, 1);
    fc_mean_inMkt_cf = cell(n_mkt, n_draws_fc);
    p_sim_inMkt_cf = cell(n_mkt, 1);
    w_sim_inMkt_cf = cell(n_mkt, 1);
    share_sim_inMkt_cf = cell(n_mkt, 1);
    
    
    prod_id_fixedproduct_cf = cell(n_mkt, n_potential);
    config_fixedproduct_cf = cell(n_mkt, n_potential);
    q_level_fixedproduct_cf = cell(n_mkt, n_potential);
    p_fixedproduct_cf = cell(n_mkt, n_potential);
    w_fixedproduct_cf = cell(n_mkt, n_potential);
    share_fixedproduct_cf = cell(n_mkt, n_potential);
    cons_surplus_fixedproduct_cf = cell(n_mkt, n_potential);
    cons_surplus_no_error_fixedproduct_cf = cell(n_mkt, n_potential);
    expmu_fixedproduct_cf = cell(n_mkt, n_potential);
    carrier_profit_fixedproduct_cf = cell(n_mkt, n_potential);
    profit_fixedproduct_cf = cell(n_mkt, n_potential);
    carrier_ind_fixedproduct_cf = cell(n_mkt, n_potential);
    oem_ind_fixedproduct_cf = cell(n_mkt, n_potential);
    q_fixedproduct_cf = cell(n_mkt, n_potential);
    fc_mean_fixedproduct_cf = cell(n_mkt, n_potential);
    p_sim_fixedproduct_cf = cell(n_mkt, n_potential);
    w_sim_fixedproduct_cf = cell(n_mkt, n_potential);
    share_sim_fixedproduct_cf = cell(n_mkt, n_potential);
    
    prod_id_cf = cell(n_mkt, 1, n_potential);
    q_level_cf = cell(n_mkt, 1, n_potential);
    config_cf = cell(n_mkt, n_draws_fc, n_potential);
    oem_profit_cf = cell(n_mkt, n_draws_fc, n_potential);
    flag_cf = zeros(n_mkt, n_draws_fc, n_potential);
    carrier_ind_cf = cell(n_mkt, n_draws_fc, n_potential);
    oem_ind_cf = cell(n_mkt, n_draws_fc, n_potential);
    q_cf = cell(n_mkt, n_draws_fc, n_potential);
    fc_mean_cf = cell(n_mkt, n_draws_fc, n_potential);
    p_cf = cell(n_mkt, n_draws_fc, n_potential);
    w_cf = cell(n_mkt, n_draws_fc, n_potential);
    share_cf = cell(n_mkt, n_draws_fc, n_potential);
    cons_surplus_cf = cell(n_mkt, n_draws_fc, n_potential);
    cons_surplus_no_error_cf = cell(n_mkt, n_draws_fc, n_potential);
    expmu_cf = cell(n_mkt, n_draws_fc, n_potential);
    carrier_profit_cf = cell(n_mkt, n_draws_fc, n_potential);
    p_sim_cf = cell(n_mkt, n_draws_fc, n_potential);
    w_sim_cf = cell(n_mkt, n_draws_fc, n_potential);
    share_sim_cf = cell(n_mkt, n_draws_fc, n_potential);
    prod_profit_cf = cell(n_mkt, n_draws_fc, n_potential); % (p-mc)*share
    oem_profit_each_product_cf = cell(n_mkt, n_draws_fc, n_potential); % (w-mc)*share
    
    for t = mkt_for_cf
        fprintf(pfid, 't = %1.0f\n', t);
        
        ind_t = ind_mkt_start(t):ind_mkt_end(t);
        
        setup_t = setup;
        setup_t.t = t;
        setup_t.q_frontier_includingbrand = max(quality_index_includingbrand(ind_t(isflagship00(ind_t))));
        brandeffect_t = brandeffect(ind_t, :);
        setup_t.brandeffect = brandeffect_t;
        apple_t = apple(ind_t);
        setup_t.apple = apple_t;
        isflagship_t = isflagship(ind_t);
        
        meanutility_t0 = meanutility(ind_t);
        model_id_t = model_id(ind_t);
        carrier_id_t = carrier_id(ind_t);
        oem_id_t = oem_id(ind_t);
        
        n_prod_t = length(ind_t);
        
        meanutility_t0 = repmat(meanutility_t0, [1,n_draws]) + shocksmln_demand(1:n_prod_t,:);
        mc_mean_t = repmat(mc_mean(ind_t),[1,n_draws]) + shocksmln_mc(1:n_prod_t,:);
        
        meanutility_t = meanutility_t0;
                
        p0_t = price(ind_t);
        w0_t = w(ind_t);
        q0_t = quality_index(ind_t);
        q_includingbrand_t = quality_index_includingbrand(ind_t);
        q_model_t = quality_index_includingbrand_model(ind_t);
        ind_endogenous_t = true(length(ind_t),1);
        carrier_t = carrier_ind(ind_t,:);
        oem_t = oem_ind(ind_t,:);
        product_id_t = product_id(ind_t);
        
        ind_id_t = ind_id(ind_t);
        
        if ~isempty(x_rand)
            x_rand_t = x_rand(ind_t, :);
        else
            x_rand_t = [];
        end
        
        
        %1) consurplus, carrier_profit, oem_varprofit in data
        if isequal(counterfactual, {'cs_carrierprof_oemvarprofit_in_data'})
            p_t = nan(length(p0_t), n_draws);
            w_t = p_t;
            share_t = p_t;
            carrier_profit_t = nan(n_carrier, n_draws);
            oem_varprofit_t = nan(n_oem, n_draws);
            cons_surplus_t = nan(n_draws,1);
            cons_surplus_no_error_t = nan(n_draws,1);
            expmu_t = cell(n_draws, 1);
            oem_profit_each_product_t = nan(length(p0_t), n_draws);
            parfor ns = 1:n_draws
                [p_t(:,ns),w_t(:,ns),~, share_t(:,ns), carrier_profit_t(:,ns), oem_varprofit_t(:,ns), ...
                    cons_surplus_t(ns), cons_surplus_no_error_t(ns), expmu_t{ns}, oem_profit_each_product_t(:,ns)] = ...
                    equi_pwq(p0_t, w0_t, q0_t, meanutility_t(:,ns), ind_endogenous_t, carrier_t, oem_t, ...
                    x_rand_t, sim_pcoeff, sim_qcoeff, sim_rand, ...
                    mc_param_q, mc_mean_t(:,ns), setup_t);
            end
            if testcode && (any(abs(p_test - p0_t)>1e-4) || any(abs(w_test - w0_t)>1e-4) || any(abs(q_test - q0_t)>1e-4))
                error('test failed')
            end
            p_cf{t} = p_t;
            w_cf{t} = w_t;
            share_cf{t} = share_t;
            carrier_profit_t = mean(carrier_profit_t,2);
            carrier_profit_cf{t} = carrier_profit_t';
            oem_varprofit_t = mean(oem_varprofit_t,2);
            oem_profit_cf{t} = oem_varprofit_t';
            cons_surplus_cf{t} = mean(cons_surplus_t);
            cons_surplus_no_error_cf{t} = mean(cons_surplus_no_error_t);
            expmu_cf{t} = expmu_t;
            oem_profit_each_product_cf{t} = mean(oem_profit_each_product_t,2);

        end
        
        %2) counterfactual smln
        %% Drop given products
        if ismember(counterfactual, {'drop_lowestquality_nonflagship','drop_lowestquality_nonflagship_fixprice', ...
                'drop_medianquality_nonflagship','drop_medianquality_nonflagship_fixprice',...
                'drop_highestquality_nonflagship','drop_highestquality_nonflagship_fixprice'})
            if ismember(counterfactual, {'drop_lowestquality_nonflagship','drop_lowestquality_nonflagship_fixprice'})
                
                oem_w_multi_prod = nan(size(oem_t, 2), 1); % num of smartphones per oem
                for nm = 1:size(oem_t,2)
                    oem_w_multi_prod(nm) = length(unique(ind_id_t(oem_t(:, nm))));
                end
                ind_nonflagship_adjustable = find(any(oem_t(:,oem_w_multi_prod>1),2) & ~isflagship_t);% nonflagship products of these oem
                [~,ind_min] = min(q_model_t(ind_nonflagship_adjustable));
                ind_drop_in_cf = find(ind_id_t == ind_id_t(ind_nonflagship_adjustable(ind_min(1))));
                
            elseif ismember(counterfactual, {'drop_medianquality_nonflagship','drop_medianquality_nonflagship_fixprice'})
                tmp = nan(size(oem_t, 2), 1); % num of smartphones per oem
                for nm = 1:size(oem_t,2)
                    tmp(nm) = length(unique(ind_id_t(oem_t(:, nm))));
                end
                tmp = find(any(oem_t(:,tmp>1),2) & ~isflagship_t);% nonflagship products of these oem
                [~, ind_median] = min(abs(median(q_model_t(tmp))-q_model_t(tmp)));
                ind_drop_in_cf = find(ind_id_t == ind_id_t(tmp(ind_median(1))));
                
            elseif ismember(counterfactual, {'drop_highestquality_nonflagship','drop_highestquality_nonflagship_fixprice'})
                
                tmp = nan(size(oem_t, 2), 1); % num of smartphones per oem
                for nm = 1:size(oem_t,2)
                    tmp(nm) = length(unique(ind_id_t(oem_t(:, nm))));
                end
                tmp = find(any(oem_t(:,tmp>1),2) & ~isflagship_t);% nonflagship products of these oem
                [~, ind_max] = max(q_model_t(tmp));
                ind_drop_in_cf = find(ind_id_t == ind_id_t(tmp(ind_max(1))));
            end
            
            setup_t_cf = setup_t;
            setup_t_cf.brandeffect(ind_drop_in_cf) = [];
            setup_t_cf.apple(ind_drop_in_cf) = [];
            
            
            
            if ismember(counterfactual, {'drop_lowestquality_nonflagship_fixprice', ...
                    'drop_medianquality_nonflagship_fixprice',...
                    'drop_highestquality_nonflagship_fixprice'});
                load('cs_carrierprof_oemvarprofit_in_data', 'p_cf', 'w_cf');
                p0_t_cf = p_cf{t}; p0_t_cf(ind_drop_in_cf,:) = [];
                w0_t_cf = w_cf{t}; w0_t_cf(ind_drop_in_cf,:) = [];
            else
                p0_t_cf = p0_t; p0_t_cf(ind_drop_in_cf) = [];
                w0_t_cf = w0_t; w0_t_cf(ind_drop_in_cf) = [];
            end
            
            
            q0_t_cf = q0_t; q0_t_cf(ind_drop_in_cf) = [];
            if ~isempty(x_rand)
                x_rand_t_cf = x_rand_t; x_rand_t_cf(ind_drop_in_cf, :) = [];
            else
                x_rand_t_cf = [];
            end
            ind_endogenous_t_cf = ind_endogenous_t; ind_endogenous_t_cf(ind_drop_in_cf) = [];
            carrier_t_cf = carrier_t; carrier_t_cf(ind_drop_in_cf,:) = [];
            oem_t_cf = oem_t; oem_t_cf(ind_drop_in_cf,:) = [];
            
            meanutility_t_cf = meanutility_t0; meanutility_t_cf(ind_drop_in_cf,:) = [];
            
            
            mc_mean_t_cf = mc_mean_t; mc_mean_t_cf(ind_drop_in_cf,:) = [];
            product_id_t_cf = product_id_t; product_id_t_cf(ind_drop_in_cf) = [];
            
            carrier_id_t_cf = carrier_id_t; carrier_id_t_cf(ind_drop_in_cf) = [];
            oem_id_t_cf = oem_id_t; oem_id_t_cf(ind_drop_in_cf) = [];
            model_id_t_cf = model_id_t; model_id_t_cf(ind_drop_in_cf) = [];
            
            n_prod_t_cf = length(ind_t) - length(ind_drop_in_cf);
            
            carrier_profit_cf_t = nan(n_carrier, n_draws);
            oem_varprofit_cf_t = nan(n_oem, n_draws);
            cons_surplus_cf_t = nan(n_draws,1);
            cons_surplus_no_error_cf_t = nan(n_draws,1);
            expmu_cf_t = cell(n_draws, 1);
            p_cf_t = nan(length(p0_t_cf), n_draws);
            w_cf_t = p_cf_t;
            share_cf_t = p_cf_t;
            
            
            if ismember(counterfactual, {'drop_lowestquality_nonflagship_fixprice', ...
                    'drop_medianquality_nonflagship_fixprice',...
                    'drop_highestquality_nonflagship_fixprice'});
                setup_t_cf.use_p0 = true;
                setup_t_cf.use_w0 = true;
                parfor ns = 1:n_draws
                    [p_cf_t(:,ns), w_cf_t(:,ns), ~, share_cf_t(:, ns), carrier_profit_cf_t(:,ns), oem_varprofit_cf_t(:,ns), cons_surplus_cf_t(ns), ...
                        cons_surplus_no_error_cf_t(ns), expmu_cf_t{ns}] = ...
                        equi_pwq(p0_t_cf(:,ns), w0_t_cf(:,ns), q0_t_cf, meanutility_t_cf(:,ns), ind_endogenous_t_cf, carrier_t_cf, oem_t_cf, ...
                        x_rand_t_cf, sim_pcoeff, sim_qcoeff, sim_rand, ...
                        mc_param_q, ...
                        mc_mean_t_cf(:,ns), setup_t_cf);
                end
                if ~isequal(p_cf_t, p0_t_cf) || ~isequal(w_cf_t, w0_t_cf)
                    error('p and w should stay the same')
                end
            else
                parfor ns = 1:n_draws
                    [p_cf_t(:,ns), w_cf_t(:,ns), ~, share_cf_t(:, ns), carrier_profit_cf_t(:,ns), oem_varprofit_cf_t(:,ns), cons_surplus_cf_t(ns), ...
                        cons_surplus_no_error_cf_t(ns), expmu_cf_t{ns}] = ...
                        equi_pwq(p0_t_cf, w0_t_cf, q0_t_cf, meanutility_t_cf(:,ns), ind_endogenous_t_cf, carrier_t_cf, oem_t_cf, ...
                        x_rand_t_cf, sim_pcoeff, sim_qcoeff, sim_rand, ...
                        mc_param_q, ...
                        mc_mean_t_cf(:,ns), setup_t_cf);
                end
            end
            
            carrier_profit_cf_t = mean(carrier_profit_cf_t,2);
            carrier_profit_cf{t} = carrier_profit_cf_t;
            oem_varprofit_cf_t = mean(oem_varprofit_cf_t,2);
            oem_profit_cf{t} = oem_varprofit_cf_t;
            cons_surplus_cf{t} = mean(cons_surplus_cf_t);
            cons_surplus_no_error_cf{t} = mean(cons_surplus_no_error_cf_t);
            expmu_cf{t} = expmu_cf_t;
            p_cf{t} = p_cf_t;
            w_cf{t} = w_cf_t;
            prod_id_cf{t} = product_id_t_cf;
            share_cf{t} = mean(share_cf_t, 2);
            

            %% Drop any fixed number of products
        elseif ismember(counterfactual, {'drop_any_nonflagship'})
            
            tmp = unique(ind_id_t(~isflagship_t));
            n_nfprod_t = length(tmp);
            nonflagship_t = cell(n_nfprod_t,1);
            for ii = 1:n_nfprod_t
                nonflagship_t{ii} = find(ind_id_t == tmp(ii));
            end
            
            
            for kk = 1:n_nfprod_t;
                k = nonflagship_t{kk};
                
                setup_t_cf = setup_t;
                setup_t_cf.brandeffect(k) = [];
                setup_t_cf.apple(k) = [];
                p0_t_cf = p0_t; p0_t_cf(k) = [];
                w0_t_cf = w0_t; w0_t_cf(k) = [];
                q0_t_cf = q0_t; q0_t_cf(k) = [];
                ind_endogenous_t_cf = ind_endogenous_t; ind_endogenous_t_cf(k) = [];
                carrier_t_cf = carrier_t; carrier_t_cf(k,:) = [];
                oem_t_cf = oem_t; oem_t_cf(k,:) = [];
                
                meanutility_t_cf = meanutility_t0; meanutility_t_cf(k,:) = [];
                
                mc_mean_t_cf = mc_mean_t; mc_mean_t_cf(k,:) = [];
                
                
                product_id_t_cf = product_id_t; product_id_t_cf(k) = [];
                if ~isempty(x_rand)
                    x_rand_t_cf = x_rand_t; x_rand_t_cf(k, :) = [];
                else
                    x_rand_t_cf = [];
                end
                
                carrier_id_t_cf = carrier_id_t; carrier_id_t_cf(k) = [];
                oem_id_t_cf = oem_id_t; oem_id_t_cf(k) = [];
                model_id_t_cf = model_id_t; model_id_t_cf(k) = [];
                
                n_prod_t_cf = length(ind_t) - length(k);
                
                carrier_profit_cf_t = nan(n_carrier, n_draws);
                oem_varprofit_cf_t = nan(n_oem, n_draws);
                cons_surplus_cf_t = nan(n_draws,1);
                cons_surplus_no_error_cf_t = nan(n_draws,1);
                expmu_cf_t = cell(n_draws, 1);
                p_cf_t = nan(length(p0_t_cf), n_draws);
                w_cf_t = p_cf_t;
                share_cf_t = p_cf_t;
                parfor ns = 1:n_draws
                    [p_cf_t(:,ns), w_cf_t(:,ns), ~, share_cf_t(:, ns), carrier_profit_cf_t(:,ns), oem_varprofit_cf_t(:,ns), cons_surplus_cf_t(ns), ...
                        cons_surplus_no_error_cf_t(ns), expmu_cf_t{ns}] = ...
                        equi_pwq(p0_t_cf, w0_t_cf, q0_t_cf, meanutility_t_cf(:,ns), ind_endogenous_t_cf, carrier_t_cf, oem_t_cf, ...
                        x_rand_t_cf, sim_pcoeff, sim_qcoeff, sim_rand, ...
                        mc_param_q, ...
                        mc_mean_t_cf(:,ns), setup_t_cf);
                end
                
                carrier_profit_cf_t = mean(carrier_profit_cf_t,2);
                carrier_profit_cf{t, 1, kk} = carrier_profit_cf_t;
                oem_varprofit_cf_t = mean(oem_varprofit_cf_t,2);
                oem_profit_cf{t, 1, kk} = oem_varprofit_cf_t;
                cons_surplus_cf{t, 1, kk} = mean(cons_surplus_cf_t);
                cons_surplus_no_error_cf{t, 1, kk} = mean(cons_surplus_no_error_cf_t);
                expmu_cf{t, 1, kk} = expmu_cf_t;
                p_cf{t, 1, kk} = p_cf_t;
                w_cf{t, 1, kk} = w_cf_t;
                prod_id_cf{t, 1, kk} = product_id_t_cf;
                share_cf{t, 1, kk} = mean(share_cf_t, 2);
                q_cf{t,1,kk} = q0_t(k); % dropped products
            end
        elseif ismember(counterfactual, {'drop_any_2_nonflagship'})
            n_potential = 0;
            
            counter = 1;
            
            for k1 = 1 : n_prod_t - 1
                oem1 = find(oem_t(k1,:));
                for k2 = k1+1:n_prod_t
                    oem2 = find(oem_t(k2,:));
                    
                    if isflagship_t(k1) || isflagship_t(k2) % if either one is flagship
                        continue
                    elseif ~any(oem_t(setdiff((1:n_prod_t), [k1;k2]), oem1)) || ~any(oem_t(setdiff((1:n_prod_t), [k1;k2]), oem2)) % if an oem is deleted due to dropping these products
                        continue
                    end
                    
                    if model_id_t(k2) == model_id_t(k1) % if they are actually the same smartphone
                        continue
                    end
                    ind_drop_in_cf = find((model_id_t == model_id_t(k1)) | (model_id_t == model_id_t(k2)));
                    if ~any(oem_t(setdiff((1:n_prod_t), ind_drop_in_cf), oem1)) || ~any(oem_t(setdiff((1:n_prod_t), ind_drop_in_cf), oem2)) % if an oem is deleted due to dropping these products
                        continue
                    end
                    
                    setup_t_cf = setup_t;
                    setup_t_cf.brandeffect(ind_drop_in_cf) = [];
                    setup_t_cf.apple(ind_drop_in_cf) = [];
                    p0_t_cf = p0_t; p0_t_cf(ind_drop_in_cf) = [];
                    w0_t_cf = w0_t; w0_t_cf(ind_drop_in_cf) = [];
                    q0_t_cf = q0_t; q0_t_cf(ind_drop_in_cf) = [];
                    ind_endogenous_t_cf = ind_endogenous_t; ind_endogenous_t_cf(ind_drop_in_cf) = [];
                    carrier_t_cf = carrier_t; carrier_t_cf(ind_drop_in_cf,:) = [];
                    oem_t_cf = oem_t; oem_t_cf(ind_drop_in_cf,:) = [];
                    
                    meanutility_t_cf = meanutility_t0; meanutility_t_cf(ind_drop_in_cf,:) = [];
                    
                    mc_mean_t_cf = mc_mean_t; mc_mean_t_cf(ind_drop_in_cf,:) = [];
                    product_id_t_cf = product_id_t; product_id_t_cf(ind_drop_in_cf) = [];
                    
                    if ~isempty(x_rand)
                        x_rand_t_cf = x_rand_t; x_rand_t_cf(ind_drop_in_cf, :) = [];
                    else
                        x_rand_t_cf = [];
                    end
                    
                    carrier_id_t_cf = carrier_id_t; carrier_id_t_cf(ind_drop_in_cf) = [];
                    oem_id_t_cf = oem_id_t; oem_id_t_cf(ind_drop_in_cf) = [];
                    model_id_t_cf = model_id_t; model_id_t_cf(ind_drop_in_cf) = [];
                    
                    n_prod_t_cf = length(ind_t) - length(ind_drop_in_cf);
                    
                    carrier_profit_cf_t = nan(n_carrier, n_draws);
                    oem_varprofit_cf_t = nan(n_oem, n_draws);
                    cons_surplus_cf_t = nan(n_draws,1);
                    cons_surplus_no_error_cf_t = nan(n_draws,1);
                    expmu_cf_t = cell(n_draws,1);
                    p_cf_t = nan(length(p0_t_cf), n_draws);
                    w_cf_t = p_cf_t;
                    share_cf_t = p_cf_t;
                    parfor ns = 1:n_draws
                        [p_cf_t(:,ns), w_cf_t(:,ns), ~, share_cf_t(:, ns), carrier_profit_cf_t(:,ns), oem_varprofit_cf_t(:,ns), cons_surplus_cf_t(ns), ...
                            cons_surplus_no_error_cf_t(ns), expmu_cf_t{ns}] = ...
                            equi_pwq(p0_t_cf, w0_t_cf, q0_t_cf, meanutility_t_cf(:,ns), ind_endogenous_t_cf, carrier_t_cf, oem_t_cf, ...
                            x_rand_t_cf, sim_pcoeff, sim_qcoeff, sim_rand, ...
                            mc_param_q, ...
                            mc_mean_t_cf(:,ns), setup_t_cf);
                    end
                    
                    carrier_profit_cf_t = mean(carrier_profit_cf_t,2);
                    carrier_profit_cf{t, 1, counter} = carrier_profit_cf_t;
                    oem_varprofit_cf_t = mean(oem_varprofit_cf_t,2);
                    oem_profit_cf{t, 1, counter} = oem_varprofit_cf_t;
                    cons_surplus_cf{t, 1, counter} = mean(cons_surplus_cf_t);
                    cons_surplus_no_error_cf{t, 1, counter} = mean(cons_surplus_no_error_cf_t);
                    expmu_cf{t,1,counter} = expmu_cf_t;
                    p_cf{t, 1, counter} = p_cf_t;
                    w_cf{t, 1, counter} = w_cf_t;
                    prod_id_cf{t, 1, counter} = product_id_t_cf;
                    share_cf{t, 1, counter} = mean(share_cf_t, 2);
                    q_cf{t,1,counter} = q0_t(ind_drop_in_cf); % dropped products
                    counter = counter+1;
                end
            end
            
            %% Add given products
        elseif isequal(counterfactual, {'add_1_product_in_gap'})
            
            % the products following dropped products in new_prod_list
            % would be the products in the gap
            
            active_oem = find(sum(oem_ind(ind_t, :)));
            
            n_prod_carrier_t = sum(carrier_ind(ind_t, :));
            
            [~, min_carrier] = min(n_prod_carrier_t);
            k = 0;
            for no = active_oem
                
                for jj = 1 : n_top_gap
                    k = k + 1;
                    setup_t_cf = setup_t;
                    setup_t_cf.brandeffect = [setup_t_cf.brandeffect; new_potential_prod_list{t, no}{min_carrier, jj}.brandeffect];
                    setup_t_cf.apple = [setup_t_cf.apple; new_potential_prod_list{t, no}{min_carrier, jj}.apple];
                    p0_t_cf = [p0_t; new_potential_prod_list{t, no}{min_carrier, jj}.p0];
                    w0_t_cf = [w0_t; new_potential_prod_list{t, no}{min_carrier, jj}.w0];
                    q0_t_cf = [q0_t; new_potential_prod_list{t, no}{min_carrier, jj}.q0];
                    ind_endogenous_t_cf = [ind_endogenous_t; true];
                    
                    oem_t_cf = [oem_t; new_potential_prod_list{t, no}{min_carrier, jj}.oem];
                    carrier_t_cf = [carrier_t; new_potential_prod_list{t, no}{min_carrier, jj}.carrier];
                    x_rand_t_cf = [x_rand_t; new_potential_prod_list{t, no}{min_carrier, jj}.x_rand];
                    
                    meanutility_t_cf = [meanutility_t0; new_potential_prod_list{t, no}{min_carrier, jj}.mean_u + shocksmln_demand(length(ind_t)+1,:)];
                    
                    mc_mean_t_cf = [mean_mc_t; new_potential_prod_list{t, no}{min_carrier, jj}.mean_mc + shocksmln_mc(length(ind_t)+1,:)];
                    
                    carrier_id_t_cf = [carrier_id_t; new_potential_prod_list{t, no}{min_carrier, jj}.carrier_id];
                    oem_id_t_cf = [oem_id_t; new_potential_prod_list{t, no}{min_carrier, jj}.oem_id];
                    model_id_t_cf = [model_id_t; new_potential_prod_list{t, no}{min_carrier, jj}.model_id];
                    
                    n_prod_t_cf = length(ind_t) + 1;
                    
                   
                    carrier_profit_cf_t = nan(n_carrier, n_draws);
                    oem_varprofit_cf_t = nan(n_oem, n_draws);
                    cons_surplus_cf_t = nan(n_draws,1);
                    cons_surplus_no_error_cf_t = nan(n_draws,1);
                    expmu_cf_t = cell(n_draws,1);
                    p_cf_t = nan(length(p0_t_cf), n_draws);
                    w_cf_t = p_cf_t;
                    prod_profit_cf_t = p_cf_t;
                    parfor ns = 1:n_draws
                        [p_cf_t(:,ns), w_cf_t(:,ns), ~, ~, ...
                            carrier_profit_cf_t(:,ns), ...
                            oem_varprofit_cf_t(:,ns), ...
                            cons_surplus_cf_t(ns), ...
                            cons_surplus_no_error_cf_t(ns),...
                            expmu_cf_t{ns}, prod_profit_cf_t(:, ns)] = ...
                            equi_pwq(p0_t_cf, w0_t_cf, q0_t_cf, meanutility_t_cf(:,ns), ind_endogenous_t_cf, carrier_t_cf, oem_t_cf, ...
                            x_rand_t_cf, sim_pcoeff, sim_qcoeff, sim_rand, mc_param_q, mc_mean_t_cf(:,ns), setup_t_cf);
                    end
                    
                    carrier_profit_cf_t = mean(carrier_profit_cf_t,2);
                    carrier_profit_cf{t, 1, k} = carrier_profit_cf_t;
                    oem_varprofit_cf_t = mean(oem_varprofit_cf_t,2);
                    oem_profit_cf{t, 1, k} = oem_varprofit_cf_t;
                    cons_surplus_cf{t, 1, k} = mean(cons_surplus_cf_t);
                    cons_surplus_no_error_cf{t, 1, k} = mean(cons_surplus_no_error_cf_t);
                    expmu_cf{t, 1, k} = expmu_cf_t;
                    p_cf{t, 1, k} = p_cf_t;
                    w_cf{t, 1, k} = w_cf_t;
                    q_cf{t, 1, k} = new_potential_prod_list{t, no}{min_carrier, jj}.q0;
                    fc_mean_cf{t, 1, k} = fc_lowerbound_add_potential{t, no}(min_carrier, jj);
                    oem_ind_cf{t, 1, k} = new_potential_prod_list{t, no}{min_carrier, jj}.oem;
                    carrier_ind_cf{t, 1, k} = new_potential_prod_list{t, no}{min_carrier, jj}.carrier;
                    prod_profit_cf{t, 1, k} = prod_profit_cf_t;
                end
            end
            
            %% Product choice eqm
        elseif ismember(counterfactual, {'merge_2_firms_seq1',...
                'merge_2_firms_seq2','merge_2_firms_simultaneous',...
                'no_cannibalization', 'no_cannibalization_simultaneous'})
            
            fixed_prod_t.q = q0_t(prod_ind_fixed{t});
            fixed_prod_t.w = w0_t(prod_ind_fixed{t});
            fixed_prod_t.p = p0_t(prod_ind_fixed{t});
            fixed_prod_t.oem = oem_t(prod_ind_fixed{t}, :);
            fixed_prod_t.carrier = carrier_t(prod_ind_fixed{t}, :);
            fixed_prod_t.carrier_id = carrier_id_t(prod_ind_fixed{t}, :);
            fixed_prod_t.oem_id = oem_id_t(prod_ind_fixed{t}, :);
            fixed_prod_t.model_id = model_id_t(prod_ind_fixed{t}, :);
            
            fixed_prod_t.mean_demand = meanutility_t0(prod_ind_fixed{t}, :);
            fixed_prod_t.mean_mc = mc_mean_t(prod_ind_fixed{t}, :);
            fixed_prod_t.brandeffect = brandeffect_t(prod_ind_fixed{t}, :);
            
            if isempty(x_rand)
                fixed_prod_t.x_rand = [];
            else
                fixed_prod_t.x_rand = x_rand_t(prod_ind_fixed{t}, :);
            end
            
            
            oem_list = cell(n_oem, 1);
            for no = 1 : n_oem
                oem_list(no) = unique(oem(oem_ind(:, no)));
            end
            
            % use observed total quantity sales to order moves
            tt_sale_t = nan(n_oem, 1);
            for no = 1 : n_oem
                tt_sale_t(no) = sum(share(time==t&oem_ind(:, no)==1));
            end
            [~, firm_seq1] = sort(tt_sale_t, 'ascend');
            [~, firm_seq2] = sort(tt_sale_t, 'descend');
            
            % remove fixed oem's
            firm_seq1(ismember(firm_seq1, fixed_oem)) = [];
            firm_seq2(ismember(firm_seq2, fixed_oem)) = [];
            
            top_seq = firm_seq2;    
            
            % convert products into indices
            [binary_prod_t, config_binary_t, full_prod_t, config_full_t]=...
                convert_config(t, oem_t, prod_id_drop, model_id_drop, ...
                brandeffect_t, p0_t, w0_t, q0_t, carrier_t, carrier_id_t, ...
                oem_id_t, model_id_t, product_id_t, meanutility_t0, mc_mean_t, x_rand, ...
                fc_sim_inMkt, fc_sim_potential, use_potential_prod, new_dropped_prod_list,...
                new_prod_list, shocksmln_demand, shocksmln_mc, ind_t, prod_id_add, ind_id_t, ...
                prod_id_add_dropped, new_potential_prod_list, n_top_gap, n_carrier, n_oem, id_fixed{t});
            
            
            % pre-merger conditions
            setup_t.merge = false;
            
            [oem_profit_inMkt, carrier_ind_inMkt, oem_ind_inMkt,...
                q_inMkt, p_inMkt, w_inMkt, share_inMkt,...
                cons_surplus_inMkt, cons_surplus_no_error_inMkt, expmu_inMkt, ...
                carrier_profit_inMkt, p_sim_inMkt, w_sim_inMkt, share_sim_inMkt] = ...
                equi_ind(config_binary_t, binary_prod_t, config_full_t, full_prod_t, fixed_prod_t, ...
                setup_t, n_top_gap, n_carrier, n_draws, x_rand, ...
                sim_pcoeff, sim_qcoeff, sim_rand, ...
                mc_param_q);
            
            config_inMkt_cf{t} = config_binary_t;
            p_inMkt_cf{t} = p_inMkt;
            w_inMkt_cf{t} = w_inMkt;
            share_inMkt_cf{t} = share_inMkt;
            cons_surplus_inMkt_cf{t} = cons_surplus_inMkt;
            cons_surplus_no_error_inMkt_cf{t} = cons_surplus_no_error_inMkt;
            expmu_inMkt_cf{t} = expmu_inMkt;
            carrier_profit_inMkt_cf{t} = carrier_profit_inMkt;
            profit_inMkt_cf{t} = oem_profit_inMkt;
            carrier_ind_inMkt_cf{t} = carrier_ind_inMkt;
            oem_ind_inMkt_cf{t} = oem_ind_inMkt;
            q_inMkt_cf{t} = q_inMkt;
            
            p_sim_inMkt_cf{t} = p_sim_inMkt;
            w_sim_inMkt_cf{t} = w_sim_inMkt;
            share_sim_inMkt_cf{t} = share_sim_inMkt;
            
            % best response iteration to compute the equilibrium
            % under a counterfactual market structure
            
            
            for nfc = 1 : n_draws_fc
                disp(['counterfactual: ', counterfactual{1}, '; fixed cost draw: ', num2str(nfc)])
                
                fc_mean_inMkt_cf{t, nfc} = compute_fc(config_binary_t, ...
                    binary_prod_t, config_full_t, full_prod_t, n_top_gap, nfc);
                
                if ismember(counterfactual, {'merge_2_firms_seq1','merge_2_firms_seq2','merge_2_firms_simultaneous'})
                    
                    merger_pairs = cell(n_potential, 1);
                    
                    if ismember(counterfactual, {'merge_2_firms_seq1'})
                        setup_t.merge = true;
                        firm_seq_cf = firm_seq1;
                    elseif isequal(counterfactual, {'merge_2_firms_seq2'})
                        setup_t.merge = true;
                        firm_seq_cf = firm_seq2;
                    else
                        error('unknown counterfactual');
                    end
                    
                    k = 0;
                    for no1 = 1 : (top_n_merge-1)
                        for no2 = no1+1 : top_n_merge
                            k = k + 1;
                            
                            if top_n_merge > 2 && k == 1
                                continue;
                            end
                            if k > n_potential
                                continue;
                            end
                            
                            if setup_t.merge
                                setup_t.merge_id = [top_seq(no1), top_seq(no2)];
                                disp(['counterfactual: ', counterfactual{1}, '; fixed cost draw: ', num2str(nfc), 'merger No. ', num2str(k)]);
                            
                                [binary_prod_kt, config_binary_kt, ...
                                    full_prod_kt, config_full_kt, fixed_prod_kt] =...
                                    ...
                                    merger_change_brand(...
                                    t,...
                                    binary_prod_t, config_binary_t, full_prod_t, config_full_t, ...
                                    brand_option, setup_t.merge_id, para_linear_est, dim_demand_brandtime,...
                                    mc_param, dim_mc_brand, key_oem_ind, fixed_prod_t);

                            else
                                setup_t.merge_id = [];
                                
                                binary_prod_kt = binary_prod_t;
                                config_binary_kt = config_binary_t;
                                full_prod_kt = full_prod_t;
                                config_full_kt = config_full_t;
                                fixed_prod_kt = fixed_prod_t;
                            end
                                
                                
                            if nfc == 1 && ismember(counterfactual, ...
                                    {'merge_2_firms_seq1','merge_2_firms_seq2',...
                                    'merge_2_firms_simultaneous'})
                                [oem_profit_fixedproduct, carrier_ind_fixedproduct, oem_ind_fixedproduct,...
                                    q_fixedproduct, p_fixedproduct, w_fixedproduct, share_fixedproduct,...
                                    cons_surplus_fixedproduct, cons_surplus_no_error_fixedproduct, expmu_fixedproduct, carrier_profit_fixedproduct,...
                                    p_sim_fixedproduct, w_sim_fixedproduct, share_sim_fixedproduct] = ...
                                    equi_ind(config_binary_kt, binary_prod_kt, config_full_kt, full_prod_kt, fixed_prod_t, ...
                                    setup_t, n_top_gap, n_carrier, n_draws, x_rand, ...
                                    sim_pcoeff, sim_qcoeff, sim_rand, ...
                                    mc_param_q);
                                
                                
                                config_fixedproduct_cf{t, k} = config_binary_t;
                                p_fixedproduct_cf{t, k} = p_fixedproduct;
                                w_fixedproduct_cf{t, k} = w_fixedproduct;
                                share_fixedproduct_cf{t, k} = share_fixedproduct;
                                cons_surplus_fixedproduct_cf{t, k} = cons_surplus_fixedproduct;
                                cons_surplus_no_error_fixedproduct_cf{t, k} = cons_surplus_no_error_fixedproduct;
                                expmu_fixedproduct_cf{t, k} = expmu_fixedproduct;
                                carrier_profit_fixedproduct_cf{t, k} = carrier_profit_fixedproduct;
                                profit_fixedproduct_cf{t, k} = oem_profit_fixedproduct;
                                carrier_ind_fixedproduct_cf{t, k} = carrier_ind_fixedproduct;
                                oem_ind_fixedproduct_cf{t, k} = oem_ind_fixedproduct;
                                q_fixedproduct_cf{t, k} = q_fixedproduct;
                                p_sim_fixedproduct_cf{t, k} = p_sim_fixedproduct;
                                w_sim_fixedproduct_cf{t, k} = w_sim_fixedproduct;
                                share_sim_fixedproduct_cf{t, k} = share_sim_fixedproduct;
                            end
                            
                            % this is the variable profit!
                            [config_binary_new, config_full_new, ...
                                profit_iter, flag_iter, carrier_ind_iter, ...
                                oem_ind_iter, q_iter, fc_mean_iter, p_iter, w_iter, ...
                                share_iter, cons_surplus_iter, cons_surplus_no_error_iter, expmu_iter, ...
                                carrier_profit_iter,...
                                p_sim_iter, w_sim_iter, share_sim_iter] =...
                                ...
                                prod_equi_swap(...
                                ...
                                config_binary_kt, binary_prod_kt, config_full_kt,...
                                full_prod_kt, fixed_prod_t, x_rand, firm_seq_cf, ...
                                sim_pcoeff, sim_qcoeff, sim_rand, ...
                                mc_param_q, nfc, n_carrier, ...
                                max_iter_count, n_top_gap, setup_t, ...
                                starting_point_option);
                            
                            config_iter.binary = config_binary_new;
                            config_iter.full = config_full_new;
                            
                            config_cf{t, nfc, k} = config_iter;
                            q_cf{t, nfc, k} = q_iter;
                            p_cf{t, nfc, k} = p_iter;
                            w_cf{t, nfc, k} = w_iter;
                            share_cf{t, nfc, k} = share_iter;
                            cons_surplus_cf{t, nfc, k} = cons_surplus_iter;
                            cons_surplus_no_error_cf{t, nfc, k} = cons_surplus_no_error_iter;
                            expmu_cf{t, nfc, k} = expmu_iter;
                            carrier_profit_cf{t, nfc, k} = carrier_profit_iter;
                            oem_profit_cf{t, nfc, k} = profit_iter;
                            flag_cf(t, nfc, k) = flag_iter;
                            carrier_ind_cf{t, nfc, k} = carrier_ind_iter;
                            oem_ind_cf{t, nfc, k} = oem_ind_iter;
                            fc_mean_cf{t, nfc, k} = fc_mean_iter;
                            p_sim_cf{t, nfc, k} = p_sim_iter;
                            w_sim_cf{t, nfc, k} = w_sim_iter;
                            share_sim_cf{t, nfc, k} = share_sim_iter;
                            
                            
                            if setup_t.merge
                                merger_pairs{k} = [oem_list{setup_t.merge_id(1)}, ' and ', oem_list{setup_t.merge_id(2)}];
                            end
                            save(char(counterfactual));
                        end
                    end
                    
                    
                    
                elseif ismember(counterfactual, {'no_cannibalization', ...
                        'no_cannibalization_simultaneous'})
                    setup_t.merge = false;
                    setup_t.merge_id = [];
                    
                    firm_seq_cf = firm_seq1;
                                        
                    disp(['counterfactual: ', counterfactual{1}, '; fixed cost draw: ', num2str(nfc)]);
                    
                    if nfc == 1
                        [oem_profit_fixedproduct, carrier_ind_fixedproduct, oem_ind_fixedproduct,...
                            q_fixedproduct, p_fixedproduct, w_fixedproduct, share_fixedproduct,...
                            cons_surplus_fixedproduct, cons_surplus_no_error_fixedproduct, expmu_fixedproduct, carrier_profit_fixedproduct,...
                            p_sim_fixedproduct, w_sim_fixedproduct, share_sim_fixedproduct] = ...
                            equi_ind(config_binary_t, binary_prod_t, config_full_t, full_prod_t, fixed_prod_t, ...
                            setup_t, n_top_gap, n_carrier, n_draws, x_rand, ...
                            sim_pcoeff, sim_qcoeff, sim_rand, ...
                            mc_param_q);
                        
                        
                        config_fixedproduct_cf{t} = config_binary_t;
                        p_fixedproduct_cf{t} = p_fixedproduct;
                        w_fixedproduct_cf{t} = w_fixedproduct;
                        share_fixedproduct_cf{t} = share_fixedproduct;
                        cons_surplus_fixedproduct_cf{t} = cons_surplus_fixedproduct;
                        cons_surplus_no_error_fixedproduct_cf{t} = cons_surplus_no_error_fixedproduct;
                        expmu_fixedproduct_cf{t} = expmu_fixedproduct;
                        carrier_profit_fixedproduct_cf{t} = carrier_profit_fixedproduct;
                        profit_fixedproduct_cf{t} = oem_profit_fixedproduct;
                        carrier_ind_fixedproduct_cf{t} = carrier_ind_fixedproduct;
                        oem_ind_fixedproduct_cf{t} = oem_ind_fixedproduct;
                        q_fixedproduct_cf{t} = q_fixedproduct;
                        p_sim_fixedproduct_cf{t} = p_sim_fixedproduct;
                        w_sim_fixedproduct_cf{t} = w_sim_fixedproduct;
                        share_sim_fixedproduct_cf{t} = share_sim_fixedproduct;
                    end
                    
                    % this is the variable profit~!
                    [config_binary_new, config_full_new, ...
                        profit_iter, flag_iter, carrier_ind_iter, ...
                        oem_ind_iter, q_iter, fc_mean_iter, p_iter, w_iter, ...
                        share_iter, cons_surplus_iter, cons_surplus_no_error_iter, expmu_iter, ...
                        carrier_profit_iter,...
                        p_sim_iter, w_sim_iter, share_sim_iter] =...
                        ...
                        prod_equi_swap(...
                        ...
                        config_binary_t, binary_prod_t, config_full_t,...
                        full_prod_t, fixed_prod_t, x_rand, firm_seq_cf, ...
                        sim_pcoeff, sim_qcoeff, sim_rand, ...
                        mc_param_q, nfc, n_carrier, ...
                        max_iter_count, n_top_gap, setup_t, ...
                        starting_point_option);
                    
                    config_iter.binary = config_binary_new;
                    config_iter.full = config_full_new;
                    
                    config_cf{t, nfc} = config_iter;
                    q_cf{t, nfc} = q_iter;
                    p_cf{t, nfc} = p_iter;
                    w_cf{t, nfc} = w_iter;
                    share_cf{t, nfc} = share_iter;
                    cons_surplus_cf{t, nfc} = cons_surplus_iter;
                    cons_surplus_no_error_cf{t, nfc} = cons_surplus_no_error_iter;
                    expmu_cf{t, nfc} = expmu_iter;
                    carrier_profit_cf{t, nfc} = carrier_profit_iter;
                    oem_profit_cf{t, nfc} = profit_iter;
                    flag_cf(t, nfc) = flag_iter;
                    carrier_ind_cf{t, nfc} = carrier_ind_iter;
                    oem_ind_cf{t, nfc} = oem_ind_iter;
                    fc_mean_cf{t, nfc} = fc_mean_iter;
                    p_sim_cf{t, nfc} = p_sim_iter;
                    w_sim_cf{t, nfc} = w_sim_iter;
                    share_sim_cf{t, nfc} = share_sim_iter;
                    
                end
            end
            
        elseif ismember(counterfactual, {'test_two_prod_deviations'})
            oem_list = cell(n_oem, 1);
            for no = 1 : n_oem
                oem_list(no) = unique(oem(oem_ind(:, no)));
            end
            
            setup_t.BR_method = 'test_two_prod_deviations';
            var_from_file = load(filename_for_checking_2prod_deviation, ...
                'counterfactual', 'config_cf', 'binary_prod_t', ...
                'full_prod_t', 'fixed_prod_t', ...
                'firm_seq_cf', 'top_n_merge', 'top_seq', 'brand_option',  ...
                'use_potential_prod');
            
            if ismember(var_from_file.counterfactual, {'merge_2_firms_seq1','merge_2_firms_seq2','merge_2_firms_simultaneous'})
                
                setup_t.merge = true;
                
                merger_pairs = cell(n_potential, 1);
                
                for nfc = 1 : n_draws_fc
                    k = 0;
                    for no1 = 1 : (var_from_file.top_n_merge-1)
                        for no2 = no1+1 : var_from_file.top_n_merge
                            k = k + 1;
                            
                            if top_n_merge > 2 && k == 1
                                continue;
                            end
                            
                            setup_t.merge_id = [var_from_file.top_seq(no1), var_from_file.top_seq(no2)];
                            disp(['two product deviation check on counterfactual ', var_from_file.counterfactual{1}, '; fixed cost draw: ', num2str(nfc), 'merger No. ', num2str(k)]);
                            
                            [binary_prod_kt, ~, ...
                                full_prod_kt, ~, fixed_prod_kt] =...
                                ...
                                merger_change_brand(...
                                t, ...
                                var_from_file.binary_prod_t, var_from_file.config_cf{t, nfc, k}.binary, ...
                                var_from_file.full_prod_t, var_from_file.config_cf{t, nfc, k}.full, ...
                                var_from_file.brand_option, setup_t.merge_id, para_linear_est, dim_demand_brandtime,...
                                mc_param, dim_mc_brand, key_oem_ind, var_from_file.fixed_prod_t);
                            
                            
                            [config_binary_new, config_full_new] =...
                                ...
                                prod_equi_swap(...
                                ...
                                var_from_file.config_cf{t, nfc, k}.binary, binary_prod_kt, var_from_file.config_cf{t, nfc, k}.full,...
                                full_prod_kt, fixed_prod_kt, x_rand, var_from_file.firm_seq_cf, ...
                                sim_pcoeff, sim_qcoeff, sim_rand, ...
                                mc_param_q, nfc, n_carrier, ...
                                max_iter_count, n_top_gap, setup_t, ...
                                starting_point_option);
                            
                            if ~isequal(config_binary_new, var_from_file.config_cf{t, nfc, k}.binary) || ...
                                    ~isequal(config_full_new, var_from_file.config_cf{t, nfc, k}.full)
                                error(['two product deviation test failed, merger between ', ...
                                    [oem_list{setup_t.merge_id(1)}, ' and ', oem_list{setup_t.merge_id(2)}], '\n']);
                            else
                                fprintf(['two product deviation test passed, merger between ',...
                                    [oem_list{setup_t.merge_id(1)}, ' and ', oem_list{setup_t.merge_id(2)}], '\n']);
                            end
                        end
                    end
                end
            end

        end

    end
    save(char(counterfactual));
end
