# Find MLE estimates in a Logit Model with inertia, 
# and data in 2 separate product-level and consumer-level matrices

# in this version, the probability of inertia is given by a maximizing attention allocation choice

# declare parameters

# 0. pure parameters

param NP;
param NT;
param NALT;
param NCS;
param Pvarn;
param Cvarn;
param NInt;

set NPs := 1..NP;
set NTs := 1..NT;
set NCSs := 1..NCS;

set ALTs := 1..NALT;
set PVars := 1..Pvarn;
set CVars := 1..Cvarn;
set Ints := 1..NInt;

# 1. choices
param DataChoice {i in NCSs};
param PInc {i in NCSs};

# 1.1 time indices
param TT {i in NCSs};

# 2. covariates
param XC {i in NCSs, x in CVars};
param XP {a in ALTs, t in NTs, x in PVars};
param CFcn {i in NCSs};

# 2.1 DM's home alternative
param CHalt {i in NCSs};

# 3. Interactions
param Int {x in PVars, y in CVars};

# 3.1 Home Bias Interactions
param HomebInt {c in CVars};

# 4. Switches
param T1 {t in NCSs};
param T2 {t in NCSs};
param T3 {t in NCSs};

param nT2;


# 5. Starting Pts
param startP {b in PVars};
param startC {b1 in PVars, b2 in CVars};
param startHbi {b in CVars};
param startH;
param startFE {j in ALTs};
param startFE_CFcn {j in ALTs};
param startp;
param startmu;
param starts;

# declare variables
var betaP {b in PVars} >=-100, <=100;
var betaC {b1 in PVars, b2 in CVars} >=-100, <=100;
var betaHbi {c in CVars} >=-100, <=100;
var homeb >=-100, <=100;
var FE {j in ALTs} >=-100, <=100;
var FE_CFcn {j in ALTs} >=-100, <=100;
var pi {c in NCSs: T1[c] = 0} >=0, <=1;
var mu >= -100, <=100;
var sigma >=0, <=100;

var lambda1 >= -100, <=100;
var lambda2 >= -100, <=100;

# define LogLik
maximize LogLikelihood:  
 sum{s in NCSs: T3[s] = 0} (sum{x in PVars} (XP[DataChoice[s],TT[s],x]*betaP[x]) + sum{x in PVars, y in CVars} (XP[DataChoice[s],TT[s],x]*XC[s,y]*Int[x,y]*betaC[x,y]) + FE[DataChoice[s]] + FE_CFcn[DataChoice[s]]*(CFcn[s]+lambda1*CFcn[s]^2 + lambda2*CFcn[s]^3 ) + (homeb + (sum{c in CVars} betaHbi[c] * HomebInt[c]*XC[s,c]))*(if DataChoice[s] = CHalt[s] then 1 else 0)) 
 - sum{s in NCSs}log( sum{j in ALTs}(exp (sum{x in PVars} (XP[j,TT[s],x]*betaP[x]) + sum{x in PVars, y in CVars} (XP[j,TT[s],x]*XC[s,y]*Int[x,y]*betaC[x,y])+ FE[j] + FE_CFcn[j]*(CFcn[s]+lambda1*CFcn[s]^2 + lambda2*CFcn[s]^3 ) + (homeb + (sum{c in CVars} betaHbi[c] * HomebInt[c]*XC[s,c]))*(if j = CHalt[s] then 1 else 0) ) )) 
 +  sum{s in NCSs: T3[s] = 1}(log( pi[s] * exp(sum{x in PVars} (XP[DataChoice[s],TT[s],x]*betaP[x]) + sum{x in PVars, y in CVars} (XP[DataChoice[s],TT[s],x]*XC[s,y]*Int[x,y]*betaC[x,y])  + FE[DataChoice[s]]  + FE_CFcn[DataChoice[s]]*(CFcn[s]+lambda1*CFcn[s]^2 + lambda2*CFcn[s]^3 ) + (homeb + (sum{c in CVars} betaHbi[c] * HomebInt[c]*XC[s,c]))*(if DataChoice[s] = CHalt[s] then 1 else 0)) + (1-pi[s])*(sum{j in ALTs}(exp(sum{x in PVars} (XP[j,TT[s],x]*betaP[x]) + sum{x in PVars, y in CVars} (XP[j,TT[s],x] * XC[s,y]*Int[x,y]*betaC[x,y])+ FE[j] + FE_CFcn[j]*(CFcn[s]+lambda1*CFcn[s]^2 + lambda2*CFcn[s]^3 ) + (homeb + (sum{c in CVars} betaHbi[c] * HomebInt[c] * XC[s,c]))*(if j = CHalt[s] then 1 else 0) ))))) 
 + sum{s in NCSs: T2[s] = 1}log(pi[s]);

subject to

picons2 {s in 1..NCS: T1[s] = 0}: pi[s] = ((1 + exp((mu - (log( sum{j in ALTs}(exp (sum{x in PVars} (XP[j,TT[s],x]*betaP[x]) + sum{x in PVars, y in CVars} (XP[j,TT[s],x]*XC[s,y]*Int[x,y]*betaC[x,y])+ FE[j] + FE_CFcn[j]*(CFcn[s]+lambda1*CFcn[s]^2 + lambda2*CFcn[s]^3 ) + (homeb + (sum{c in CVars} betaHbi[c] * HomebInt[c]*XC[s,c]))*(if j = CHalt[s] then 1 else 0) ) )) - (sum{x in PVars} (XP[PInc[s],TT[s],x]*betaP[x]) + sum{x in PVars, y in CVars} (XP[PInc[s],TT[s],x]*XC[s,y]*Int[x,y]*betaC[x,y]) + FE[PInc[s]] + FE_CFcn[PInc[s]]*(CFcn[s]+lambda1*CFcn[s]^2 + lambda2*CFcn[s]^3 ) + (homeb + (sum{c in CVars} betaHbi[c] * HomebInt[c] * XC[s,c]))*(if PInc[s] = CHalt[s] then 1 else 0)) ))/sigma)) ^ (-1));

# delta i,j*(i,t),t for choice situation (i,t)=s is:
# sum{x in PVars} (XP[DataChoice[s],TT[s],x]*betaP[x]) + sum{x in PVars, y in CVars} (XP[DataChoice[s],TT[s],x]*XC[s,y]*Int[x,y]*betaC[x,y]) + FE[DataChoice[s]];

# delta j,a,t for choice situation (i,t)=s is:
# sum{x in PVars} (XP[j,TT[s],x]*betaP[x]) + sum{x in PVars, y in CVars} (XP[j,TT[s],x]*XC[s,y]*Int[x,y]*betaC[x,y]) + FE[j];

# Name the problem
problem LogLikMax: 

# Choose the objective function
LogLikelihood,

# List the variables
betaP, betaC, betaHbi, homeb, FE, FE_CFcn, mu, pi, sigma, lambda1, lambda2,

#list constraints
picons2;