/*********************************************************************
Table 2:
	Column (1), (2)
*********************************************************************/

use leads_hygiene_alert, clear

gen post = (month>=0)
gen postXalert = post*alert

tab rating, missing
gen rating_cat = 0 if (rating==.)
replace rating_cat = 1 if rating < 3
replace rating_cat = 2 if rating==3 | rating==3.5
replace rating_cat = 3 if rating>=4 & rating~=.
tab rating_cat, missing

tab price, missing
replace price = 0 if price == .

gen time = month

xtset business_id month

xi i.rating_cat*time i.price*time

** NOTE: the variable "lnleads" is removed from the data due to the data agreement with Yelp **
eststo clear
	xtreg leads_n postXalert post time _IpriX* _IratX*, fe cluster(business_id)
eststo reg1
	xtreg lnleads postXalert post time _IpriX* _IratX*, fe cluster(business_id)
eststo reg2
esttab using result.csv, star(* 0.10 ** 0.05 *** 0.01) nomtitles nogap replace csv se drop(_I*X*)



/*********************************************************************
Table 2:
	Column (3), (4)
*********************************************************************/

use reviews_hygiene_alert, clear

gen post = (month>=0)
gen postXalert = post*alert

tab rating, missing
gen rating_cat = 0 if (rating==.)
replace rating_cat = 1 if rating < 3
replace rating_cat = 2 if rating==3 | rating==3.5
replace rating_cat = 3 if rating>=4 & rating~=.
tab rating_cat, missing

tab price, missing
replace price = 0 if price == .

gen time = month


xi i.rating_cat*time i.price*time

xtset business_id month

** NOTE: the variable "lnnum_rev" is removed from the data due to the data agreement with Yelp **
eststo clear
	xtreg num_rev_n postXalert post time _IpriX* _IratX*, fe cluster(business_id)
eststo reg1
	xtreg lnnum_rev postXalert post time _IpriX* _IratX*, fe cluster(business_id)
eststo reg2
esttab using result.csv, star(* 0.10 ** 0.05 *** 0.01) nomtitles nogap replace csv se drop(_I*X*)



/*********************************************************************
Table 2:
	Column (5), (6)
*********************************************************************/

use orders_hygiene_alert, clear

gen post = (month>=0)
gen postXalert = post*alert

tab rating, missing
gen rating_cat = 0 if (rating==.)
replace rating_cat = 1 if rating < 3
replace rating_cat = 2 if rating==3 | rating==3.5
replace rating_cat = 3 if rating>=4 & rating~=.
tab rating_cat, missing

tab price, missing
replace price = 0 if price == .

gen time = month

xtset business_id month

xi i.rating_cat*time i.price*time

** NOTE: the variable "lnnum_order" is removed from the data due to the data agreement with Yelp **
eststo clear
	xtreg num_order_n postXalert post time _IpriX* _IratX*, fe cluster(business_id)
eststo reg1
	xtreg lnnum_order postXalert post time _IpriX* _IratX*, fe cluster(business_id)
eststo reg2
esttab using result.csv, star(* 0.10 ** 0.05 *** 0.01) nomtitles nogap replace csv se drop(_I*X*)



/*********************************************************************
Figure 5
*********************************************************************/

*********************** LEADS *************************

use leads_hygiene_alert_weekly, clear

collapse (mean) leads_mean = leads_n ///
	(sd) leads_sd = leads_n ///
	(count) ct_leads = leads_n, ///
	by(week alert)

local outcome "leads"
foreach X of local outcome {
	generate h_`X' = `X'_mean + `X'_sd/sqrt(ct_`X')
	generate l_`X' = `X'_mean - `X'_sd/sqrt(ct_`X')
}


** PLOT **

tsset alert week

#delimit ;
twoway
	(tsline leads_mean if alert == 0, lpattern(shortdash) lc(gs5) lw(medthick))
	(tsline leads_mean if alert == 1, lpattern(longdash_dot) lc(gs0) lw(medthick))
	(rcap h_leads l_leads week if alert == 0, lc(gs3) lw(vthin))
	(rcap h_leads l_leads week if alert == 1, lc(black) lw(vthin))
	,
	xline(0, lwidth(thin) lcolor(red))
	legend(order(1 "Businesses (Score>70)" 2 "Businesses (Score<=70)") size(medsmall))
	ytitle("Standardized Counts", size(medsmall))
	tlabel(-16(4)28, labsize(small))
	ylabel(-0.2(0.1)0.1, labsize(small))
	xtitle("")
	xscale(lw(medium)) yscale(lw(medium))
	graphregion(fcolor(white));
#delimit cr
graph export "Fig5_A.eps", replace



*********************** # of REVIEWS *************************

use reviews_hygiene_alert_weekly, clear

collapse (mean) num_rev_mean = num_rev_n ///
	(sd) num_rev_sd = num_rev_n  ///
	(count) ct_num_rev = num_rev_n , ///
	by(week alert)

local outcome "num_rev"
foreach X of local outcome {
	generate h_`X' = `X'_mean + `X'_sd/sqrt(ct_`X')
	generate l_`X' = `X'_mean - `X'_sd/sqrt(ct_`X')
}

** PLOT **
tsset alert week

#delimit ;
twoway
	(tsline num_rev_mean if alert == 0, lpattern(shortdash) lc(gs5) lw(medthick))
	(tsline num_rev_mean if alert == 1, lpattern(longdash_dot) lc(gs0) lw(medthick))
	(rcap h_num_rev l_num_rev week if alert == 0, lc(gs3) lw(vthin))
	(rcap h_num_rev l_num_rev week if alert == 1, lc(gs0) lw(vthin))
	,
	xline(0, lwidth(thin) lcolor(red))
	legend(order(1 "Businesses (Score>70)" 2 "Businesses (Score<=70)") size(medsmall))
	ytitle("Standardized Counts", size(medsmall))
	ylabel(-0.3(0.1)0.1, labsize(small))
	tlabel(-16(4)28, labsize(small))
	xtitle("")
	xscale(lw(medium)) yscale(lw(medium))
	graphregion(fcolor(white));
#delimit cr
graph export "Fig5_B.eps", replace


*********************** # of ORDERS *************************

use orders_hygiene_alert_weekly, clear

collapse (mean) num_order_mean = num_order_n ///
	(sd) num_order_sd = num_order_n  ///
	(count) ct_num_order = num_order_n , ///
	by(week alert)

local outcome "num_order"
foreach X of local outcome {
	generate h_`X' = `X'_mean + `X'_sd/sqrt(ct_`X')
	generate l_`X' = `X'_mean - `X'_sd/sqrt(ct_`X')
}

** PLOT **
tsset alert week

#delimit ;
twoway
	(tsline num_order_mean if alert == 0, lpattern(shortdash) lc(gs5) lw(medthick))
	(tsline num_order_mean if alert == 1, lpattern(longdash_dot) lc(gs0) lw(medthick))
	(rcap h_num_order l_num_order week if alert == 0, lc(gs3) lw(vthin))
	(rcap h_num_order l_num_order week if alert == 1, lc(gs0) lw(vthin))
	,
	xline(0, lwidth(thin) lcolor(red))
	legend(order(1 "Businesses (Score>70)" 2 "Businesses (Score<=70)") size(medsmall))
	ytitle("Standardized Counts", size(medsmall))
	ylabel(-0.3(0.1)0.6, labsize(small))
	tlabel(-16(4)28, labsize(small))
	xtitle("")
	xscale(lw(medium)) yscale(lw(medium))
	graphregion(fcolor(white));
#delimit cr
graph export "Fig5_C.eps", replace
