clear;
clc;

addpath(strcat(pwd,'/REProgram')); 
addpath(strcat(pwd,'/My_file')); 
%% Parameters:

betas=(1/(1 + .015)); % Saver Discount Factor 

phi=0.0078; %Spread Parameters

BH= .9773; %High Debt
BL=.78; % Low Debt
Bt1 = 1.0773; % Debt to GDP
Y=1;


%% Steady State
RSss=1/betas;
betab= betas * 1/(1 + phi * (Bt1 - BH ) );
Bt2 = ((betas/betab ) -   1 + phi *BL)/phi;
Ctb1 =.5*Y -   Bt1 * (1 - 1/(RSss * (1 + phi * (BH - Bt1))) ); 
Ctb2 =.5*Y -   Bt2 * (1 - 1/(RSss * (1 + phi * (BL - Bt2))) ) ;
Cts1 =Y -Ctb1 ; 
Cts2 =Y -Ctb2 ;

%% Transition
v.B   = Bt1;
v.BB  = BH;
v.betab =betab;
v.Cb  = Ctb1;
v.Rb = 1/v.betab;
v.phi= phi;
v.betas= betas;
[A B C  Indicator_Variables NY NX NK ]= M(v);
 C(end,end)=BL-BH;

 reds;
 solds;
 
x0=[0;BL-BH];

Irf=irf_fede(100,D(1:NY-NK,:), G, x0);
Irfn=[zeros(NY-NK,1) Irf(1:NY-NK,:);zeros(NK,1) Irf(NY-NK+1:end,:)];


Irfn=[Irfn(1:2,:);
       Irfn(3,:)+betab/betas*phi*(Irfn(end-1,:)-Irfn(end,:));
       Irfn(3:end,:)];
   Irfn(3,:)=(Irfn(3,:)/betab + 1/betab-1);
   Irfn(4,:)=(Irfn(4,:)/betas + 1/betas-1);
   Irfn(5,:)=(Irfn(5,:) + v.B);
   Irfn(6,:)=(Irfn(6,:)+v.BB);
%% Graph   
t={'$C$','$r$','$b^{gdp}$','$\bar{b}^{gdp}$'};
color=lines(20);
Tirf=31;
fig = figure(1);
fig.Position = [1, 1, 1500, 700];


subplot(2,2,1)
title(t{1},'interpreter','LaTex','FontSize',16)
hold on
h1(1,:)=plot(0:Tirf-1,Irfn(1,1:Tirf)*100,'Color',color(1,:),'LineWidth',1.5);
h1(2,:)=plot(0:Tirf-1,Irfn(2,1:Tirf)*100,'--','Color',color(2,:),'LineWidth',1.5);
plot(0:Tirf-1,zeros(Tirf,1),'r','LineWidth',1.5)

hold off
xlabel('$Quarters$','interpreter','LaTex','FontSize',16)
subplot(2,2,2)
title(t{2},'interpreter','LaTex','FontSize',16)
hold on
h1(1,:)=plot(0:Tirf-1,Irfn(3,1:Tirf)*100,'Color',color(1,:),'LineWidth',1.5);
h1(2,:)=plot(0:Tirf-1,Irfn(4,1:Tirf)*100,'--','Color',color(2,:),'LineWidth',1.5);
plot(0:Tirf-1,ones(Tirf,1)*(1/betas -1)*100,'r','LineWidth',1.5)
plot(0:Tirf-1,ones(Tirf,1)*(1/betab -1)*100,'r','LineWidth',1.5)  
hold off
xlabel('$Quarters$','interpreter','LaTex','FontSize',16)
subplot(2,2,3)
title(t{3},'interpreter','LaTex','FontSize',16)
hold on
plot(0:Tirf-1,Irfn(5,1:Tirf)*100,'Color',color(1,:),'LineWidth',1.5)
plot(0:Tirf-1,ones(Tirf,1)*v.B*100,'r','LineWidth',1.5)     
xlabel('$Quarters$','interpreter','LaTex','FontSize',16)

sh=subplot(2,2,4);
p=get(sh,'position');
     lh=legend(sh,[h1(1,:) h1(2,:)],{'Borrowers ' 'Savers'},'Interpreter','LaTex','FontSize',16);
     set(lh,'position',p);
     axis(sh,'off'); 
   