

function[A B C A_nzlb B_nzlb B_zlb Indicator_Variables NY NX NK ]= Matrix_build_Inflation(var)%% Dimensions:

%% Legend:
% c_s = c^s_t
% c_b = c^b_t
% y__= y
% pi_ = \pi_t
%i_s=i_t^s
%i_b = i_t^b
%b_b= b
%l_1=\lambda_1
%l_2=\lambda_2
%l_3=\lambda_3
%l_4=\lambda_4
%l_5=\lambda_5
%l_6=\lambda_6
%l_7=\lambda_7
%c_r= c_t^R
%i_s=i^ss_t
% d_t=d_t



%% Indicator
% CONTROLS ARE in t and t+1
% ENDOGENOUS STATES are in t-1 and t
% EXOGENOUS STATES are in t and t+1
Indicator_Controls=['c_s','c_b','y__','pi_','i_b','i_s','r_n'];
Indicator_En_States=['b_b','bgd'];
Indicator_Ex_States=['iss','d_t'];

Indicator_Variables=[Indicator_Controls,Indicator_En_States,Indicator_Ex_States];

%% Dimensions
NY=length(Indicator_Variables)/3;
NX=length(Indicator_Ex_States)/3;
NK=NX+length(Indicator_En_States)/3;

%% Give the numbers

for i=0:length(Indicator_Variables)/3-1
eval(['ind_' Indicator_Variables(3*i+1:3*(i+1)) '=' num2str(i+1) ]);
eval(['ind_' num2str(i+1) '=' num2str(i+1) ]);

end

%% Initialize the Matrices
A=zeros(NY,NY);
B=zeros(NY,NY);
C= zeros(NY,NX);
%% Equations:

% Eq. 1- Resource Constraint:

%  0 = y_t - chi *c_t^b - (1-chi) * c_t^s
B(ind_1, ind_y__)= 1 ;
B(ind_1,ind_c_b) = - var.chi;
B(ind_1, ind_c_s)= - ( 1 - var.chi);

%%

% Eq. 2 Euler borrowers:

% c_{t+1}^b + sigma* pi_{t+1} - sigma lambda b_t= c_t^b + sigma i_t^b - sigma lambda b_t 

A(ind_2, ind_c_b) = 1;
A(ind_2, ind_pi_) = var.sigma;
A(ind_2,ind_b_b)  = - var.sigma * var.nu;

B(ind_2,ind_c_b) = 1;
B(ind_2,ind_i_b) = var.sigma;
B(ind_2,ind_d_t) = - var.sigma *var.nu;



%% 

% Eq.3 Euler Savers:

% c_{t+1}^s + sigma pi_{t+1}= c_t^s + sigma i_t^s

A(ind_3, ind_c_s) = 1;
A(ind_3, ind_pi_) = var.sigma;

B(ind_3,ind_c_s) = 1;
B(ind_3,ind_i_s)= var.sigma;

%% 

%  Borrowers B.c.

% b/(1+i) (b_t)= c_t^b + b/(1 +i) i_t^b + b/Pi( b_{t-1} -  pi_t) - y_t

A(ind_4,ind_b_b) =var.b/ var.i_bar;

B(ind_4,ind_c_b)= 1;
B(ind_4,ind_i_b)= var.b/var.i_bar;
B(ind_4,ind_b_b)= var.b/var.Pi_bar;
B(ind_4,ind_pi_)= - var.b/var.Pi_bar;
B(ind_4,ind_y__)= -1;



%%

% Spread

% phi *b_t= i_t^b -i_t^s + phi * d_t

A(ind_5, ind_b_b) = var.phi;

B(ind_5,ind_i_b)= 1;
B(ind_5,ind_i_s)= -1;
B(ind_5, ind_d_t)= var.phi ;

%%

% AS:

% beta * pi_{t+1}= pi_t - k *y_t

A(ind_6,ind_pi_) = var.beta;

B(ind_6,ind_pi_)= 1;
B(ind_6,ind_y__)= - var.k;


%% Policy Function:

% Inflation Target:

% 0=pi_t-pi


B(ind_7, ind_pi_)=1;

%%

% Debt over GDP process

% b_t - bgd =  b/Y y_t

A(ind_8,ind_b_b)=var.chi*var.b;
A(ind_8,ind_bgd)= -1;

B(ind_8,ind_y__)=var.chi * var.b;

%% 

% Natural rate

% - chi*(phi + lambda) b_t= r_t^n + chi*(phi + lambda) d_t

A(ind_9,ind_b_b)=  var.chi* (var.phi + var.nu);

B(ind_9,ind_d_t)=  var.chi* (var.phi + var.nu);
B(ind_9,ind_r_n)= -  1;


%%

% Interest rate:

% i_{t+1}^ss=0

A(ind_10,ind_iss)=1;

%%



% Target level:

% d_{t+1}= d_t

A(ind_11,ind_d_t)=1;

B(ind_11,ind_d_t)=1;

%% New equations:

A_nzlb=A;
B_nzlb=B;

B_zlb=B_nzlb;
B_zlb(ind_7,:)=0;
%%

% Equation zlb:

% 0= i_t^s-i_t^{ss}
B_zlb(ind_7,ind_i_s)= 1;
B_zlb(ind_7,ind_iss)= -1;



