clear;
clc;
close all
%% MASTER CODE:
% to use together with:
% reds and solds from Woodford website;
% 1. Steady_State;
% 2. Matrix_build_Inflation;
% 3. Time_Matrices_b
% 4. Irf_fede
%% NAME and add path
addpath(strcat(pwd,'/REProgram')); 
addpath(strcat(pwd,'/Myfile')); 


%% Exogenous Parameters

Tirf=30;% 


%% Exogenous Parameters

var.Target=[1.0773*4;.88*4]; % Debt over GDP
var.eta=1.; % Labor Disutility
var.rho= 1.5; % Relative Risk Aversion
var.sigma=1/var.rho; % Inverse of Relative Risk Aversion
var.k=.02;
var.chi= 0.61; % Portion of Borrowers
var.Pi_bar = 1 + 0.02/4; % Inflation
var.beta=(1/(1 + .015/4)); % Discount Factor

var.i_bar= var.Pi_bar/var.beta; % Nominal Interest Rate
var.theta= 7.88; % Elasticity


Sim_d={'oe','o0','ie','p'};

Span=1000;

%% TIME FOR THE SIMULATION IN THE GRAPH



%% TIME 
% T is the time in which the shock on the safe level of the debt, d_t, hit
% the economy
% T_1+1 is the time in which the economy enter in zlb, T_2+1 is the time in which
% economy exit from zlb
var.T=1;
var.T_1=0;%% TIME IN WHICH ECONOMY ENTER IN ZLB


%% STEADY STATE

%% LEAVE AFTER

for ii=1:4
    
    Sim=Sim_d(ii);
    [var] = Steady_State(var);
    var.b= var.D_b(1)/var.Y_bar;
var.nu=.159*var.b^(-1);%1.*var.phi;
var.phi=0.055*var.b^(-1);

%% Intermediate Parameters
%% SHOCK
if var.T>0
var.v= (var.D_b(2)-var.D_b(1))/(var.Y_bar);

else
    var.v=0;
end
if strcmp('o',Sim)
C_b_r=  (var.C_b(2) -var.C_b(1))/var.Y_bar;
C_s_r=  (var.C_s(2) -var.C_s(1))/var.Y_bar;
var.epsilonc= C_b_r - C_s_r;% Shock on consumption
end




%% BUILD THE MATRIX AND THE INDEX
if strcmp('o',Sim)
[A B C NY NK NX A_nzlb B_nzlb B_zlb Indicator_Variables]= Matrix_Build_optimal(var);
var.T_2=25; %% TIME IN WHICH ECONOMY EXIT (INCLUDED)
legend_label{ii}='O.p.';

elseif strcmp('p',Sim)
    legend_label{ii}='IT in benchmark imposing  ZLB';
[A B C A_nzlb B_nzlb B_zlb Indicator_Variables NY NX NK ]= Matrix_build_Inflation(var);
var.T_2=12; %% TIME IN WHICH ECONOMY EXIT (INCLUDED)
elseif strcmp('o0',Sim)
    legend_label{ii}='IT in  benchmark  without  ZLB';
   
    
   [A B C A_nzlb B_nzlb B_zlb Indicator_Variables NY NX NK ]= Matrix_build_Inflation(var);
var.T_2=0; %% TIME IN WHICH ECONOMY EXIT (INCLUDED)
elseif strcmp('oe',Sim)
    legend_label{ii}='IT in NK  without  ZLB';
    load('N_r')
[A B C A_nzlb B_nzlb B_zlb Indicator_Variables NY NX NK ]= Matrix_build_inflation_EW(var);
var.T_2=0;
else
    legend_label{ii}='IT in NK imposing ZLB';
    load('N_r')
[A B C A_nzlb B_nzlb B_zlb Indicator_Variables NY NX NK ]= Matrix_build_inflation_EW(var);
var.T_2=7;
end
%% Indicator
% You find the meaning inside Matrix_Build_Inflation
for i=0:length(Indicator_Variables)/3-1
eval(['ind_', Indicator_Variables(3*i+1:3*(i+1)) '=' num2str(i+1) ]);

end      
       
       
%% WOODFORD      
reds;
solds;


%% Drop the imaginary part

if abs( max(max(imag(D)))) < 10^(-13)
    D=real(D);
end

if abs(max(max(imag(G)))) < 10^(-13)
    G=real(G);
end


%% Build exogenous process

NC=  NY - NK; % # of controls
NE = NK - NX; % # of endogenous state;
NZ = NX; % # of exogenous state


%% Built the matrices:

M_z= zeros(NZ,NZ);
if strcmp('o',Sim)||strcmp('o0',Sim)||strcmp('p',Sim)
M_z(ind_d_t - NC -NE ,ind_d_t - NC -NE)=1;
end
%% Check:

M_z_1= G(NE+1:end,NE+1:end);

if max(max(abs(M_z_1-M_z)))>10^(-6)
    M_z=M_z_1;
end

%% 2. Exogenous State shock
if strcmp('o',Sim)||strcmp('o0',Sim)||strcmp('p',Sim)
NS = 3; % #s of shocks NS<=NZ
else
    NS1= length( find (abs ( N_r(2:end) )> 10^(-5) )) ;
    NS =NS1 + 1; % #s of shocks NS<=NZ
end

if strcmp('o',Sim)||strcmp('o0',Sim)||strcmp('p',Sim)
    for i = 1:NS
    eval(['M_' num2str(i) '=  zeros(NZ,1)' ]);
    end
M_1(ind_d_t - NC -NE,1)= var.v; % for z
M_2(ind_iss - NC -NE,1)= - log(var.i_bar); % for i_bar
if strcmp('o',Sim)
M_3(ind_c_r - NC -NE,1)=var.epsilonc; % for i_bar
end 
M = [M_1 M_2 M_3];

else
    M=zeros(NZ,NS);
M(ind_r_n- NC -NE,1:NS-1)=N_r(2:NS);
M(ind_iss - NC -NE,NS)= - log(var.i_bar); % for i_bar
end



% NB:
% It is important that shock and end of the shock are in the same position:
% If the process for the shock of deleverage is defined in column 1 in
% matrix M THEN time at which the process end should be in position 1 in
% vector time_M
if strcmp('o',Sim)||strcmp('o0',Sim)||strcmp('p',Sim)
   
time_M= zeros(size(M,2),2);
time_M(1,1)= var.T; % Time at which shock for deleverage ends (included)
time_M(2,1)= var.T_1;% Time at which shock for zlb starts (included)
time_M(2,2)= var.T_2;% Time at which shock for zlb ends (included)
if strcmp('o',Sim)
 time_M(3,1)= 1;% Time at which shock for zlb ends (included)
end
else
    time_Md= [0:NS-2 var.T_1 ; 1:NS-1 var.T_2];
time_M=time_Md';
end
%% Build the endogenous process:
% Since we define the matrix for ex. state we should re-write matrix A and
% B. Notice that contrained and unconstrained economy have the same A
% matrix while they have different B matrices. Then we should define
% B_tilde matrix as a 3-dimensional matrix. The first matrix (:,:,1) is the
% B matrix from zlb where we leave the equations for the ex. state, hence B
% has dimension NC+NE*NY the second  matrix (:,:,2) is the B outside the
% zlb, again this matrix has dimesion NC+NE * NY.

%% A
A_tilde = A_nzlb (1 : end-NZ ,1 : end-NZ);
%% B
B_tilde = NaN(NC+NE,NY,2);
B_tilde(:,:,1) = B_nzlb ( 1:end -NZ,:);
B_tilde(:,:,2) = B_zlb ( 1:end -NZ,:);
B_tilde(:,:,3) = B_nzlb ( 1:end -NZ,:);

%% Coefficients:
% Outside zlb we KNOW the coefficients for the end. variables processes.
% They are the output of reds and solds and also the basis to build the new
% coefficients. Hence we store them

D_tilde = D(1:NC, :);
G_tilde = G(1:NE , :);

g_x = G_tilde(: , 1:NE);
g_z = G_tilde(: , NE+1:end) * M_z;

h_x = D_tilde(: , 1:NE);
h_z = D_tilde(: , NE+1:end) * M_z;

%% Time_mat
% Imagine to have 1 break in the system of equation, this means that a
% certain time T* the economy pass from a system of equation to another.
% Then Time_Matrix should be defined as 1st position 0 (time1-1), 2nd
% position T*-1 (because you have to write the moment when the old system is still active)
% 3rd position S where S is the time in which simulation end. If you have
% more than one break (imagine T_1* and T_2*) and you know that T_1*<=T_2*
% then Time_mat=[0,T_1*,T_2*,S].

S = 1000; % Last period


Time_Mat= NaN(size(B_tilde,3)+1,1);
Time_Mat(1)= 0;
Time_Mat(2)= var.T_1;
Time_Mat(3)= var.T_2;
Time_Mat(4)= S;

%% Time_Matrices and Irf_fede 
% Description are inside the code, i compare the code with WOODFORD toolbox
% in case of 1 period shock
[F_1 F_2 V_1 V_2 M_tilde H_shock g_shock]= Time_Matrices(A_tilde,B_tilde, NZ,NC,NE,...
    M,time_M,S,h_x,h_z,g_x,g_z,Time_Mat,M_z);
y0=zeros(NC,1);
z0=zeros(NZ,1);
x0=zeros(NE,1);

Irf_d= Irf_fede(H_shock ,g_shock, M_tilde, NC,NE,NX,F_1,F_2,V_1,V_2,M_z,S,x0,z0);
Dummy=NaN(size(Irf_d,1),size(Irf_d,2)+1);
Dummy(:,2:end)=Irf_d(:,1:end);
Dummy(:,1)=[y0;x0;z0];
Irf_d=Dummy;

%% CHANGE THE VARIABLES 
% We need to have the debt level


%% New Variables:
% We want to have the inflation and interest rate target
log_Steady_state=zeros(NY,1);
log_Steady_state(ind_i_s,1)= log(var.i_bar);
log_Steady_state(ind_pi_,1)= log(var.Pi_bar);

log_Steady_State_new = log_Steady_state * ones(1,S+1);


New_Irf_d = (exp(Irf_d + log_Steady_State_new)-1)*400.*(abs((exp(Irf_d + log_Steady_State_new)-1)*400)>10.^(-10))...
    + 0.*(abs((exp(Irf_d + log_Steady_State_new)-1)*400)<10.^(-10)) ;
%% Definition
Out(:,ii)=Irf_d(ind_y__,:);
Inf(:,ii)=New_Irf_d(ind_pi_,:);
Int(:,ii)=New_Irf_d(ind_i_s,:);
R_n(:,ii)=(exp(Irf_d(ind_r_n,:)- log(var.beta))-1)*4;  

 if strcmp('p',Sim)&& var.T_2==0;
     N_r = Irf_d(ind_r_n,:);
     save N_r N_r
 end
    
end

%% GRAPH
s={'-' ,'--',':','-.' ,'--','-.'};
color=['r' 'b' 'k' 'g' 'm'];
color=lines(20);%[0. 0.4 0.2; 1 0.4 .2];
sizes=[1.5  1.5  1.5  1.5];
fig=figure(1);
fig.Position = [1, 1, 1500, 700];

subplot(2,2,1)
for ii=1:size(Out,2)
    hold on
plot(0:Tirf, Out(1:Tirf+1,ii)'*100,s{ii},'Color',color(ii,:),'LineWidth',sizes(ii))
%plot(0:Tirf,zeros(Tirf+1,1),'r','LineWidth',1.5)
hold off
end
ylabel('$\%$','Interpreter','LaTex','FontSize',16)
title('$Y$','Interpreter','LaTex','FontSize',16)
subplot(2,2,4)
for ii=1:size(Out,2)
hold on
    plot(0:Tirf, R_n(1:Tirf+1,ii)*100',s{ii},'Color',color(ii,:),'LineWidth',sizes(ii))
    
end
%plot(0:Tirf,((var.beta^(-1) -1)*400*ones(Tirf+1,1)),'r','LineWidth',1.5)
hold off
ylabel('$\%$','Interpreter','LaTex','FontSize',16)
xlabel('Quarters','Interpreter','LaTex','FontSize',16)
title('$r^n$','Interpreter','LaTex','FontSize',16)
subplot(2,2,3)
for ii=1:size(Out,2)
hold on
    plot(0:Tirf, Int(1:Tirf+1,ii)',s{ii},'Color',color(ii,:),'LineWidth',sizes(ii))
   %  plot(0:Tirf,(exp( log_Steady_State_new(ind_i_s,1:Tirf+1))-1)*400,'r','LineWidth',sizes(ii))
hold off
end
ylabel('$\%$','Interpreter','LaTex','FontSize',16)
xlabel('Quarters','Interpreter','LaTex','FontSize',16)
title('$i$','Interpreter','LaTex','FontSize',16)
subplot(2,2,2)
for ii=1:size(Out,2)
hold on
    plot(0:Tirf, Inf(1:Tirf+1,ii)',s{ii},'Color',color(ii,:),'LineWidth',sizes(ii))
  
end
  % plot(0:Tirf,(exp( log_Steady_State_new(ind_pi_,1:Tirf+1))-1)*400,'r','LineWidth',1.5)
hold off

   ylim([-.5 2.5])
title('$\pi$','Interpreter','LaTex','FontSize',16)
ylabel('$\%$','Interpreter','LaTex','FontSize',16)

legend(legend_label,'Location','SouthEast','Interpreter','LaTex','FontSize',16)
legend boxoff

 