function [var] = Steady_State(var)
%% Output
var.Y_bar= ( var.rho * exp ( - var.rho)) ^( 1 / (1 + var.eta));
%% Debt
var.D_b = var.Target' * var.Y_bar/ var.chi;
var.D_s=  - var.D_b * var.chi / (1  - var.chi);

%% Consumption
var.C_b = var.Y_bar + ( var.beta - 1)* var.D_b/var.Pi_bar;
var.C_s = var.Y_bar + ( var.beta - 1) *var.D_s/var.Pi_bar ;

if max((var.chi*var.C_b + (1-var.chi)*var.C_s- var.Y_bar*ones(size(var.chi*var.C_b + (1-var.chi)*var.C_s,1),size(var.chi*var.C_b + (1-var.chi)*var.C_s,2))))>10^(-10)
    error('Aggregation does not work')
end

%%

%% Parameters:

var.lambda_c = (var.rho * (1 + var.eta) + var.rho^2)/((1 + var.eta )*( var.eta + var.rho));
var.lambda_pi = var.theta/var.k;
