function [residual, g1, g2, g3] = Taylor_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(23, 1);
T28 = params(2)*((1-y(15))/y(10)+y(15)/y(11));
T30 = 1/y(2);
T59 = params(8)/(1-params(8));
T60 = y(14)^T59;
T73 = params(7)^(1/(1-params(8)));
T81 = y(33)^T59;
T97 = (1-(1-params(10))*y(4))^params(8);
T117 = params(16)*(1+y(37))^params(15);
T124 = params(16)*(1+y(37))^(params(15)-1);
T146 = (1+y(23))^params(15);
T172 = (y(27)/params(3))^(-1);
T178 = params(3)^params(20);
lhs =y(11);
rhs =params(1)*y(10);
residual(1)= lhs-rhs;
lhs =y(31)*(1+y(8))/(1+y(37));
rhs =1;
residual(2)= lhs-rhs;
lhs =y(9);
rhs =T28/T30;
residual(3)= lhs-rhs;
lhs =y(12);
rhs =y(16)*(exp(y(28))/y(22)-y(10))-params(9)*y(17)+params(6);
residual(4)= lhs-rhs;
lhs =y(13);
rhs =params(2)*(y(12)/y(3))^(-params(5));
residual(5)= lhs-rhs;
lhs =T60;
rhs =(1-params(11))*(exp(y(28))*y(18)-y(10)+params(12)-y(29))*T73/params(9)+(1-params(10))*y(32)*T81;
residual(6)= lhs-rhs;
lhs =y(15);
rhs =params(10)*(1-y(14));
residual(7)= lhs-rhs;
lhs =y(16);
rhs =(1-y(15))*y(4)+y(14)*(1-y(4));
residual(8)= lhs-rhs;
lhs =y(17);
rhs =((y(16)-(1-params(10))*y(4))/T97)^(1/(1-params(8)));
residual(9)= lhs-rhs;
lhs =y(19);
rhs =params(15)*(1-params(17))*y(20)/((params(15)-1)*y(21));
residual(10)= lhs-rhs;
lhs =y(20);
rhs =y(18)*y(24)+y(32)*T117*y(35);
residual(11)= lhs-rhs;
lhs =y(21);
rhs =y(24)+y(32)*T124*y(36);
residual(12)= lhs-rhs;
lhs =1;
rhs =(1-params(16))*y(19)^(1-params(15))+params(16)*(1+y(23))^(-(1-params(15)));
residual(13)= lhs-rhs;
lhs =y(22);
rhs =(1-params(16))*y(19)^(-params(15))+params(16)*y(5)*T146;
residual(14)= lhs-rhs;
lhs =y(25);
rhs =(-log(params(1)))+params(2)*(1-y(34)-y(33))*y(38);
residual(15)= lhs-rhs;
lhs =y(26);
rhs =params(9)*T60/T73;
residual(16)= lhs-rhs;
lhs =y(25)/params(18);
rhs =y(26)/params(19)*T172;
residual(17)= lhs-rhs;
lhs =y(10);
rhs =y(27)^(1-params(20))*T178;
residual(18)= lhs-rhs;
lhs =y(22)*y(24);
rhs =y(16)*exp(y(28));
residual(19)= lhs-rhs;
lhs =y(8);
rhs =params(4)+params(23)*(y(1)-params(4))+y(23)*(1-params(23))*params(24)+x(it_, 3);
residual(20)= lhs-rhs;
lhs =y(28);
rhs =params(21)*y(6)-x(it_, 1);
residual(21)= lhs-rhs;
lhs =y(29);
rhs =params(22)*y(7)+x(it_, 2);
residual(22)= lhs-rhs;
lhs =y(30);
rhs =x(it_, 3);
residual(23)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(23, 41);

  %
  % Jacobian matrix
  %

T243 = getPowerDeriv(y(12)/y(3),(-params(5)),1);
T257 = getPowerDeriv(y(14),T59,1);
T287 = getPowerDeriv((y(16)-(1-params(10))*y(4))/T97,1/(1-params(8)),1);
  g1(1,10)=(-params(1));
  g1(1,11)=1;
  g1(2,8)=y(31)/(1+y(37));
  g1(2,31)=(1+y(8))/(1+y(37));
  g1(2,37)=(-(y(31)*(1+y(8))))/((1+y(37))*(1+y(37)));
  g1(3,9)=1;
  g1(3,2)=(-((-(T28*(-1)/(y(2)*y(2))))/(T30*T30)));
  g1(3,10)=(-(params(2)*(-(1-y(15)))/(y(10)*y(10))/T30));
  g1(3,11)=(-(params(2)*(-y(15))/(y(11)*y(11))/T30));
  g1(3,15)=(-(params(2)*((-1)/y(10)+1/y(11))/T30));
  g1(4,10)=y(16);
  g1(4,12)=1;
  g1(4,16)=(-(exp(y(28))/y(22)-y(10)));
  g1(4,17)=params(9);
  g1(4,22)=(-(y(16)*(-exp(y(28)))/(y(22)*y(22))));
  g1(4,28)=(-(y(16)*exp(y(28))/y(22)));
  g1(5,3)=(-(params(2)*(-y(12))/(y(3)*y(3))*T243));
  g1(5,12)=(-(params(2)*T243*1/y(3)));
  g1(5,13)=1;
  g1(6,10)=(-(T73*(-(1-params(11)))/params(9)));
  g1(6,32)=(-((1-params(10))*T81));
  g1(6,14)=T257;
  g1(6,33)=(-((1-params(10))*y(32)*getPowerDeriv(y(33),T59,1)));
  g1(6,18)=(-(T73*exp(y(28))*(1-params(11))/params(9)));
  g1(6,28)=(-(T73*(1-params(11))*exp(y(28))*y(18)/params(9)));
  g1(6,29)=(-(T73*(-(1-params(11)))/params(9)));
  g1(7,14)=params(10);
  g1(7,15)=1;
  g1(8,14)=(-(1-y(4)));
  g1(8,15)=y(4);
  g1(8,4)=(-(1-y(15)-y(14)));
  g1(8,16)=1;
  g1(9,4)=(-((T97*(-(1-params(10)))-(y(16)-(1-params(10))*y(4))*(-(1-params(10)))*getPowerDeriv(1-(1-params(10))*y(4),params(8),1))/(T97*T97)*T287));
  g1(9,16)=(-(T287*1/T97));
  g1(9,17)=1;
  g1(10,19)=1;
  g1(10,20)=(-(params(15)*(1-params(17))/((params(15)-1)*y(21))));
  g1(10,21)=(-((-(params(15)*(1-params(17))*y(20)*(params(15)-1)))/((params(15)-1)*y(21)*(params(15)-1)*y(21))));
  g1(11,32)=(-(T117*y(35)));
  g1(11,18)=(-y(24));
  g1(11,20)=1;
  g1(11,35)=(-(y(32)*T117));
  g1(11,37)=(-(y(35)*y(32)*params(16)*getPowerDeriv(1+y(37),params(15),1)));
  g1(11,24)=(-y(18));
  g1(12,32)=(-(T124*y(36)));
  g1(12,21)=1;
  g1(12,36)=(-(y(32)*T124));
  g1(12,37)=(-(y(36)*y(32)*params(16)*getPowerDeriv(1+y(37),params(15)-1,1)));
  g1(12,24)=(-1);
  g1(13,19)=(-((1-params(16))*getPowerDeriv(y(19),1-params(15),1)));
  g1(13,23)=(-(params(16)*getPowerDeriv(1+y(23),(-(1-params(15))),1)));
  g1(14,19)=(-((1-params(16))*getPowerDeriv(y(19),(-params(15)),1)));
  g1(14,5)=(-(params(16)*T146));
  g1(14,22)=1;
  g1(14,23)=(-(params(16)*y(5)*getPowerDeriv(1+y(23),params(15),1)));
  g1(15,33)=(-(y(38)*(-params(2))));
  g1(15,34)=(-(y(38)*(-params(2))));
  g1(15,25)=1;
  g1(15,38)=(-(params(2)*(1-y(34)-y(33))));
  g1(16,14)=(-(params(9)*T257/T73));
  g1(16,26)=1;
  g1(17,25)=1/params(18);
  g1(17,26)=(-(T172*1/params(19)));
  g1(17,27)=(-(y(26)/params(19)*1/params(3)*getPowerDeriv(y(27)/params(3),(-1),1)));
  g1(18,10)=1;
  g1(18,27)=(-(T178*getPowerDeriv(y(27),1-params(20),1)));
  g1(19,16)=(-exp(y(28)));
  g1(19,22)=y(24);
  g1(19,24)=y(22);
  g1(19,28)=(-(y(16)*exp(y(28))));
  g1(20,1)=(-params(23));
  g1(20,8)=1;
  g1(20,23)=(-((1-params(23))*params(24)));
  g1(20,41)=(-1);
  g1(21,6)=(-params(21));
  g1(21,28)=1;
  g1(21,39)=1;
  g1(22,7)=(-params(22));
  g1(22,29)=1;
  g1(22,40)=(-1);
  g1(23,30)=1;
  g1(23,41)=(-1);

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],23,1681);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],23,68921);
end
end
end
end
