function [residual, g1, g2, g3] = Efficient_wage_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 45, 1);

%
% Model equations
%

T17 = params(19)^(-1);
T28 = 1/y(3);
T34 = (-1)/(y(3)*y(3));
T50 = getPowerDeriv(params(4)+y(21)*(exp(y(22))-y(3))-params(7)*y(20),(-params(3)),1);
T59 = 1/(1-params(6));
T60 = params(5)^T59;
T70 = params(6)/(1-params(6));
T71 = y(19)^T70;
T80 = (-(T60*(1-params(6))*((-1)-log(params(1)))/params(7)+(1-params(6)*y(19))*T71*T28*params(2)*(1-params(8))));
T88 = (-(T60*(-(1-params(9)))/params(7)));
T102 = params(2)*(-(1-y(8)))/(y(3)*y(3));
T104 = (-(T102/T28));
T113 = params(2)*((1-y(8))/y(3)+y(8)/y(4));
T135 = (-((1-params(6)*y(19))*T71*params(2)*(1-params(8))*(-y(3))/(y(3)*y(3))));
T145 = (-((1-y(9))*1/y(4)));
T152 = (-(params(2)*(-y(8))/(y(4)*y(4))/T28));
T162 = (-(params(16)/(1-params(3))*getPowerDeriv(y(5),1-params(3),1)));
T167 = y(7)^T70;
T177 = (1+y(16))^params(13);
T178 = params(14)*T177;
T188 = params(14)*(1+y(16))^(params(13)-1);
T200 = getPowerDeriv(y(7),T70,1);
T215 = params(2)*(1/y(4)+(-1)/y(3));
T233 = (1-y(9)*(1-params(8)))^params(6);
T236 = (y(9)-y(9)*(1-params(8)))/T233;
T237 = getPowerDeriv(T236,T59,1);
T244 = (-(exp(y(22))/y(15)-y(3)));
T255 = (-(1-params(8)))*getPowerDeriv(1-y(9)*(1-params(8)),params(6),1);
T261 = (-(T237*(T233*(-(1-params(8)))-(y(9)-y(9)*(1-params(8)))*T255)/(T233*T233)));
T278 = (-(T60*exp(y(22))*(1-params(9))/params(7)));
T279 = y(29)*T278;
T288 = (-((1-params(14))*getPowerDeriv(y(12),(-params(13)),1)));
T295 = (-((1-params(14))*getPowerDeriv(y(12),1-params(13),1)));
T305 = (-(params(13)*(1-params(15))/(y(14)*(params(13)-1))));
T319 = (-((-((params(13)-1)*y(13)*params(13)*(1-params(15))))/(y(14)*(params(13)-1)*y(14)*(params(13)-1))));
T332 = (-(y(9)*(-exp(y(22)))/(y(15)*y(15))));
T333 = y(27)*T332;
T342 = getPowerDeriv(1+y(16),params(13),1);
T349 = (-(params(14)*getPowerDeriv(1+y(16),(-(1-params(13))),1)));
T354 = (-(y(2)*(1+y(1))))/((1+y(16))*(1+y(16)));
T365 = params(14)*getPowerDeriv(1+y(16),params(13)-1,1);
T391 = getPowerDeriv(y(19),T70,1);
T419 = (1-y(21)*(1-params(8)))^params(6);
T422 = (y(21)-y(21)*(1-params(8)))/T419;
T423 = getPowerDeriv(T422,T59,1);
T429 = (-(1-params(8)))*getPowerDeriv(1-y(21)*(1-params(8)),params(6),1);
T435 = (-(T423*((-(1-params(8)))*T419-(y(21)-y(21)*(1-params(8)))*T429)/(T419*T419)));
T462 = (-(T60*exp(y(22))*(1-params(6))/params(7)));
T468 = (-(T60*(1-params(9))*exp(y(22))*y(11)/params(7)));
T471 = (-(y(9)*exp(y(22))/y(15)));
T474 = y(38)*T462+y(29)*T468+y(27)*T471;
residual(1) = y(25)*y(2)/(1+y(16));
residual(2) = y(26)+T17*y(25)*(1+y(1))/(1+y(16));
residual(3) = y(43)*(-(y(9)*T28))+y(41)*(T34-params(16)*(-y(21))*T50)+y(38)*T80+y(29)*T88+y(28)*(-(params(2)*(-y(3))/(y(3)*y(3))))+y(9)*y(27)+y(26)*T104+y(24)*(-params(1))+params(19)*y(26)*(-((-(T34*T113))/(T28*T28)))+params(19)*y(28)*(-(T28*params(2)))+T17*y(38)*T135;
residual(4) = y(43)*T145+y(24)+y(26)*T152;
residual(5) = y(27)+y(43)*T162;
residual(6) = y(28)+T17*y(29)*(-((1-params(8))*T167))+T17*y(34)*(-(y(13)*T178))+T17*y(35)*(-(y(14)*T188));
residual(7) = y(31)*(-(1-y(9)))+params(8)*y(30)+y(29)*T200+T17*y(29)*(-(T200*(1-params(8))*y(6)));
residual(8) = y(9)*y(31)+y(30)+y(26)*(-(T215/T28));
residual(9) = y(43)*(-(log(y(3))-log(y(4))))+y(42)*(-exp(y(22)))+y(32)*(-(1/T233*T237))+y(31)+y(27)*T244+params(19)*y(31)*(-(1-y(8)-y(7)))+params(19)*y(32)*T261;
residual(10) = y(32)+params(7)*y(27);
residual(11) = y(34)*(-y(17))+T279;
residual(12) = y(37)*T288+y(33)+y(36)*T295;
residual(13) = y(34)+y(33)*T305+T17*y(34)*(-(T178*y(6)));
residual(14) = y(35)+y(33)*T319+T17*y(35)*(-(T188*y(6)));
residual(15) = y(42)*y(17)+y(37)+T333+params(19)*y(37)*(-T178);
residual(16) = y(37)*(-(params(14)*y(15)*T342))+y(36)*T349+T17*y(25)*T354+T17*y(34)*(-(y(13)*y(6)*params(14)*T342))+T17*y(35)*(-(y(14)*y(6)*T365));
residual(17) = y(42)*y(15)+(-y(35))+y(34)*(-y(11));
residual(18) = 1+y(43);
residual(19) = y(40)*(-(1-y(21)+y(21)*params(8)))+y(38)*T391+T17*y(38)*(-((1-params(6)*y(19))*params(2)*(1-params(8))*T391+T71*params(2)*(1-params(8))*(-params(6))));
residual(20) = y(39)+y(41)*(-(params(16)*T50*(-params(7))));
residual(21) = y(41)*(-(params(16)*(exp(y(22))-y(3))*T50))+y(40)+y(39)*(-(1/T419*T423))+params(19)*y(39)*T435+params(19)*y(40)*(-(1-params(8)*(1-y(19))-y(19)));
residual(22) = y(44)+y(42)*(-(y(9)*exp(y(22))))+y(41)*(-(params(16)*T50*y(21)*exp(y(22))))+T474+params(19)*y(44)*(-params(17));
residual(23) = y(45)+y(29)*T88+params(19)*y(45)*(-params(18));
residual(24) = y(4)-y(3)*params(1);
residual(25) = y(2)*(1+y(1))/(1+y(16))-1;
residual(26) = y(2)-T113/T28;
residual(27) = y(5)-(params(4)+y(9)*(exp(y(22))/y(15)-y(3))-params(7)*y(10));
residual(28) = y(6)-params(2);
residual(29) = T167-(T60*(1-params(9))*(exp(y(22))*y(11)-y(3)+params(10)-y(23))/params(7)+T167*(1-params(8))*y(6));
residual(30) = y(8)-params(8)*(1-y(7));
residual(31) = y(9)-(y(9)*(1-y(8))+(1-y(9))*y(7));
residual(32) = y(10)-T236^T59;
residual(33) = y(12)-y(13)*params(13)*(1-params(15))/(y(14)*(params(13)-1));
residual(34) = y(13)-(y(17)*y(11)+y(13)*T178*y(6));
residual(35) = y(14)-(y(17)+y(14)*T188*y(6));
residual(36) = 1-((1-params(14))*y(12)^(1-params(13))+params(14)*(1+y(16))^(-(1-params(13))));
residual(37) = y(15)-((1-params(14))*y(12)^(-params(13))+T177*params(14)*y(15));
residual(38) = T71-(T60*(1-params(6))*(exp(y(22))-y(3)-y(3)*log(params(1)))/params(7)+(1-params(6)*y(19))*T71*params(2)*(1-params(8)));
residual(39) = y(20)-T422^T59;
residual(40) = y(21)-(y(21)*(1-params(8)*(1-y(19)))+y(19)*(1-y(21)));
residual(41) = T28-params(16)*(params(4)+y(21)*(exp(y(22))-y(3))-params(7)*y(20))^(-params(3));
residual(42) = y(15)*y(17)-y(9)*exp(y(22));
residual(43) = y(18)-(y(9)*log(y(3))+(1-y(9))*log(y(4))+params(16)/(1-params(3))*y(5)^(1-params(3)));
residual(44) = y(22)-(y(22)*params(17)-x(1));
residual(45) = y(23)-(params(18)*y(23)+x(2));
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(45, 45);

  %
  % Jacobian matrix
  %

T620 = getPowerDeriv(params(4)+y(21)*(exp(y(22))-y(3))-params(7)*y(20),(-params(3)),2);
T682 = y(26)*(-((-(T34*params(2)*(-y(8))/(y(4)*y(4))))/(T28*T28)));
T732 = y(26)*(-(params(2)*(-1)/(y(4)*y(4))/T28));
T757 = getPowerDeriv(y(7),T70,2);
T783 = (T233*(1-(1-params(8)))-(y(9)-y(9)*(1-params(8)))*T255)/(T233*T233)*getPowerDeriv(T236,T59,2);
T835 = y(33)*(-((-((params(13)-1)*params(13)*(1-params(15))))/(y(14)*(params(13)-1)*y(14)*(params(13)-1))));
T864 = getPowerDeriv(1+y(16),params(13),2);
T910 = getPowerDeriv(y(19),T70,2);
T966 = (T419*(1-(1-params(8)))-(y(21)-y(21)*(1-params(8)))*T429)/(T419*T419)*getPowerDeriv(T422,T59,2);
  g1(1,2)=y(25)*1/(1+y(16));
  g1(1,16)=y(25)*(-y(2))/((1+y(16))*(1+y(16)));
  g1(1,25)=y(2)/(1+y(16));
  g1(2,1)=T17*y(25)*1/(1+y(16));
  g1(2,16)=T17*y(25)*(-(1+y(1)))/((1+y(16))*(1+y(16)));
  g1(2,25)=T17*(1+y(1))/(1+y(16));
  g1(2,26)=1;
  g1(3,3)=y(43)*(-(y(9)*T34))+y(41)*((y(3)+y(3))/(y(3)*y(3)*y(3)*y(3))-params(16)*(-y(21))*(-y(21))*T620)+y(38)*(-((1-params(6)*y(19))*T71*T34*params(2)*(1-params(8))))+y(28)*(-(params(2)*((-(y(3)*y(3)))-(-y(3))*(y(3)+y(3)))/(y(3)*y(3)*y(3)*y(3))))+y(26)*(-((T28*params(2)*(-((-(1-y(8)))*(y(3)+y(3))))/(y(3)*y(3)*y(3)*y(3))-T34*T102)/(T28*T28)))+params(19)*y(26)*(-((T28*T28*(-(T34*T102+T113*(y(3)+y(3))/(y(3)*y(3)*y(3)*y(3))))-(-(T34*T113))*(T28*T34+T28*T34))/(T28*T28*T28*T28)))+params(19)*y(28)*(-(T34*params(2)))+T17*y(38)*(-((1-params(6)*y(19))*T71*params(2)*(1-params(8))*((-(y(3)*y(3)))-(-y(3))*(y(3)+y(3)))/(y(3)*y(3)*y(3)*y(3))));
  g1(3,4)=params(19)*T682;
  g1(3,8)=y(26)*(-(params(2)*1/(y(3)*y(3))/T28))+params(19)*y(26)*(-((-(T34*T215))/(T28*T28)));
  g1(3,9)=y(27)+y(43)*(-T28);
  g1(3,19)=y(38)*(-(T71*T28*params(2)*(1-params(8))*(-params(6))+(1-params(6)*y(19))*T28*params(2)*(1-params(8))*T391))+T17*y(38)*(-(T71*params(2)*(1-params(8))*(-y(3))/(y(3)*y(3))*(-params(6))+(1-params(6)*y(19))*params(2)*(1-params(8))*(-y(3))/(y(3)*y(3))*T391));
  g1(3,20)=y(41)*(-(params(16)*(-y(21))*(-params(7))*T620));
  g1(3,21)=y(41)*(-(params(16)*((-T50)+(-y(21))*(exp(y(22))-y(3))*T620)));
  g1(3,22)=y(41)*(-(params(16)*(-y(21))*y(21)*exp(y(22))*T620));
  g1(3,24)=(-params(1));
  g1(3,26)=T104+params(19)*(-((-(T34*T113))/(T28*T28)));
  g1(3,27)=y(9);
  g1(3,28)=(-(params(2)*(-y(3))/(y(3)*y(3))))+params(19)*(-(T28*params(2)));
  g1(3,29)=T88;
  g1(3,38)=T80+T17*T135;
  g1(3,41)=T34-params(16)*(-y(21))*T50;
  g1(3,43)=(-(y(9)*T28));
  g1(4,3)=T682;
  g1(4,4)=y(43)*(-((1-y(9))*(-1)/(y(4)*y(4))))+y(26)*(-(params(2)*(-((-y(8))*(y(4)+y(4))))/(y(4)*y(4)*y(4)*y(4))/T28));
  g1(4,8)=T732;
  g1(4,9)=y(43)*1/y(4);
  g1(4,24)=1;
  g1(4,26)=T152;
  g1(4,43)=T145;
  g1(5,5)=y(43)*(-(params(16)/(1-params(3))*getPowerDeriv(y(5),1-params(3),2)));
  g1(5,27)=1;
  g1(5,43)=T162;
  g1(6,7)=T17*y(29)*(-((1-params(8))*T200));
  g1(6,13)=T17*y(34)*(-T178);
  g1(6,14)=T17*y(35)*(-T188);
  g1(6,16)=T17*y(34)*(-(y(13)*params(14)*T342))+T17*y(35)*(-(y(14)*T365));
  g1(6,28)=1;
  g1(6,29)=T17*(-((1-params(8))*T167));
  g1(6,34)=T17*(-(y(13)*T178));
  g1(6,35)=T17*(-(y(14)*T188));
  g1(7,6)=T17*y(29)*(-((1-params(8))*T200));
  g1(7,7)=y(29)*T757+T17*y(29)*(-((1-params(8))*y(6)*T757));
  g1(7,9)=y(31);
  g1(7,29)=T200+T17*(-(T200*(1-params(8))*y(6)));
  g1(7,30)=params(8);
  g1(7,31)=(-(1-y(9)));
  g1(8,3)=y(26)*(-((T28*params(2)*1/(y(3)*y(3))-T34*T215)/(T28*T28)));
  g1(8,4)=T732;
  g1(8,9)=y(31);
  g1(8,26)=(-(T215/T28));
  g1(8,30)=1;
  g1(8,31)=y(9);
  g1(9,3)=y(27)+y(43)*(-T28);
  g1(9,4)=y(43)*1/y(4);
  g1(9,7)=params(19)*y(31);
  g1(9,8)=params(19)*y(31);
  g1(9,9)=y(32)*(-(T237*(-T255)/(T233*T233)+1/T233*T783))+params(19)*y(32)*(-((T233*(-(1-params(8)))-(y(9)-y(9)*(1-params(8)))*T255)/(T233*T233)*T783+T237*(T233*T233*((-(1-params(8)))*T255-(T255*(1-(1-params(8)))+(y(9)-y(9)*(1-params(8)))*(-(1-params(8)))*(-(1-params(8)))*getPowerDeriv(1-y(9)*(1-params(8)),params(6),2)))-(T233*(-(1-params(8)))-(y(9)-y(9)*(1-params(8)))*T255)*(T233*T255+T233*T255))/(T233*T233*T233*T233)));
  g1(9,15)=y(27)*(-((-exp(y(22)))/(y(15)*y(15))));
  g1(9,22)=y(42)*(-exp(y(22)))+y(27)*(-(exp(y(22))/y(15)));
  g1(9,27)=T244;
  g1(9,31)=1+params(19)*(-(1-y(8)-y(7)));
  g1(9,32)=(-(1/T233*T237))+params(19)*T261;
  g1(9,42)=(-exp(y(22)));
  g1(9,43)=(-(log(y(3))-log(y(4))));
  g1(10,27)=params(7);
  g1(10,32)=1;
  g1(11,17)=(-y(34));
  g1(11,22)=T279;
  g1(11,29)=T278;
  g1(11,34)=(-y(17));
  g1(12,12)=y(37)*(-((1-params(14))*getPowerDeriv(y(12),(-params(13)),2)))+y(36)*(-((1-params(14))*getPowerDeriv(y(12),1-params(13),2)));
  g1(12,33)=1;
  g1(12,36)=T295;
  g1(12,37)=T288;
  g1(13,6)=T17*y(34)*(-T178);
  g1(13,14)=T835;
  g1(13,16)=T17*y(34)*(-(y(6)*params(14)*T342));
  g1(13,33)=T305;
  g1(13,34)=1+T17*(-(T178*y(6)));
  g1(14,6)=T17*y(35)*(-T188);
  g1(14,13)=T835;
  g1(14,14)=y(33)*(-((-((-((params(13)-1)*y(13)*params(13)*(1-params(15))))*((params(13)-1)*y(14)*(params(13)-1)+(params(13)-1)*y(14)*(params(13)-1))))/(y(14)*(params(13)-1)*y(14)*(params(13)-1)*y(14)*(params(13)-1)*y(14)*(params(13)-1))));
  g1(14,16)=T17*y(35)*(-(y(6)*T365));
  g1(14,33)=T319;
  g1(14,35)=1+T17*(-(T188*y(6)));
  g1(15,9)=y(27)*(-((-exp(y(22)))/(y(15)*y(15))));
  g1(15,15)=y(27)*(-(y(9)*(-((-exp(y(22)))*(y(15)+y(15))))/(y(15)*y(15)*y(15)*y(15))));
  g1(15,16)=params(19)*y(37)*(-(params(14)*T342));
  g1(15,17)=y(42);
  g1(15,22)=T333;
  g1(15,27)=T332;
  g1(15,37)=1+params(19)*(-T178);
  g1(15,42)=y(17);
  g1(16,1)=T17*y(25)*(-y(2))/((1+y(16))*(1+y(16)));
  g1(16,2)=T17*y(25)*(-(1+y(1)))/((1+y(16))*(1+y(16)));
  g1(16,6)=T17*y(34)*(-(y(13)*params(14)*T342))+T17*y(35)*(-(y(14)*T365));
  g1(16,13)=T17*y(34)*(-(y(6)*params(14)*T342));
  g1(16,14)=T17*y(35)*(-(y(6)*T365));
  g1(16,15)=y(37)*(-(params(14)*T342));
  g1(16,16)=y(37)*(-(params(14)*y(15)*T864))+y(36)*(-(params(14)*getPowerDeriv(1+y(16),(-(1-params(13))),2)))+T17*y(25)*(-((-(y(2)*(1+y(1))))*(1+y(16)+1+y(16))))/((1+y(16))*(1+y(16))*(1+y(16))*(1+y(16)))+T17*y(34)*(-(y(13)*y(6)*params(14)*T864))+T17*y(35)*(-(y(14)*y(6)*params(14)*getPowerDeriv(1+y(16),params(13)-1,2)));
  g1(16,25)=T17*T354;
  g1(16,34)=T17*(-(y(13)*y(6)*params(14)*T342));
  g1(16,35)=T17*(-(y(14)*y(6)*T365));
  g1(16,36)=T349;
  g1(16,37)=(-(params(14)*y(15)*T342));
  g1(17,11)=(-y(34));
  g1(17,15)=y(42);
  g1(17,34)=(-y(11));
  g1(17,35)=(-1);
  g1(17,42)=y(15);
  g1(18,43)=1;
  g1(19,19)=y(38)*T910+T17*y(38)*(-(params(2)*(1-params(8))*T391*(-params(6))+params(2)*(1-params(8))*T391*(-params(6))+(1-params(6)*y(19))*params(2)*(1-params(8))*T910));
  g1(19,21)=y(40)*(-((-1)+params(8)));
  g1(19,38)=T391+T17*(-((1-params(6)*y(19))*params(2)*(1-params(8))*T391+T71*params(2)*(1-params(8))*(-params(6))));
  g1(19,40)=(-(1-y(21)+y(21)*params(8)));
  g1(20,3)=y(41)*(-(params(16)*(-params(7))*(-y(21))*T620));
  g1(20,20)=y(41)*(-(params(16)*(-params(7))*(-params(7))*T620));
  g1(20,21)=y(41)*(-(params(16)*(-params(7))*(exp(y(22))-y(3))*T620));
  g1(20,22)=y(41)*(-(params(16)*(-params(7))*y(21)*exp(y(22))*T620));
  g1(20,39)=1;
  g1(20,41)=(-(params(16)*T50*(-params(7))));
  g1(21,3)=y(41)*(-(params(16)*((-T50)+(exp(y(22))-y(3))*(-y(21))*T620)));
  g1(21,19)=params(19)*y(40)*(-(params(8)-1));
  g1(21,20)=y(41)*(-(params(16)*(exp(y(22))-y(3))*(-params(7))*T620));
  g1(21,21)=y(41)*(-(params(16)*(exp(y(22))-y(3))*(exp(y(22))-y(3))*T620))+y(39)*(-(T423*(-T429)/(T419*T419)+1/T419*T966))+params(19)*y(39)*(-(((-(1-params(8)))*T419-(y(21)-y(21)*(1-params(8)))*T429)/(T419*T419)*T966+T423*(T419*T419*((-(1-params(8)))*T429-(T429*(1-(1-params(8)))+(y(21)-y(21)*(1-params(8)))*(-(1-params(8)))*(-(1-params(8)))*getPowerDeriv(1-y(21)*(1-params(8)),params(6),2)))-((-(1-params(8)))*T419-(y(21)-y(21)*(1-params(8)))*T429)*(T419*T429+T419*T429))/(T419*T419*T419*T419)));
  g1(21,22)=y(41)*(-(params(16)*(exp(y(22))*T50+(exp(y(22))-y(3))*y(21)*exp(y(22))*T620)));
  g1(21,39)=(-(1/T419*T423))+params(19)*T435;
  g1(21,40)=1+params(19)*(-(1-params(8)*(1-y(19))-y(19)));
  g1(21,41)=(-(params(16)*(exp(y(22))-y(3))*T50));
  g1(22,3)=y(41)*(-(params(16)*y(21)*exp(y(22))*(-y(21))*T620));
  g1(22,9)=y(42)*(-exp(y(22)))+y(27)*(-(exp(y(22))/y(15)));
  g1(22,11)=T279;
  g1(22,15)=T333;
  g1(22,20)=y(41)*(-(params(16)*y(21)*exp(y(22))*(-params(7))*T620));
  g1(22,21)=y(41)*(-(params(16)*(y(21)*exp(y(22))*(exp(y(22))-y(3))*T620+exp(y(22))*T50)));
  g1(22,22)=y(42)*(-(y(9)*exp(y(22))))+T474+y(41)*(-(params(16)*(T50*y(21)*exp(y(22))+y(21)*exp(y(22))*y(21)*exp(y(22))*T620)));
  g1(22,27)=T471;
  g1(22,29)=T468;
  g1(22,38)=T462;
  g1(22,41)=(-(params(16)*T50*y(21)*exp(y(22))));
  g1(22,42)=(-(y(9)*exp(y(22))));
  g1(22,44)=1+params(19)*(-params(17));
  g1(23,29)=T88;
  g1(23,45)=1+params(19)*(-params(18));
  g1(24,3)=(-params(1));
  g1(24,4)=1;
  g1(25,1)=y(2)/(1+y(16));
  g1(25,2)=(1+y(1))/(1+y(16));
  g1(25,16)=T354;
  g1(26,2)=1;
  g1(26,3)=(-((T28*T102-T34*T113)/(T28*T28)));
  g1(26,4)=T152;
  g1(26,8)=(-(T215/T28));
  g1(27,3)=y(9);
  g1(27,5)=1;
  g1(27,9)=T244;
  g1(27,10)=params(7);
  g1(27,15)=T332;
  g1(27,22)=T471;
  g1(28,6)=1;
  g1(29,3)=T88;
  g1(29,6)=(-((1-params(8))*T167));
  g1(29,7)=T200-T200*(1-params(8))*y(6);
  g1(29,11)=T278;
  g1(29,22)=T468;
  g1(29,23)=T88;
  g1(30,7)=params(8);
  g1(30,8)=1;
  g1(31,7)=(-(1-y(9)));
  g1(31,8)=y(9);
  g1(31,9)=1-(1-y(8)-y(7));
  g1(32,9)=(-(T237*(T233*(1-(1-params(8)))-(y(9)-y(9)*(1-params(8)))*T255)/(T233*T233)));
  g1(32,10)=1;
  g1(33,12)=1;
  g1(33,13)=T305;
  g1(33,14)=T319;
  g1(34,6)=(-(y(13)*T178));
  g1(34,11)=(-y(17));
  g1(34,13)=1-T178*y(6);
  g1(34,16)=(-(y(13)*y(6)*params(14)*T342));
  g1(34,17)=(-y(11));
  g1(35,6)=(-(y(14)*T188));
  g1(35,14)=1-T188*y(6);
  g1(35,16)=(-(y(14)*y(6)*T365));
  g1(35,17)=(-1);
  g1(36,12)=T295;
  g1(36,16)=T349;
  g1(37,12)=T288;
  g1(37,15)=1-T178;
  g1(37,16)=(-(params(14)*y(15)*T342));
  g1(38,3)=(-(T60*(1-params(6))*((-1)-log(params(1)))/params(7)));
  g1(38,19)=T391-((1-params(6)*y(19))*params(2)*(1-params(8))*T391+T71*params(2)*(1-params(8))*(-params(6)));
  g1(38,22)=T462;
  g1(39,20)=1;
  g1(39,21)=(-(T423*(T419*(1-(1-params(8)))-(y(21)-y(21)*(1-params(8)))*T429)/(T419*T419)));
  g1(40,19)=(-(1-y(21)+y(21)*params(8)));
  g1(40,21)=1-(1-params(8)*(1-y(19))-y(19));
  g1(41,3)=T34-params(16)*(-y(21))*T50;
  g1(41,20)=(-(params(16)*T50*(-params(7))));
  g1(41,21)=(-(params(16)*(exp(y(22))-y(3))*T50));
  g1(41,22)=(-(params(16)*T50*y(21)*exp(y(22))));
  g1(42,9)=(-exp(y(22)));
  g1(42,15)=y(17);
  g1(42,17)=y(15);
  g1(42,22)=(-(y(9)*exp(y(22))));
  g1(43,3)=(-(y(9)*T28));
  g1(43,4)=T145;
  g1(43,5)=T162;
  g1(43,9)=(-(log(y(3))-log(y(4))));
  g1(43,18)=1;
  g1(44,22)=1-params(17);
  g1(45,23)=1-params(18);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],45,2025);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],45,91125);
end
end
end
end
