function [residual, g1, g2, g3] = flexprice_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(13, 1);
T34 = params(7)/(1-params(7));
T35 = y(8)^T34;
T45 = params(6)^(1/(1-params(7)));
T53 = y(19)^T34;
T71 = (1-(1-params(9))*y(2))^params(7);
T98 = (y(15)/params(3))^(-1);
T104 = params(3)^params(18);
lhs =y(6);
rhs =y(10)*(exp(y(16))-y(5))-params(8)*y(11)+params(5);
residual(1)= lhs-rhs;
lhs =y(7);
rhs =params(2)*(y(6)/y(1))^(-params(4));
residual(2)= lhs-rhs;
lhs =T35;
rhs =(1-params(10))*(exp(y(16))-y(5)+params(11)-y(17))*T45/params(8)+(1-params(9))*y(18)*T53;
residual(3)= lhs-rhs;
lhs =y(9);
rhs =params(9)*(1-y(8));
residual(4)= lhs-rhs;
lhs =y(10);
rhs =(1-y(9))*y(2)+y(8)*(1-y(2));
residual(5)= lhs-rhs;
lhs =y(11);
rhs =((y(10)-(1-params(9))*y(2))/T71)^(1/(1-params(7)));
residual(6)= lhs-rhs;
lhs =y(13);
rhs =(-log(params(1)))+params(2)*(1-y(20)-y(19))*y(21);
residual(7)= lhs-rhs;
lhs =y(14);
rhs =params(8)*T35/T45;
residual(8)= lhs-rhs;
lhs =y(13)/params(16);
rhs =y(14)/params(17)*T98;
residual(9)= lhs-rhs;
lhs =y(5);
rhs =y(15)^(1-params(18))*T104;
residual(10)= lhs-rhs;
lhs =y(12);
rhs =y(10)*exp(y(16));
residual(11)= lhs-rhs;
lhs =y(16);
rhs =params(19)*y(3)-x(it_, 1);
residual(12)= lhs-rhs;
lhs =y(17);
rhs =params(20)*y(4)+x(it_, 2);
residual(13)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(13, 23);

  %
  % Jacobian matrix
  %

T130 = getPowerDeriv(y(6)/y(1),(-params(4)),1);
T140 = getPowerDeriv(y(8),T34,1);
T164 = getPowerDeriv((y(10)-(1-params(9))*y(2))/T71,1/(1-params(7)),1);
  g1(1,5)=y(10);
  g1(1,6)=1;
  g1(1,10)=(-(exp(y(16))-y(5)));
  g1(1,11)=params(8);
  g1(1,16)=(-(y(10)*exp(y(16))));
  g1(2,1)=(-(params(2)*(-y(6))/(y(1)*y(1))*T130));
  g1(2,6)=(-(params(2)*T130*1/y(1)));
  g1(2,7)=1;
  g1(3,5)=(-(T45*(-(1-params(10)))/params(8)));
  g1(3,18)=(-((1-params(9))*T53));
  g1(3,8)=T140;
  g1(3,19)=(-((1-params(9))*y(18)*getPowerDeriv(y(19),T34,1)));
  g1(3,16)=(-(T45*exp(y(16))*(1-params(10))/params(8)));
  g1(3,17)=(-(T45*(-(1-params(10)))/params(8)));
  g1(4,8)=params(9);
  g1(4,9)=1;
  g1(5,8)=(-(1-y(2)));
  g1(5,9)=y(2);
  g1(5,2)=(-(1-y(9)-y(8)));
  g1(5,10)=1;
  g1(6,2)=(-((T71*(-(1-params(9)))-(y(10)-(1-params(9))*y(2))*(-(1-params(9)))*getPowerDeriv(1-(1-params(9))*y(2),params(7),1))/(T71*T71)*T164));
  g1(6,10)=(-(T164*1/T71));
  g1(6,11)=1;
  g1(7,19)=(-(y(21)*(-params(2))));
  g1(7,20)=(-(y(21)*(-params(2))));
  g1(7,13)=1;
  g1(7,21)=(-(params(2)*(1-y(20)-y(19))));
  g1(8,8)=(-(params(8)*T140/T45));
  g1(8,14)=1;
  g1(9,13)=1/params(16);
  g1(9,14)=(-(T98*1/params(17)));
  g1(9,15)=(-(y(14)/params(17)*1/params(3)*getPowerDeriv(y(15)/params(3),(-1),1)));
  g1(10,5)=1;
  g1(10,15)=(-(T104*getPowerDeriv(y(15),1-params(18),1)));
  g1(11,10)=(-exp(y(16)));
  g1(11,12)=1;
  g1(11,16)=(-(y(10)*exp(y(16))));
  g1(12,3)=(-params(19));
  g1(12,16)=1;
  g1(12,22)=1;
  g1(13,4)=(-params(20));
  g1(13,17)=1;
  g1(13,23)=(-1);

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],13,529);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],13,12167);
end
end
end
end
