%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SVAR: This file replicates Figure 5 and 6
disp(' --------------------------------------------------------------------')
disp('  ')
disp(' Structural VAR - Instrumental Variable ')
disp('  ')
disp('              Figure 5 & 6 ')
disp('  ')
disp(' --------------------------------------------------------------------')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')


% Age groups
init_group = 2;
end_group  = 8;

% Loop over age groups
for entry_variable=init_group:end_group

CONTROLS            = xlsread('data/FF_DATA.xlsx','CONTROLS');
NARR                = xlsread('data/FF_DATA.xlsx','FF PROXIES'); 
PROX                = NARR(:,entry_variable);
PROX(isnan(PROX))   = 0;

URATE_AGE           = xlsread('data/FF_DATA.xlsx','URATE'); 
PRATE_AGE           = xlsread('data/FF_DATA.xlsx','PRATE');
ATR_AGE             = xlsread('data/FF_DATA.xlsx','ATR'); 
AMTR_AGE            = xlsread('data/FF_DATA.xlsx','AMTR'); 

DATASET.TSERIES = [AMTR_AGE(:,1) AMTR_AGE(:,entry_variable) URATE_AGE(:,entry_variable) PRATE_AGE(:,entry_variable) CONTROLS(:,2)  CONTROLS(:,6:10)   PROX ATR_AGE(:,2) ];
DATASET.LABEL   = {'DATES','AMTR_AGE','UR_AGE','PR_AGE','RGDP','GOV_TOT','STPRICE','DDEBT','AVTAX','DFFR','PROX', 'ATR_AGE'};
DATASET.UNIT    = [     0     1           1       1       2        1         1        1      1       2        2       1 ];
DATASET.FIGLABELS= [{'year' ,'Average Marginal Tax Rate','Unemployment Rate Age','Participation Rate Age','Real GDP', ...
                    'Government Spending','Real Stock Prices', 'DlogDebt','Avg Tax','DFFR','AMTR proxy','Avg Tax Age'}];  
                
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
SPEC.sb              = 1961;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [  ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 5; % Length of IR horizon 
SPEC.select_variables = {'AMTR_AGE','ATR_AGE','RGDP','GOV_TOT','DDEBT','STPRICE','DFFR','UR_AGE','PR_AGE'};
plotdisplay = {'UR_AGE','PR_AGE'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   


% Estimate SVARIV model
SVARIV               = SPEC;
SVARIV               = doProxySVAR(SVARIV); 

% Inference:
clevel              = [95 68];    % CI Percentiles
nboot               = 5000;
SVARIVci            = doProxySVARci(SVARIV,clevel,3,nboot);

% Make Plot 
name = '_SVARIV';

display1= cell2mat(values(SVARIV.MAP,plotdisplay));
% Save Output from every iteration
FF_SVARIV(:,:,entry_variable) = SVARIV.irs(:,display1);% time,UR or PR,age group
FF_SVARIVciL(:,:,:,entry_variable) = squeeze(SVARIVci.irsL(:,display1,:));% time,UR or PR,age group
FF_SVARIVciH(:,:,:,entry_variable) = squeeze(SVARIVci.irsH(:,display1,:));% time,UR or PR,age group
UNRATE_mean(entry_variable) = mean(SPEC.vars(:,8));

end

avg_lf_share = [ (0.067613748+0.114089218)	0.237455049	0.228682514	0.195562158	0.120387512	0.036209801];

plot_style_estimated = 'o-';

idx_ur = 1;
idx_pr = 2;
FIGLABELS_UR = {'SHOULD NOT HAPPEN!','A. URATE 16+','B. URATE 16-24','C. URATE 25-34','D. URATE 35-44','E. URATE 45-54','F. URATE 55-64','G. URATE 65+'};
FIGLABELS_PR = {'SHOULD NOT HAPPEN!','A. PRATE 16+','B. PRATE 16-24','C. PRATE 25-34','D. PRATE 35-44','E. PRATE 45-54','F. PRATE 55-64','G. PRATE 65+'};
numrows =2;
numcols =4;

approx_digit = '%.3f';
%% IRFS Unemployment Rate by Age
figure('units','normalized','outerposition',[0 0 1 1])
for nvar = init_group:end_group
                  
        box on
        hold on
           subplot(numrows,numcols,nvar-init_group+1);
            plot(0:SVARIV.irhor-1,FF_SVARIV(:,idx_ur,nvar),plot_style_estimated,'MarkerSize',4,'LineWidth',2,'Color', [0 0 0.5]);hold on
            if nvar==2
                dur_agg =FF_SVARIV(:,idx_ur,nvar);
            else
                dur_age(:,nvar-init_group+1)=FF_SVARIV(:,idx_ur,nvar);
            end                
           if isempty(SVARIVci)==0
                if isempty(FF_SVARIVciH)==0
                p1=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_ur,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_ur,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                end
                if size(FF_SVARIVciH,2)>1
                p2=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_ur,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_ur,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');              
                end               
            end
            hline(0,'k-')
            ti=title( FIGLABELS_UR{nvar});
            xl=xlabel('horizon (years)','Fontsize',8);
            yl=ylabel('percentage points','Fontsize',8);
            set(gca,'XTick',0:1:10)
            set([xl,yl], 'FontName', 'AvantGarde','FontSize',12);
            set([ti], 'FontName', 'AvantGarde','FontSize',16);
            grid on
            axis manual
            axis([0 SVARIV.irhor-1 -2.5 2])
end
str=strcat('FF_figures/',name,'_','urate_age_groups_Figure5');
saveas(gcf,str,'epsc');


%% IRFS Participation Rate by Age
figure('units','normalized','outerposition',[0 0 1 1])
for nvar = init_group:end_group
                  
        box on
        hold on
           subplot(numrows,numcols,nvar-init_group+1);
            plot(0:SVARIV.irhor-1,FF_SVARIV(:,idx_pr,nvar),plot_style_estimated,'MarkerSize',4,'LineWidth',2,'Color', [0 0 0.5]);hold on
            if isempty(SVARIVci)==0
                if isempty(FF_SVARIVciH)==0
                p1=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_pr,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_pr,1,nvar)),'LineWidth',1,'Color', [0 0 0.5],'LineStyle','--');hold on
                end
                if size(FF_SVARIVciH,2)>1
                p2=plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciH(:,idx_pr,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');hold on
                plot(0:SVARIV.irhor-1,squeeze(FF_SVARIVciL(:,idx_pr,2,nvar)),'LineWidth',1,'Color', [0.9 0 0],'LineStyle','-.');              
                end               
            end
            hline(0,'k-')
            ti=title( FIGLABELS_PR{nvar});
            xl=xlabel('horizon (years)','Fontsize',8);
            yl=ylabel('percentage points','Fontsize',8);
            set(gca,'XTick',0:1:10)
            set([xl,yl], 'FontName', 'AvantGarde','FontSize',12);
            set([ti], 'FontName', 'AvantGarde','FontSize',16);
            grid on
            axis manual
            axis([0 SVARIV.irhor-1 -2.5 0.5])
end
str=strcat('FF_figures/',name,'_','prate_age_groups_Figure6');
saveas(gcf,str,'epsc');


% DECOMPOSITION AGGREGATE URATE IN AGE-SPECIFIC SHARE
disp('-----------------------------------------------------------------------------')
disp('             16-24       25-34       35-44       45-54       55-64       65+ ')
disp('-----------------------------------------------------------------------------')
for ii=0:SVARIV.irhor-1
    dur_agg_sum_age(ii+1,:) = sum(avg_lf_share(1:length(dur_age(1,2:end))).*dur_age(ii+1,2:end));
    share_ur_agg(ii+1,:)  = avg_lf_share(1:length(dur_age(1,2:end))).*dur_age(ii+1,2:end)./dur_agg_sum_age(ii+1,:);
    disp([' Horizon:' num2str(ii) ';' num2str(share_ur_agg(ii+1,:) ) ])
end
disp('-----------------------------------------------------------------------------')
disp('             16-24       25-34       35-44       45-54       55-64       65+ ')
disp('-----------------------------------------------------------------------------')
for ii=0:SVARIV.irhor-2
    dur_agg_sum_age(ii+1,:) = sum(avg_lf_share(1:length(dur_age(1,2:end))).*dur_age(ii+1,2:end));
    share_ur_ctfl(ii+1,:) = (1/length(dur_age(1,2:end))).*dur_age(ii+1,2:end)./sum((1/length(dur_age(1,2:end))).*dur_age(ii+1,2:end));
    disp([' Horizon:' num2str(ii) ';' num2str(share_ur_ctfl(ii+1,:) ) ])
end


disp('--------------------------------------------------------------------------------------')
disp('             16+   16-24       25-34       35-44       45-54       55-64       65+ ')
disp('--------------------------------------------------------------------------------------')
disp([' Avg URATE:' num2str(100*UNRATE_mean(2:end))   ])
disp([' Rel URATE:' num2str(UNRATE_mean(2:end)./UNRATE_mean(2))   ])
disp([' Avg LFS  :' num2str([ 0 100*avg_lf_share])   ])

% for ii=0:SVARIV.irhor-1
%     disp([' Horizon:' num2str(ii) '; Agg : '   num2str(dur_agg(ii+1,:) ) ' ; Summ Age : ' num2str(dur_agg_sum_age(ii+1,:)) ])
% end
